<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Marketing_Chit_Invoice_Process extends CI_Controller
{
    var $main_menu_name = "marketing_chit_invoice_process";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Marketing_Order_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Common_Model');
        $this->load->model('Marketing_Loading_Model');
        $this->load->model('Marketing_Chit_Invoice_Model');
        $this->load->model('Marketing_Seettu_Order_Process_Model');
        $this->load->model('Customer_Model');
    }
    public function get_term_value()
    {
        $item_group       = $this->input->get('IG');
        $item_group_value = $this->Marketing_Chit_Invoice_Model->get_term_value($item_group);
        $json_data        = array(
            "data" => $item_group_value['gruop_value']
        );
        echo json_encode($json_data);
    }
    public function index()
    {
        $data['type'] = $this->input->get('t');
        if ($data['type'] == 1) {
            $data['page_name'] = "Issued sample for customers";
        }
        if ($data['type'] == 2) {
            $data['page_name'] = "List Seetu";
        }
        $data['sales_rep_issues'] = $this->Marketing_Order_Model->get_all_sales_rep_issue();
        $data['main_menu_name']   = $this->main_menu_name;
        $data['sub_menu_name']    = $this->sub_menu_name;
		$data['routes_list']     = $this->Marketing_Loading_Model->get_all_routes();
        $this->load->view('marketing/marketing_chit_invoices_list', $data);
    }
    public function seettu_order_for_customer()
    {
        $seettu_term_id         = $this->uri->segment(3);
        $data['seettu_details'] = $this->Marketing_Chit_Invoice_Model->get_seettu_term_details($seettu_term_id);
        $data['sales_rep_list'] = $this->Marketing_Order_Model->get_all_sales_user_reps();
        $data['routes_list']    = $this->Marketing_Loading_Model->get_all_routes();
        $data['items_groups']   = $this->Marketing_Chit_Invoice_Model->get_all_items_group();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        //print_r($data['routes_list']);
        $this->load->view('marketing/marketing_seettu_orders_manage', $data);
    }
    public function chit_cus_all_details_by_id()
    {
        $chit_id              = $this->uri->segment(3);
        $data['page_name']    = "Issued sample for customers";
        $data['chit_details'] = $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_details_by_seettu_id($chit_id);
        $invoice_value        = $this->Marketing_Chit_Invoice_Model->get_total_invoice_value_by_seettu_id($chit_id);
        $total_invoice_value  = 0;
        if (isset($invoice_value)) {
            foreach ($invoice_value as $row) {
                if ($row['product_price']) {
                    $total_invoice_value = $total_invoice_value + ($row['product_price'] * $row['product_qty']);
                }
            }
        } else {
            $total_invoice_value = 0;
        }
        $data['total_invoice_value'] = $total_invoice_value;
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = $this->sub_menu_name;
        $this->load->view('marketing/marketing_chit_all_details', $data);
    }
    public function manage()
    {
        $issue_card_id = $this->uri->segment(3);
        $route_id      = $this->uri->segment(4);
        $cus_id        = $this->uri->segment(5);
        if ($issue_card_id == 0) {
            $data['sales_rep_list']  = $this->Marketing_Order_Model->get_all_sales_user_reps();
            $data['warehouse_list']  = $this->Warehouse_Model->get_all_warehouse();
            $data['sample_issue_id'] = $issue_card_id;
            $data['route_id']        = $route_id;
            $data['type']            = 'A';
            $data['main_menu_name']  = $this->main_menu_name;
            $data['sub_menu_name']   = 'issue_card';
            $data['routes_list']     = $this->Marketing_Loading_Model->get_all_routes();
            $data['items_groups']    = $this->Marketing_Chit_Invoice_Model->get_all_items_group();
            $this->load->view('marketing/marketing_chit_invoice_open', $data);
        } else {
            $data['route_id']        = $route_id;
            $data['customer_id']     = $cus_id;
            $data['warehouse_list']  = $this->Warehouse_Model->get_all_warehouse();
            $data['type']            = 'SAMPLE';
            $data['sample_issue_id'] = $issue_card_id;
            $data['main_menu_name']  = $this->main_menu_name;
            $data['sub_menu_name']   = 'issue_card';
            $data['routes_list']     = $this->Marketing_Loading_Model->get_all_routes();
            $data['items_groups']    = $this->Marketing_Chit_Invoice_Model->get_all_items_group();
            $this->load->view('marketing/marketing_chit_invoice_open', $data);
        }
    }
    public function seettu_issue_samlple_list_for_customer()
    {
        $chit_term_id           = $this->uri->segment(3);
        $data['seettu_term_id'] = $chit_term_id;
        $data['page_name']      = "Issued sample for customers";
        $data['chit_details']   = $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_details_by_seettu_term_id($chit_term_id);
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        $this->load->view('marketing/sample_all_details_customer', $data);
    }
    public function get_all_sample_pending_list_by_customer()
    {
        $customer_id    = $this->input->get('cus_id');
        $seettu_term_id = $this->input->get('seettu_term_id');
        $result         = $this->Marketing_Chit_Invoice_Model->get_pending_sample_list_by_customer_id($customer_id);
        $data           = array();
        foreach ($result as $r) {
            $action        = "";
            $eye_btn       = "<button  id=group_product_id name=group_product_id class='btn btn-primary'   onClick=get_items(" . $r['grp_id'] . ")>  <i class= clip-eye></i></button> ";
            $action        = '<div class="btn-group text-left">
                       
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            
                            
                            <li><a onClick="invoice_order(' . $r['cus_issue_id'] . ',' . $seettu_term_id . ')" data-toggle="modal" href="#"  data-placement="top" data-original-title="save_invoice"> Invoice This Sample</a></li>
                            
                            
                            
                            
                            
                            </ul></div>';
            $nested_data   = array();
            $nested_data[] = $r['cus_issue_ref_no'] . " - " . $r['cus_issue_document_no'];
            $nested_data[] = $r['Issue_date'];
            $nested_data[] = $eye_btn . " &nbsp;&nbsp;" . $r['product_name'] . " (" . $r['product_code'] . ") - " . $r['book_year'];
            $nested_data[] = $r['product_qty'];
            $nested_data[] = $r['product_qty'] * $r['product_price'];
            $nested_data[] = $action;
            $data[]        = $nested_data;
        }
        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function save_chit_open()
    {
        $book_year         = $this->input->post('book_year');
        $sale_reference_no   = $this->input->post('card_ref_number');
        $chit_type         = $this->input->post('chit_type');
        $customer_id       = $this->input->post('customer_id');
        //$item_group_id=$this->input->post('item_group_id');
        $remark            = $this->input->post('remark');
        $terms             = $this->input->post('terms');
        $route_id          = $this->input->post('route_id');
        $temp_date         = $this->input->post('open_datetime');
        $open_date         = date('Y-m-d', strtotime($temp_date));
        //$sale_reference_no = $this->input->post('sale_reference_no');
        $warehouse_id      = $this->input->post('warehouse_id');
        $sales_rep_id      = $this->input->post('sales_rep_id');
        $chit_id           = 0;
		$card_ref_number=$this->Customer_Model->gen_cus_code('chit_id','marketing_seettu_customer_master','SPE');
        $data              = array(
            'book_year' => $book_year,
            'card_ref_number' => $card_ref_number,
            'chit_type' => $chit_type,
            'customer_id' => $customer_id,
            'sales_rep_id' => $sales_rep_id,
            'remark' => $remark,
            'terms' => $terms,
            'route_id' => $route_id,
            'open_date' => $open_date,
            'sale_reference_no' => $sale_reference_no,
            'warehouse_id' => $warehouse_id,
            'open_datetime' => date('Y-m-d H:i:s')
        );
        $this->db->trans_start();
        $result             = $this->Marketing_Chit_Invoice_Model->save_chit_open($data, $chit_id);
        $itemid             = $this->db->insert_id();
        $row                = $this->input->post('item_group_id');
        $row2               = $this->input->post('item_group_value');
        $rowCount           = count($row);
        $data_items         = array();
        $total_seettu_value = 0;
        for ($i = 0; $i < $rowCount; $i++) {
            $term_id = $row[$i];
            if ($term_id == 29) {
                $term_amount_value = $row2[$i];
            } else {
                $term_amount       = $this->Marketing_Chit_Invoice_Model->get_term_amount($term_id);
                $term_amount_value = $term_amount['gruop_value'];
            }
            //print_r($term_amount);
            if (isset($row[$i])) {
                $data_item = array(
                    'm_c_c_id' => $itemid,
                    'type' => 'NORMAL',
                    'term' => $row[$i],
                    'term_amount' => $term_amount_value,
                    'status' => 'PENDING',
					'term_no' => $i+1
                );
                $this->Marketing_Chit_Invoice_Model->save_chit_term_details($data_item);
                if ($term_id == 29) {
                    $total_seettu_value = $total_seettu_value + $term_amount_value;
                } else {
                    $total_seettu_value = $total_seettu_value + $term_amount_value;
                }
                $data_item = array(
                    'chit_total_value' => $total_seettu_value,
                    'chit_term_value' => $total_seettu_value / $terms
                );
                $this->Marketing_Chit_Invoice_Model->update_chit_master_details($data_item, $itemid);
            }
        }
        $this->db->trans_complete();
        $trans_status = $this->db->trans_status();
        if ($trans_status == FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        echo json_encode(array(
            'id' => 0,
            'error' => 0,
            'disMsg' => "ok"
        ));
    }
    public function get_product_suggestion_seettu()
    {
        $term_id       = $this->input->get('t');
        $book_id       = $this->input->get('b');
        $item_group    = $this->input->get('ig');
        $spelling_term = $this->input->get('term');
        $warehouse_id  = $this->input->get('wh');
        $product_list  = $this->Marketing_Chit_Invoice_Model->get_products_suggestions_get_for_seettu_invoice($term_id, $book_id, $item_group, $spelling_term, $warehouse_id);
        $json          = array();
        foreach ($product_list as $row) {
            $product_id    = $row['product_id'];
            $grp_id        = $row['grp_id'];
            $product_items = $this->Marketing_Chit_Invoice_Model->get_product_items($grp_id);
            $item_ist_qty  = "";
            foreach ($product_items as $row1) {
                $item_ist_qty = $item_ist_qty . $row1['product_name'];
                $item_ist_qty = $item_ist_qty . $row1['quantity'];
                $item_ist_qty = $item_ist_qty . " / ";
            }
            $product_name            = $row['product_name'];
            $product_code            = $row['product_code'];
            $product_part_no         = $row['product_part_no'];
            $product_oem_part_number = $row['product_oem_part_number'];
            $product_id              = $row['product_id'];
            $product_price           = $row['product_price'];
            $down_payment            = 0;
            $per_day_rental          = 0;
            $sendParameters          = "'$product_id','$product_name','$product_code','$product_price'";
            $sendParameters          = "$product_id,$product_name,$product_code,$product_price";
            $extraName               = '';
            $extraName .= ", Selling Price: " . number_format($product_price, 2, '.', ',');
            if ($product_part_no)
                $extraName .= ", Part No: $product_part_no";
            if ($product_oem_part_number)
                $extraName .= ", OEM Part No: $product_oem_part_number";
            $qty_in_stock = 0;
            $qty          = 1;
            $extraName .= ", Qty in stock: " . $qty;
            if ($qty > 0) {
                $json_itm = array(
                    'id' => $row['product_id'],
                    'sales_rep_issue_id' => $term_id,
                    'product_id' => $row['product_id'],
                    'product_code' => $row['product_code'],
                    'product_name' => $row['product_name'] . " ( " . $item_ist_qty . " ) ",
                    'product_price' => $row['product_price'],
                    'down_payment' => 0,
                    'per_day_rental' => 0,
                    'rep_commision' => 0,
                    'daily_rental_days' => 0,
                    'product_part_no' => $row['product_part_no'],
                    'item_cost' => $row['product_cost'],
                    'qtyforcheck' => $qty,
                    //'sales_rep_issue_id'=> $rep_issue_id,
                    'product_oem_part_number' => $row['product_oem_part_number'],
                    'value' => $row['product_name'] . " (" . $row['product_code'] . ")" . " ( " . $item_ist_qty . " ) ",
                    'label' => $row['product_name'] . " (" . $row['product_code'] . ")$extraName" . " ( " . $item_ist_qty . " ) "
                );
                array_push($json, $json_itm);
            }
        }
        echo json_encode($json);
    }
    public function chit_invoice_list()
    {
        $start            = $this->input->get('start');
        $length           = $this->input->get('length');
        $search           = $this->input->get('search');
		$route           = $this->input->get('route');
        $totalData        = 0;
        $totalFiltered    = 0;
        $delete_invoice   = "";
        $edit_seettu      = "";
        $total_term_value = 0;
        $total_payment    = 0;
        $data             = array();
        $condition        = $this->input->get('t');
        if ($condition == 1) {
            $count             = $this->Marketing_Chit_Invoice_Model->chit_invoice_list("", "", $search,$route );
            $chit_invoice_list = $this->Marketing_Chit_Invoice_Model->chit_invoice_list($start, $length, $search,$route );
        }
        if ($condition == 2) {
            $count             = $this->Marketing_Chit_Invoice_Model->chit_invoice_list2("", "", $search,$route );
            $chit_invoice_list = $this->Marketing_Chit_Invoice_Model->chit_invoice_list2($start, $length, $search,$route );
        }
        $totalData     = $count;
        $totalFiltered = $totalData;
        //print_r($chit_invoice_list);
        foreach ($chit_invoice_list as $row) {
            $total_term_value_monthly_rental = $row['chit_term_value'];
            //action status issue type
            $action                          = "";
            $issue_type                      = '<span class="label label-info">undifine</span>';
            $status                          = '<span class="label label-danger">Error</span>';
            //action status issue type
            $id                              = $row['chit_id'];
            /*    -----------------------------------------------------------------------------*/
            //get the total value for term amount invoice yet
            $issued_terms_total_value_temp   = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_issued_total_term_value($id);
            $issued_terms_total_value        = 0;
            $test                            = "";
            if (isset($issued_terms_total_value_temp)) {
                $previous_id = 0;
                foreach ($issued_terms_total_value_temp as $row3) {
                    if ($previous_id != $row3['seettu_cus_item_id']) {
                        //$test=$test." / ".$row3['seettu_cus_item_id']." - ".$row3['term_amount']." / ";
                        if ($row3['term_amount']) {
                            $issued_terms_total_value = $issued_terms_total_value + $row3['term_amount'];
                        }
                    }
                    $previous_id = $row3['seettu_cus_item_id'];
                }
            } else {
                $issued_terms_total_value = 0;
            }
            //print_r($issued_terms_total_value_temp['SUM(mst.term_amount)']);
            /*    -----------------------------------------------------------------------------*/
            //invoice all payment detail for per seettu
            $terms_payment_details = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_payment_details_all($id);
            $recevied_payment      = 0;
            if ($terms_payment_details['received_amount']) {
                $recevied_payment = $terms_payment_details['received_amount'];
            }
            /*    -----------------------------------------------------------------------------*/
            //invoice all item valu and qty
            $terms_invoice_details      = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_invoice_details_all($id);
            $invice_total_value_in_this = 0;
            foreach ($terms_invoice_details as $row2) {
                $temp_invice_total_value    = $row2['product_price'] * $row2['product_qty'];
                $invice_total_value_in_this = $invice_total_value_in_this + $temp_invice_total_value;
            }
            /*    -----------------------------------------------------------------------------*/
            //get invoice count for yet
            $terms_invoice_count              = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_invoice_master_count($id);
            /*    -----------------------------------------------------------------------------*/
            //calculate total monthly rental term value issued
            $total_term_value_monthly_rental  = $total_term_value_monthly_rental * $terms_invoice_count;
            /*    -----------------------------------------------------------------------------*/
            //get the term total and sale totat diff
            $invoice_exceeding_value          = $invice_total_value_in_this - $issued_terms_total_value;
            /*    -----------------------------------------------------------------------------*/
            // should be receive payment as term value    
            $sholud_be_recived_as_mothly_term = $total_term_value_monthly_rental - $recevied_payment;
            /*    -----------------------------------------------------------------------------*/
            $current_outstanding              = $sholud_be_recived_as_mothly_term + $invoice_exceeding_value;
            $on_break_value                   = $invice_total_value_in_this - $recevied_payment;
            if ($this->session->userdata('ss_group_id') == 1 || $this->session->userdata('ss_group_id') == 2) {
                $delete_invoice = '<li><a href="#" onClick="delete_seettu(' . $id . ')"><i class="fa fa-file-text-o"></i> Delete Seettu</a></li>';
            }
            $nested_data = array();
            $linvdate    = "";
            $inv_date    = $this->Marketing_Chit_Invoice_Model->get_last_invoice_date($row['chit_id']);
            if (isset($inv_date['invoice_date'])) {
                $linvdate = $inv_date['invoice_date'];
            } else {
                $linvdate = "Not yet";
            }
            if ($row['chit_invoice_status'] == "INITIALIZE") {
                if ($linvdate == "Not yet") {
                    $status = '<span class="label label-warning">Not Issued</span>';
                } else {
                    $status = '<span class="label label-info">On going</span>';
                }
                $action = '<div class="btn-group text-left">
                       
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a  href="' . base_url() . 'marketing_chit_invoice_process/chit_cus_all_details_by_id/' . $id . '" target="_blank"><i class="fa fa-file-text-o"></i> Seetu Details</a></li>
                            
                            
                            <li><a href="#" onClick="complete_seettu(' . $id . ')"><i class="fa fa-file-text-o"></i> Finish Seettu </a></li>
                            <li><a href="#" onClick="break_seettu(' . $id . ')"><i class="fa fa-file-text-o"></i> Brake Seettu </a></li>
                            
                            ' . $delete_invoice . '
                            
                            </ul></div>';
            }
            if ($row['chit_type'] == "NORMALSEETTU") {
                $issue_type  = 'Normal Seettu';
                $outstanding = $current_outstanding;
            }
            if ($row['chit_type'] == "MIXSITTU") {
                $issue_type  = 'Mix Seettu';
                $outstanding = $current_outstanding;
            }
            if ($row['chit_type'] == "ITEMVALUESETTU") {
                $issue_type  = 'Item Value Seettu';
                $outstanding = $on_break_value;
            }
            $nested_data[] = $row['open_date'];
            $nested_data[] = $linvdate;
            $nested_data[] = $row['card_ref_number'];
            $nested_data[] = $row['cus_code'];
            $nested_data[] = $row['cus_name'];
            $nested_data[] = $row['route_name'];
            $nested_data[] = $row['chit_term_value'];
            $nested_data[] = $outstanding;
            if ($row['chit_type'] == "ITEMVALUESETTU") {
                //$nested_data[]=$outstanding;
                //$nested_data[]="Removed";
            } else {
                //$nested_data[]=$total_term_value-$recevied_payment  ;
                //$nested_data[]="Removed";
            }
            $nested_data[] = $issue_type;
            $nested_data[] = $on_break_value;
            $nested_data[] = $status;
            $nested_data[] = $action;
            $data[]        = $nested_data;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_all_chit_term_by_chit_id()
    {
        $chit_id             = $this->input->get('id');
        $master_sample_count = $this->Marketing_Chit_Invoice_Model->get_is_sample_master_issue_result($chit_id);
        $chit_term_list      = $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_term_details_by_seettu_id($chit_id);
        $data                = array();
        $count               = 1;
        foreach ($chit_term_list as $row) {
            $id          = $row['id'];
            $edit_seettu = '';
            if ($this->session->userdata('ss_group_id') != 4 || $this->session->userdata('ss_group_id') != 5) {
                $edit_seettu = '<li><a href="#" onClick="edit_seettu(' . $id . ')"><i class="fa fa-edit"></i> Edit Seettu</a></li>';
            }
            $sample_count        = $this->Marketing_Chit_Invoice_Model->get_is_sample_issue_result($id);
            $terms_order_count   = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_order_details_count($id);
            $terms_order_details = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_order_details_approval_status($id);
            $terms_invoice_count = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_invoice_details_count($id);
            $terms_payment_count = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_payment_details_count($id);
            if (isset($terms_order_details['approval_status'])) {
                $app_status = $terms_order_details['approval_status'];
            } else {
                $app_status = (-1);
            }
            $term_count = "Term - " . $count;
            $count++;
            $action      = "";
            $issue_type  = '<span class="label label-info">undifine</span>';
            $status      = '<span class="label label-danger">Error</span>';
            $details     = "";
            $nested_data = array();
            //$issues = $this->Marketing_Chit_Invoice_Model->items_issue_count_by_chit_id($row['chit_id']);            
            if ($app_status == 0) {
                $details = '<span class="label label-warning">Approval Pending</span>';
            }
            if ($app_status == (-1)) {
                $details = '';
            }
            if ($app_status == 1) {
                $details = '<span class="label label-success">Approved</span>';
            }
            if ($row['type'] == "NORMAL") {
                $sample_add = "";
                if ($master_sample_count == 0) {
                    $sample_add = '<li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_issue_samlple_list_for_customer/' . $id . '"><i class="fa fa-plus-square"> </i> Add Cusromer Sample</a></li>';
                }
                $status              = '<span class="label label-warning">Not Issued</span>';
                $specical_privilage2 = '';
                if ($this->session->userdata('ss_group_id') == 1 || $this->session->userdata('ss_group_id') == 2) {
                    $specical_privilage2 = '                        
                        <li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_issue_samlple_list_for_customer/' . $id . '"><i class="fa fa-plus-square"> </i> Add Cusromer Sample (For Admin only)</a></li>
                                                
                         ';
						 $specical_privilage2 = ' ';
                }
              
                if ($terms_order_count > 0 && $app_status == 0) {
                    $status = '<span class="label label-info">Ordered</span>';
                   
                }
                if ($terms_order_count > 0 && $app_status == 1) {
                    $status = '<span class="label label-info">Redy to invoice</span>';
                   
                }
                if ($terms_invoice_count > 0) {
                    $terms_invoice_details      = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_invoice_details($id);
                    $invice_total_value_in_this = 0;
                    foreach ($terms_invoice_details as $row2) {
                        $temp_invice_total_value    = $row2['product_price'] * $row2['product_qty'];
                        $invice_total_value_in_this = $invice_total_value_in_this + $temp_invice_total_value;
                    }
                    $details   = 'Sale : ' . $invice_total_value_in_this;
                    $is_sample = "";
                    if ($sample_count > 0) {
                        $is_sample = " (Sample)";
                    }
                    $status = '<span class="label label-success">invoiced' . $is_sample . '</span>';
                  
                }
                if ($terms_payment_count > 0) {
                    $terms_order_details        = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_payment_details($id);
                    $last_payment_date          = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_payment_details_last($id);
                    $terms_invoice_details      = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_term_invoice_details($id);
                    $master_seettu_details      = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_master_details($row['m_c_c_id']);
                    $invice_total_value_in_this = 0;
                    foreach ($terms_invoice_details as $row2) {
                        $temp_invice_total_value    = $row2['product_price'] * $row2['product_qty'];
                        $invice_total_value_in_this = $invice_total_value_in_this + $temp_invice_total_value;
                    }
                    $master_details = $this->Marketing_Seettu_Order_Process_Model->get_all_seettu_cus_master_details($row['m_c_c_id']);
                    $term_balance   = $master_seettu_details['chit_term_value'] - $terms_order_details['received_amount'];
                    //$cash_balance=$term_balance-$terms_order_details['received_amount'];
                    $is_sample      = "";
                    if ($sample_count > 0) {
                        $is_sample = " (Sample)";
                    }
                    $status             = '<span class="label label-success">invoiced</span>';
                    $specical_privilage = '';
                    if ($this->session->userdata('ss_group_id') == 1 || $this->session->userdata('ss_group_id') == 2) {
                        $specical_privilage = '                        
                        <li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_issue_samlple_list_for_customer/' . $id . '"><i class="fa fa-file-text-o"></i> Add Cusromer Sample</a></li>
                        
                        <li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_order_for_customer/' . $id . '"><i class="fa fa-file-text-o"></i> Seettu new order</a></li>
                        
                        <li><a onClick="invoice_order(' . $id . ')" data-toggle="modal" href="#"  data-placement="top" data-original-title="save_invoice"> Invoice this order</a></li>
                         ';
                    }
                    $action  = '<div class="btn-group text-left">
                       
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_invoiced_details/' . $id . '"><i class="fa fa-file-text-o"></i> Seettu Invoice details</a></li>
                            
                            <li><a onClick="add_payment(' . $id . ')" data-toggle="modal" href="#"  data-placement="top" data-original-title="add_payment"> Add Payment</a></li>                            
                            '. $specical_privilage .'                  
            
                            </ul></div>';
                    $details = 'Sale : ' . $invice_total_value_in_this . ' Paid : ' . $terms_order_details['received_amount'] . " --- last payment on " . $last_payment_date['payment_date'] . $is_sample;
                }
            }
			
			
			  $action = '<div class="btn-group text-left">                       
                          <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button> <ul role="menu" class="dropdown-menu pull-right">
                          <li><a href="' . base_url() . 'marketing_chit_invoice_process/seettu_order_for_customer/' . $id . '"><i class="fa fa-file-text-o"></i> Seettu new order</a></li>
						  <li><a onClick="add_payment(' . $id . ')" data-toggle="modal" href="#"  data-placement="top" data-original-title="add_payment"><i class="fa fa-money"> </i>  Add Payment</a></li> ' . $sample_add  . $edit_seettu . '
            
                            </ul></div>';
			
			
			
            $nested_data[] = $term_count;
            $nested_data[] = $row['group_code'];
            $nested_data[] = $row['term_amount'] . " ( " . $row['term_amount'] / 12 . " X 12 ) ";
            $nested_data[] = $details;
            $nested_data[] = $status;
            $nested_data[] = $action;
            $data[]        = $nested_data;
        }
        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_all_chit_invoice_item_chit_id()
    {
        $chit_id            = $this->input->get('id');	
		$chit_term_list      = $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_term_details_by_seettu_id($chit_id);
		
		$data               = array();
        $count              = 0;		
		$total_sale			=0;	
		foreach($chit_term_list as $key) 
		{
			$chit_invoiced_list = $this->Marketing_Chit_Invoice_Model->chit_invoiced_list_by_term_id($key['id']);			
			$table="<table class='table table-bordered table-condensed table-hover table-striped dataTable'> <tbody>
			<thead>
			<th >Product</th>
			<th class='col-xs-1'>Qty</th>
			<th class='col-xs-1'>Sub Value</th>
			<th class='col-xs-2'>Remarks</th>			
			</thead>
			";
			$tr="<tr>";
			$tre="<tr>";
			$td="<td>";
			$tde="</td>";
			$table_e=" </tbody> </table>";
			
			$total_invoice_value=0;
			$table_rows="";
			$count_recode=0;			
			
			foreach($chit_invoiced_list as $key1) 
			{
				$count_recode=1;
				$total_invoice_value+=$key1['product_qty'] * $key1['product_price'];	
				$data1="";
				$data2="";
				$data3="";
				$data4="";
				$return="";
				if($key1['is_return']==1)
				{
				$return=" <p style='color:#D00'>Returned  Date : ".$key1['return_date']." Qty  : ".$key1['return_qty']." Reason : ".$key1['retun_reason']."</p>";	
				}
				
				 $data1  = "<button  id=group_product_id name=group_product_id class='btn btn-primary'   onClick=get_items(" . $key1['grp_id'] . ")>  <i class= clip-eye></i></button> " . $key1['product_name'] . " / " . $key1['product_code'] . " / Year  " . $key1['book_year'].$return;
				 $data2=$key1['product_qty'];
				 $data3=$key1['product_qty'] * $key1['product_price'];
				 $data4=$key1['invoice_remarks'];				 
				 $table_rows.=$tr.$td.$data1.$tde.$td.$data2.$tde.$td.$data3.$tde.$td.$data4.$tde.$tre;				 
			}			
			$full_table=$table.$table_rows.$table_e;			
			if($count_recode==0)
			{
				$full_table="";
			}
			
			
			$count++;
			$nested_data   = array();
            $nested_data[] = "Term - ".$count;
            $nested_data[] = $key['group_code'];
            $nested_data[] =$key['term_amount'];
            $nested_data[] = $full_table;
            $nested_data[] = $total_invoice_value;
            $data[]        = $nested_data;
			$total_sale   +=$total_invoice_value;
		}
			$nested_data   = array();
			$nested_data[] = "";
            $nested_data[] = "";
            $nested_data[] ="";
            $nested_data[] ="<h4><strong >Total Sales Rs.</strong> <h4>";
            $nested_data[] = "<h4>".$total_sale."</h4>";
			 $data[]        = $nested_data;

        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
	 public function get_all_chit_pending_order_item_chit_id()
    {
        $chit_id            = $this->input->get('id');	
		$chit_term_list      = $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_term_details_by_seettu_id($chit_id);
		
		$data               = array();
        $count              = 0;	
		$total_sale			=0;	
		foreach($chit_term_list as $key) 
		{
			$chit_invoiced_list = $this->Marketing_Chit_Invoice_Model->chit_peinging_order_list_by_term_id($key['id']);			
			$table="<table class='table table-bordered table-condensed table-hover table-striped dataTable'> <tbody>
			<thead>
			<th >Product</th>
			<th class='col-xs-1'>Qty</th>
			<th class='col-xs-1'>Sub Value</th>
			<th class='col-xs-1'>Order Date</th>
						
			</thead>
			";
			$tr="<tr>";
			$tre="<tr>";
			$td="<td>";
			$tde="</td>";
			$table_e=" </tbody> </table>";
			
			$total_invoice_value=0;
			$table_rows="";
			$count_recode=0;
			foreach($chit_invoiced_list as $key1) 
			{
				$count_recode=1;
				$total_invoice_value+=$key1['product_qty'] * $key1['product_price'];
				$total_sale+=$total_invoice_value;				
				$data1="";
				$data2="";
				$data3="";
				$data4="";
				
				
				
				 $data1  = "<button  id=group_product_id name=group_product_id class='btn btn-primary'   onClick=get_items(" . $key1['grp_id'] . ")>  <i class= clip-eye></i></button> " . $key1['product_name'] . " / " . $key1['product_code'] . " / Year  " . $key1['book_year'];
				 $data2=$key1['product_qty'];
				 $data3=$key1['product_qty'] * $key1['product_price'];
				 $data4=$key1['order_date'];
								 
				 $table_rows.=$tr.$td.$data1.$tde.$td.$data2.$tde.$td.$data3.$tde.$td.$data4.$tde.$tre;				 
			}			
			$full_table=$table.$table_rows.$table_e;			
			if($count_recode==0)
			{
				$full_table="";
			}
			$count++;
			$nested_data   = array();
            $nested_data[] = "Term - ".$count;
            $nested_data[] = $key['group_code'];
            $nested_data[] =$key['term_amount'];
            $nested_data[] = $full_table;
            $nested_data[] = $total_invoice_value;
            $data[]        = $nested_data;
		}
		$nested_data   = array();
		 	$nested_data[] = "";
            $nested_data[] = "";
            $nested_data[] ="";
            $nested_data[] ="<h4><strong >Total Pending Orders Rs.</strong> <h4>";
            $nested_data[] = "<h4>".$total_sale."</h4>";
			 $data[]        = $nested_data;

        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
    public function chit_order_list()
    {
        $chit_invoice_list = $this->Marketing_Chit_Invoice_Model->chit_invoice_list();
        $data              = array();
        foreach ($chit_invoice_list as $row) {
            $nested_data = array();
            $id          = $row['chit_id'];
            $action      = '<div class="btn-group text-left">
                       
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="' . base_url() . 'marketing_process/chit_orders/' . $id . '"><i class="fa fa-file-text-o"></i> Seetu Details</a></li>
                            <li><a href="' . base_url() . 'marketing_process/cus_order_manage/' . $id . '"><i class="fa fa-file-text-o"></i> Item Issue</a></li>
                            <li><a href="#" onClick="finish_sample_order(' . $id . ')"><i class="fa fa-file-text-o"></i> Finish chit Order</a></li>
                            <li><a href="#" onClick="finish_sample_order(' . $id . ')"><i class="fa fa-file-text-o"></i> Brake chit Order</a></li>
                            
                            </ul></div>';
            $date        = date_create($row['sale_datetime']);
            $d2          = date_format($date, "Y-m-d");
            $issue_type  = '<span class="label label-danger">Error</span>';
            if ($row['chit_type'] == "NORMALSEETTU") {
                $issue_type = '<span class="label label-info">Normal</span>';
            }
            if ($row['chit_type'] == "") {
            }
            if ($row['chit_type'] == "") {
            }
            $nested_data[] = $d2;
            $nested_data[] = "not yet";
            $nested_data[] = $row['card_ref_number'];
            $nested_data[] = $row['cus_name'];
            $nested_data[] = $row['route_name'];
            $nested_data[] = $issue_type;
            $nested_data[] = $status;
            $nested_data[] = $action;
            $data[]        = $nested_data;
        }
        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function seettu_invoiced_details()
    {
        $seettu_invoice_term_id   = $this->uri->segment(3);
        $data['main_menu_name']   = $this->main_menu_name;
        $data['sub_menu_name']    = "";
        $data['SID']              = $seettu_invoice_term_id;
        $data['invoiced_item']    = $this->Marketing_Chit_Invoice_Model->get_invoice_items_by_term_id($seettu_invoice_term_id);
        $customer_id              = $data['invoiced_item'][0]['customer_id'];
        $data['customer_details'] = $this->Customer_Model->get_customer_info($customer_id);
        $this->load->view('marketing/seettu_invoice_details', $data);
    }
    public function delete_all_seettu_details()
    {
        $id = $this->input->get('id');
        $this->db->trans_start();
        $this->Marketing_Chit_Invoice_Model->delete_payment($id);
        $this->Marketing_Chit_Invoice_Model->delete_invoice($id);
        $this->Marketing_Chit_Invoice_Model->delete_order($id);
        $this->Marketing_Chit_Invoice_Model->delete_term($id);
        $this->Marketing_Chit_Invoice_Model->delete_seettu($id);
        $this->db->trans_complete();
        $trans_status = $this->db->trans_status();
        if ($trans_status == FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        echo json_encode(array(
            'id' => 0,
            'error' => 0,
            'disMsg' => "ok",
            'status' => 1
        ));
    }
    public function edit_seettu()
    {
        $seettu_term_id         = $this->input->get('seettu_term_id');
        $data['seettu_term_id'] = $seettu_term_id;
        $data['seettu_details'] = $this->Marketing_Chit_Invoice_Model->get_seettu_details($seettu_term_id);
        //($data['seettu_details']);
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = '';
        $this->load->view('models/edit_settu', $data);
    }
    public function edit_seettu_save()
    {
        $seettu_term_id          = $this->input->post('seettu_term_id');
        $term_item_amount        = $this->input->post('term_item_amount');
        $term_amount             = $this->input->post('term_amount');
        $settu_total             = $this->input->post('settu_total');
        $data1                   = array(
            'chit_term_value' => $term_amount,
            'chit_total_value' => $settu_total
        );
        $data2                   = array(
            'term_amount' => $term_item_amount
        );
        $all_seettu_term_details = $this->Marketing_Chit_Invoice_Model->get_seettu_term_details_only($seettu_term_id);
        $term_item_id            = $all_seettu_term_details['id'];
        $master_id               = $all_seettu_term_details['m_c_c_id'];
        $result                  = $this->Marketing_Chit_Invoice_Model->update_settu_master_table($data1, $master_id);
        $result                  = $this->Marketing_Chit_Invoice_Model->update_settu_term_table($data2, $term_item_id);
        if ($result == 1) {
            echo json_encode(array(
                'id' => 0,
                'type' => 0,
                'status' => 1
            ));
        } else {
            echo json_encode(array(
                'status' => '0'
            ));
        }
    }
    public function retun_items()
    {
        $invoice_id = $this->input->get('id');
        $comment    = $this->input->get('comment');
        $product    = $this->Marketing_Chit_Invoice_Model->get_product_qty_by_invoice_id($invoice_id);
        $pd_qty     = $product['product_qty'];
        if ($pd_qty > 0) {
            $data1  = array(
                'product_qty' => 0,
                'is_return' => 1,
                'retun_reason' => $comment,
                'return_qty' => $pd_qty,
                'return_date' => date('Y-m-d')
            );
            $result = $this->Marketing_Chit_Invoice_Model->update_settu_invoice_table_for_return($data1, $invoice_id);
            if ($result == 1) {
                echo json_encode(array(
                    'id' => 0,
                    'type' => 0,
                    'status' => 1
                ));
            } else {
                echo json_encode(array(
                    'status' => '0'
                ));
            }
        } else {
            echo json_encode(array(
                'status' => '0'
            ));
        }
    }
	
	//2019-01-06 new update
	public function manual_customer_invoice()
	{
		$this->load->model('Marketing_Order_Management_Model');	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "marketing_order_arrange_list";
		$delivary_id =$this->uri->segment('3');		
		$delivary_details=$this->Marketing_Order_Management_Model->get_delivary_details($delivary_id);		
	    $data['delivary_details']=$delivary_details;		
        $this->load->view('invoice/manual_invoice',$data);
	}
	
	
	public function pending_order_list_by_delivery_id()
    {
		$this->load->model('Marketing_Order_Management_Model');
		$delivery_id = $this->input->get('id');
		$delivary_items_settu_order=$this->Marketing_Order_Management_Model->get_delivary_settu_order_items($delivery_id);
        
        $data              = array();
        foreach ($delivary_items_settu_order as $row) {
            $nested_data = array();
            $id          = $row['id'];		
			if($row['issue_status']==0)
			{			
            $action      = '<div class="btn-group text-left">                       
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">                           
                            <li><a href="#" onClick="order_manual_invoice('. $id .')"><i class="fa fa-file-text-o"></i> Invoice This Order</a></li>			                </ul></div>';				
			}
			else
			{
				$action      = '<span class="label label-success">invoiced</span>';
			} 
			$nested_data[] = $row['card_ref_number']."-".$row['chit_id'];
			$nested_data[] = $row['chit_term_value'];          
            $nested_data[] = $row['product_code'];
            $nested_data[] = $row['product_name'];
			$nested_data[] = $row['product_qty'];
			$nested_data[] = $row['issue_qty'];
            $nested_data[] = $row['cus_name'];

            $nested_data[] = $action;
            $data[]        = $nested_data;
        }
        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
	public function save_new_invoice()
	{
		$order_id=$this->input->post('id');
		$invoice_qty=$this->input->post('qty');	
		$temp_date         = $this->input->post('date_time');
        $invoice_date       = date('Y-m-d', strtotime($temp_date));
		$added_date_time=date('Y-m-d H:i:s');
		$this->load->model('Marketing_Seettu_Order_Process_Model');
		$this->load->model('Android_Model');
		$row=$this->Android_Model->get_order_full_details($order_id);
		$check=$this->Android_Model->check_order_alrady_invoiced($order_id);
		   $error=""; 
		   $result=0;
		   if(isset($row['id']))
		   {
			   if($row['id']==$order_id&&$invoice_qty>0&&$invoice_qty<=$row['product_qty']&&$check==0){				
				$next_ref_number=$this->Common_Model->gen_ref_number('invoice_id','marketing_seettu_customer_term_invoice','INV');			
				$data_item=array(					
					'seettu_cus_master_id'=>$row['seetu_cus_master_id'],
					'route_id'=>$row['route_id'],								
					'sales_rep_id'=>$row['salse_rep_id'],
					'seettu_order_id'=>$row['id'],			
					'warehouse_id'=>$row['warehouse_id'],					
					'customer_id'=>$row['customer_id'],
					'document_ref_number'=>$next_ref_number,
					'invoice_type'=>$row['issue_type'],					
					'seettu_cus_item_id'=>$row['seetu_cus_term_id'] ,
					'invoice_date'=>$invoice_date ,
					'system_enter_date_time'=>$added_date_time ,
					'system_enter_by'=>$this->session->userdata('ss_user_id'),
					'invoice_remarks'=>"" ,
					'status'=>"INVOICED",					
					'product_id'=>$row['product_id'],
					'product_qty'=>$invoice_qty,
					'product_price'=>$row['product_price'],
					'product_cost'=>$row['product_cost'],
					'seettu_type'=>$row['seettu_type'],
					'delivery_id'=>$row['loading_id'], 
					'saved_by'=>"SYSTEM",
					'total_cost'=>$row['product_cost']*$invoice_qty,
					'total_sale'=>$row['product_price']*$invoice_qty
				);								
				$result=$this->Marketing_Seettu_Order_Process_Model->save_customer_term_seettu_invoice($data_item);
				$last_invoice_id=$this->db->insert_id();
				
				if($result==1){
				$remaining_status=0;
				if($invoice_qty<$row['product_qty']){
					$remaining_status=1;
				}
				$data=array(
				'issue_date'=>$added_date_time ,
				'issue_status'=>1,
				'issue_qty'=>$invoice_qty ,
				'remailning_status'=> $remaining_status,
				'remaining_qty'=>$row['product_qty']-$invoice_qty 				
				);
				$result=$this->Android_Model->update_customer_order_table_for_invoice($row['id'],$data);
				if($result==0){
				$error="Update Order function fail. Please inform to system ADMIN";	
				}
				}							
			   }else{
				  $error="Details miss match. Please contact your administrator. ERROR CODE :OR-".$order_id."SM-".$row['seetu_cus_master_id'];	   
			   }				
		   }
		   else{
				  $error="Cannot invoice this order. Please contact your admin.  ERROR CODE :OR-".$order_id."IS_NOT_VALID_ORDER";	   
			   }
			
			if ($result==1) {
				echo json_encode(array('last_id'=>$last_invoice_id,'message'=>"Order Invoiced",'status' =>true));
			} else {
				echo json_encode(array('last_id'=>0,'message'=>$error,'status' =>false));
			}
		
	}
	

	
	
	 public function get_all_chit_payment_by_chit_id()
    {
		$this->load->model('Marketing_Order_Management_Model');
        $chit_id= $this->input->get('id');	
		$chit_term_list= $this->Marketing_Chit_Invoice_Model->get_all_cus_seettu_term_details_by_seettu_id($chit_id);
		
		$data               = array();
		$total_payment=0;
        $count              = 0;		
		foreach($chit_term_list as $key3) 
		{
			$chit_invoiced_list = $this->Marketing_Order_Management_Model->get_payment_list_by_seettu_id($key3['id']);			
			$table="<table class='table table-bordered table-condensed table-hover table-striped dataTable'> <tbody>
			<thead>
			
			<th class='col-xs-1'>Date</th>
			<th class='col-xs-1'>Ref Number</th>
			<th class='col-xs-2'>Note</th>
			<th class='col-xs-1'>Collect By</th>
			<th class='col-xs-1'>Amount</th>			
			</thead>
			";
			$tr="<tr>";
			$tre="<tr>";
			$td="<td>";
			$tde="</td>";
			$table_e=" </tbody> </table>";
			
			$total_payment_term=0;
			$table_rows="";
			$count_recode=0;
			foreach($chit_invoiced_list as $key4) 
			{
				$total_payment_term+=$key4['received_amount'];
				//$total_payment+=$total_payment_term;
				$count_recode=1;				
				$data1="";
				$data2="";
				$data3="";
				$data4="";
				$data5="";
				
				
				
				 $data1 =$key4['payment_date'];
				 $data2=$key4['document_ref_no'];
				 $data3=$key4['sale_pymnt_note'];
				 $data4=$key4['user_first_name'];
				 $data5=$key4['received_amount'];
								 
				 $table_rows.=$tr.$td.$data1.$tde.$td.$data2.$tde.$td.$data3.$tde.$td.$data4.$tde.$td.$data5.$tde.$tre;				 
			}			
			$full_table=$table.$table_rows.$table_e;			
			if($count_recode==0)
			{
				$full_table="";
			}
			$count++;
			$nested_data   = array();
            $nested_data[] = "Term - ".$count;
            $nested_data[] = $key3['group_code'];
            $nested_data[] =$key3['term_amount'];
            $nested_data[] = $full_table;
            $nested_data[] = $total_payment_term;
            $data[]        = $nested_data;
			$total_payment+=$total_payment_term;
		}
			$nested_data   = array();
		 	$nested_data[] = "";
            $nested_data[] = "";
            $nested_data[] ="";
            $nested_data[] ="<h4><strong >Total Payment Rs.</strong> <h4>";
            $nested_data[] = "<h4>".$total_payment."</h4>";
			 $data[]        = $nested_data;

        $json_data = array(
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
	
	
	
	function breake_seettu()
	{
		$chit_id= $this->input->get('id');		
		$data=array(
		'mofidy_by'=>$this->session->userdata('ss_user_id'),
		'close_date'=> date('Y-m-d'),
		'chit_invoice_status'=>"BREAK"		
		);
		$result = $this->Marketing_Chit_Invoice_Model->update_settu_master_table($data, $chit_id);
		
		$message="Error Occured";
		if($result==1){
			$message="Succesfully updated";
		}
		
		 echo json_encode(array(
            'id' => $chit_id,
            'message' => $message,
            'status' => $result
        ));
		
	}
	
	function complete_seettu()
	{
		$chit_id= $this->input->get('id');		
		$data=array(
		'mofidy_by'=>$this->session->userdata('ss_user_id'),
		'close_date'=> date('Y-m-d'),
		'chit_invoice_status'=>"COMPLETED"		
		);
		$result = $this->Marketing_Chit_Invoice_Model->update_settu_master_table($data, $chit_id);
		
		$message="Error Occured";
		if($result==1){
			$message="Succesfully updated";
		}
		
		 echo json_encode(array(
            'id' => $chit_id,
            'message' => $message,
            'status' => $result
        ));
		
	}
	
	
	
	
	
	
}