<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Products extends CI_Controller {

    var $main_menu_name = "products";
	var $sub_menu_name = "products";

    public function __construct()
     {
            parent::__construct();
            $this->load->model('category_models');
            $this->load->model('product_models');
			$this->load->model('common_model');
			$this->load->model('Sales_Model');
			$this->load->model('Transfer_Model');
			$this->load->model('Purchases_Model');
			$this->load->model('Product_Damage_Model');
			$this->load->model('Sales_Return_Model');
			$this->load->model('Purchase_Return_Model');
	}

    public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('products',$data);
	}

	public function add_product()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] 	= 'add_products';
		$data['main_category'] 	= $this->category_models->getCategory();
		$data['main_brand'] 	= $this->category_models->getBrand();
		$data['unit_type'] 		= $this->product_models->getUnit();
		$data['tax'] 		    = $this->product_models->getTax();
		$this->load->view('add_product',$data);
	}

	public function get_sub_category_by_id()
	{
		$parent_category =  $this->input->get('category_id');

		if ( $parent_category ) {
			$val = $this->category_models->get_sub_category( $this->input->get('category_id') );
			if (!empty($val)) {
				echo '<select name="subcategory" id="subcategory" class="form-control search-select">';
				echo "<option value=''></option>";
				foreach ($val as $key => $lst) {
				echo "<option value='$lst->sub_cat_id'>$lst->sub_cat_name</option>";
				}
				echo '</select>';
			}
			
		} else {
			echo NULL;
		}
		
	}

	public function save_product()
	{
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('product_name', 'Product Name', 'required');
        $this->form_validation->set_rules('product_code', 'Product Code', 'required|is_unique[product.product_code]');
        $this->form_validation->set_rules('product_cost', 'product cost', 'required');
        $this->form_validation->set_rules('product_price', 'product price', 'required');
        $this->form_validation->set_rules('wholesale_price', 'wholesale price', 'required');
        $this->form_validation->set_rules('credit_salling_price', 'credit salling price', 'required');
        $this->form_validation->set_rules('alert_quty', 'alert quty', 'required');
		$this->form_validation->set_rules('brand', 'Brand', 'required');
		$this->form_validation->set_rules('short_code', 'short code', 'required');
		



        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        	$product_name 			= $this->input->post('product_name');
        	$product_name_sinhala 	= $this->input->post('product_name_sinhala');
        	$product_code 			= $this->input->post('product_code');
        	$category 	  			= $this->input->post('category');
        	$subcategory  			= $this->input->post('subcategory');
			if(!$subcategory)$subcategory=0;
        	$unit 		  			= $this->input->post('unit');
        	$product_cost 			= $this->price_filter($this->input->post('product_cost'));
        	$product_price 			= $this->price_filter($this->input->post('product_price'));
        	$product_price_2 		= $this->price_filter($this->input->post('product_price_2'));
        	$wholesale_price 		= $this->price_filter($this->input->post('wholesale_price'));
        	$wholesale_price_2		= $this->price_filter($this->input->post('wholesale_price_2'));
			$credit_salling_price 	= $this->price_filter($this->input->post('credit_salling_price'));
        	$tax 					= $this->input->post('tax');
        	$alert_quty 			= $this->input->post('alert_quty');
        	//$image_name 			= $this->input->post('product_image');
        	$product_details 		= $this->input->post('product_details');
			$product_part_no 		= $this->input->post('product_part_no');
			$product_oem_part_number=$this->input->post('product_oem_part_number');			
			$brand=$this->input->post('brand');
			$capacity=$this->input->post('capacity');
			$short_code=$this->input->post('short_code');
			$color=$this->input->post('color');			
			$product_id=$this->input->post('product_id');
			$store_position=$this->input->post('store_position');
			 $product_max_qty=$this->input->post('product_max_qty');
			if(!$product_max_qty)$product_max_qty=0;
        	if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->image_config($image_name_enc));
                if ( ! $this->upload->do_upload()){
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else{
                    $this->load->library('image_lib',$this->image_manipulation->image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
						//start array for save tha data
						$data1 = array(
       					'cat_id'             	=> $category,
       					'sub_cat_id'         	=> $subcategory,
						'product_name'        	=> $product_name,	   
						'product_name_sinhala'         => $product_name_sinhala,
						// 'product_code'			=> $product_code,
						'product_image'        	=> $imgName,
						'product_thumb' 			=> $imageThumb,
       					'product_alert_qty'  	=> $alert_quty,
						'product_unit'  			=> $unit,
       					'product_cost'  			=> $product_cost,
       					'product_price'			=> $product_price,
       					'wholesale_price'  		=> $wholesale_price,
						'product_price_2'			=> $product_price_2,
						'wholesale_price_2'  		=> $wholesale_price_2,
       					'credit_salling_price'  	=> $credit_salling_price,
       					'tax'  					=> $tax,
       					'product_details' 		=> $product_details,
						'product_part_no' => $product_part_no,
						'product_oem_part_number' => $product_oem_part_number,
						'store_position'=>$store_position,
						'product_max_qty'		=>$product_max_qty,
						'item_code'				=>$short_code,
						'capacity'				=>$capacity,
						'color'					=>$color,
						'brand_id'				=>$brand,
    					);
						//End array for save tha data					
						$last_id = $this->product_models->save_product($data1);  
                       if ($last_id) {
                               $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
                               echo json_encode($st);
                       } else {
                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
                       $this->image_lib->clear();
                    } 
                }
        	} else {			
				 $data2 = array(
       			'cat_id'         		=> $category,
				'sub_cat_id'         	=> $subcategory,
				'product_name'        	=> $product_name,	   
				'product_name_sinhala' 	=> $product_name_sinhala,
				// 'product_code'			=> $product_code,
       			'product_alert_qty'  	=> $alert_quty,
       			'product_unit'  		=> $unit,
				'product_cost'  		=> $product_cost,
				'product_price'			=> $product_price,
				'wholesale_price'  		=> $wholesale_price,	   
				'product_price_2'		=> $product_price_2,
				'wholesale_price_2'  	=> $wholesale_price_2,
				'credit_salling_price'  => $credit_salling_price,
				'tax'  					=> $tax,
				'product_details' 		=> $product_details,
				'product_part_no' 		=> $product_part_no,
				'product_oem_part_number' => $product_oem_part_number,
				'store_position'		=>$store_position,
	   			'product_max_qty'		=>$product_max_qty,
				'item_code'				=>$short_code,
				'capacity'				=>$capacity,
				'color'					=>$color,
				'brand_id'				=>$brand,
				 );				
                      $last_id = $this->product_models->save_product($data2);
                       if ($last_id) {
                               $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
                               echo json_encode($st);
                       } else {
                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
        	}
        	
        }

	}

	function price_filter($amount='')
	{
		if($amount){
		$s = explode("Rs.",$amount);
		return str_replace(',', '', $s[1]);
			}else{return 0;}
			
	}

	public function get_list_product($value='')
	{
			
		$search_key=$this->input->get('search');
		$search_key_val=$search_key['value'];
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$totalData = 0;
		
		//print_r($search_key);
		
		$search_name=$this->input->get('search_name');
		if($search_name) $search_key_val=$search_name;
		
	//	echo "search_key_val:$search_key_val";
				
		$values = '';
		$value_count = '';
		if($search_key_val){
		//	$values = $this->product_models->getProducts($start,$length,$search_key_val);
			//$value_count = $this->product_models->getProducts('','',$search_key_val);
		//	$totalData = count($value_count);	
			}else
			{
		//	$values = $this->product_models->getProducts($start,$length,'');
		//	$value_count = $this->product_models->getProducts('','','');
		//	$totalData = count($value_count);
			}
		
		$values = $this->product_models->getProducts($start,$length,$search_key_val);
			$value_count = $this->product_models->getProducts('','',$search_key_val,1);
			$totalData =0;// count($value_count);
			
		$totalData =($value_count);
		$totalFiltered = $totalData;  
		
	    //    $values = $this->product_models->getProducts();
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {
if ($products->product_name == "OUTSTANDING"){continue;} 
	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
              $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;
              $qty = $this->product_models->get_item_qty($products->product_id);
              $qty = (empty($qty[0]->qty)) ? "--:--" : $qty[0]->qty ;
	          $row = array();
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$purchased_return_qty=$this->Purchase_Return_Model->getPurchasedRtnQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				
				$row[] = '';//'<div style="margin-bottom: 0px; width: 50px; height: 50px;" class="fileupload-new thumbnail"><img alt="" src="'.asset_url()."uploads/thumbs/".$products->product_thumb.'"></div>';
				$row[] = $products->product_code;
//				$row[] = $products->product_oem_part_number;
//				$row[] = $products->product_part_no;
$dis_class="";
if($products->product_status==0){
    $dis_class="class='alert-danger'";
}
				$row[] = "<span $dis_class>".$products->product_name.'<br />'.$products->product_name_sinhala."<span>";
				$row[] = $products->cat_name;
				$row[] = $retVal;
				$row[] = $products->product_price;
				//$row[] = $products->product_price_2;
			//	$row[] = $products->wholesale_price;
			//	$row[] = $products->wholesale_price_2;
			//	$row[] = $products->credit_salling_price;
			$des='';
			if($products->product_part_no){
			    	$des=$products->product_part_no.'%';
			}
				$row[] = $des;
				$row[] = $products->product_cost;
				$row[] = number_format(($purchased_qty-$purchased_return_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty), 2, '.', ',');
						$actdes='';
						$actdes =$actdes. '<div class="btn-group text-left">
						<button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
						<ul role="menu" class="dropdown-menu pull-right">
						<li><a href="'.base_url('products/view').'/'.$products->product_id.'"><i class="fa fa-file-text-o"></i> Product Details</a></li>
						';
						if ($this->session->userdata('ss_group_id')!=3){
						$actdes =$actdes. '    <li><a href="'.base_url('products/edit').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Edit Product</a></li>
						<li class="divider"></li>
						<li><a onclick="product_delete('.$products->product_id.'); return false;" href="#"><i class="fa fa-trash-o"></i> Delete Product</a></li>
						';
						
							$actdes = $actdes.'<li><a onclick=" print_barcode('.$products->product_id.'); return false;" href="#"><i class="fa fa-print"></i> Print Barcode</a></li>';
							if ($products->product_status == 1) {
								$actdes = $actdes.' <li><a style="cursor: pointer;" onClick="disable_product(' . $products->product_id . ')"><i class="glyphicon fa fa-minus-circle"></i> Disable Product</a></li>';
							} else
	
							if ($products->product_status == 0) {
								$actdes = $actdes.' <li><a style="cursor: pointer;" onClick="enable_product(' . $products->product_id . ')"><i class="fa fa-check"></i> Enable Product</a></li>';
							}
						}
						$actdes = $actdes.'</ul></div>';
				$row[] =$actdes;		
	                $data[] = $row;
	            }

	            $output = array(
								"recordsTotal"    => intval( $totalData ),  
								"recordsFiltered" => intval( $totalFiltered ),
								"data" =>$data
								);
	            echo json_encode($output);
	        }else{
	            $output = array(
								"recordsTotal"    => '',  
								"recordsFiltered" => '',
								"data" =>''
				);
	            echo json_encode($output);
	        }
	   }

  public function view($product_id = "")
  { 

    $sd = $this->product_models->get_product_by_id($product_id);

    if(!empty($sd)){

          $data['product_details'] = $this->product_models->get_product_by_id($product_id);
          $data['warehouses'] = $this->product_models->get_warehouse_product($product_id);
          $data['main_menu_name'] = $this->main_menu_name;
          $data['sub_menu_name'] = $this->sub_menu_name;
          $this->load->view('view_product',$data);

    }else{

          show_404();

    }

  }

  public function edit($product_id='')
  {
          $data['main_menu_name'] = $this->main_menu_name;
          $data['sub_menu_name']  = $this->sub_menu_name;
          $data['main_category']  = $this->category_models->getCategory();
          $data['unit_type']      = $this->product_models->getUnit();
          $data['tax']            = $this->product_models->getTax();
          $data['product_details']= $this->product_models->get_product_by_id($product_id);
	  	  $data['main_brand'] 	= $this->category_models->getBrand();
          $data['sub_category']   = $this->category_models->getSubCategory($data['product_details']->cat_id);
          $this->load->view('edit_product',$data);
  }

  public function single_barcode($product_id='')
  {
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $this->load->view('barcode/product_barcode',$data);
  }

    function gen_barcode($product_code = NULL, $height = 80)
    {
      if($this->input->get('code')){ $product_code = $this->input->get('code'); }
      if($this->input->get('height')){ $height = $this->input->get('height'); }
    
    //load library
    $this->load->library('zend');
    //load in folder Zend
    $this->zend->load('Zend/Barcode');
    //'drawText' => FALSE
    $barcodeOptions = array('text' => $product_code, 'barHeight' => $height, 'stretchText' => TRUE );
    $rendererOptions = array('imageType'=>'png', 'horizontalPosition' => 'center', 'verticalPosition' => 'middle');
    $imageResource = Zend_Barcode::render('code128', 'image', $barcodeOptions, $rendererOptions);
    return $imageResource;
     
    }

  function delete_product($product_id='')
  {
    $d = $this->product_models->delete_product($this->input->post('product_id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
    
  }
  public function edit_product()
  {
     
          $product_name           = $this->input->post('product_name');
		  $product_name_sinhala   = $this->input->post('product_name_sinhala');
//		  echo $product_name_sinhala;die();
          $product_code           = $this->input->post('product_code');
          $category               = $this->input->post('category');
          $subcategory            = $this->input->post('subcategory');
          $unit                   = $this->input->post('unit');
          $product_cost           = $this->price_filter($this->input->post('product_cost'));
          $product_price          = $this->price_filter($this->input->post('product_price'));
		  $product_price_2          = $this->price_filter($this->input->post('product_price_2'));
          $wholesale_price        = $this->price_filter($this->input->post('wholesale_price'));
		  $wholesale_price_2        = $this->price_filter($this->input->post('wholesale_price_2'));
          $credit_salling_price   = $this->price_filter($this->input->post('credit_salling_price'));
          $tax                    = $this->input->post('tax');
          $alert_quty             = $this->input->post('alert_quty');
          $product_details        = $this->input->post('product_details');
		  $product_part_no 		= $this->input->post('product_part_no');
		  $product_oem_part_number= $this->input->post('product_oem_part_number');
		  $store_position= $this->input->post('store_position');
		  $product_max_qty=$this->input->post('product_max_qty');
	  	  $brand=$this->input->post('brand');
		  $capacity=$this->input->post('capacity');
		  $short_code=$this->input->post('short_code');
	 	  $color=$this->input->post('color'); 
	 	  
	 	//  echo ""

          if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->image_config($image_name_enc));
                if ( ! $this->upload->do_upload()){
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else{
                    $this->load->library('image_lib',$this->image_manipulation->image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
						//data array start						
						$data1 = array(
       					'cat_id'             	=> $category,
       					'sub_cat_id'         	=> $subcategory,
						'product_name'        	=> $product_name,	   
						'product_name_sinhala'  => $product_name_sinhala,
						'product_code'		=> $product_code,
						'product_image'        	=> $imgName,
						'product_thumb' 		=> $imageThumb,
       					'product_alert_qty'  	=> $alert_quty,
						'product_unit'  		=> $unit,
       					'product_cost'  		=> $product_cost,
       					'product_price'			=> $product_price,
       					'wholesale_price'  		=> $wholesale_price,
						'product_price_2'		=> $product_price_2,
						'wholesale_price_2'  	=> $wholesale_price_2,
       					'credit_salling_price'  => $credit_salling_price,
       					'tax'  					=> $tax,
       					'product_details' 		=> $product_details,
						'product_part_no' 		=> $product_part_no,
						'product_oem_part_number'=> $product_oem_part_number,
						'store_position'		=>$store_position,
						'product_max_qty'		=>$product_max_qty,
						'item_code'				=>$short_code,
						'capacity'				=>$capacity,
						'color'					=>$color,
						'brand_id'				=>$brand,
    					);					
						//data array end
                       if ($this->product_models->update_product($this->input->post('product_id'),$data1)) {
                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);
                       } else {
                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
                       $this->image_lib->clear();
                    }                  

                }

          } else {			  
			  	//data array start
			  	$data2 = array(
       			'cat_id'         		=> $category,
				'sub_cat_id'         	=> $subcategory,
				'product_name'        	=> $product_name,	   
				'product_name_sinhala' 	=> $product_name_sinhala,
				 'product_code'			=> $product_code,
       			'product_alert_qty'  	=> $alert_quty,
       			'product_unit'  		=> $unit,
				'product_cost'  		=> $product_cost,
				'product_price'			=> $product_price,
				'wholesale_price'  		=> $wholesale_price,	   
				'product_price_2'		=> $product_price_2,
				'wholesale_price_2'  	=> $wholesale_price_2,
				'credit_salling_price'  => $credit_salling_price,
				'tax'  					=> $tax,
				'product_details' 		=> $product_details,
				'product_part_no' 		=> $product_part_no,
				'product_oem_part_number' => $product_oem_part_number,
				'store_position'		=>$store_position,
	   			'product_max_qty'		=>$product_max_qty,
				'item_code'				=>$short_code,
				'capacity'				=>$capacity,
				'color'					=>$color,
				'brand_id'				=>$brand,
				 );		  
			  	
			  		//data array end
                       if ($this->product_models->update_product($this->input->post('product_id'),$data2)) {
                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);
                       } else {
                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }

          }
          


  }

 public function getProductsForReport() {

        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->get('cat_srh');

        $values = $this->product_models->getProductsForReportAlert($srh_warehouse_id, $cat_srh);
        echo json_encode($values);
    }
	
	public function enable() {

        $product_id = $this->input->get('product_id');

        $result = $this->product_models->enable($product_id);

        return $result;
    }

    public function disable() {

        $product_id = $this->input->get('product_id');

        $result = $this->product_models->disable($product_id);

        return $result;
    }

}