<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class City_Model extends CI_Model {

public function __construct()
   {
      parent::__construct();

   }     

function citySave($data)
{ 
     if($this->db->insert('mstr_city', $data))
     {
       return true;
     }
     else
     {
       return false;
     }
}

function getCityByName($city_name='')
{
  $this->db->select('m.*');
  $this->db->select('r.route_name');
  $this->db->from('mstr_city m');
  $this->db->join('route r','r.route_id=m.route_id','left');
  $this->db->where('cname',$city_name);
  $cat = $this->db->get();
  $ret = ( $cat->num_rows > 0 ) ? $cat->result() :false ;
  return $ret;
}

public function getCity()
{
     $this->db->select('m.*');
     $this->db->select('r.route_name');
     $this->db->select('d.district_name');
     $this->db->from('mstr_city m');
     $this->db->join('route r','r.route_id=m.route_id','left');
     $this->db->join('master_district d','d.district_id=m.district_id','left');
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
}

function getCityBYId($city_id='')
{
  $this->db->select('*');
  $this->db->from('mstr_city');
  $this->db->where('cid',$city_id);
  $cat = $this->db->get();
  $ret = ( $cat->num_rows > 0 ) ? $cat->result() :false ;
  return $ret;
}

function cityUpdate($city_id='',$data)
{
  $this->db->where('cid', $city_id);
   if($this->db->update('mstr_city', $data))
   {
     return true;
   }
   else
   {
     return false;
   }
}

function cityChangeStatus($city_id='',$status='')
{
  $cat_id = ($status ==0) ? 1 : 0 ;
  $data  = array(
                 'status'  => $cat_id
              );
  $this->db->where('cid', $city_id);
   if($this->db->update('mstr_city', $data))
   {
     return true;
   }
   else
   {
     return false;
   }
}

function cityPermanentDelete($city='')
{ 
     $this->db->where('cid', $city);
     if($this->db->delete('mstr_city'))
     {
       return true;
     }
     else
     {
       return false;
     }
 
}

public function get_distric()
{
     $this->db->select('*');
     $this->db->from('master_district');
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
}


  




}
