<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Purchases_Order_Model extends CI_Model {
  
  private $tableName = 'purchases_order';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  public function get_purchese_order_data_by_id($po_id='')
  {
     $this->db->select('*');
     $this->db->from('purchases_order_items i');
     $this->db->where('i.po_id',$po_id);
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
    function get_next_ref_no($w){
	  $this->db->select_max('warehouse_po_id');
	  $this->db->where("warehouse_id", $w);
	  	
	  return $this->db->get('purchases_order');
  }

  
  

  
   //Sales best for dashboard
   function getBestSales($year=null,$month=0,$from=0,$to=0){
	$this->db->select('SUM(ft.fi_qty)AS fi_qty_tot,p.product_name,p.product_code,p.product_part_no,p.product_oem_part_number');
	$this->db->from('fi_table ft');
	$this->db->join('product p', 'ft.fi_item_id = p.product_id', 'left');
	$this->db->where('ft.fi_type_id', 'sale');
	if($month){
		$this->db->where('MONTH(ft.fi_date_time)', $month , FALSE);
	}
	if($year){
		$this->db->where('YEAR(ft.fi_date_time)', $year , FALSE);
	}
	if($to){
		$this->db->limit($to,$from);
	}
	$this->db->order_by("fi_qty_tot", "desc");
	$this->db->group_by('ft.fi_item_id');
	$query=$this->db->get();
	return $query->result();
  }  
  

 
  //Sales get avalable product qty
  function get_avalable_product_qty($product_id,$warehouse_id){
		$this->db->select_sum('fi_qty');
		$query = $this->db->get('fi_table');
	
		return $query->row()->fi_qty;
  }
  

  
    //Sales get information
	public function get_po_info($id)
	 {
		$this->db->select('r.*,w.*,s.supp_company_name');
		$this->db->from('purchases_order r');
		$this->db->join('warehouses w', 'w.id = r.warehouse_id', 'left');
		//$this->db->join('requisition req', 'req.req_id = r.req_id', 'left');
		$this->db->join('supplier s', 's.supp_id = r.supp_id', 'left');
		$this->db->where("r.po_id", $id);
		$this->db->order_by("r.po_id", "desc");
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result(); 
	 }

    //Sales get information
	public function get_purchases_order_items_by_id($po_id)
	 {
		$this->db->select('ri.*, u.unit_name,u.unit_name,p.product_name,p.product_code,p.product_part_no');
		$this->db->from('purchases_order_items ri');
		 $this->db->join('mstr_unit u','ri.product_unit = u.unit_id','left');
		  $this->db->join("product p", "p.product_id = ri.product_id", "left");
		$this->db->where("ri.po_id", $po_id);
		$this->db->order_by("ri.po_id", "desc");
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result(); 
	 }
	 
	     //Sales get information
	public function get_purchases_order_details_by_id($po_id)
	 {
		$this->db->select('r.*,w.*,s.supp_company_name');
		$this->db->from('purchases_order r');
		$this->db->join('warehouses w', 'w.id = r.warehouse_id', 'left');
		//$this->db->join('requisition req', 'req.req_id = r.req_id', 'left');
		$this->db->join('supplier s', 's.supp_id = r.supp_id', 'left');
		$this->db->where("r.po_id", $po_id);
		$this->db->order_by("r.po_id", "desc");
		$query = $this->db->get();  
		//echo $this->db->last_query();
		return $query->row();
	 }
	 	 
	 
	 
	//Sales item list get by id 
	public function get_po_item_list_by_po_id($po_id)
	 {
		$this->db->select('i.*,u.unit_name,p.product_name,p.product_code,p.product_part_no');
		$this->db->from('purchases_order_items i');
		$this->db->join('product p', 'i.product_id = p.product_id', 'left');
		$this->db->join('mstr_unit u', 'u.unit_id = i.product_unit', 'left');
		//$this->db->join('supplier s', 's.supp_id = i.product_unit', 'left');
		$this->db->order_by("i.poitm_id", "desc");
		$this->db->where("i.po_id", $po_id);//("id !=",$id);
		$query = $this->db->get();
		return $query->result();
		
	 }

	//Sales save
	function save_purchases_order(&$supplier_data,$po_id=false)
	{
		if (!$po_id)
		{
			$this->db->insert($this->tableName,$supplier_data);
		}else {
			$this->db->where('po_id', $po_id);
			return $this->db->update($this->tableName,$supplier_data);
		}
	}	
	
	//Sales item save
	function save_purchases_order_item(&$data_item)
	{
			$this->db->insert('purchases_order_items',$data_item);
	}	

	//Sales get for report
	function get_all_purchases_order_for_report($srh_warehouse_id='',$srh_to_date='',$srh_from_date='',$po_id='',$from='',$to='') {
		$this->db->select('s.* , c.cus_name');
		$this->db->from('purchases_order s');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
		
		$this->db->order_by("s.po_id", "desc");
		$this->db->group_by('s.po_id');
		if($srh_warehouse_id){
			$this->db->where("s.warehouse_id",$srh_warehouse_id);//("id !=",$id);
		}
		if($srh_to_date){
			$this->db->where("s.po_datetime <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("s.po_datetime >=",$srh_from_date);//("id !=",$id);
		}
		if($po_id){
			$this->db->where("s.po_id =",$po_id);//("id !=",$id);
		}
		if($to){
		$this->db->limit($to,$from);
		}
		$query = $this->db->get();
		return $query->result_array();
	}	
	
	//Sales all get
	function get_all_purchases_order($warehouse_id='') {
		$this->db->select('o.*,w.*');
		$this->db->from('purchases_order o');
		$this->db->join('warehouses w', 'w.id = o.warehouse_id', 'left');
		
		$this->db->order_by("o.po_id", "desc");
		$this->db->where("o.po_id IS NOT NULL");//("id !=",$id);
		if($warehouse_id){
		$this->db->where("o.warehouse_id",$warehouse_id);
		}
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_all_purchases_orders_for_grn() {
		$this->db->select('o.*,w.*/');
		$this->db->from('purchases_order o');
		$this->db->join('warehouses w', 'w.id = o.warehouse_id', 'left');
		//$this->db->join('requisition r', 'r.req_id = o.req_id', 'left');
		$this->db->order_by("o.po_id", "desc");
		$this->db->where("o.po_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result();
	}
	
	//Sales get for print
	function get_all_purchases_order_for_print_purchases_order() {
		$this->db->select('s.* , c.cus_name ');
		$this->db->from('purchases_order s');
		$this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
	
		$this->db->order_by("s.po_id", "desc");
		$this->db->group_by('s.po_id');
		$this->db->where("s.po_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	public function delete_old_purchases_order_items($po_id)
	{
		$this->db->where('po_id', $po_id);
		$this->db->delete('purchases_order_items');
	}
	

	
	//Get product sujetions
	function get_products_suggestions_po($term) {
		$this->db->select('product'.'.*');
		$this->db->order_by("product_name", "asc");
		//$this->db->where("product_id != 1");
		$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		 $this->db->limit(10, 0);
		$query = $this->db->get('product');
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
		//Get product sujetions
	function get_products_suggestions($term) {
		$this->db->select('product'.'.*');
		$this->db->order_by("product_name", "asc");
		$this->db->where("product_id != 1");
		$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		 $this->db->limit(10, 0);
		$query = $this->db->get('product');
		//echo $this->db->last_query();
		return $query->result_array();
	}
	
	//Get all products
	function get_all_products() {
		$this->db->select('product'.'.*');
		$this->db->order_by("product_name", "asc");
		$this->db->where("product_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get('product');
		return $query->result_array();
	}
	
	
}