<?php
defined('BASEPATH') OR exit('No direct script access allowed');



class product_model extends CI_Model {
  public function __construct() {
    parent::__construct();
    $this->load->database();
    $this->table = 'product';
  }

  //edit by gihan dias 2023/06/22
  public function get_shop_product_count($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$keyword='',$brand_id='',$color_id='',$capacity_id='',$storage_id='',$min_price='',$max_price=''){

    $this->db->from('product p');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    //$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }

    /*

    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }

    if($min_price){
      $this->db->where('p.product_price >=' , $min_price);
    }
    if($max_price){
      $this->db->where('p.product_price <=' , $max_price);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    */


    $query = $this->db->get();
    //echo $this->db->last_query(); die();
    $result = $query->num_rows();
    return $result;
  }

  //edit by gihan dias 2023/06/22
  public function get_product_details($pid){
    $this->db->select('p.product_id,p.product_code,p.product_name,p.product_image,p.product_price,p.product_details,p.preparation_time');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');
    $this->db->select('mc.capacity_name');

    $this->db->from('product p');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('mstr_capacity mc','mc.capacity_id = p.capacity_id','left');
    //$this->db->join('mstr_waranty mw','mw.waranty_id = p.warranty_id','left');
    $this->db->where('p.product_id' , $pid);
    $query = $this->db->get();
    return $query->row_array();
  }

  //edit by gihan dias 2023/06/22

//   public function get_product_variation_details(){
//     $this->db->distinct();
//     $this->db->select('product_details pd');
//     $this->db->from('product_variation');

//     $query = $this->db->get();
//     return $query->result_array();
// }

public function get_shop_product_list_by_category($cat_id, $start, $no_of_recode) {
  $this->db->select('p.*');
  $this->db->from('product p');
  $this->db->join("product_category pc", 'pc.cat_id = p.cat_id', 'left');
  $this->db->where('p.cat_id', $cat_id);
  $this->db->where("p.product_status", 1);
  $this->db->where("pc.cat_status", 1);
  $this->db->limit($no_of_recode, $start);
  $query = $this->db->get();
  return $query->result_array();
}





public function get_product_variation_details($product_id){
  $this->db->distinct();
  $this->db->select('pv.product_weight,pv.product_w_id ');
  $this->db->from('product p ');
  $this->db->join('product_variation pv', 'p.product_id = pv.product_id', 'inner');
  $this->db->where("pv.product_id",$product_id);
  $query = $this->db->get();
  return $query->result_array();
}

public function get_product_price($product_price_id){

  $this->db->select('pv.product_price, pv.product_w_id, pv.product_weight, p.product_name, p.product_thumb, p.product_id');
  $this->db->from('product_variation pv');
  $this->db->join('product p', 'p.product_id = pv.product_id', 'inner');
  $this->db->where("pv.product_w_id", $product_price_id);
  $query = $this->db->get();
  return $query->row_array();
}
public function save_order_details($data) {
  if ($data) {
      $this->db->insert('write_type', $data);
      $insert_id = $this->db->insert_id();
      return $insert_id;
  } else {
      return false;
  }
}
// public function get_product_details($product_details){

//   $this->db->select('pv.product_details,pv.product_price, pv.product_w_id,pv.product_weight');
//   $this->db->from('product_variation pv');
//    $this->db->where("pv.product_w_id", $product_details);
//   $query = $this->db->get();
//   return $query->row_array();
// }







  public function get_shop_product_list($cat_id='',$sub_cat_id='',$keyword='',$min_price='',$max_price='',$start='',$no_of_recode=''){
  //  $get_avalable_product  = $this->get_avalable_product();
  $this->db->select('p.*');

  $this->db->from('product p');

  if($cat_id){
    $this->db->where('p.cat_id' , $cat_id);
  }

/*
    $this->db->select('p.*');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');

    $this->db->from('product p');

    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');

    $this->db->where("p.product_status",1);
    $this->db->where("p.show_website",1);
    $this->db->where("pc.cat_status",1);

    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }


    if($min_price){
      $this->db->where('p.product_price >=' , $min_price);
    }
    if($max_price){
      $this->db->where('p.product_price <=' , $max_price);
    }
    $q_where='';
    if($keyword){
      $pieces = explode(" ", $keyword);
      //print_r($pieces);
      for($i=0; $i<count($pieces); $i++){
        $searh_key=$pieces[$i];
        $this->db->like('p.product_name', $searh_key);
      }
      //$this->db->where($q_where);
      //$this->db->like('p.product_name', $keyword);
    }
    if($no_of_recode){
      $this->db->limit($no_of_recode,$start);
    }else{
      $this->db->limit(40);
    }
    $this->db->order_by('pable','DESC');
    */
    $query = $this->db->get();
    //echo $this->db->last_query(); die();
    return $query->result_array();
  }

  public function get_product($data) {
    $this->db->select('product.*');
    if (isset($data['cat_id'])) {
      $this->db->where('cat_id', $data['cat_id']);
    }

    $query = $this->db->get($this->table);
    return $query->result();
  }


  public function get_product_price_des($pid){
    $set_special_price=0;
    $cus_type=$this -> session -> userdata('cus_type');

    //echo "test:".$cus_type;
    if($cus_type=='Special') $set_special_price=1;

    // echo "..:$set_special_price";
    // echo "cus id:".$this -> session -> userdata('site_cus');

    if($set_special_price==1){
      $this->db->select('pis.special_price as w_price,pis.special_price,pis.pis_cost_price,pis.pis_cost_price,pis.pis_cash_price,p.is_price_manual_upate,p.price_5,p.wholesale_price');

      $this->db->order_by('pis.special_price' , "desc");
    }
    else {
      $this->db->select('pis.w_price as w_price,pis.special_price,pis.pis_cost_price,pis.pis_cost_price,pis.pis_cash_price,p.is_price_manual_upate,p.price_5,p.wholesale_price');
      $this->db->order_by('pis.w_price' , "desc");
    }

    //$this->db->select('pis.special_price as w_price,pis.special_price,pis.pis_cost_price,pis.pis_cost_price');

    $this->db->from('purchase_items_serial pis');
    $this->db->join("product p",'pis.product_id = p.product_id','left');

    $this->db->where('pis.product_id' , $pid);

    //$this->db->where('pis.product_avalable' , 1);
    $where = '(pis.product_avalable="1" or pis.product_avalable = "2")';
    $this->db->where($where);
    // $this->db->or_where('pis.product_avalable' , 1);




    $query = $this->db->get();

    $return_array=array();
    $return_array=$query->row_array();


    //echo "<br/> test:".$return_array['is_price_manual_upate'];

    if($return_array['is_price_manual_upate']==1){
      if($set_special_price==1){
        $return_array['w_price']=$return_array['price_5'];
      }else{
        $return_array['w_price']=$return_array['wholesale_price'];
      }
    }

    // echo "";
    //  echo $this->db->last_query();
    // print_r($return_array);
    return $return_array;
    // $pro_dis_price_ary=$query->row_array();
    //  $pro_dis_price=$pro_dis_price_ary['w_price'];
    //print_r($pro_price_des['w_price']);
    // return $pro_dis_price;
  }



  public function get_product_warranty_des($pid){
    $set_special_price=0;
    $cus_type=$this -> session -> userdata('cus_type');
    if($cus_type=='Special') $set_special_price=1;

    //echo "cus_name:$set_special_price";
    // echo "cus id:".$this -> session -> userdata('site_cus');

    {
      $this->db->select('pis.pis_warranty_month as pis_warranty_days');
    }

    //$this->db->select('pis.special_price as w_price,pis.special_price,pis.pis_cost_price,pis.pis_cost_price');

    $this->db->from('purchase_items_serial pis');
    $this->db->join("product p",'pis.product_id = p.product_id','left');

    $this->db->where('pis.product_id' , $pid);
    $this->db->where('pis.product_avalable' , 1);
    $this->db->order_by('pis.pis_warranty_month' , "asc");
    $query = $this->db->get();

    $return_array=array();
    $return_array=$query->row_array();


    //echo "<br/> test:".$return_array['is_price_manual_upate'];



    // print_r($return_array);
    return $return_array;
    // $pro_dis_price_ary=$query->row_array();
    //  $pro_dis_price=$pro_dis_price_ary['w_price'];
    //print_r($pro_price_des['w_price']);
    // return $pro_dis_price;
  }



  public function get_product_list($cat_id='',$sub_cat_id='',$keyword=''){
    $this->db->select('p.*');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->from('product p');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('color c','c.color_id = p.color_id','left');
    $this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }



    $query = $this->db->get();
    return $query->result_array();
  }
  //------------------------------------------------

  public function get_group_products($gid){

    $this->db->select('product.*,color.color,memory.memory');
    //$this->db->join('product_attribute' , 'product.product_id = product_attribute.product_id', 'left outer');
    $this->db->join('color' , 'color.color_id = product.color_id', 'left outer');
    $this->db->join('memory' , 'memory.memory_id = product.storage_id', 'left outer');
    $this->db->where('product.group_id',$gid);
    $query = $this->db->get('product');
    return $query->result_array();
  }



  public function get_product_group($data) {
    $this->db->select('product_groups.*');
    $this->db->from('product_groups');
    $this->db->join("product",'product_groups.product_g_id = product.group_id');
    if (isset($data['cat_id'])) {
      $this->db->where('cat_id', $data['cat_id']);
    }
    $query = $this->db->get($this->table);
    return $query->result();
  }

  public function get_product_byid($p_id) {
    $this->db->select();
    $this->db->where('product_id', $p_id);
    $query1 = $this->db->get($this->table)->first_row('array');
    return $query1;
  }

  public function get_category() {
    $query = $this->db->get('product_category');
    return $query->result();
  }

  public function get_subcategory() {
    $query = $this->db->get('product_sub_category');
    return $query->result();
  }

  //----------------------------------------------------------------------

  public function get_single_product($product_id)
  {
    //get new arrival product
    $new_arraival=$this->get_single_product_details($product_id);

    $new_arrival_data=array();
    foreach($new_arraival as $na){
      $di_de_dis		=0;
      $di_de_dis_id	=0;
      $sp_of_dis		=0;
      $sp_of_dis_id	=0;
      $discount_value	=0;
      $discount_id	=0;
      $discount_type	=0;
      $di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);
      //$availble_qty=$this->get_available_qty($na['product_id']);
      $availble_qty=$na['stock_availability'];
      $sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
      if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
      if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];}
      if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
      if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

      $discount_price=($na['product_price']/100)*$discount_value;
      $product_price=$na['product_price']-$discount_price;

      $nested_data=array(
        'product_name'=>$na['product_name'],
        'product_code'=>$na['product_code'],
        'product_thumb'=>$na['product_thumb'],
        'product_image'=>$na['product_image'],
        'cat_name'=>$na['cat_name'],
        'product_price'=>number_format($product_price, 2, '.', ''),
        'product_cost'=>$na['product_cost'],
        'product_details'=>$na['product_details'],
        'product_specification'=>$na['product_specification'],
        'product_id'=>$na['product_id'],
        'discount_value'=>number_format($discount_price, 2, '.', ''),
        'original_price'=>$na['product_price'],
        'accessories'=>$na['accessories'],
        'brand_name'=>$na['brand_name'],
        'model_number'=>$na['model_number'],
        'color'=>$na['color'],
        'sh_cat_value'=>$na['sh_cat_value'],
        'product_discount_id'=>$discount_id,
        'product_discount'=>$discount_value."%",
        'availble_qty'=>$availble_qty,
        'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
        'image_path'=>base_url()."admin/uploads/product/image/",
        'waranty_conditions'=>$na['waranty_conditions'],
        'stock_availability'=>$na['stock_availability'],
        'sold_qty'=>$na['sold_qty'],
        'return_policy'=>$na['return_policy'],
        'delivery_estimate'=>$na['delivery_estimate'],

      );
      $new_arrival_data=$nested_data;
    }
    return  $new_arrival_data;
  }


  //----------------------------------------------------------------------

  public function get_muliti_product($data)
  {
    $product_list=array();
    foreach($data as $na){
      $di_de_dis		=0;
      $di_de_dis_id	=0;
      $sp_of_dis		=0;
      $sp_of_dis_id	=0;
      $discount_value	=0;
      $discount_id	=0;
      $discount_type	=0;
      $di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);
      //$availble_qty=$this->get_available_qty($na['product_id']);
      $availble_qty=$na['stock_availability'];
      $sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
      if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
      if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];}
      if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
      if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

      //$avalable_qty_ary=$this->get_item_avalable_qty_by_id($na['product_id']);
      //$product_avalable=$avalable_qty_ary['product_avalable'];

      $discount_price=($na['product_price']/100)*$discount_value;
      $product_price=$na['product_price']-$discount_price;

      $nested_data=array(
        'product_name'=>$na['product_name'],
        'product_code'=>$na['product_code'],
        'product_thumb'=>$na['product_thumb'],
        'product_image'=>$na['product_image'],
        'cat_name'=>$na['cat_name'],
        'product_price'=>$product_price,
        'product_cost'=>$na['product_cost'],
        'product_details'=>$na['product_details'],
        'product_specification'=>$na['product_specification'],
        'product_id'=>$na['product_id'],
        'discount_value'=>$discount_price,
        'original_price'=>$na['product_price'],
        'accessories'=>$na['accessories'],
        'brand_name'=>$na['brand_name'],
        'model_number'=>$na['model_number'],
        'color'=>$na['color'],
        'sh_cat_value'=>$na['sh_cat_value'],
        'product_discount_id'=>$discount_id,
        'product_discount'=>$discount_value."%",
        'availble_qty'=>$availble_qty,
        'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
        'image_path'=>base_url()."admin/uploads/product/image/",
        'waranty_conditions'=>$na['waranty_conditions'],
        'stock_availability'=>$na['stock_availability'],
        'sold_qty'=>$na['sold_qty'],
        'return_policy'=>$na['return_policy'],
        'product_avalable'=>$na['pable'],

      );
      $product_list[]=$nested_data;
    }
    $this->array_sort_by_column($product_list, 'product_avalable',SORT_DESC);
    return  $product_list;
  }

  function array_sort_by_column(&$arr, $col, $dir = SORT_ASC) {
    $sort_col = array();
    foreach ($arr as $key => $row) {
      $sort_col[$key] = $row[$col];
    }

    array_multisort($sort_col, $dir, $arr);
  }


  public function get_single_product_details($product_id)
  {
    $this->db->select('pc.*');
    $this->db->select('p.*');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('sh.sh_cat_value');
    $this->db->from('product p');
    $this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
    $this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
    $this->db->join('color c','p.color_id=c.color_id','left');
    $this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    return $query->result_array();
  }
  //----------------------------------------------------------------------------
  //get product daily deal disount
  public function get_daily_deal_disount($product_id)
  {
    $date=date("Y-m-d H:i:s");
    $this->db->select('dp.discount_value,dp.discount_presentage,dp.daily_deal_id');
    $this->db->from('daily_deals_product dp');
    $this->db->where("dp.is_remove",0);
    $this->db->where("dp.approval_status",1);
    $this->db->where("dp.product_id",$product_id);
    $this->db->where("dp.start_date_time <=",$date);
    $this->db->where("dp.end_date_time >",$date);
    $this->db->order_by('dp.daily_deal_id','desc');
    $query=$this->db->get();
    return $query->row_array();
  }
  //get product special offer  disount
  public function get_speciacl_offer_disount($product_id)
  {
    $date=date("Y-m-d H:i:s");
    $this->db->select('dp.discount_value,dp.discount_presentage,dp.sp_dis_id,dp.start_date_time,dp.end_date_time');
    $this->db->from('specical_offer_product dp');
    $this->db->where("dp.is_remove",0);
    $this->db->where("dp.approval_status",1);
    $this->db->where("dp.product_id",$product_id);
    $this->db->where("dp.start_date_time <=",$date);
    $this->db->where("dp.end_date_time >",$date);
    $this->db->order_by('dp.sp_dis_id','desc');
    $query=$this->db->get();
    return $query->row_array();
  }
  //--get product spesifications
  public function get_single_product_spesification($product_id)
  {
    $this->db->select('p.*');
    $this->db->from('product_specification p');
    //$this->db->where("p.product_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    return $query->result_array();
  }

  public function get_single_product_connectivity($product_id)
  {
    $this->db->select('p.*');
    $this->db->from('product_connectivity p');
    //$this->db->where("p.product_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    return $query->result_array();
  }

  public function get_single_product_accessories($product_id)
  {
    $this->db->select('p.*');
    $this->db->from('product_accessories p');
    //$this->db->where("p.product_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    return $query->result_array();
  }



  public function get_image_list($product_id)
  {
    $this->db->select('p.*');
    $this->db->from('product_images p');
    //$this->db->where("p.product_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    return $query->result_array();
  }

  public function get_image_list_mobile($product_id)
  {
    $this->db->select('p.*');
    $this->db->from('product_images p');
    //$this->db->where("p.product_status",1);
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    $result=$query->result_array();
    $product_list=array();
    foreach($result as $row){
      $nested_data=array(
        'product_image'=>$row['product_image'],
        'product_thumb'=>$row['product_thumb'],
        'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
        'image_path'=>base_url()."admin/uploads/product/image/",
      );
      $product_list[]=$nested_data;
    }
    $this->db->select('p.product_image,p.product_thumb');
    $this->db->from('product p');
    $this->db->where("p.product_id",$product_id);
    $query=$this->db->get();
    $result_2=$query->row_array();
    $nested_data_2=array(
      'product_image'=>$result_2['product_image'],
      'product_thumb'=>$result_2['product_thumb'],
      'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
      'image_path'=>base_url()."admin/uploads/product/image/",
    );
    $product_list[]=$nested_data_2;
    return $product_list;
  }


  public function get_available_qty($product_id)
  {

    $qty= 1000;
    $order_qty=$this->get_order_qty($product_id);
    return $qty-$order_qty;

  }

  public function get_order_qty($product_id)
  {
    $this->db->select_sum('oci.product_qty');
    $this->db->from('order_customer_item oci');
    $this->db->join("order_customer oc",'oc.ord_cus_id = oci.order_cus_id','left');
    $this->db->where("oci.product_status",1);
    $this->db->where("oc.is_cancelled",0);
    $this->db->where("oci.product_id",$product_id);
    $query=$this->db->get();
    $result= $query->row_array();
    if($result['product_qty']){
      return $result['product_qty'];
    }else{
      return 0;
    }
  }

  public function get_item_avalable_qty_by_id($product_id)
  {
    $this->db->select_sum('pis.product_avalable');
    $this->db->from('purchase_items_serial pis');
    //	$this->db->join("order_customer oc",'oc.ord_cus_id = oci.order_cus_id','left');
    //$this->db->where("pis.product_status",1);
    $this->db->where("pis.product_id",$product_id);
    //$this->db->where("oc.is_cancelled",0);
    //$this->db->where("oci.product_id",$product_id);
    $this->db->where_not_in("pis.avalable_warehouse_id",array(19,22));

    $query=$this->db->get();
    $result= $query->row_array();
    if($result){
      return $result;
    }else{
      return 0;
    }
  }

  public function get_avalable_product()
  {
    $this->db->select('pis.product_id');
    $this->db->from('purchase_items_serial pis');
    $this->db->where_not_in("pis.avalable_warehouse_id",array(19,22));
    $this->db->where("pis.product_avalable",1);
    $this->db->group_by("pis.product_id");
    $query=$this->db->get();
    //echo $this->db->last_query(); die();
    $result= $query->result_array();
    if($result){
      $data = array();
      foreach($result as $row){
        $data[] = array('product_id'=>$row['product_id']);
      }
      $this->db->truncate('temp_avalable_product');
      //$this->db->delete('temp_avalable_product');
      $this->db->insert_batch('temp_avalable_product', $data);
      return true;;
    }else{
      return 0;
    }
  }




  //----------------------------------------------------------------------------- moblie part

  function getTopDeals($dis_level){
    $this->db->select('a.*');
    $this->db->select('p.*');
    $this->db->select('pc.*');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('sh.sh_cat_value');
    $this->db->from('daily_deals_product a');
    $this->db->join('product p','p.product_id=a.product_id','left');
    $this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
    $this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
    $this->db->join('color c','p.color_id=c.color_id','left');
    $this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    $this->db->where("a.approval_status",1);
    $this->db->where("a.is_remove",0);
    $this->db->where("a.category_top",1);
    $this->db->where("a.discount_level",$dis_level);
    $this->db->order_by('a.daily_deal_id','desc');
    $this->db->limit(1);
    $query=$this->db->get();
    return $query->result_array();
  }

  function getTopDealsAll($dis_level){
    $date=date("Y-m-d H:i:s");
    $this->db->select('a.*');
    $this->db->select('p.*');
    $this->db->select('pc.*');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('sh.sh_cat_value');
    $this->db->from('daily_deals_product a');
    $this->db->join('product p','p.product_id=a.product_id','left');
    $this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
    $this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
    $this->db->join('color c','p.color_id=c.color_id','left');
    $this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    $this->db->where("a.approval_status",1);
    $this->db->where("a.is_remove",0);
    $this->db->where("a.category_top",1);
    $this->db->where("a.discount_level",$dis_level);
    $this->db->where("a.start_date_time <=",$date);
    $this->db->where("a.end_date_time >",$date);
    $this->db->order_by('a.daily_deal_id','desc');
    //$this->db->limit(1);
    $query=$this->db->get();
    return $query->result_array();
  }

  public function flash_deal_multi_product($data)
  {
    $product_list=array();
    foreach($data as $na){
      $di_de_dis		=0;
      $di_de_dis_id	=0;
      $sp_of_dis		=0;
      $sp_of_dis_id	=0;
      $discount_value	=0;
      $discount_id	=0;
      $discount_type	=0;
      $di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);
      //$availble_qty=$this->get_available_qty($na['product_id']);
      $availble_qty=$na['stock_availability'];
      $sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
      $sp_dis_start_date=null;
      $sp_dis_end_date=null;
      if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
      if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];$sp_dis_start_date=$sp_of_dis_data['start_date_time'];$sp_dis_end_date=$sp_of_dis_data['end_date_time'];}
      if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
      if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

      $discount_price=($na['product_price']/100)*$discount_value;
      $product_price=$na['product_price']-$discount_price;

      $nested_data=array(
        'product_name'=>$na['product_name'],
        'product_code'=>$na['product_code'],
        'product_thumb'=>$na['product_thumb'],
        'product_image'=>$na['product_image'],
        'cat_name'=>$na['cat_name'],
        'product_price'=>number_format($product_price, 2, '.', ''),
        'product_cost'=>$na['product_cost'],
        //'product_details'=>$na['product_details'],
        //'product_specification'=>$na['product_specification'],
        'product_id'=>$na['product_id'],
        'discount_value'=>number_format($discount_price, 2, '.', ''),
        'original_price'=>$na['product_price'],
        'accessories'=>$na['accessories'],
        'brand_name'=>$na['brand_name'],
        'model_number'=>$na['model_number'],
        'color'=>$na['color'],
        'sh_cat_value'=>$na['sh_cat_value'],
        'product_discount_id'=>"".$discount_id."",
        'product_discount'=>$discount_value."%",
        'availble_qty'=>"".$availble_qty."",
        'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
        'image_path'=>base_url()."admin/uploads/product/image/",
        'waranty_conditions'=>$na['waranty_conditions'],
        'stock_availability'=>$na['stock_availability'],
        'sold_qty'=>$na['sold_qty'],
        'return_policy'=>$na['return_policy'],
        'delivery_estimate'=>$na['delivery_estimate'],
        'sp_discount_start'=>$sp_dis_start_date,
        'sp_discount_end'=>$sp_dis_end_date,

      );
      $product_list[]=$nested_data;
    }
    return  $product_list;
  }

  public function getFlashDealCategories()
  {
    $this->db->select('pc.cat_name,pc.cat_image_thumb,pc.cat_image,pc.cat_id,pc.image_path,pc.thumb_path');
    $this->db->from('specical_offer_product sop');
    $this->db->join("product p",'p.product_id = sop.product_id','inner');
    $this->db->join("product_category pc",'p.cat_id = pc.cat_id','inner');
    $this->db->where("pc.cat_status",1);
    $this->db->where("sop.is_remove",0);
    $this->db->where("sop.approval_status",1);
    $this->db->order_by('pc.cat_priority','asc');
    $this->db->group_by('pc.cat_id');
    $query=$this->db->get();
    $result= $query->result_array();
    if($result){
      return $result;
    }else{
      return false;
    }
  }

  public function getFlashDealCategoriesItems($cat_id)
  {
    $this->db->select('p.*,sop.discount_presentage,sop.discount_value,sop.category_top');
    $this->db->from('specical_offer_product sop');
    $this->db->join("product p",'p.product_id = sop.product_id','inner');
    $this->db->join("product_category pc",'p.cat_id = pc.cat_id','inner');
    $this->db->where("pc.cat_status",1);
    $this->db->where("sop.is_remove",0);
    $this->db->where("sop.approval_status",1);
    $this->db->where("p.cat_id",$cat_id);
    $query=$this->db->get();
    $result= $query->result_array();
    return $result;

  }

  function get_group_id_by_product($product_id){
    $this->db->select('gi.grp_id');
    $this->db->from('group_pricing_items gi');
    $this->db->join("group_pricing g",'g.grp_id = gi.grp_id','left');
    $this->db->where("g.grp_status",1);
    $this->db->where("gi.product_id",$product_id);
    $this->db->group_by("gi.grp_id");
    $query=$this->db->get();
    $result= $query->result_array();
    //print_r($result);
    $data=array();
    foreach($result as $g){
      $data[]=$g['grp_id'];
    }
    return $data;

  }

  function get_product_list_by_group_id($param){
    $this->db->select('p.*');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('ms.storage_name');
    $this->db->select('mc.capacity_name');
    //$this->db->select('mw.waranty_name');
    $this->db->from('group_pricing_items gi');
    $this->db->join("group_pricing g",'g.grp_id = gi.grp_id','left');
    $this->db->join("product p",'p.product_id = gi.product_id','left');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('color c','c.color_id = p.color_id','left');
    $this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
    $this->db->join('mstr_storage ms','ms.storage_id = p.storage_id','left');
    $this->db->join('mstr_capacity mc','mc.capacity_id = p.capacity_id','left');
    $this->db->where("g.grp_status",1);
    $this->db->where_in("gi.grp_id",$param);
    //$this->db->group_by("gi.product_id");
    $query=$this->db->get();
    $result= $query->result_array();
    $data=array();
    foreach($result as $g){
      $data[]=$g;
    }
    return $data;
  }

  public function get_recent_items($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$keyword=''){
    $this->db->select('p.*');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('sh.sh_cat_value');
    $this->db->from('product p');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('color c','c.color_id = p.color_id','left');
    $this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
    $this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($sub_cat_2_id){
      $this->db->where('p.sub_cat_2_id' , $sub_cat_2_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    $this->db->order_by('p.product_id','desc');
    $this->db->limit(20);
    $query = $this->db->get();
    return $query->result_array();
  }

  public function get_brand_list($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$keyword=''){
    $this->db->select('b.*');
    $this->db->from('product p');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pc.cat_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($sub_cat_2_id){
      $this->db->where('p.sub_cat_2_id' , $sub_cat_2_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    $this->db->group_by('b.brand_id');
    $this->db->limit(500);
    $query = $this->db->get();
    return $query->result_array();
  }

  public function get_color_list($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$brand_id='',$keyword=''){
    $this->db->select('c.*');
    $this->db->from('product p');
    //$this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    //$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('color c','c.color_id = p.color_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("c.color_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($sub_cat_2_id){
      $this->db->where('p.sub_cat_2_id' , $sub_cat_2_id);
    }
    if($brand_id){
      $this->db->where('p.brand_id' , $brand_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    $this->db->group_by('c.color_id');
    $this->db->limit(500);
    $query = $this->db->get();
    return $query->result_array();
  }

  public function get_size_list($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$brand_id='',$color_id='',$keyword=''){
    $this->db->select('mc.capacity_name,mc.capacity_id');
    $this->db->from('product p');
    //$this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    //$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('mstr_capacity mc','mc.capacity_id = p.capacity_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("mc.capacity_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($sub_cat_2_id){
      $this->db->where('p.sub_cat_2_id' , $sub_cat_2_id);
    }
    if($brand_id){
      $this->db->where('p.brand_id' , $brand_id);
    }
    if($color_id){
      $this->db->where('p.color_id' , $color_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    $this->db->group_by('mc.capacity_id');
    $this->db->limit(500);
    $query = $this->db->get();
    return $query->result_array();
  }

  public function get_storage_list($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$brand_id='',$color_id='',$keyword=''){
    $this->db->select('mc.storage_id,mc.storage_name');
    $this->db->from('product p');
    //$this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    //$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('mstr_storage mc','mc.storage_id = p.storage_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("mc.storage_status",1);
    if($cat_id){
      $this->db->where('p.cat_id' , $cat_id);
    }
    if($sub_cat_id){
      $this->db->where('p.sub_cat_id' , $sub_cat_id);
    }
    if($sub_cat_2_id){
      $this->db->where('p.sub_cat_2_id' , $sub_cat_2_id);
    }
    if($brand_id){
      $this->db->where('p.brand_id' , $brand_id);
    }
    if($color_id){
      $this->db->where('p.color_id' , $color_id);
    }
    if($keyword){
      $this->db->like('p.product_name', $keyword);
    }
    $this->db->group_by('mc.storage_id');
    $this->db->limit(500);
    $query = $this->db->get();
    return $query->result_array();
  }

  function add_review($data) {
    if($data){
      $this->db->insert('customer_product_review', $data);
      $insertid =  $this->db->insert_id();
      return $insertid ;
    } else {
      return false;
    }
  }

  public function get_relevant_product_list($product_id=''){
    $this->db->select('p.*');
    $this->db->select('pc.cat_name');
    $this->db->select('psc.sub_cat_name');
    $this->db->select('b.brand_name');
    $this->db->select('c.color');
    $this->db->select('sh.sh_cat_value');
    $this->db->from('product_relevant_items pr');
    $this->db->join("product p",'p.product_id = pr.relevant_product_id','left');
    $this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
    $this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
    $this->db->join('color c','c.color_id = p.color_id','left');
    $this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
    $this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
    $this->db->where("p.product_status",1);
    $this->db->where("pr.product_id",$product_id);
    $this->db->where("pc.cat_status",1);
    $query = $this->db->get();
    return $query->result_array();
  }








}
