<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual_Function_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_area($area_data,$area_id)
	{
		if (!$area_id)
		{
			//$this->db->insert($this->tableName,$area_data);
		}else {
			//$this->db->where('area_id', $area_id);
			//return $this->db->update($this->tableName,$area_data);
		}
	}	
	
	public function disable_product($id)
	{
		$data = array(
			'product_status' => 0
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function enable_product($id)
	{
		$data = array(
			'product_status' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function get_unpaid_sales()
	{		
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->where("s.payment_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	public function close_sale($id)
	{
		if($id>0){
			$data = array(
			'payment_status' => 1,
			'closed_date' => date("Y-m-d H:i:s")
		);	
		$this->db->where('sale_id', $id);
		$this->db->update('sales', $data);
		}else{
			return false;
		}
		
	}

	public function get_uncomplte_multiple_payment()
	{		
		$this->db->select('s.*');
		$this->db->from('sale_multiple_payment s');
		$this->db->where("s.payment_settlement_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	public function close_payment($id)
	{
		if($id>0){
			$data = array(
			'payment_settlement_status' => 1
		);	
		$this->db->where('smp_id', $id);
		$this->db->update('sale_multiple_payment', $data);
		}else{
			return false;
		}		
	}


	public function get_pending_sale_list()
	{	
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->join('customer c','c.cus_id=s.customer_id','left');
		$this->db->where("s.payment_status", 0);https://github.com/ajaxorg/ace/wiki/Default-Keyboard-Shortcuts
		$this->db->where("c.cus_credit_status", 1);
		$this->db->order_by('s.sale_datetime','desc');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function get_not_updated_initial_batch()
	{		
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->where("p.added_initial_batch", 0);
		$this->db->limit(1000);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		function save_batch($data)
	{
		if ($data)
		{
			$this->db->insert('batch_product',$data);
		}
	}
	
		public function update_product($id)
	{
	    if($id>0){
	        	$data = array(
			'added_initial_batch' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	        
	    }else{
	        echo "Update Error";
	        return false;
	    }
	}
	
	function insert_initial_grn($data)
	{
		if ($data)
		{
			$this->db->insert('purchase_items',$data);
			$id = $this->db->insert_id();
			return $id;
		}else{
		    return false;
		}
	}
	
	public function delete_grn_1()
	{
		$this->db->where('purchase_id', 1);
		$this->db->delete('purchase_items');
	}
	
	
}