<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Android_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
    public function get_user_active_delivery($rep_id)
	{
		$this->db->select('mlu.area_id,mlu.id,mlu.warehouse_id');
		$this->db->from('marketing_loading_unloading mlu');			
		$this->db->where("mlu.loading_status",3);	
		$this->db->where("mlu.approval_status",1);
		$this->db->where("mlu.rep_id",$rep_id);		
		$query=$this->db->get();
		return $query->row_array();
	}
    function get_all_products_via_sales_rep($delivery_id)
	{
		$this->db->select('li.product_id');
		$this->db->select('p.product_name,p.product_code,p.product_price,p.wholesale_price,p.credit_salling_price,p.product_cost');
		$this->db->from('lot_order_items li');
		$this->db->join('product p','li.product_id=p.product_id','left');
		$this->db->where('li.delivery_id',$delivery_id);
		$this->db->where('li.delivery_status',1);
		$this->db->where('li.is_delete_item',0);
		$this->db->where('p.product_status',1);
		$this->db->group_by('li.product_id');
		$query=$this->db->get();
		return $query->result_array();
	}
    public function get_all_customer_issue($routes)
    {
	  $this->db->select('marketing_issue_customer.*');		
	  $this->db->select('customer.cus_name,customer.cus_code');
	  $this->db->select('routes.route_name');
	  $this->db->select('product.product_name, product.product_code,product.grp_id,product.book_year,product.product_price,product.product_cost');
	  $this->db->from('marketing_issue_customer');
	  $this->db->join('customer','customer.cus_id=marketing_issue_customer.cus_id','left');
	  $this->db->join('routes','routes.route_id=marketing_issue_customer.route_id','left');
	  $this->db->join('product','product.product_id=marketing_issue_customer.product_id','left');
	  $this->db->where('marketing_issue_customer.status',"ISSUED");
	  $this->db->where_in('marketing_issue_customer.route_id',$routes);
	  $this->db->order_by('marketing_issue_customer.cus_issue_id','desc');
	  $query=$this->db->get();
	 return $query->result_array();	   
  }
   public function update_worng_loading($loading_id)
   {
	    $data=array('delivery_status'=>0,'status'=>"ORDER_GENERATED",'loading_id'=>0);
	    $this->db->where("marketing_seettu_customer_term_order.loading_id",$loading_id);
		return $this->db->update('marketing_seettu_customer_term_order', $data);
   }
 	function save_customer(&$customer_data,$cus_id=false)
	{
		if (!$cus_id)
		{
			$this->db->insert($this->tableName,$customer_data);
		}else {
			$this->db->where('cus_id', $cus_id);
			$this->db->update($this->tableName,$customer_data);
			$this->db->where('cus_id', $cus_id);
			return $this->db->update($this->tableName,$customer_data);
		}
	}
	function get_all_customers_by_route_id($rote_id)
	{
		$this->db->select('customer.cus_id,customer.cus_name,customer.cus_code');
		$this->db->from('customer');
		$this->db->where('cus_status',1);
		$this->db->where('route_id',$rote_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	function get_all_customer_print($cus_id=false) 
	{
		$this->db->select('customer.*, mstr_country.country_short_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->order_by("customer.cus_name", "asc");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		$this->db->where("customer.cus_type","normal");
		if($cus_id){
		$this->db->where("customer.cus_id",$cus_id);
		}
		$query = $this->db->get();
		return $query->result();
	}
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');		
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_type","normal");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	function get_all_easy_customers() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_type","easy");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	function get_all_customer() {
		$this->db->select('customer.*, mstr_country.country_short_name,routes.route_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->join('routes', 'routes.route_id = customer.route_id', 'left');
		$this->db->order_by("customer.cus_id", "desc");
		$this->db->where("customer.cus_type","normal");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
	}
	public function get_customer_info($id)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $id);
		$this->db->order_by("cus_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	public function delete_customer($cus_id)
	{
		$this->db->where('cus_id', $cus_id);
		$this->db->delete('customer');
	}
	public function disable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 0
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}
	public function enable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 1
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}
    public function get_ref_customer_info($cus_code)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $cus_code);
		$query = $this->db->get();		
		return $query->row_array(); 
	 }
    public function gen_cus_code($column_name,$table_name,$type_code)
    {
	$this->db->select_max($column_name);
	$query = $this->db->get($table_name);
		$g = $query->result();
		$val = 1;
		$u = 0 ;
		
     if($query->num_rows() >0)
     {
	$val += $g[0]->$column_name;
	$u = $this->set_ref_no($val,$type_code);
	return $u;
	 } else
     {
       return false;
     }
   }

   function set_ref_no($f,$t)
   {
	  $w='';
   	 $d = date('Y/m/');
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%04d",$f+1);
   	 return $w;
   }
   function get_order_full_details($order_id)
	{
		$this->db->select('mscto.*');
		$this->db->from('marketing_seettu_customer_term_order mscto');
		$this->db->where('mscto.id',$order_id);
		$this->db->where('mscto.issue_status',0);
		$this->db->where('mscto.approval_status',1);
		$this->db->where('mscto.delivery_status',1);		
		$query=$this->db->get();
		return $query->row_array();
	}
	public function update_customer_order_table_for_invoice($order_id,$data)
	{
		$this->db->where('id',$order_id);
		$result=$this->db->update('marketing_seettu_customer_term_order', $data);
		return $result;
	}
	function check_order_alrady_invoiced($order_id)
	{
		$this->db->select('invoice_id');
		$this->db->from('marketing_seettu_customer_term_invoice');
		$this->db->where('seettu_order_id',$order_id);
		$query = $this->db->get();
        return $query->num_rows();
	}
   function save_log_android_transaction ($data)
   {
	 $result=$this->db->insert('log_android',$data);
	 return  $result;	   
   }
   
   function save_transaction_log ($data)
   {
	 $result=$this->db->insert('transaction_log',$data);
	 return  $result;	   
   }
   function save_visitlocation_log ($data)
   {
	 $result=$this->db->insert('visit_location',$data);
	 return  $result;	   
   }
   function get_cash_collector_summary($report_from_date, $report_to_date,$user_id)
	{
		$this->db->select('mp.received_amount,mp.payment_method,mp.payment_id,mp.document_ref_no,mp.customer_id,mp.chit_id,mp.sale_pymnt_note,mp.delivery_id');
		$this->db->from('marketing_payment mp');
		$this->db->where('mp.added_by',$user_id);
		$this->db->where("mp.payment_date >=",$report_from_date);
		$this->db->where("mp.payment_date <=",$report_to_date);
		$query=$this->db->get();
		return $query->result_array();	
	}
//2019-10-26 update	 by sachith eranga
    public function get_free_issue_list($delivery_id)
    {
	  $this->db->select('mf.product_id,mf.quantity,mf.total_issue_qty,mf.pending_issue_qty,mf.id,mf.free_issue_invoice_id');		
	  $this->db->select('c.cus_id');  
	  $this->db->select('p.product_name, p.product_code,p.grp_id,p.book_year');
	  $this->db->from('marketing_free_issue_items mf');
	  $this->db->join('marketing_free_issue_invoice mfm','mfm.id=mf.free_issue_invoice_id','left');
	  $this->db->join('customer c','c.cus_id=mfm.customer_id','left');
	  $this->db->join('product p','p.product_id=mf.product_id','left');
	  $this->db->where('mf.loading_id',$delivery_id);
	  $this->db->where('mf.delivery_status',1);
	  $query=$this->db->get();
	  return $query->result_array();
  } 
   function get_customer_settu_order_status($cus_id,$delivery_id)
   {	 
	  $this->db->from('marketing_seettu_customer_term_order mo');
	  $this->db->where('mo.loading_id',$delivery_id);
	  $this->db->where('mo.customer_id',$cus_id); 
	  $this->db->where('mo.delivery_status',1);
	  $query=$this->db->get();
	  return $query->num_rows();   
   }
	function get_customer_free_issue_order_status($cus_id,$delivery_id)
   {	 
	  $this->db->from('marketing_free_issue_items fi');
	  $this->db->join('marketing_free_issue_invoice mfm','mfm.id=fi.free_issue_invoice_id','left');
	  $this->db->where('fi.loading_id',$delivery_id);
	  $this->db->where('mfm.customer_id',$cus_id); 
	  $this->db->where('fi.delivery_status',1);
	  $this->db->where('fi.remaining_status',0);
	  $query=$this->db->get();
	  return $query->num_rows();   
   }
	function get_customer_issue_sample_status($cus_id)
   {	 
	  $this->db->from('marketing_issue_customer mis');	 
	  $this->db->where('mis.cus_id',$cus_id); 
	  $this->db->where('mis.status',"ISSUED");
	  $query=$this->db->get();
	  return $query->num_rows();   
   }
    function get_delivery_sale_list($delivery,$user){
	  $this->db->select('c.*');  
	  $this->db->select('s.*'); 
	  $this->db->select('u.user_first_name'); 
	  $this->db->from('sales s');
	  $this->db->join('customer c','c.cus_id=s.customer_id','left');
	  $this->db->join('user u','u.user_id=s.sales_rep_id','left');
	  $this->db->where('s.delivery_id',$delivery);
	  $this->db->where('s.user',$user);
	  $this->db->where('s.sale_status',1);
	  $query=$this->db->get();
	 return $query->result_array();
   }
   function get_delivery_sale_product_list($sale_id){
	  $this->db->select('si.*');  
	  $this->db->select('p.product_code,p.product_name'); 
	  $this->db->from('sale_items si');
	  $this->db->join('product p','p.product_id=si.product_id','left');
	  $this->db->where('si.sale_id',$sale_id);
	  $query=$this->db->get();
	 return $query->result_array();
   }
    function get_delivery_payment_list($delivery,$user){
	  $this->db->select('c.*');  
	  $this->db->select('sm.*'); 
	  $this->db->select('u.user_first_name'); 
	  $this->db->select('pt.p_type_name'); 
	  $this->db->from('sale_multiple_payment sm');
	  $this->db->join('customer c','c.cus_id=sm.customer_id','left');
	  $this->db->join('user u','u.user_id=sm.user_id','left');
	  $this->db->join('mstr_payment_type pt','pt.p_type_id=sm.payment_type','left');
	  $this->db->where('sm.delivery_id',$delivery);
	  $this->db->where('sm.user_id',$user);
	  $this->db->where('sm.payment_status',1);
	  $query=$this->db->get();
	 return $query->result_array();
   }
    function get_delivery_sale_single_payment_list($payment_id){
	  $this->db->select('sp.*');  
	  $this->db->select('s.card_ref_number'); 
	  $this->db->from('sale_payments sp');
	  $this->db->join('sales s','s.sale_id=sp.sale_id','left');
	  $this->db->where('sp.smp_id',$payment_id);
	  $query=$this->db->get();
	 return $query->result_array();
   }
    function get_direct_sale_details($sale_id){
	  $this->db->select('s.*');  
	  $this->db->select('u.user_first_name'); 
	  $this->db->select('c.cus_name,c.cus_code'); 
	  $this->db->from('sales s');
	  $this->db->join('customer c','c.cus_id=s.customer_id','left');
	  $this->db->join('user u','u.user_id=s.user','left');
	  $this->db->where('s.sale_id',$sale_id);
	  $query=$this->db->get();
	 return $query->row_array();
   }
   function get_multiple_payment_details($id){
	  $this->db->select('c.*');  
	  $this->db->select('sm.*'); 
	  $this->db->select('u.user_first_name'); 
	  $this->db->select('pt.p_type_name'); 
	  $this->db->from('sale_multiple_payment sm');
	  $this->db->join('customer c','c.cus_id=sm.customer_id','left');
	  $this->db->join('user u','u.user_id=sm.user_id','left');
	  $this->db->join('mstr_payment_type pt','pt.p_type_id=sm.payment_type','left');
	  $this->db->where('sm.smp_id',$id);
	  $query=$this->db->get();
	 return $query->row_array();
   }
     public function get_registered_device($user_id,$device_id,$code)
	{
	    $this->db->select('m.mr_id,m.activation_status');  
		$this->db->from('mobile_register m');
		$this->db->where("m.activation_code",$code);	
		$this->db->where("m.device_id",$device_id);
		$this->db->where("m.user_id",$user_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	function save_activation_code($data)
	{
		return $this->db->insert('mobile_register',$data);
	}
	function save_sales($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_master',$data);
	}
	function save_sales_item($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_item',$data);
	}
	function save_backup_payment($data)
	{
		return $this->db->insert('mobile_payment_backup_master',$data);
	}
	function save_backup_payment_items($data)
	{
		return $this->db->insert('mobile_payment_backup_item',$data);
	}
	function insert_delivery_return_master_table($data)
	{
		 $this->db->insert('delivery_return_master',$data);
		 return $this->db->insert_id(); 
	}
	function insert_delivery_return_item_table($data)
	{
		return $this->db->insert('delivery_return_items',$data);
	}
   
   
    public function check_alrady_exist_return($ref_no)
	{
		$this->db->from('delivery_return_master m');			
		$this->db->where("m.mobile_ref_no",$ref_no);		
		$query=$this->db->get();
		return $query->num_rows();
	}
   
   	function insert_rep_order_master($data)
	{
		 $this->db->insert('order_request_master',$data);
		 return $this->db->insert_id(); 
	}
	function insert_rep_order_item($data)
	{
		 $this->db->insert('order_request_item',$data);
		 return $this->db->insert_id(); 
	}
	
	function get_area(){
	  $this->db->select('s.area_id,s.area_name'); 
	  $this->db->from('master_area s');
	  $this->db->where('s.status',1);
	  $query=$this->db->get();
	 return $query->result_array();
	}
   
   
}