<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 1/26/2016
 * Time: 3:14 PM
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Attn
{
    private $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->library('session');
        $this->CI->config->item('base_url');
    }
    
    public function p($array=array())
    {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
        //die();
    }

    function filter_by_key($array, $member, $value) {
        $filtered = array();
        foreach($array as $k => $v) {
            if($v->{$member} == $value){
                $filtered[] = $v;
            }
        }
        return $filtered;
    }

    function check_time_diff($t1,$t2){
        $time1 = new DateTime($t1);
        $time2 = new DateTime($t2);
        $interval = $time1->diff($time2);
        $s = (int)$interval->format('%s');
        if($s==0)
        {
            return TRUE;
        }
        return FAlSE;
    }

    public function get_unit_id()
    {
        return ($this->CI->session->userdata('Unit_Id')) ? $this->CI->session->userdata('Unit_Id') : false;
    }

    function checkAdmin()
    {
        //return ($this->CI->session->userdata('Type') and ($this->CI->session->userdata('Type') == 'ADMIN' OR $this->CI->session->userdata('Type') == 'MANAGER'));
        return ($this->CI->session->userdata('Type') and ($this->CI->session->userdata('Type') == 'ADMIN'));
    }

    function checkType($type='ADMIN')
    {
        //return ($this->CI->session->userdata('Type') and ($this->CI->session->userdata('Type') == 'ADMIN' OR $this->CI->session->userdata('Type') == 'MANAGER'));
        return ($this->CI->session->userdata('Type') and ($this->CI->session->userdata('Type') == $type));
    }

    function getType($type='ADMIN')
    {
        return $this->CI->session->userdata('Type');
    }

    function check_permition()
    {
        if ($this->CI->session->userdata('Comp') and ($this->CI->session->userdata('Type') and ($this->CI->session->userdata('Type') == 'MANAGER' OR $this->CI->session->userdata('Type') == 'ADMIN'))) {
            return true;
        } else {
            $this->CI->messages->add('You have no permission to access', "error");
            return false;
        }
    }

    public function clear_tags($str)
    {
        return htmlentities(
            strip_tags($str,
                '<span><div><a><br><p><b><i><u><img><blockquote><small><ul><ol><li><hr><big><pre><code><strong><em><table><tr><td><th><tbody><thead><tfoot><h3><h4><h5><h6>'
            ),
            ENT_QUOTES | ENT_XHTML | ENT_HTML5,
            'UTF-8'
        );
    }

    public function decode_html($str)
    {
        return html_entity_decode($str, ENT_QUOTES | ENT_XHTML | ENT_HTML5, 'UTF-8');
    }

    function getMonth($year, $month)
    {

        // this calculates the last day of the given month
        $last = cal_days_in_month(CAL_GREGORIAN, $month, $year);

        $date = new DateTime();
        $res = Array();

        // iterates through days
        for ($day = 1; $day <= $last; $day++) {
            $date->setDate($year, $month, $day);

            //$res[$day]=$date->format("l");
            $res[] = (strlen($day) < 2) ? (int)'0' . $day : $day;
        }
        return $res;
    }

    function DateIntervalToSec($start, $end)
    {
        $start = new DateTime($start);
        $end = new DateTime($end);
        // as datetime object returns difference in seconds
        $diff = $start->diff($end);
        $diff_sec = $diff->format('%r') . ( // prepend the sign - if negative, change it to R if you want the +, too
                ($diff->s) + // seconds (no errors)
                (60 * ($diff->i)) + // minutes (no errors)
                (60 * 60 * ($diff->h)) + // hours (no errors)
                (24 * 60 * 60 * ($diff->d)) + // days (no errors)
                (30 * 24 * 60 * 60 * ($diff->m)) + // months (???)
                (365 * 24 * 60 * 60 * ($diff->y)) // years (???)
            );
        return $diff_sec;
    }

    function convertSeconds($seconds, $concat = ':')
    {
        $trailSeconds = $seconds % 60;
        $minutes = floor($seconds / 60);
        $trailMinute = (($trailSeconds >= 30)) ? 1 : 0;
        $minutes = $minutes + (int)$trailMinute;
        if ($minutes >= 60) {
            $hour = floor($minutes / 60);
            $minutes = $minutes % 60;
            /*if($minutes > 30){
                $hour = $hour + 1;
            }*/
            $hour = ($hour < 10) ? '0' . $hour : $hour;
            /*$minutes = ($minutes < 30) ? '0' . $minutes : $minutes;*/
            $minutes = ($minutes < 10) ? '0' . $minutes : $minutes;
            return $hour . $concat . $minutes;
            //return $hour . $concat . '00';
        } else {
            $minutes = ($minutes < 10) ? '0' . $minutes : $minutes;
            return '00' . $concat . $minutes;
        }
    }

    function filter_by_value($array, $index, $value)
    {
        $newarray = array();
        if (is_array($array) && count($array) > 0) {
            foreach (array_keys($array) as $key) {
                $temp[$key] = $array[$key][$index];

                if ($temp[$key] == $value) {
                    $newarray[$key] = $array[$key];
                }
            }
        }
        return $newarray;
    }

    function get_formatted_attendance($records = array(), $sempl = array(), $comp = '')
    {
        $new_array = array();
        if(!empty($records) and is_array($records))
        {
            $i = 0;
            $new_row = array();
            $new_i = 0;
            $in_time = '';
            $out_time = '';
            $out_date = '';
            $new = false;
            $array_cout = is_array($records) ? count($records) : 0;
            foreach ($records as $row)
            {
                if($i==0)
                {
                    $new_row = $row;
                    $new_row['Comp'] = $comp;
                    $new_row['INTIME'] = $new_row['TIME'];
                    $in_time = $this->_merge_datetime($new_row['DATE'],$sempl->Shift_From);
                    $out_time = $this->_add_hours($in_time,$sempl->Hours);
                    $out_date = date_format(date_create($out_time), 'Y-m-d');
                    unset($new_row['TIME']);
                }
                else
                {
                    if($new)
                    {
                        $new_row = $row;
                        $new_row['Comp'] = $comp;
                        $new_row['INTIME'] = $new_row['TIME'];
                        $in_time = $this->_merge_datetime($new_row['DATE'],$sempl->Shift_From);
                        $out_time = $this->_add_hours($in_time,$sempl->Hours);
                        $out_date = date_format(date_create($out_time), 'Y-m-d');
                        unset($new_row['TIME']);
                        $new = false;
                    }
                    else
                    {
                        if($row['DATE']==$out_date and ($row['TIME'] > $out_time))
                        {
                            $new_row['OUTDATE'] = $row['DATE'];
                            $new_row['OUTTIME'] = $row['TIME'];
                            $new_row['EDIT'] = 0;
                            $new_array[$new_i] = $new_row;
                            $new_i++;
                            unset($new_row);
                            $new = true;
                        }
                        else if($row['DATE']==$out_date and ($row['TIME'] < $out_time))
                        {
                            $new_row['OUTDATE'] = $row['DATE'];
                            $new_row['OUTTIME'] = $row['TIME'];
                            //Added by namal 2017-05-02
                            $new_row['EDIT'] = 0;
                            $new_array[$new_i] = $new_row;
                            $new_i++;
                            unset($new_row);
                            $new = true;
                        }
                        else if($row['DATE'] < $out_date)
                        {
                            $new_row['OUTDATE'] = $row['DATE'];
                            $new_row['OUTTIME'] = $row['TIME'];
                        }
                        else if($row['DATE'] > $out_date)
                        {
                            if(!isset($new_row['OUTDATE'])) $new_row['OUTDATE']='0000-00-00';
                            if(!isset($new_row['OUTTIME'])) $new_row['OUTTIME']='00:00:00';
                            $new_row['EDIT'] = 0;
                            $new_array[$new_i] = $new_row;
                            $new_i++;
                            unset($new_row);
                            $new_row = $row;
                            $new_row['Comp'] = $comp;
                            $new_row['INTIME'] = $new_row['TIME'];
                            $in_time = $this->_merge_datetime($new_row['DATE'],$sempl->Shift_From);
                            $out_time = $this->_add_hours($in_time,$sempl->Hours);
                            $out_date = date_format(date_create($out_time), 'Y-m-d');
                            unset($new_row['TIME']);
                            $new = false;
                        }
                        else
                        {
                            $new_row['OUTDATE'] = $row['DATE'];
                            $new_row['OUTTIME'] = $row['TIME'];
                        }
                    }
                }
                $i++;
            }

            if(!empty($new_row))
            {
                /*if(!isset($new_row['OUTTIME'])) {
                    if($this->attn->check_time_diff($sempl->Shift_To,$sempl->Shift_From))
                    $new_row['OUTTIME']='00:00:00';
                }
                $new_row['EDIT'] = 0;*/
                unset($new_row);
            }
        }
        return $new_array;
    }

    private function _merge_datetime($date, $time)
    {
        $date = new DateTime($date);
        $time = new DateTime($time);
        // Solution 1, merge objects to new object:
        $merge = new DateTime($date->format('Y-m-d') . ' ' . $time->format('H:i:s'));
        return $merge->format('Y-m-d H:i:s'); // Outputs '2017-03-14 13:37:42'
        /*// Solution 2, update date object with time object:
        $date->setTime($time->format('H'), $time->format('i'), $time->format('s'));
        echo $date->format('Y-m-d H:i:s'); // Outputs '2017-03-14 13:37:42'*/
    }

    private function _add_hours($datetime, $hours)
    {
        $dt = new DateTime($datetime);
        $dt->add(new DateInterval('PT' . $hours . 'H'));
        return $dt->format("Y-m-d H:i:s");
    }

    function clean($string)
    {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        $string = preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.

        return preg_replace('/-+/', '', $string); // Replaces multiple hyphens with single one.
    }

    function loggedIn()
    {
        return $this->CI->session->userdata('logged_in');
    }

    function getComp()
    {
        return $this->CI->session->userdata('Comp');
    }

    function getDivice()
    {
        return $this->CI->session->userdata('Unit_Id');
    }

    function organize_array($array=array())
    {
        $new_array = array();
        if(!empty($array)){
            
            foreach($array as $a)
            {
                $new_array[$a->EId] = $a;
            }
        }
        return $new_array;
    }

    function object_filter($object, $key,$value = '') {
        $new_object = array();
        if (is_array($object) && count($object) > 0) {
            foreach ($object as $ob) {
                if (isset($ob->{$key}) and $ob->{$key} == $value) {
                    $new_object[] = $ob;
                }
            }
        }
        return $new_object;
    }

    function getNameFromNumber($num){
        $numeric = $num%26;
        $letter = chr(65+$numeric);
        $num2 = intval($num/26);
        if($num2 > 0){
            return $this->getNameFromNumber($num2-1).$letter;
        }else{
            return $letter;
        }
    }

    public function formatMoney($number)
    {
        return $number;
        return number_format($number, 2);
    }

    function DaysInMonth($month) {
        $time=strtotime($month);
        $m=date("m",$time);
        $y=date("Y",$time);
        $numDays = cal_days_in_month (CAL_GREGORIAN, $m,$y);
        return $numDays;
    }

    function getDaysInYearMonth ($month, $format){
        $date = DateTime::createFromFormat("Y-m", "$month");

        $datesArray = array();
        for($i=1; $i<=$date->format("t"); $i++){
            $datesArray[] = DateTime::createFromFormat("Y-m-d", "$month-$i")->format($format);
        }
        return $datesArray;
    }

    function check_access($type,$page='')
    {
        if($type=='ADMIN'){
            return true;
        }elseif($type=='USER'){
            $access_user = array('employee','employee_add','employee_inactive','employee_employee_filter');
            if (in_array($page, $access_user)) {
                return true;
            }
        }else{
            return false;
        }

    }

    public function checkPermissions($module = null, $js = null)
    {
        if (!$this->actionPermissions($module)) {
            $this->CI->messages->add("Access Denied! You don't have right to access the requested page", "error");
            if ($js) {
                die("<script type='text/javascript'>setTimeout(function(){ window.top.location.href = '" . (isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : site_url('welcome')) . "'; }, 10);</script>");
            } else {
                redirect('welcome');
            }
        }
    }

    public function actionPermissions($module = null)
    {
        if(isset($this->CI->permission[$module])){
            $permission = $this->CI->permission[$module];
            return (($permission==1)?true:false);
        }
        return true;
    }
}