<?php
require_once ("Main_model.php");
class Payroll_model extends Main_model
{
    private $tableName = 'payroll';
    private $join = 'comp';
    public function _construct()
    {
        //$this->load->database();
    }


    function count_all($id=0)
    {
        $this->db->from($this->tableName);
        if($id!=0)
        {
            $this->db->where('Code',$id);
        }
        return $this->db->count_all_results();
    }

    public function getMonthPayroll($month=NULL,$emp=0)
    {
        $this->db->select('Comp,EmpNo,EmpName');
        $this->db->from("payslip AS p");
        $this->db->where('p.Month',$month);
        if($emp!=0) $this->db->where('p.EmpNo',$emp);
        $this->db->order_by('ABS(p.EmpNo) ASC',FALSE);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function getAllDecMonths($month=NULL,$emp=0)
    {
        $this->db->select('Comp,EmpNo,EmpName,NotBasicAllowance,Deduction');
        $this->db->from("payslip");
        $this->db->where('Month', $month);
        if($emp!=0) $this->db->where('EmpNo',$emp);
        $this->db->group_by('EmpNo');
        $this->db->order_by('ABS(EmpNo) ASC',FALSE);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function getNetSaleryMonths($form_month=NULL,$to_month=NULL,$emp=0)
    {
        $this->db->select('Comp,EmpNo,EmpName,SUM(salaryPayable) AS NetSalary');
        $this->db->from("payslip AS p");
        $this->db->where('p.Month >=', $form_month);
        $this->db->where('p.Month <=', $to_month);
        if($emp!=0) $this->db->where('p.EmpNo',$emp);
        $this->db->group_by('p.EmpNo');
        $this->db->order_by('ABS(p.EmpNo) ASC',FALSE);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function getGrossSaleryMonths($form_month=NULL,$to_month=NULL,$emp=0,$company='')
    {
        $this->db->select('p.Comp,p.EmpNo,p.EmpName,SUM(GrossSalary) AS GrossSalary');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e','e.EmpNo=P.EmpNo','left');
        $this->db->where('p.Month >=', $form_month);
        $this->db->where('p.Month <=', $to_month);
        if($emp!=0) $this->db->where('p.EmpNo',$emp);
        if($company!=0) $this->db->where('e.Comp',$company);
        $this->db->group_by('p.EmpNo');
        $this->db->order_by('ABS(p.EmpNo) ASC',FALSE);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    /*
    Returns all the employees
    */
    function get_all()
    {
        $this->db->select('t.*, jt.Name');
        $this->db->from($this->tableName." AS t");
        $this->db->join($this->join.' AS jt', 't.Comp = jt.Code','left');
        //$this->db->where('t.Active',1);
        $query = $this->db->get();
        return $query->result();
    }

    function get_all_filter($Dep_code='')
    {
        /*
         * EmpNo may has EPFNo or EmpNo
         * For EmpNo use EId
        */
        $this->db->select('IF(t.EPFNo != "",t.EPFNo,t.EmpNo) AS EmpNo,t.EmpNo as EId,t.Comp,t.EmpName, jt.Name');
        //$this->db->select('t.EmpNo,t.Comp,t.EmpName, jt.Name');
        $this->db->from($this->tableName." AS t");
        $this->db->join($this->join.' AS jt', 't.Comp = jt.Code','left');
        //if(!$this->checkAdmin()) $this->db->where('t.Comp',$this->_getComp());
        if($Dep_code != '') $this->db->where('t.Dep_code',$Dep_code);
        $this->db->where('t.Active',1);
        $this->db->order_by('t.EmpName','asc');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_employee_payroll($emp=0)
    {
        $this->db->select('*');
        $this->db->from("payroll");
        //$this->db->where('Comp',$comp);
        $this->db->where('EmpNo',$emp);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data[$row['EmpNo']] = $row;
            return $data;
        }
        else
        {
            return false;
        }
    }

    function get_employee_custom_transactions($month='',$EmpNo='')
    {
        $this->db->select('Code,Amount');
        $this->db->from("custom_transaction");
        if($month != '') $this->db->where('Month',$month);
        if($EmpNo != '') $this->db->where('EmpNo',$EmpNo);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[$row->Code] = $row->Amount;
            }
            return $data;
        }
    }

    function get_all_emp_name()
    {
        $this->db->select('IF(t.EPFNo != "",t.EPFNo,t.EmpNo) AS EmpNo,t.EmpNo as EId, t.EmpName');
        $this->db->from($this->tableName." AS t");
        //$this->db->where('t.Comp',$comp);
        $this->db->where('t.Active',1);
        $query = $this->db->get();
        return $query->result();
    }

    function get_info($EmpNo='',$month)
    {
        $this->db->from($this->tableName);
        $this->db->where('EmpNo',$EmpNo);
        $this->db->where('Month',$month);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function get_basic_salary($EmpNo='')
    {
        $this->db->select('Basic_Salary');
        $this->db->from($this->tableName);
        $this->db->where('EmpNo',$EmpNo);
        //$this->db->where('Comp',$comp);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row()->Basic_Salary;
        }
        else
        {
            return false;
        }
    }

    public function search($term='',$department='')
    {
        $this->db->select('EmpNo,EmpName');
        if($term!='') $this->db->like('EmpNo',$term);
        if($term!='') $this->db->or_like('EmpName',$term);
        if($department!='') $this->db->where('Dep_code',$department);
        $q = $this->db->get($this->tableName);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    function exist($where = array())
    {
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function addIncrement($data = array())
    {
        $this->db->from('increment');
        $this->db->where(array('EmpNo'=>$data['EmpNo'],'Comp'=>$data['Comp'],'Month'=>$data['Month']));
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            $this->db->where(array('EmpNo'=>$data['EmpNo'],'Comp'=>$data['Comp'],'Month'=>$data['Month']));
            return $this->db->update('increment', $data);
        }
        else
        {
            return $this->db->insert('increment', $data);
        }
    }

    public function addPayroll($data = array(), $options = array())
    {
        $exist = $this->exist(array('EmpNo'=>$data['EmpNo'],'Comp'=>$data['Comp']));
        if(!$exist)
        {
            //echo $this->attn->p($data);
            if ($this->db->insert('payroll', $data)) {
                //echo $this->attn->p($options); die();
                if(isset($options) and !empty($options)){
                    return $this->db->insert_ignore_batch('payroll_options', $options);
                }else
                    return true;

            }
            return false;
        }else{
            $this->db->where(array('EmpNo'=>$data['EmpNo'],'Comp'=>$data['Comp']));
            unset($data['EmpNo']);
            unset($data['Comp']);
            //echo '<pre>',print_r($data); die();
            if ($this->db->update('payroll', $data)) {
                foreach ($options as $option) {
                    $this->db->from('payroll_options');
                    $this->db->where('EmpNo',$option['EmpNo']);
                    $this->db->where('Comp',$option['Comp']);
                    $this->db->where('Type_Id',$option['Type_Id']);
                    $this->db->where('Code',$option['Code']);
                    $query = $this->db->get();
                    if($query->num_rows()==1)
                    {
                        $this->db->from('payroll_options');
                        $this->db->where('EmpNo',$option['EmpNo']);
                        $this->db->where('Comp',$option['Comp']);
                        $this->db->where('Type_Id',$option['Type_Id']);
                        $this->db->where('Code',$option['Code']);
                        $this->db->update('payroll_options', array('Amount'=>$option['Amount']));
                    }
                    else
                    {
                        $this->db->insert('payroll_options', $option);
                    }
                }
                return true;
            }
            return false;
        }
    }


    function get_info_filter($EmpNo='')
    {
        $this->db->select('e.*, d.Description as department,g.Name as designation');
        $this->db->from('employee as e');
        $this->db->join('department as d', 'e.Comp = d.Comp_Id AND e.Dep_code = d.Dep_code','left');
        $this->db->join('designation as g', 'e.Comp = g.Comp AND e.Designation = g.Id','left');
        $this->db->where('e.EmpNo',$EmpNo);
        //$this->db->where('e.Comp',$comp);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            $r = $query->row_array();
            $r['payroll'] = '';
            $r['p_options'] = '';
            $this->db->select('Comp,Id AS Type_Id,Code,Amount');
            $this->db->from('items');
            $this->db->where_in('Id',array('A', 'D',));
            $q1= $this->db->get();
            $r['p_options'] = $q1->result_array();
            $this->db->select('Basic_Salary,Ot,Epf,Attendance,Welfare');
            $this->db->from('payroll');
            $this->db->where('EmpNo',$r['EmpNo']);
            $q= $this->db->get();
            if($q->num_rows()==1)
            {
                $r['payroll'] = $q->row_array();
                $this->db->select('Comp,Type_Id,Code,Amount');
                $this->db->from('payroll_options');
                $this->db->where('EmpNo',$r['EmpNo']);
                $q2= $this->db->get();
                if($q->num_rows()>0)
                {
                    $r['p_options'] = $q2->result_array();
                }
            }
            return $r;
        }
        else
        {
            return false;
        }
    }


    function get_payroll_options($EmpNo='')
    {
        $this->db->select('Comp,Type_Id,Code,Amount');
        $this->db->from('payroll_options');
        $this->db->where('EmpNo',$EmpNo);
        $q= $this->db->get();
        $p_options = array();
        if($q->num_rows()>0)
        {
            foreach($q->result_array() as $row){
                $p_options[$row['Code']] = $row;
            }
        }
        return $p_options;
    }
    /*
    Inserts or updates a page
    */
    function save(&$employee_data,$employee_id=false)
    {
        if (!$employee_id)
        {
            if(!$this->exist($employee_data['EmpNo']))
            {
                if($this->db->insert($this->tableName,$employee_data))
                {
                    return true;
                }
            }
            return false;
        }
        $this->db->where('EmpNo', $employee_id);
        $this->db->where('Comp',$employee_data['Comp']);
        return $this->db->update($this->tableName,$employee_data);
    }

    /*
    Deletes one employee
    */
    function delete($id)
    {
        if($this->delete_image($id))
        {
            $this->db->where('Code', $id);
            $this->db->where('Comp',$this->attn->getComp());
            return $this->db->delete($this->tableName);
        }
        return false;

    }

    public function deleteIncrement($emp,$month){
        $this->db->where('EmpNo',$emp);
        //$this->db->where('Comp',$comp);
        $this->db->where('Month',$month);
        if($this->db->delete('increment'))
        {
            return true;
        }
        return false;
    }

    public function change_status($employee_id)
    {
        $this->db->where('EmpNo', $employee_id);
        //$this->db->where('Comp',$comp);
        //$this->db->where('Comp',$this->_getComp());
        $this->db->update($this->tableName,array( 'Active' => '0'));
        //echo $this->db->last_query();
        return true;
    }

    function upload_file($image)
    {
        $uploadedFiles = array();
        $config['upload_path'] = './thems/frontend/images/emplyees/';
        $config['allowed_types'] = 'gif|jpg|png|bmp|jpeg';
        $config['max_size'] = '3000';
        $config['max_width'] = '4000';
        $config['max_height'] = '4000';
        $this->load->library('upload', $config);
        $upload = $this->upload->do_upload($image);
        $path = $this->upload->data();
        $configThumb = array();
        $configThumb['image_library'] = 'gd2';
        $configThumb['source_image'] = $path['full_path'];
        $configThumb['create_thumb'] = FALSE;
        $configThumb['maintain_ratio'] = FALSE;
        $configThumb['width'] = 204;
        $configThumb['height']=200;
        $this->load->library('image_lib');

        $this->image_lib->initialize($configThumb);

        if ( ! $this->image_lib->resize())
        {
            $this->messages->add($this->image_lib->display_errors(), "error");
            return false;
        }
        else
        {
            $this->image_lib->clear();
            return $path;
        }
    }

}
?>
