<?php
require_once (APPPATH."models/Main_model.php");
class Transaction_model extends Main_model
{
	private $tableName = 'transaction';
	private $join = 'employee';
	private $join2 = 'shift';
	
	public function _construct()
	{
		//$this->load->database();
	}
	
	function exist($exist)
	{
		$this->db->from($this->tableName);
		$this->db->where($exist);
		$query = $this->db->get();
		$this->db->where('Comp_Id', $this->attn->getComp());
		if($query->num_rows()==1)
		{
			$this->messages->add($this->lang->line('error_T_exist'), "error");
			return true;
		}
		else
		{
			return false;
		}
	}
	
	
	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the shifts
	*/
	function get_all($id=0,$limit=0,$offset=0)
	{
		$this->db->select('t.*, jt.EmpName');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
		$this->db->where('t.Comp_Id', $this->attn->getComp());
		$this->db->where('jt.Active',1);
  		$query = $this->db->get();
		return $query->result();
	}
	

	function get_info($where = array())
	{
		if(is_array($where))
		{
			$this->db->select('*');
			$this->db->from($this->tableName);
			$this->db->where($where);
			$this->db->where('Comp_Id', $this->attn->getComp());
			$query = $this->db->get();
			if($query->num_rows()==1)
			{
				return $query->row();
			}
			else
			{
				return false;
			}
		}
		return false;
	}

	/*
	Inserts or updates a page
	*/
	function save(&$Tsn_data,$Tsn_id=false)
	{
		$exist = array_slice($Tsn_data, 0, 3);
		if (!$Tsn_id)
		{
			if(!$this->exist($exist))
			{
				if($this->db->insert($this->tableName,$Tsn_data))
				{
					//$Tsn_data['shift_code']=$this->db->insert_id();
					return true;
				}
			}
			return false;
		}
		$this->db->where($exist);
		$this->db->where('Comp_Id', $this->attn->getComp());
		return $this->db->update($this->tableName,$Tsn_data);
	}
	
	/*
	Deletes one shift
	*/
	function delete($id)
	{
		if($this->delete_image($id))
		{
			$this->db->where('Code', $id);
			$this->db->where('Comp_Id', $this->attn->getComp());
			return $this->db->delete($this->tableName); 
		}
		return false;
		
	}
	
	public function change_status($Tsn_id,$status)
	{
		$this->db->where('Code', $Tsn_id);
		$this->db->where('Comp_Id', $this->attn->getComp());
		return $this->db->update($this->tableName,array( 'pStatus' => $status));	
	}
}
?>