<?php
require_once("Main_model.php");

class Loan_model extends Main_model
{

    public function _construct()
    {
        //$this->load->database();
    }

    /*
    Determines if a given string is an exists
    */
    function exists($var)
    {
        if ($var) {
            return true;
        } else {
            return false;
        }
    }

    public function addLoan($data = array())
    {
        $where = array(
            'EmpNo'=> $data['EmpNo'],
            'Year'=>$data['Year'],
            'Comp'=>$data['Comp'],
        );
        if(!$this->exist($where,'loan'))
        {
            if($this->db->insert('loan',$data))
            {
                return true;
            }
        }
        $this->messages->add('Employee Loan already exist', "error");
        return false;
    }

    function exist($where=array(),$table='loan')
    {
        $this->db->from($table);
        $this->db->where($where);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            $this->messages->add('Employee Loan already exist', "error");
            return true;
        }
        else
        {
            return false;
        }
    }

    function get_loan($id)
    {
        $this->db->select('l.*,e.FullName');
        $this->db->from('loan as l');
        $this->db->where('Id',$id);
        $this->db->join('employee AS e', 'l.EmpNo = E.EmpNo','left');
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function get_loan_payments($id='')
    {
        $this->db->select('*');
        $this->db->from("loan_payments");
        $this->db->where('loan_id',$id);
        $q = $this->db->get();
        $data = array();
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return false;
    }

    function get_employee_loans()
    {
        $this->db->select('EmpNo,Installment');
        $this->db->from("loan");
        $this->db->group_by('EmpNo');
        $q = $this->db->get();
        $data = array();
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[$row->EmpNo] = $row->Installment;
            }
            return $data;
        }
    }

    function get_empl_loan($EmpNo='')
    {
        $this->db->select('*');
        $this->db->from("loan");
        $this->db->where('EmpNo',$EmpNo);
        $this->db->where('Status','Pending');
        $q = $this->db->get();
        if($q->num_rows()==1)
        {
            return $q->row();
        }
        else
        {
            return false;
        }
    }

    public function deleteLoan($emp,$month){
        $this->db->where('EmpNo',$emp);
        $this->db->where('Year',$month);
        if($this->db->delete('loan'))
        {
            return true;
        }
        return false;
    }
}
?>