<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Loan extends MY_Controller {

    private $model;

    public function __construct() {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('loan_model');
        $this->model = $this->loan_model;

    }

    /*** Meal ***/
    function index()
    {
        //to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'loan_list';
        $data['page_title'] = 'List';
        $data['heading'] = 'Loan';
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/loan/index',$data);
    }

    function view($id)
    {

        //to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'loan_list';
        $data['page_title'] = 'View';
        $data['heading'] = 'Loan';
        $data['payments'] = $this->model->get_loan_payments($id);
        $data['loan'] = $this->model->get_loan($id);
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/loan/view',$data);
    }

    public function getLoanList()
    {
      
        $this->load->library('datatables');
        $this->datatables
            ->select(
            $this->db->dbprefix('loan').".Id AS Id,
            ".$this->db->dbprefix('loan').".Comp AS Comp,
            ".$this->db->dbprefix('employee').".EmpName,
            ".$this->db->dbprefix('loan').".Year,
            ".$this->db->dbprefix('loan').".FullAmount,
            ".$this->db->dbprefix('loan').".Term,
            ".$this->db->dbprefix('loan').".Installment,
            ".$this->db->dbprefix('loan').".InsCount,
            ".$this->db->dbprefix('loan').".InsAmount,
            ".$this->db->dbprefix('loan').".Status
            ")
            ->from("loan")
            ->join("employee",'loan.EmpNo=employee.EmpNo')
            //->where('loan.Comp', $this->attn->getComp())
            //->where('employee.Comp', $this->attn->getComp())
            ->add_column("Actions", "
            <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				 
				  <a class=\"dropdown-item\" href='". site_url('loan/view/$1') . "'
					><i class=\"bx bx-trash me-1\"></i> View</a>
				</div>
			  </div>", "Id")
            ->unset_column('Comp,EmpNo,Id');
        //<a class=\"tip green\" data-original-title='Edit record' href='" . site_url('loan/edit?emp=$1&year=$2&comp=$3') . "' ><i class=\"fa fa-edit\"></i></a>
        if(!empty($emp)){
            $this->db->where('loan.EmpNo', $emp);
        }
        if(!empty($year)){
            $this->db->where('loan.Year', $year);
        }
        //$this->db->where_in('Code',array('BF','LA'));
        echo $this->datatables->generate();
    }

    function add()
    {
        //$this->attn->checkPermissions('loan_add');
        $data['page'] = 'loan';
        $data['page_title'] = 'Add Loan';
        $data['heading'] = 'Loans';
        $data['e'] = ($this->input->get('emp'))?$this->input->get('emp'):NULL;
        $data['y'] = ($this->input->get('year'))?$this->input->get('year'):NULL;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'required');
        $this->form_validation->set_rules('Year', 'Year', 'required');
        $this->form_validation->set_rules('FullAmount', 'Premium', 'required');
        $this->form_validation->set_rules('Term', 'Term', 'required');
        $this->form_validation->set_rules('Installment', 'Installment', 'required');
        if ($this->form_validation->run() == true) {

            $rows = array(
                'Comp' => $this->attn->getComp(),
                'EmpNo' => $this->input->post('EmpNo'),
                'Year' => $this->input->post('Year'),
                'FullAmount' => $this->input->post('FullAmount'),
                'Term' => $this->input->post('Term'),
                'Installment' => $this->input->post('Installment'),
            );
            //echo '<pre>',print_r($data); die();

        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('loan/add');
        }

        if ($this->form_validation->run() == true && $this->model->addLoan($rows)) {
            $this->messages->add('Loan successfully added', "success");
            redirect('loan/add?emp='.$this->input->post('EmpNo').'&year='.$this->input->post('Year'));
        } else {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter();
            //echo '<pre>',print_r($data['employees']); die();
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/loan/add', $data);
        }
    }

    public function getLoans()
    {
        $emp = ($this->input->get('emp'))?$this->input->get('emp'):'';
        $year = ($this->input->get('year'))?$this->input->get('year'):'';
        $this->load->library('datatables');
        $this->datatables
            ->select("Comp,EmpNo,Year,FullAmount,Term,Installment")
            ->from("loan")
            //->join("employee",'custom_transaction.EmpNo=employee.EmpNo')
            //->where('loan.Comp', $this->attn->getComp())
            //->where('employee.Comp', $this->attn->getComp())
            ->add_column("Actions", "
            <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				 
				  <a class=\"dropdown-item\" href='". site_url('loan/deleteLoan/?emp=$1&year=$2&comp=$3') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>", "EmpNo,Year,Comp")
            ->unset_column('Comp,EmpNo');
        //<a class=\"tip green\" data-original-title='Edit record' href='" . site_url('loan/edit?emp=$1&year=$2&comp=$3') . "' ><i class=\"fa fa-edit\"></i></a>
        if(!empty($emp)){
            $this->db->where('loan.EmpNo', $emp);
        }
        if(!empty($year)){
            $this->db->where('loan.Year', $year);
        }
        //$this->db->where_in('Code',array('BF','LA'));
        echo $this->datatables->generate();
    }


    /*** /Loan ***/
    function deleteLoan()
    {
        $emp = ($this->input->get('emp'))?$this->input->get('emp'):NULL;
        $year = ($this->input->get('year'))?$this->input->get('year'):NULL;
        $comp = ($this->input->get('comp'))?$this->input->get('comp'):NULL;
        //$this->sma->checkPermissions(NULL, TRUE);
        if ($this->model->deleteLoan($emp,$year,$comp)) {
            if($this->input->is_ajax_request()) {
                echo 'Deleted'; die();
            }
            $this->session->set_flashdata('message', lang('loan_deleted'));
            redirect('loan/add');
        }

    }

}

?>