<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MonthItem extends MY_Controller
{

    private $model;

    public function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('monthitem_model');
        $this->model = $this->monthitem_model;
        //$this->model->monthly_fixed($this->attn->getComp(),date('Y-m'));
        //$this->model->monthly_fixed($this->attn->getComp(), '2019-06');
    }

    // this function for index page (Home)
    function index($month = NULL, $item = NULL)
    {
        $this->attn->checkPermissions('monthItem');
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'monthItem';
        $data['page_title'] = 'Monthly Pay Apply';
        $data['heading'] = 'Transactions';
        if ($month) {
            $data['month'] = $month;
        }
        $data['url'] = base_url('monthItem');
        $data['Edit'] = $this->Edit;
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/items/apply', $data);
    }

    /*** Meal ***/

   

    /*** /Meal ***/
    function deleteCustomTrans()
    {
        $emp = ($this->input->get('emp')) ? $this->input->get('emp') : NULL;
        $month = ($this->input->get('month')) ? $this->input->get('month') : NULL;
        $code = ($this->input->get('code')) ? $this->input->get('code') : NULL;
        $comp = ($this->input->get('comp')) ? $this->input->get('comp') : NULL;
        //$this->sma->checkPermissions(NULL, TRUE);
        if ($this->monthitem_model->deleteMeal($emp, $month, $code, $comp)) {
            if ($this->input->is_ajax_request()) {
                echo 'Deleted';
                die();
            }
            $this->session->set_flashdata('message', lang('meal_deleted'));
            redirect('welcome');
        }

    }


    public function getApplyLeaves()
    {
        $this->load->model('transaction/leave_transaction_model');

        $rtn = array();
        $emp = $this->input->post('emp');
        $month = $this->input->post('month');
        $leaves = $this->leave_transaction_model->get_employee_month_leaves($this->attn->getComp(), $emp, $month);
        if ($leaves)
            $rtn['msg'] = $leaves;
        else
            $rtn['msg'] = 0;
        echo json_encode($rtn);
    }
    /*** /Recycle  ***/

    /*** Hostel  ***/
    function Hostel()
    {
        $data['page'] = 'hostel';
        $data['e'] = ($this->input->get('emp')) ? $this->input->get('emp') : NULL;
        $data['m'] = ($this->input->get('month')) ? $this->input->get('month') : NULL;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'required');
        $this->form_validation->set_rules('month', 'Month', 'required');
        if ($this->form_validation->run() == true) {

            if ($this->input->post('Amount')) {
                $rows[] = array(
                    'Comp' => $this->attn->getComp(),
                    'Month' => $this->input->post('month'),
                    'Code' => 'Hos',
                    'EmpNo' => $this->input->post('EmpNo'),
                    'Amount' => $this->input->post('Amount'),
                );
            }
            //echo '<pre>',print_r($data); die();

        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('monthItem/hostel');
        }

        if ($this->form_validation->run() == true && $this->monthitem_model->addCustomTrans($rows)) {
            $this->messages->add('Hostsel allowance successfully added', "success");
            redirect('monthItem/hostel?emp=' . $this->input->post('EmpNo') . '&month=' . $this->input->post('month'));
        } else {
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter($this->attn->getComp());
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/items/hostel', $data);
        }
    }

    public function getHostels()
    {
        $emp = ($this->input->get('emp')) ? $this->input->get('emp') : '';
        $month = ($this->input->get('month')) ? $this->input->get('month') : '';
        $this->load->library('datatables');
        $this->datatables
            ->select("Month,Code AS code,employee.EmpNo AS EId,IF(employee.EPFNo != '',employee.EPFNo,employee.EmpNo) AS EmpNo,employee.EmpName,Amount,custom_transaction.Comp AS Comp")
            ->from("custom_transaction")
            ->join("employee", 'custom_transaction.EmpNo=employee.EmpNo')
            ->where($this->db->dbprefix('custom_transaction') . '.Comp', $this->attn->getComp())
            ->where('employee.Comp', $this->attn->getComp())
            ->add_column("Actions", "
            <a href=\"#\" class=\"tip po red\" title=\"Delete Record\" data-content=\"<p>Are You Sure?</p><a class='btn btn-danger po-delete' href='" . site_url('monthItem/deleteCustomTrans/?emp=$1&month=$2&code=$3&comp=$4') . "'>I am sure.</a>
             <button class='btn po-close'>No</button>\" rel=\"popover\" data-original-title=\"<b></b>\"><i class=\"fa fa-trash-o\"></i></a>", "EId,Month,code,Comp")
            ->unset_column('code,Comp,EId');
        if (!empty($emp)) {
            $this->db->where('custom_transaction.EmpNo', $emp);
        }
        if (!empty($month)) {
            $this->db->where('Month', $month);
        }
        $this->db->where('Code', 'Hos');
        echo $this->datatables->generate();
    }

    /*** /Hostel  ***/

    /*
     *For employee number use EId not EmpNo
     */

    public function load($item = null, $code = null, $month = null)
    {
        $this->attn->checkPermissions('monthItem_load');
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page_title'] = 'Monthly Pay Apply';
        $data['heading'] = 'Transaction';
        $data['page'] = 'monthItem';
        $data['Edit'] = $this->Edit;
        $data['edit'] = false;
        if ($code and $item and $month) {
            $data['edit'] = true;
            $data['month'] = $month;
            $data['code'] = $code;
            $data['Id'] = $item;
            $this->load->model('items_model');
            $where = array('Id' => $item, 'Code' => $code);
            $data['item'] = $this->items_model->get_info($where);
            $data['ids'] = $this->items_model->get_all_by_id($item);
        }
        //echo '<pre>',print_r($data['item']); die();
        $check = $this->model->exist_rows(array('month' => $month, 'Item_Code' => $code));
        $this->load->model('employee_model');
        $employees = $this->employee_model->get_all_filter();
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $payrolls = $model->get_payroll();
        //echo '<pre>',print_r($employees); die();
        $all_employees = $employees;
        switch ($item) {
            case 'A':
                $satarday_seconds = 5 * 60 * 60;
                foreach ($employees as $employee) {
                    $emp_month_worked_days = 0;
                    $month_worked_days = 26;
                    $month_work_days = 25;
                    $attendance_allowance = 0;
                    $col = 0;
                    $br1 = 1000;
                    $br2 = 2500;
                    $col_50 = 0;
                    $col_100 = 0;
                    $custom_transactions = array();
                    $month_attended_days = 0;
                    $month_attended_saturdays = 0;
                    $emp_no = $employee->EId;
                    $emp_type = $employee->work_type;
                    if($emp_type=='Probation'){
                        $month_work_days = 26;
                    }
                    $this->load->model('transaction/leave_transaction_model');
                    $leaves = $this->leave_transaction_model->get_employee_month_leaves($emp_no, $month);
                    $app_nopay = $this->leave_transaction_model->get_employee_month_nopays($emp_no, $month);
                    $trns_nopay = $this->monthitem_model->get_employee_month_nopay($month, $emp_no);
                    //check nopay added in timesheet apply nopay or transaction month transaction (all)
                    $nopay = 0;
                    if ($app_nopay and $app_nopay = !0) {
                        $nopay = $app_nopay;
                    } else if ($trns_nopay) {
                        $nopay = $trns_nopay;
                    }
                    $custom_transactions = $this->monthitem_model->get_employee_custom_transactions($month, $emp_no);
                    $this->load->model('payroll_model');
                    $basic_salary = $this->payroll_model->get_basic_salary($emp_no);
                    $holidays = $this->monthitem_model->get_holidays($month);
                    $month_days = $this->attn->DaysInMonth($data['month']);
                    $month_worked_days = $month_days - count($holidays);
                    $emp_month_worked_days = $month_worked_days - ($leaves + $nopay);
                    $nopay_leave = $leaves + $nopay;

                    $night_allowance_days = 0;
                    $completed_attn = $this->model->get_month_completed_attn($emp_no, $month);
                    $payrolls_options = $this->payroll_model->get_payroll_options($emp_no);


                    if ($data['item']->Code == $code) {
                        $employee->Amount = $data['item']->Amount;
                    }

                    $month_value = 0;
                    if(isset($payrolls_options[$code])){
                        $month_value = $payrolls_options[$code]['Amount'];
                    }
                    switch ($code) {

                        case '0004':
                            if($nopay > 0){
                                if(isset($payrolls_options[$code])){
                                    $month_value = $payrolls_options[$code]['Amount'];
                                    $value_par_day = $month_value/$month_work_days;
                                    //echo $meal_value_par_day; die();
                                    $value_nopay = round($value_par_day*$nopay,2);
                                    $employee->Amount = $month_value - floatval($value_nopay);
                                }
                            }else{
                                $employee->Amount = $month_value;
                            }
                            break;
                        case '0005':
                            if($nopay > 0){
                                if(isset($payrolls_options[$code])){
                                    $month_value = $payrolls_options[$code]['Amount'];
                                    $value_par_day = $month_value/$month_work_days;
                                    //echo $meal_value_par_day; die();
                                    $value_nopay = round($value_par_day*$nopay,2);
                                    $employee->Amount = $month_value - floatval($value_nopay);
                                }
                            }else{
                                $employee->Amount = $month_value;
                            }
                            break;
                        case '0006':
    
                            if($nopay > 0){
                                if(isset($payrolls_options[$code])){
                                    $month_value = $payrolls_options[$code]['Amount'];
                                    $value_par_day = $month_value/$month_work_days;
                                    //echo $meal_value_par_day; die();
                                    $value_nopay = round($value_par_day*$nopay,2);
                                    $employee->Amount = $month_value - floatval($value_nopay);
                                }
                            }else{
                                $employee->Amount = $month_value;
                            }
                            break;
                        case '0066':
                            if($nopay > 0){
                                if(isset($payrolls_options[$code])){
                                    $month_value = $payrolls_options[$code]['Amount'];
                                    $value_par_day = $month_value/$month_work_days;
                                    //echo $meal_value_par_day; die();
                                    $value_nopay = round($value_par_day*$nopay,2);
                                    $employee->Amount = $month_value - floatval($value_nopay);
                                }
                            }else{
                                $employee->Amount = $month_value;
                            }
                            break;
                            
                        case 'BR':
                            $employee->Amount = $br1;
                            break;

                        case 'BR2':
                            $employee->Amount = $br2;
                            break;
                    }
                }
                break;
            case 'D':
                $this->load->model('loan_model');
                $employee_loans = $this->loan_model->get_employee_loans();
                foreach ($employees as $employee) {
                    $emp_no = $employee->EId;
                    if ($data['item']->Code == $code) {
                        $employee->Amount = $data['item']->Amount;
                    }
                    switch ($code) {
                        case 'Wel':
                            if (isset($payrolls[$emp_no])) {
                                $payroll = $payrolls[$emp_no];
                                if ($payroll['Welfare'] and $payroll['Welfare'] == 1) {
                                    $employee->Amount = 100;
                                }
                            }
                            ;
                            break;
                        case '001':
                            if (isset($employee_loans[$emp_no])) {
                                $loan = $employee_loans[$emp_no];
                                $employee->Amount = $loan;
                            }
                            ;
                            break;
                    }
                }
                break;
            case 'N':
                $this->load->model('transaction/leave_transaction_model');
                foreach ($employees as $employee) {
                    $emp_no = $employee->EId;
                    $nopay = $this->leave_transaction_model->get_employee_month_nopays($emp_no, $month);
                    $employee->Rate = $nopay;
                }
            case 'L':
                break;
            case 'O':
                foreach ($employees as $employee) {
                    $emp_no = $employee->EId;

                    $this->load->model('payroll_model');
                    $payrolls = $this->payroll_model->get_employee_payroll($emp_no);
                    $employee->Rate = 0;
                    //Check employee applicable or not for OT
                    $is_ot_applicable = 1;
                    if (isset($payrolls[$emp_no])) {
                        $payroll = $payrolls[$emp_no];
                        if ($payroll['Ot'] == 0) {
                            $is_ot_applicable = 0;
                        }
                    }

                    $ncode = $code;
                    if ($code == 'NOT')
                        $ncode = 'OT';
                    if ($is_ot_applicable == 1) {
                        $employee_ot = $this->model->get_month_completed_attn_by_code($emp_no, $month, $ncode);
                        $employee->Rate = $this->attn->convertSeconds($employee_ot, '.');

                    }
                }
                break;
            default:
                break;
        }
        $data['employees'] = $this->attn->organize_array($employees);
        //echo '<pre>',print_r($data['employees']); die();
        $where = array('t.month' => $month, 't.Item_Code' => $code, 't.Id_Item' => $item);
        $saved = $this->model->get_all_month($where);
        //echo '<pre>',print_r($saved); die();
        if ($saved and !empty($saved)) {
            $organized_saved = $this->attn->organize_array($saved);
            //echo '<pre>',print_r($organized_saved); die();
            foreach ($organized_saved as $os) {
                if (isset($data['employees'][$os->EId]) and $data['employees'][$os->EId]) {

                    if (!isset($data['employees'][$os->EId]->Amount)) {
                        $data['employees'][$os->EId]->Amount = $os->Amount;
                    }
                    if (!isset($data['employees'][$os->EId]->Rate)) {
                        $data['employees'][$os->EId]->Rate = $os->Rate;
                    }
                }
            }
            $data['employees_saved'] = $organized_saved;
            //echo '<pre>',print_r($organized_saved); die();
        }
        /* if($saved){
             $organized_saved = $this->attn->organize_array($saved);
             foreach($all_employees as $emp){
                 $emp->month = $saved['0']->month;
                 $emp->Id_Item = $saved['0']->Id_Item;
                 $emp->Id = $saved['0']->Id_Item;
                 if (isset($organized_saved[$emp->EId])) {
                     $emp->Rate = $organized_saved[$emp->EId]->Rate;
                     $emp->Amount = $organized_saved[$emp->EId]->Amount;
                 } else {
                     $emp->Rate = 0;
                     $emp->Amount = 0;
                 }
             }
             $data['employees'] = $all_employees;
             $data['employees_saved'] = $this->attn->organize_array($employees);
         }*/
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/items/apply', $data);
    }

    public function monthpay_employee($emp = NULL, $month = NULL)
    {
        $this->attn->checkPermissions('monthItem_monthpay_employee');
        $data = $this->data;
        $data['page'] = 'monthItem_employee';
        $data['page_title'] = 'Monthly pay apply for employee';
        $data['heading'] = 'Master Files';
        $data['url'] = base_url('monthItem/monthpay_employee');
        $this->load->model('employee_model');
        if ($month) {
            $data['month'] = $month;
        }
        $not = 0;
        $dot = 0;
        $tot = 0;
        $nopay = 0;
        $month_work_days = 25;
        $month_worked_days = 26;
        $attendance_allowance = 0;
        $meal_allowance = 0;
        $transport_allowance = 0;
        $performance_allowance = 0;
        $satarday_seconds = 5 * 60 * 60;
        $br1 = 0;
        $br2 = 0;
        $custom_transactions = array();
        $is_Welfare = 0;
        $is_ot_applicable = 1;
        $night_allowance = 0;
        if ($emp) {
            $this->load->model('payroll_model');
            $payrolls = $this->payroll_model->get_employee_payroll($emp);
            $payrolls_options = $this->payroll_model->get_payroll_options($emp);
            //echo '<pre>',print_r($payrolls_options); die();
            if (isset($payrolls[$emp])) {
                $payroll = $payrolls[$emp];
                if ($payroll['Welfare'] and $payroll['Welfare'] == 1) {
                    $is_Welfare = 100;
                }
                if ($payroll['Ot'] == 0) {
                    $is_ot_applicable = 0;
                }
            }
            $data['Welfare'] = $is_Welfare;
            $month_attended_days = 0;
            $month_attended_saturdays = 0;
            $data['empNo'] = $emp;
            $holidays = $this->monthitem_model->get_holidays($month);
            $month_days = $this->attn->DaysInMonth($data['month']);
            $month_worked_days = $month_days - count($holidays);
            $this->load->model('transaction/leave_transaction_model');
            $leaves = $this->leave_transaction_model->get_employee_month_leaves($emp, $month);

            $app_nopay = $this->leave_transaction_model->get_employee_month_nopays($emp, $month);
            $this->load->model('payroll_model');
            $trns_nopay = $this->monthitem_model->get_employee_month_nopay($month, $emp);
            //check nopay added in timesheet apply nopay or transaction month transaction (all)
            $nopay = 0;
            if ($app_nopay and $app_nopay = !0) {
                $nopay = $app_nopay;
            } else if ($trns_nopay) {
                $nopay = $trns_nopay;
            }
            //echo $nopay.'d'; die();
            $nopay_leave = $leaves + $nopay;
            $custom_transactions = $this->monthitem_model->get_employee_custom_transactions($month, $emp);

            $this->load->model('payroll_model');
            $basic_salary = $this->payroll_model->get_basic_salary($emp);
            $emp_month_worked_days = $month_worked_days - ($leaves + $nopay);
            $completed_attn = $this->model->get_month_completed_attn($emp, $month);
            foreach ($completed_attn as $a) {
                if ($a->WEEKDAY == 5 and ($a->DIFF < $satarday_seconds)) {
                    $month_attended_saturdays++;
                } else {
                    $month_attended_days++;
                }
                if ($is_ot_applicable == 1) {
                    $not = $not + $a->OT;
                    $dot = $dot + $a->DOT;
                    $tot = $tot + $a->TOT;
                }
            }
            //applied items for month
            $apply_items = $this->model->get_all_month_by_employee($data['month'], $emp);
            $data['apply_allowances'] = $this->_item_filter($apply_items, 'A');
            //echo '<pre>',print_r($data['apply_allowances']); die();
            $data['apply_deductions'] = $this->_item_filter($apply_items, 'D');
            $data['apply_nopays'] = $this->_item_filter($apply_items, 'N');
            $data['apply_overtimes'] = $this->_item_filter($apply_items, 'O');
            $month_worked_days = (float) $month_worked_days;

            $nopay_leave = (float) $nopay_leave;
            if ($nopay_leave < 0.5) {
                $attendance_allowance = 4000;

            } elseif ($nopay_leave > 0.5 and $nopay_leave <= 1) {
                $attendance_allowance = 3500;
            } elseif ($nopay_leave == 2) {
                $attendance_allowance = 2500;
            } elseif ($nopay_leave > 2.5 and $nopay_leave < 3) {
                $attendance_allowance = 2000;
            } else {
                $attendance_allowance = 0;
            }
            $data['apply_lates'] = $this->_item_filter($apply_items, 'L');
            $printing_allowance = 0;
            $this->load->model('employee_model');
            $emp_details = $this->employee_model->get_info($emp);
            $emp_type = $emp_details->work_type;
            if($emp_type=='Probation'){
                $month_work_days = 26;
            }
            $completed_attn = $this->model->get_month_completed_attn($emp, $month);

        }

        $this->load->model('items_model');
        $data['items'] = $this->items_model->get_all('', '');
        
        $data['allowances'] = $this->_item_filter($data['items'], 'A');
        
        foreach ($data['allowances'] as $awc) {
            if ($awc->Id == 'A') {
                $month_value = 0;
                if(isset($payrolls_options[$awc->Code])){
                    $month_value = $payrolls_options[$awc->Code]['Amount'];
                }
                switch ($awc->Code) {

                    case '0004':
                        if($nopay > 0){
                            $code = '0004';
                            if(isset($payrolls_options[$code])){
                                $month_value = $payrolls_options[$code]['Amount'];
                                $value_par_day = $month_value/$month_work_days;
                                //echo $meal_value_par_day; die();
                                $value_nopay = round($value_par_day*$nopay,2);
                                $awc->Amount = $month_value - floatval($value_nopay);
                            }
                        }else{
                            $awc->Amount = $month_value;
                        }
                        break;
                    case '0005':
                        if($nopay > 0){
                            $code = '0005';
                            if(isset($payrolls_options[$code])){
                                $month_value = $payrolls_options[$code]['Amount'];
                                $value_par_day = $month_value/$month_work_days;
                                //echo $meal_value_par_day; die();
                                $value_nopay = round($value_par_day*$nopay,2);
                                $awc->Amount = $month_value - floatval($value_nopay);
                            }
                        }else{
                            $awc->Amount = $month_value;
                        }
                        break;
                    case '0006':

                        if($nopay > 0){
                            $code = '0006';
                            if(isset($payrolls_options[$code])){
                                $month_value = $payrolls_options[$code]['Amount'];
                                $value_par_day = $month_value/$month_work_days;
                                //echo $meal_value_par_day; die();
                                $value_nopay = round($value_par_day*$nopay,2);
                                $awc->Amount = $month_value - floatval($value_nopay);
                            }
                        }else{
                            $awc->Amount = $month_value;
                        }
                        break;
    
                    /*case isset($custom_transactions[$awc->Code]):
                        $awc->Amount = $custom_transactions[$awc->Code];
                        break;*/
                }
            }
        }

        $data['deductions'] = $this->_item_filter($data['items'], 'D');
        foreach ($data['deductions'] as $dct) {
            if (isset($custom_transactions[$dct->Code]))
                $dct->Amount = $custom_transactions[$dct->Code];

            if ($dct->Code == 'Wel' and isset($payrolls[$emp])) {
                $payroll = $payrolls[$emp];
                if ($payroll['Welfare'] and $payroll['Welfare'] == 1) {
                    $dct->Amount = 100;
                }
            }
            ;
        }

        $data['nopays'] = $this->_item_filter($data['items'], 'N');
        if (!empty($data['nopays'])) {
            foreach ($data['nopays'] as $np) {
                switch ($np->Code) {
                    case 'NP':
                        if ($nopay) {
                            $np->Days = $nopay;
                        }
                }
            }
        }
        $data['overtimes'] = $this->_item_filter($data['items'], 'O');
        if (!empty($data['overtimes'])) {
            foreach ($data['overtimes'] as $ovrtims) {
                switch ($ovrtims->Code) {
                    case 'DOT':
                        if ($dot) {
                            $ovrtims->Hours = $this->attn->convertSeconds($dot, '.');
                        }
                        break;
                    case 'NOT':
                        if ($not) {
                            $ovrtims->Hours = $this->attn->convertSeconds($not, '.');
                        }
                        break;
                    case 'TOT':
                        if ($tot) {
                            $ovrtims->Hours = $this->attn->convertSeconds($tot, '.');
                        }
                        break;
                }
            } 
        }
        $data['lates'] = $this->_item_filter($data['items'], 'L');
        $data['employees'] = $this->employee_model->get_all_filter('', 1);
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/items/employee_monthly_pay', $data);
    }


    private function _item_filter($objects, $filter = '')
    {
        $newarray = array();
        if (is_array($objects) && count($objects) > 0) {
            foreach ($objects as $ob) {
                if ($ob->Id == $filter) {
                    $newarray[] = $ob;
                }
            }
        }
        return $newarray;
    }

    private function _get_worked_days($objects = array())
    {
        $worked_days = array();
        if (!empty($objects)) {
            foreach ($objects as $o) {
                if (!in_array($o->ind, $worked_days)) {
                    $worked_days[] = $o->ind;
                }

                if (!in_array($o->outd, $worked_days)) {
                    $worked_days[] = $o->outd;
                }
            }
        }
        return $worked_days;
    }

    public function post()
    {
        //echo '<pre>',print_r($_POST),die();
        $post_id = $this->input->post('comp_id') == '' ? false : $this->input->post('comp_id');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('month', 'Month', 'trim|required');
        $this->form_validation->set_rules('Id_Item', 'Item', 'trim|required');
        $this->form_validation->set_rules('Item_Code', 'Code', 'trim|required');
        if ($this->form_validation->run() == FALSE) {
            $this->messages->add(validation_errors(), "error");
            redirect($this->input->post('refer_from'));
        } else {
            $comp_data = array();
            foreach ($_POST['record'] as $record) {
                if ((isset($record[8])) or (isset($record[9]))) {
                    //echo $record[1],'<br/>';
                    if ($record[4])
                        $comp_data[] = array(
                            'Comp' => ($this->input->post('Comp') != '') ? $this->input->post('Comp') : $this->session->userdata('Comp'),
                            'month' => trim($record[2]),
                            'Id_Item' => trim($record[3]),
                            'Item_Code' => trim($record[4]),
                            'EmpNo' => trim($record[1]),
                            'Rate' => (isset($record[5])) ? trim($record[5]) : 0.00,
                            'Amount' => (isset($record[6])) ? trim($record[6]) : 0.00,
                        );
                }
            }
            $code = $this->input->post('code');
            $Id = $this->input->post('Id');
            $month = $this->input->post('month');
            //echo '<pre>',print_r($comp_data),die();
            //get save id
            $returnId = $this->model->save($comp_data);
            if ($returnId) {
                $this->messages->add('Apply Success', "success");
                //redirect('monthItem/');
                redirect('monthItem/load/' . $Id . '/' . $code . '/' . $month);
            } else {
                if ($this->messages->count() == 0)
                    $this->messages->add('Apply Error', "error");
                redirect($this->input->post('refer_from'));
            }
        }
    }

    public function add_monthpay()
    {
        //echo '<pre>',print_r($_POST),die();
        $post_id = $this->input->post('comp_id') == '' ? false : $this->input->post('comp_id');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('month', 'Month', 'trim|required');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'trim|required');
        if ($this->form_validation->run() == FALSE) {
            $this->messages->add(validation_errors(), "error");
            redirect('monthItem/monthpay_employee');
        } else {
            $comp_data = array();
            //echo '<pre>',print_r($_POST['records']),die();
            foreach ($_POST['records'] as $record) {
                if ((isset($record[4])) or (isset($record[5]))) {
                    //echo $record[1],'<br/>';
                    if (isset($record[4]) or isset($record[5]))
                        $comp_data[] = array(
                            'Comp' => ($this->input->post('Comp') != '') ? $this->input->post('Comp') : $this->attn->getComp(),
                            'month' => trim($record[2]),
                            'Id_Item' => trim($record[3]),
                            'Item_Code' => trim($record[1]),
                            'EmpNo' => $this->input->post('EmpNo'),
                            'Rate' => (isset($record[5])) ? trim($record[5]) : 0.00,
                            'Amount' => (isset($record[4])) ? trim($record[4]) : 0.00,
                        );
                }
            }
            //echo '<pre>',print_r($comp_data),die();
            //get save id
            $returnId = $this->model->save($comp_data);
            if ($returnId) {
                $this->messages->add('Apply Success', "success");
                redirect('monthItem/monthpay_employee/' . $this->input->post('EmpNo') . '/' . $this->input->post('month'));
            } else {
                if ($this->messages->count() == 0)
                    $this->messages->add('Apply Error', "error");
                redirect('monthItem/monthpay_employee/' . $this->input->post('EmpNo') . '/' . $this->input->post('month'));
            }
        }
    }

    //change status
    public function status($id)
    {
        if (isset($id)) {
            if ($this->model->change_status($id)) {
                $this->messages->add($this->lang->line('success_apply_delete'), "success");
            } else {
                $this->messages->add($this->lang->line('error_apply_delete'), "error");
            }
        } else {
            $this->messages->add($this->lang->line('error_apply_delete'), "error");
        }
        redirect('add-department');
    }

}

?>