<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Person extends MY_Controller {
	
	private $model;
	 public function __construct()
	{
		parent::__construct();
		$this->load->model('user_model');
		$this->model = $this->user_model;
	} 
	
	function index()
	{
		//echo hash('sha512', '123@123');die();
		if ($this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('today-attendance');
		}
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/login',$data);
	}
	
	public function login()
	{
		//echo hash('sha512', 'demorathna1234**');die();
		if ($this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('welcome');
		}
		$return =array();
			if($this->model->login($this->input->post('User_ID'), $this->input->post('Password')))
			{
				//$this->messages->add($this->lang->line('success_login'), "success");
				redirect('welcome/');
			}
			else
			{
				$this->messages->add($this->lang->line('error_login'), "error");
				$this->index();
			}
	}
	
	public function login_old()
	{
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('Company_code', 'Company Code', 'required');
		$this->form_validation->set_rules('User_ID', 'Username', 'required');
		$this->form_validation->set_rules('Password', 'Password', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			$this->index();
		}
		else
		{
			if($this->model->login($this->input->post('Company_code'), $this->input->post('User_ID'), $this->input->post('Password')))
			{
				$this->messages->add($this->lang->line('success_login'), "success");
				redirect('upload-attendance/');
			}
			else
			{
				$this->messages->add($this->lang->line('error_login'), "error");
				$this->index();
			}
		}
	}
	
	public function users()
	{
		if($this->session->userdata('user_id')==1)
		{
			$data['message'] = view_error($this->messages->get());
			$data['users'] = $this->model->get_all();
			$this->load->view('templates/users/user_list',$data);
		}
		else
		{
			$this->messages->add($this->lang->line('error_permisiion'), "error");
			redirect('admin/product');

		}
	}
	
	public function post()
	{
		if($this->input->get('user_id'))
		{
			$data['edit'] = true;
			$data['udetails'] = $this->model->get_info($this->input->get('user_id'));
		}
		else
		{
			$data['edit'] = false;
		}
		$data['message'] = view_error($this->messages->get());
		$this->load->view('admin/users/add_user',$data);
	}
		
	public function save()
	{
		$post_id=$this->input->post('user_id')=='' ? null:$this->input->post('user_id');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('user_type', 'Select User type', 'trim|required');
		$this->form_validation->set_rules('fname', 'First Name', 'trim|required');
		$this->form_validation->set_rules('lname', 'Last Name', 'trim|required');
		if($post_id) $this->form_validation->set_rules('user_email', 'Email', 'trim|required|valid_email');
		else $this->form_validation->set_rules('user_email', 'Email', 'trim|required|valid_email|is_unique[user.user_email]');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[repassword]');
		$this->form_validation->set_rules('repassword', 'Password Confirmation', 'trim|required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			$url = ($post_id) ? '?user_id='.$post_id : null;
			redirect('/admin/user/post/'.$url);
		}
		else
		{
			//hash('sha512', $password);
			$page_data = array(
			'id' => $post_id ,
			'fname' => $this->input->post('fname') ,
			'lname' => $this->input->post('lname') ,
			'user_email' => $this->input->post('user_email') ,
			'password' =>  hash('sha512', $this->input->post('password'))
			);
			//get save id
			$returnId = $this->model->save($page_data,$post_id,$this->input->post('user_type'));
			$posttest = isset($post_id) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($posttest.' user succefuly', "success");
				redirect('/admin/user/users');
			}
			else
			{
				$redirect_url = ($posttest=='edit') ? '?user_id='.$post_id : '';
				$this->messages->add('not '.$posttest.' user', "error");
				redirect('admin/user/post/'.$redirect_url);
			}
		}	
	}
	
	function check_edit()
	{
		if($this->session->userdata('Comp'))
		{
			return true; 
		}
		else
		{
			$this->messages->add('You have no permission to access', "error");
			return false;
		}
	}
	/*
	Logs out a user by destorying all session data and redirect to login
	*/
	
	function logout()
	{
		$this->session->sess_destroy();
		redirect('');
	}
	
}
?>