<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 12/03/2018
 * Time: 11:33 AM
 * 
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Department_model extends CI_Model
{

    private $tableName = 'department';
    public function __construct()
    {
        parent::__construct();
        
    }

    public function record_count()
    {
        //$this->db->where('Status','Active');
        $this->db->from('department');
        return $this->db->count_all_results();
    }

    public function getAllComp($limit, $start)
    {
        $this->db->limit($limit, $start);
        //$this->db->where('Status','Active');
        $query = $this->db->get("department");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getAll()
    {
        $query = $this->db->get("department");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getCompByID($id)
    {
        $this->db->select('*')
            ->from('department')
            ->where('Id',$id);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            $row =  $q->row();
            return $row;
        }
        return FALSE;
    }

    function addDepartment(&$company_data)
    {
        if (!$this->exist_company($company_data['Dep_code'], $company_data['Comp_Id'])) {
            if ($this->db->insert($this->tableName, $company_data)) {
                $company_data['Dep_code'] = $this->db->insert_id();
                return true;
            }
        }
        return false;
    }

    function exist_company($Name, $Comp_Id)
    {
        $this->db->from($this->tableName);
        $this->db->where('Dep_code', $Name);
        $this->db->where('Comp_Id', $Comp_Id);
        //$this->db->where('Status',1);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $this->messages->add($this->lang->line('error_company_exist'), "error");
            return true;
        } else {
            return false;
        }
    }

    public function updateComp($id,$data = array())
    {
        $this->db->where('Id',$id);
        if ($this->db->update('department', $data)) {
            return true;
        }
        return false;
    }

    public function updateStatus($id,$status='Pending',$note='')
    {
        $this->db->where('Id', $id);
        if ($this->db->update('department', array('Status' => $status,'Note' => $note))) {
            return true;
        }
        return false;
    }


    public function change_status($id,$status)
    {
        $this->db->where('Id', $id);
        if ($this->db->update('department', array('Status'=>$status))) {
            return true;
        }
        return false;
    }



    public function getOrderByID($id)
    {
        $this->db->select("A.first_name,A.last_name,A.email,A.type,A.address,A.city,A.postal_code,A.state,A.phone,C.country_name,B.TotalAmount as grand_total")
            ->from('Comps_users AS A')
            ->join('Comps AS B','A.Comps_id=B.Id','left')
            ->join('countries AS C','A.country=C.id','left')
            ->where('A.Comps_id',$id);
        $q = $this->db->get();
        if ($q->num_rows() == 1) {
            return $q->row();
        }
        return FALSE;
    }


    public function delete($id)
    {
        /*if ($this->_checkInstitute($id)) {
            return false;
        }

        if ($this->_checkParent($id)) {
            return false;
        }*/
        $Comps =$this->getEventByID($id);
        if ($this->db->delete('Comp', array('Id' => $id))) {
            $this->tmw->file_delete($this->path.'Comps/'.$Comps->FrontImage);
            $this->tmw->file_delete($this->path.'Comps/'.$Comps->BannerImage);
            return true;
        }
        return FALSE;
    }
    
}
?>