<?php $this->load->view("templates/common/top_section"); ?>
    <div class="page-content">
        <div class="page-header"><h1> <?= (isset($page_title) ? $page_title : null) ?></h1></div>
        <!-- /.page-header -->

        <div class="hr hr-18 dotted hr-double"></div>
        <div class="row">

            <div class="col-xs-12 col-sm-12 col-md-12">

                <div class="widget-box">
                    <div class="widget-header widget-header-small">
                        <h5 class="widget-title lighter">Search</h5>
                    </div>

                    <div class="widget-body">
                        <div class="widget-main">
                            <form method="post" action="<?= base_url('leave_transaction/monthly_got_leaves'); ?>" class="form-search">
                                <div class="row">

                                    <div class="col-xs-12 col-sm-2">

                                        <input type="text" autocomplete="off"
                                               class="col-xs-12 col-sm-12 month-picker" <?php echo (isset($month)) ? 'value="' . $month . '"' : null; ?>
                                               data-date-format="yyyy-mm" id="month" name="month" placeholder="Month">
                                    </div>

                                    <div class="col-xs-12 col-sm-3">
                                        <select id="EmpNo" name="EmpNo" class="chosen-select col-xs-12 col-sm-10">
                                            <option value="">--Select Employee--</option>
                                            <?php
                                            if (is_array($employees)) {
                                                foreach ($employees as $epm) :
                                                    $ck = (isset($EmpNo) and !empty($EmpNo) and $EmpNo == $epm->EId) ? 'selected' : null;
                                                    echo '<option ' . $ck . ' value="' . $epm->EId . '">' . $epm->EmpNo . ' - ' . $epm->EmpName . '</option>';
                                                endforeach;
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <!-- /control-group -->
                                    <div class="col-xs-12 col-sm-2">
                                        <div class="form-group">

                                            <button class="btn btn-purple btn-sm" name="submit" id="search"
                                                    type="submit">
                                                <span class="ace-icon fa fa-search icon-on-right bigger-110"></span>
                                                Search

                                            </button>


                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="space-6"></div>

                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="table-header">
                            Leaves
                        </div>

                        <div role="grid">
                            <table class="table table-striped table-bordered table-hover">
                                <thead>
                                <tr role="row">
                                    <th>From</th>
                                    <th>To</th>
                                    <th>LeaveType</th>
                                    <th>Days</th>
                                </tr>
                                </thead>
                                <tbody role="alert" aria-live="polite" aria-relevant="all">
                                <?php
                                $days = 0;
                                    if(isset($month_leaves) and !empty($month_leaves)){

                                        foreach ($month_leaves as $row):
                                            $days = $days+(float)$row->Days;
                                            ?>
                                            <tr role="row">
                                                <td><?=$row->LeaveFrom; ?></td>
                                                <td><?=$row->LeaveTo; ?></td>
                                                <td><?=$row->LeaveType; ?></td>
                                                <td><?=$row->Days; ?></td>
                                            </tr>
                                            <?php
                                        endforeach;
                                    }
                                ?>
                                <?php
                                if(isset($month_nopay) and !empty($month_nopay)){
                                    foreach ($month_nopay as $row):
                                        $days = $days+(float)$row->Days;
                                        ?>
                                        <tr role="row">
                                            <td><?=$row->NopayFrom; ?></td>
                                            <td><?=$row->NopayTo; ?></td>
                                            <td>Nopay</td>
                                            <td><?=$row->Days; ?></td>
                                        </tr>
                                        <?php
                                    endforeach;
                                }
                                ?>
                                <tr>
                                    <td colspan="3" style="text-align: right">Total</td>
                                    <td><?=$days; ?></td>
                                </tr>
                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>

            </div>


        </div>
    </div>
<?php $this->load->view("templates/common/footer"); ?>