<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script type="text/javascript">
// Example starter JavaScript for disabling form submissions if there are invalid fields
(function () {
  'use strict'

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }

        form.classList.add('was-validated')
      }, false)
    })
})()

function makeBalance()
{
    var value = $('#Days').val();
    var dbalance = $('#day').val();
    var Leave_Code = $('#Leave_Code').val();
    if(Leave_Code==''){
        alert('select leave code');
        $('#Days').val('');
    }else {
        if (isNaN(value)) alert('Enter Number');
        else{
            var newbalance = parseFloat(dbalance - value);
            if(newbalance > 0)
            {
                $('#Balance').val(newbalance);
            }
            else
            {
                alert('Leave limit exceed. Please enter small value');
                $('#Days').val('');
                $('#Balance').val(dbalance);
            }
        }
    }

}

function cal_dates(s,e)
{
    var error = 0;
    if(!$.trim(s).length) {
        alert('select start date');
        error = 1;
    }
    if(!$.trim(e).length) {
        alert('select end date');
        error = 1;
    }

   /* var timestamp_start = Date.parse(s).val();
    if (isNaN(timestamp_start) == true) {
        error = 1;
    }
    var timestamp_end = Date.parse(e).val();
    if (isNaN(timestamp_end) == true) {
        error = 1;
    }*/

    if (error==0)
    {
        var start_date = new Date(s);
        var end_date = new Date(e);
        if(end_date > start_date)
        {
               //var difference = dateDiffInDays(start_date, end_date);
            var difference = (end_date - start_date)/(1000*60*60*24);
            $('#Days').val(difference+1);
            makeBalance();
        }
        else
        {
            //alert('End date should be greater than Start date');
        }
    }
}

$(function () {

    $('#leave-submit').click(function(event) {
        event.preventDefault();
        //$('#leavet').submit();
    });

    var EmpNo;


    //or change it into a date range picker
    $('.input-daterange').datepicker({
        autoclose:true,
        format: "yyyy-mm-dd",
    });

    $('.years').datepicker({
        autoclose: true,
        format: " yyyy-mm-dd",
    });

	$('.date-picker').datepicker({
		autoclose: true,
		todayHighlight: true
	});

	<?php
        if(isset($emp)){
    ?>
        loadRecords(<?=$emp; ?>);
        EmpNo = <?=$emp; ?>;
    <?php
        }
    ?>

	//loadRecords();

    $('#LeaveFrom').change(function(e) {
        e.preventDefault();
        var LeaveFrom = $(this).val();
        var LeaveTo = $('#LeaveTo').val();
    });

    $('#LeaveTo').change(function(e) {
        e.preventDefault();
        var LeaveFrom = $('#LeaveFrom').val();
        var LeaveTo = $('#LeaveTo').val();
        cal_dates(LeaveFrom,LeaveTo);
    });

	$('#EmpNo').change(function(event) {
	    //alert($(this).val());
	   event.preventDefault();
        EmpNo = $(this).val();
        loadRecords($(this).val());

	    $('.input').each(function() {
				$(this).val('');
	   });
	});



    $('#Leave_Code').change(function(event) {
	   event.preventDefault();
	    $('.disable').each(function() {
				$(this).val('');
	   });
	  var code = $(this).val();
	  var user_id = EmpNo;
	  //alert(user_id);
	   $.ajax({
		   url: '<?php echo base_url('leave_transaction/get_leave_days'); ?>',
		   data: {
			  Leave_Code: code,
			  EmpNo: user_id,
		   },
		   error: function() {
			  alert('An error has occurred, Select another one');
		   },
		   dataType: 'json',
		   success: function(data) {
			 
			 $.each(data, function( index, value ) {
				$('#'+index).val(value);
			});
             
		   },
		   type: 'POST'
		});
	});
});
</script>

<script type="text/javascript">
	function loadRecords(v)
	{
		var oTable1 = $('#leave-balance').dataTable({
			"aaSorting": [ [2, "desc"]],
			"aLengthMenu": [[2, 5, 10, -1], [2, 5, 10, "All"]],
			"iDisplayLength": 4,
			"bDestroy": true,
			'bProcessing': true,
			'bServerSide': true,
			'sAjaxSource': '<?= site_url('leave_transaction/getBalanceLeaves?v=1') ?>'+'&emp='+v,
			'fnServerData': function (sSource, aoData, fnCallback) {
				aoData.push({
					"name": "",
					"value": ""
				});
				$.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
			},
			"aoColumns": [{ "bSortable":false }, null, null, { "bSortable":false }]
		});

        var oTable2 = $('#applied-leave').dataTable({
            "aaSorting": [ [2, "desc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "iDisplayLength": 50,
            "bDestroy": true,
            'bProcessing': true,
            'bServerSide': true,
            'sAjaxSource': '<?= site_url('leave_transaction/getLeaves?v=1') ?>'+'&emp='+v,
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "",
                    "value": ""
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            "aoColumns": [{ "bSortable":false }, null, null,null,null, null,null, { "bSortable":false }]
        });

	}
</script>