<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    include('core_production_material_in_out_model.php');
class Production_Material_In_Out_Model extends Core_Production_Material_In_Out_Model
{
    public function __construct()
    {
        parent::__construct();
         $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
    /* standard function */
    public function runSaveMaster($data){
        return $this->saveMaster($data);
    }
    public function runSaveItems($data){
        return $this->saveItems($data);
    }
    public function runSaveSubItems($data){
        return $this->saveSubItems($data);
    }
    public function runUpdateMasterUsingPrimaryId($id,$data){
        return $this->updateMasterUsingPrimaryId($id,$data);
    }
    public function runUpdateItemsUsingPrimaryId($id,$data){
        return $this->updateItemsUsingPrimaryId($id,$data);
    }
    public function runUpdateSubItemsUsingPrimaryId($id,$data){
        return $this->updateSubItemsUsingPrimaryId($id,$data);
    }
    public function runDeleteMasterUsingPrimaryId($id){
        return $this->deleteMasterUsingPrimaryId($id);
    }
    public function runDeleteItemsUsingPrimaryId($id){
        return $this->deleteItemsUsingPrimaryId($id);
    }
    public function runDeleteSubItemsUsingPrimaryId($id){
        return $this->deleteSubItemsUsingPrimaryId($id);
    }
    public function runSelectMasterUsingPrimaryId($id){
        return $this->selectMasterUsingPrimaryId($id);
    }
    public function runSelectItemsUsingPrimaryId($id){
        return $this->selectItemsUsingPrimaryId($id);
    }
    public function runSelectSubItemsUsingPrimaryId($id){
        return $this->selectSubItemsUsingPrimaryId($id);
    }
     public function runUpdateMasterUsingSecondaryId($id,$data){
        return $this->updateMasterUsingSecondaryId($id,$data);
    }
    public function runUpdateItemsUsingSecondaryId($id,$data){
        return $this->updateItemsUsingSecondaryId($id,$data);
    }
    public function runUpdateSubItemsUsingSecondaryId($id,$data){
        return $this->updateSubItemsUsingSecondaryId($id,$data);
    }
    public function runSelectMasterUsingSecondaryId($id){
        return $this->selectMasterUsingSecondaryId($id);
    }
    public function runSelectItemsUsingSecondaryId($id){
        return $this->selectItemsUsingSecondaryId($id);
    }
    public function runSelectSubItemsUsingSecondaryId($id){
        return $this->selectSubItemsUsingSecondaryId($id);
    }
    
    /*customizable function*/
     public function runGetPendingSTN($id,$data){
       return  $this->getPendingSTN($id,$data);
    }
    private function getPendingSTN($id,$data)
    {
       $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_store_note_master p');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $this->db->where("p.psnm_warehouse_id",$id);
        $this->db->where("p.psnm_pickup_status",0);
        $this->db->where("p.psnm_status",1);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function runGetSelectedSTN($id,$data){
       return  $this->getSelectedSTN($id,$data);
    }
    private function getSelectedSTN($id,$data)
    {
        $this->db->select('p.*,psoi.psoi_id,psoi.psoi_status');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_stock_out_item psoi');
        $this->db->join('production_store_note_master p', 'p.psnm_id = psoi.psnm_id', 'inner');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $this->db->where("psoi.psom_id",$id);
        $this->db->where("p.psnm_pickup_status",1);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
     public function runGetSelectedSTNMaterial($id,$data){
       return  $this->getSelectedSTNMaterial($id,$data);
    }
    private function getSelectedSTNMaterial($id,$data)
    {
        $this->db->select('pm.*,u.unit_name,mpt.mpt_name,');
        $this->db->select('psnm.psnm_warehouse_id');
        $this->db->from('product_material pm');
        $this->db->join('production_batch_sub_items pbsi', 'pbsi.pbsi_product_mat_id = pm.product_mat_id', 'inner');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psnsi.psnm_id', 'inner');
        $this->db->join('production_stock_out_item psoi', 'psoi.psnm_id = psnm.psnm_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = pm.product_mat_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = pm.product_mat_type_id', 'inner');
        $this->db->where("psoi.psoi_status = 0");
        $this->db->where("psoi.is_deleted = 0");
        $this->db->where("psoi.psom_id",$id);
        $this->db->group_by('pm.product_mat_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function runGetSumAllSTNMaterial($id,$mstr_id){
       return  $this->getSumAllSTNMaterial($id,$mstr_id);
    }
    private function getSumAllSTNMaterial($id,$mstr_id)
    {
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('production_stock_out_item psoi', 'psoi.psnm_id = psnsi.psnm_id', 'inner');
        $this->db->where("psoi.psoi_status = 0");
        $this->db->where("psoi.is_deleted = 0");
        $this->db->where("pbsi.pbsi_product_mat_id",$id);
        $this->db->where("psoi.psom_id",$mstr_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['pbis_qty'])){
            return $result['pbis_qty'];
        }else{
            return 0;
        }
    }
    
    public function runGetNotCompleteIssueNoteListServerSide($start, $length, $search_key_val,$customer_condition){
       return  $this->getNotCompleteIssueNoteListServerSide($start, $length, $search_key_val,$customer_condition);
    }
    private function getNotCompleteIssueNoteListServerSide($start, $length, $search_key_val,$customer_condition)
    {
        $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_stock_out_master p');
        $this->db->join('warehouses w', 'w.id = p.psom_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psom_user_id', 'inner');
        $filters='';
        if(isset($customer_condition['id'])){
            $filters.=' AND p.psom_warehouse_id = '.$customer_condition["id"];
        }
        if ($search_key_val) {
            $this->db->where("p.is_deleted = 0 AND p.psom_status= 0 AND AND p.psom_ref_no LIKE '$search_key_val%'".$filters);
		    $this->db->or_where("p.is_deleted = 0 AND p.psom_status = 0  AND p.psom_document_no LIKE '%$search_key_val%'".$filters);
        }else{
            $this->db->where("p.is_deleted = 0 AND p.psom_status = 0 ".$filters);
        }
		$this->db->order_by("p.psom_id", "asc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    public function runGetPendingSTNListServerSide($start, $length, $search_key_val,$customer_condition){
       return  $this->getPendingSTNListServerSide($start, $length, $search_key_val,$customer_condition);
    }
    private function getPendingSTNListServerSide($start, $length, $search_key_val,$customer_condition)
    {
        $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_store_note_master p');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $filters='';
        if(isset($customer_condition['id'])){
            $filters.=' AND p.psnm_warehouse_id = '.$customer_condition["id"];
        }
        if ($search_key_val) {
            $this->db->where("p.is_deleted = 0 AND p.psnm_status= 1 AND p.psnm_pickup_status = 0 AND p.psnm_ref_no LIKE '$search_key_val%'".$filters);
		    $this->db->or_where("p.is_deleted = 0 AND p.psnm_status = 1 AND p.psnm_pickup_status = 0 AND p.psnm_manual_ref_no LIKE '%$search_key_val%'".$filters);
        }else{
            $this->db->where("p.is_deleted = 0 AND p.psnm_status = 1 AND p.psnm_pickup_status = 0 ".$filters);
        }
		$this->db->order_by("p.psnm_id", "asc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    public function runGetSTNDetails($id){
       return  $this->getSTNDetails($id);
    }
    private function getSTNDetails($id)
    {
        $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name,w.address,w.phone');
        $this->db->select('um.user_first_name');
        $this->db->select('ua.user_first_name as pickup_by');
        $this->db->from('production_store_note_master p');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.psnm_pickup_by', 'left');
        $this->db->where("p.psnm_id",$id);
        $query = $this->db->get();
        return $query->row_array(); 
    }
    
    public function runGetSTNItemDetails($id){
       return  $this->getSTNItemDetails($id);
    }
    private function getSTNItemDetails($id)
    {
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->select('pm.product_mat_code,pm.product_mat_name,pm.product_mat_id,u.unit_name,mpt.mpt_name');
        $this->db->from('product_material pm');
        $this->db->join('production_batch_sub_items pbsi', 'pbsi.pbsi_product_mat_id = pm.product_mat_id', 'inner');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = pm.product_mat_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = pm.product_mat_type_id', 'inner');
        $this->db->where("psnsi.psnm_id",$id);
        $this->db->group_by('pbsi.pbsi_product_mat_id');
        $query = $this->db->get();
        return $query->result_array(); 
    }
    
    public function runGetSumAllSTNMaterialActualCount($id,$mstr_id){
       return  $this->getSumAllSTNMaterialActualCount($id,$mstr_id);
    }
    private function getSumAllSTNMaterialActualCount($id,$mstr_id)
    {
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_id = pbsi.pbi_id', 'inner');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbi.pbi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psni.psnm_id', 'inner');
        $this->db->where("psni.is_deleted = 0");
        $this->db->where("pbsi.pbsi_product_mat_id",$id);
        $this->db->where("psni.psnm_id",$mstr_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['pbis_qty'])){
            return $result['pbis_qty'];
        }else{
            return 0;
        }
    }
    
    
    
    public function runGetSTNProductionItemDetails($id){
       return  $this->getSTNProductionItemDetails($id);
    }
    private function getSTNProductionItemDetails($id)
    {
        $this->db->select('pbi.pbi_qty , pbi.pbi_ref_no');
        $this->db->select('p.product_code,p.product_name,p.product_id,u.unit_name,mpt.mpt_name');
        $this->db->from('product p');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_product_id = p.product_id', 'inner');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbi.pbi_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = p.product_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = p.product_type_id', 'inner');
        $this->db->where("psni.psnm_id",$id);
        $this->db->group_by('pbi.pbi_id');
        $query = $this->db->get();
        return $query->result_array(); 
    }
    
    public function runGetSumAllSTNProductionActualCount($id,$mstr_id){
       return  $this->getSumAllSTNProductionActualCount($id,$mstr_id);
    }
    private function getSumAllSTNProductionActualCount($id,$mstr_id)
    {
        $this->db->select_sum('pbi.pbi_qty');
        $this->db->from('production_batch_items pbi');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbi.pbi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psni.psnm_id', 'inner');
        $this->db->where("psni.is_deleted = 0");
        $this->db->where("pbi.pbi_product_id",$id);
        $this->db->where("psni.psnm_id",$mstr_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['pbi_qty'])){
            return $result['pbi_qty'];
        }else{
            return 0;
        }
    }
    
    public function runGetPendingInternalGRN($id){
       return  $this->getPendingInternalGRN($id);
    }
    private function getPendingInternalGRN($id)
    {
        $this->db->select('pg.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_grn pg');
         $this->db->join('warehouses w', 'w.id = pg.pgrnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = pg.finish_by', 'left');
        $this->db->where("pg.pgrnm_warehouse_id",$id);
        $this->db->where("pg.pgrnm_status",1);
        $this->db->where("pg.pgrnm_pick_up_status",0);
        $query = $this->db->get();
        return $query->result(); 
    }
    
    public function runGetMaterialWithBatch($id){
       return  $this->getMaterialWithBatch($id);
    }
     function getMaterialWithBatch($search_key_val){
		$this->db->select('p.*');
		$this->db->select('b.batch_id,b.batch_ref_number');
		$this->db->from('batch_product b');
		 $this->db->join('product_material p', 'p.product_mat_id = b.product_id', 'inner');
	    $this->db->where("p.product_mat_status = 1 AND  b.grn_type = 2  AND  p.product_mat_code LIKE '$search_key_val%'");
		$this->db->or_where("p.product_mat_status = 1 AND  b.grn_type = 2   AND p.product_mat_name LIKE '%$search_key_val%'");
		$this->db->order_by("p.product_mat_name", "asc");
		$this->db->group_by('b.batch_id');
		$this->db->limit(50);
		$query = $this->db->get();
		return $query->result_array();
	}
    
    
    
    
    
     public function runGetBatchAllDetails($id){
       return  $this->getBatchAllDetails($id);
    }
     function getBatchAllDetails($id){
		$this->db->select('gi.product_mat_id,gi.pbi_id,gi.quantity');
		$this->db->select('p.product_id');
		$this->db->select('g.pgrnm_warehouse_id');
		$this->db->select('b.batch_ref_number');
		$this->db->from('batch_product b');
		$this->db->join('production_grn_intermediat_product gi', 'gi.pgrni_id = b.grn_item_id', 'inner');
		$this->db->join('product_material pm', 'pm.product_mat_id = gi.product_mat_id', 'inner');
		$this->db->join('product p', 'pm.product_mat_id = p.sub_product_of', 'inner');
		$this->db->join('production_grn g', 'g.pgrnm_id = gi.pgrnm_id', 'inner');
		$this->db->where('b.batch_id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
    
    
    
    
     public function runSaveProductionConvertTable($data){
       return  $this->saveProductionConvertTable($data);
    }
     private function saveProductionConvertTable($pd){
        if ($this->db->insert('production_convert', $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    
    
    
     public function runGetGTNDetails($id){
       return  $this->getGTNDetails($id);
    }
    private function getGTNDetails($id)
    {
        $this->db->select('pg.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_grn pg');
         $this->db->join('warehouses w', 'w.id = pg.pgrnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = pg.finish_by', 'left');
        $this->db->where("pg.pgrnm_id",$id);
        $query = $this->db->get();
        return $query->row_array(); 
    }
    
    public function runGetGTNItems($id){
       return  $this->getGTNItems($id);
    }
    private function getGTNItems($id)
    {
        $this->db->select('u.unit_name,mpt.mpt_name,');
        $this->db->select('pbi.pbi_ref_no,pbi.pbi_estimate_cost,pbi.pbi_qty');
        $this->db->select('p.product_code,p.product_name,p.product_id');
        $this->db->select('pgi.*');
        $this->db->from('production_grn_items pgi');
         $this->db->join('product p', 'p.product_id = pgi.product_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = p.product_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = p.product_type_id', 'inner');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_id = pgi.pbi_id', 'inner');
        $this->db->where("pgi.pgrnm_id",$id);
        $query = $this->db->get();
        return $query->result_array(); 
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /*Old function*/
    
  
   
    public function runGetNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition){
       return  $this->getNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition);
    }
    private function getNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition)
    {
        $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_store_note_master p');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $filters='';
        if(isset($customer_condition['id'])){
            $filters.=' AND p.psnm_warehouse_id = '.$customer_condition["id"];
        }
        if ($search_key_val) {
            $this->db->where("p.is_deleted = 0 AND p.psnm_status= 0 AND p.psnm_pickup_status = 0 AND p.psnm_ref_no LIKE '$search_key_val%'".$filters);
		    $this->db->or_where("p.is_deleted = 0 AND p.psnm_status = 0 AND p.psnm_pickup_status = 0 AND p.psnm_manual_ref_no LIKE '%$search_key_val%'".$filters);
        }else{
            $this->db->where("p.is_deleted = 0 AND p.psnm_status = 0 AND p.psnm_pickup_status = 0 ".$filters);
        }
		$this->db->order_by("p.psnm_id", "asc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    public function runGetSelectedBatchMaterial($id,$data){
       return  $this->getSelectedBatchMaterial($id,$data);
    }
    private function getSelectedBatchMaterial($id,$data)
    {
        $this->db->select('pm.*,u.unit_name,mpt.mpt_name,');
        $this->db->from('product_material pm');
        $this->db->join('production_batch_sub_items pbsi', 'pbsi.pbsi_product_mat_id = pm.product_mat_id', 'inner');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_id = pbsi.pbi_id', 'inner');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbi.pbi_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = pm.product_mat_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = pm.product_mat_type_id', 'inner');
        $this->db->where("psni.issue_status = 0");
        $this->db->where("psni.is_deleted = 0");
        $this->db->where("psni.psnm_id",$id);
        $this->db->group_by('pm.product_mat_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function runGetGTNPendingProductMaterialData($id){
       return  $this->getGTNPendingProductMaterialData($id);
    }
    private function getGTNPendingProductMaterialData($id){
        $this->db->select('pgi.*');
        $this->db->select('pbi.pbi_ref_no,pbi.pbi_unit_cost');
        $this->db->from('production_grn_intermediat_product pgi');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_id = pgi.pbi_id', 'inner');
        $this->db->where("pgi.pgrnm_id",$id);
        $this->db->where("pgi.pgtni_status",0);
        $query = $this->db->get();
        return $query->result_array();
    }
    
   public function runSaveBatchProductTable($data){
       return  $this->saveBatchProductTable($data);
    }
     private function saveBatchProductTable($pd){
        if ($this->db->insert('batch_product', $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }  
    
    public function runUpdateGRNMaterialItemUsingPrimaryId($id,$data){
       return  $this->updateGRNMaterialItemUsingPrimaryId($id,$data);
    }
    private function updateGRNMaterialItemUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where('pgrni_id', $id);
            return $this->db->update('production_grn_intermediat_product',$data);  
        }else{
            return false;
        }
    }
    public function runUpdateGRNMasterTableUsingPrimaryId($id,$data){
       return  $this->updateGRNMasterTableUsingPrimaryId($id,$data);
    }
    private function updateGRNMasterTableUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where('pgrnm_id', $id);
            return $this->db->update('production_grn',$data);  
        }else{
            return false;
        }
    }
    
    
    
    public function runUpdateProductionGRNItemTableUsingSecondryId($id,$data){
       return  $this->updateProductionGRNItemTableUsingSecondryId($id,$data);
    }
    private function updateProductionGRNItemTableUsingSecondryId($id,$data){
        if($id>0){
            $this->db->where('pgrnm_id', $id);
            return $this->db->update('production_grn_items',$data);  
        }else{
            return false;
        }
    }
    
    
    	function get_availble_grn_qty($id){
	    $this->db->select('p.quantity');
		$this->db->from('production_grn_items p');
	    $this->db->where("p.pgrnp_id",$id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['quantity'])){
		    return $result['quantity'];
		}else{
		    return 0;
		}
	    
	}
	
		function marked_pakagening_damage($id){
	    $this->db->select('p.packing_damage');
		$this->db->from('production_grn_items p');
	    $this->db->where("p.pgrnp_id",$id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['packing_damage'])){
		    return $result['packing_damage'];
		}else{
		    return 0;
		}
	    
	}
    
    
     function update_production_grn_items_table($id,$data){
        if($id>0){
            $this->db->where('pgrnp_id', $id);
            return $this->db->update('production_grn_items',$data);  
        }else{
            return false;
        }
    }
    
     function update_production_grn_intermediat_product($id,$data){
        if($id>0){
            $this->db->where('pgrnp_id', $id);
            return $this->db->update('production_grn_items',$data);  
        }else{
            return false;
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  
}