<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_Category extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "categories";

    public function __construct()
     {
            parent::__construct();
            $this->load->model('category_models');
			$this->load->model('Common_Model');
			$this->load->model('Sequerty_Model');
     }

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('product_category/product_category',$data);
	}

    public function add_category()
    {
        $data['id'] = 1;
        $this->load->view('product_category/create_category',$data);
    }
    public function edit_category($category_id)
    {
        $data['category_details'] = $this->category_models->getCategory_by_id($category_id);
        $this->load->view('product_category/create_category',$data);
    }

    public function update_category()
    {
        if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->category_image_config($image_name_enc));
                if ( ! $this->upload->do_upload())
                {                   
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else
                {
                    $this->load->library('image_lib',$this->image_manipulation->category_image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];


                       if ($this->category_models->category_update($this->input->post('category_tbl_id') ,$this->input->post('cat_id'), $this->input->post('cat_name'), $imgName['file_name'], $imageThumb,$this->input->post('cat_priority'))) {

                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);

                       } else {

                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
                       $this->image_lib->clear();
                    }  
                                  
                }
        }
        else
        {
               if ($this->category_models->category_update($this->input->post('category_tbl_id') ,$this->input->post('cat_id'), $this->input->post('cat_name'),NULL,NULL,$this->input->post('cat_priority'))) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {

                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
        }
        
    }

    public function add_subcategory()
    {
        $data = array( 'getCategory' => $this->category_models->getCategory() );
        $this->load->view('product_category/create_sub_category',$data);
    }

    public function getProduct($value='')
    {
    	$arrayName = array('id' =>123);
    	echo json_encode($arrayName);
    }

    public function category_save()
    {
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('cat_id', 'Category Code', 'required|is_unique[product_category.cat_code]');
        $this->form_validation->set_rules('cat_name', 'Category Name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
          if (!empty($_FILES["userfile"]['name'])) {

                $image_name_enc = time().$_FILES["userfile"]['name'];

                $this->load->library('upload',$this->image_manipulation->category_image_config($image_name_enc));
                if ( ! $this->upload->do_upload())
                {
                   
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else
                {
                    $this->load->library('image_lib',$this->image_manipulation->category_image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];


                       if ($this->category_models->category_save($this->input->post('cat_id'), $this->input->post('cat_name'), $imgName['file_name'], $imageThumb, $this->input->post('cat_priority'))) {

                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);

                       } else {

                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
                       $this->image_lib->clear();
                    }                  
                }

          } else {

               if ($this->category_models->category_save($this->input->post('cat_id'), $this->input->post('cat_name'),NULL,NULL,$this->input->post('cat_priority'))) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {

                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }
          

        }

    }

    public function getCategory()
    {       
        $values = $this->category_models->getCategory();
        $data = array();
        if (!empty($values)) {
            foreach ($values as $categoriy) {

            if ($categoriy->cat_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
                $row[] = '<div style="margin-bottom: 0px; height: 70px; width: 70px;" class="fileupload-new thumbnail"><img alt="" src="'.base_url()."uploads/categories/image/thumbs/".$categoriy->cat_image_thumb.'">
                </div>';
                $row[] = strtoupper($categoriy->cat_code);
                $row[] = strtoupper($categoriy->cat_name);
                $row[] = '<a class="btn btn-xs btn-blue" href="'.base_url()."system_settings/subcategories/".$categoriy->cat_id.'" data-toggle="modal"><i class="glyphicon fa fa-list"></i></a> <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->cat_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->cat_id.','.$categoriy->cat_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->cat_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }
            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);
        }
    }

    public function category_change_status()
    {
           if($this->category_models->category_change_status($this->input->post('cat_id'),$this->input->post('status'))) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function category_permanent_delete()
    {
           if($this->category_models->category_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent category with children categorys existing');
                   echo json_encode($st);
           }
    }

    //sub category module function begin

    public function category_sub_save()
    {
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('parent_category', 'parent category', 'required');
        $this->form_validation->set_rules('cat_code', 'Category Code', 'required|is_unique[product_category.cat_code]');
        $this->form_validation->set_rules('cat_name', 'Category Name', 'required');

        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $image_av=0;
            $image_name="";
            $image_thumb="";
            //------------------------------------------------------------------image upload
            
             if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->sub_category_image_config($image_name_enc));
                if ( ! $this->upload->do_upload())
                {
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else
                {
               
                    $this->load->library('image_lib',$this->image_manipulation->sub_category_image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
                        $image_name=$imgName['file_name'];
                        $image_thumb=$imageThumb;
                        $image_av=1;
                       $this->image_lib->clear();
                    }                  
                }
             }
            
            //------------------------------------------------------------------image upload end
           if($this->category_models->category_sub_save($this->input->post('parent_category'),$this->input->post('cat_code'),$this->input->post('cat_name'),$this->input->post('sub_cat_priority'),$image_av,$image_name,$image_thumb)) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
        }
    }
    //var $parent_category_id;

    public function subcategories($parent_category_id='')
    {
      //$this->parent_category_id = $parent_category_id;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = $this->sub_menu_name;
      $data['sub_categorys'] = $this->category_models->getCategory();
      $data['parent_cat_id'] = $parent_category_id;
      $this->load->view('product_category/subcategory',$data);
    }

    public function get_sub_Category($parent_category_id)
    {

       
        $values = $this->category_models->get_sub_category($parent_category_id);
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {
            
            $row = array();
                $row[] = '<div style="margin-bottom: 0px; height: 70px; width: 70px;" class="fileupload-new thumbnail"><img alt="" src="'.base_url()."uploads/sub_categories/image/".$categoriy->image.'">
                </div>';
                $row[] = strtoupper($categoriy->sub_cat_code);
                $row[] = strtoupper($categoriy->sub_cat_name);
                $row[] = strtoupper($categoriy->cat_name);
                $row[] = '<a class="btn btn-xs btn-blue" href="'.base_url()."product_category/subcategories2/".$categoriy->sub_cat_id.'" data-toggle="modal"><i class="glyphicon fa fa-list"></i></a> <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="sub_category_edit('.$categoriy->sub_cat_id.')"><i class="glyphicon fa fa-edit"></i></a> <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="sub_perm_delete('.$categoriy->sub_cat_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }

            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function edit_sub_category($category_id="")
    {
        $data['sub_category_details'] = $this->category_models->get_sub_Category_by_id($category_id);
        $data['getCategory']          = $this->category_models->getCategory();
        $this->load->view('product_category/create_sub_category',$data);
    }

    public function sub_category_permanent_delete()
    {
           if($this->category_models->sub_category_permanent_delete($this->input->post('sub_cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function update_sub_category()
    {
        $image_av=0;
        $image_name="";
        $image_thumb="";
        //------------------------------------------------------------------image upload
            
             if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->sub_category_image_config($image_name_enc));
                if ( ! $this->upload->do_upload())
                {
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else
                {
                  
                    $this->load->library('image_lib',$this->image_manipulation->sub_category_image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                        $imgName    = $this->upload->data();
                        $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
                        $image_name=$imgName['file_name'];
                        $image_thumb=$imageThumb;
                        $image_av=1;
                       $this->image_lib->clear();
                    }                  
                }
             }
            
            //------------------------------------------------------------------image upload end
                       if ($this->category_models->sub_category_update($this->input->post('parent_category') ,$this->input->post('sub_category_tbl_id'), $this->input->post('cat_code'),$this->input->post('cat_name'),$this->input->post('sub_cat_priority'),$image_av,$image_name,$image_thumb)) {

                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);

                       } else {

                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
    }

    //sub category module function end


    //sub category 2 module start
    public function subcategories2($parent_category_id='')
    {
      //$this->parent_category_id = $parent_category_id;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = $this->sub_menu_name;
      $data['sub_categorys'] = $this->category_models->get_sub_category($parent_category_id);
      $data['parent_cat_id'] = $parent_category_id;
      $this->load->view('product_category/subcategory2',$data);
    }

    public function get_sub_Category2($parent_category_id)
    {

       
        $values = $this->category_models->get_sub_category2($parent_category_id);
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {
            
            $row = array();
                $row[] = strtoupper($categoriy->sub_cat_2_code);
                $row[] = strtoupper($categoriy->sub_cat_2_name);
                $row[] = strtoupper($categoriy->sub_cat_name);
                $row[] = '<a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="sub_category_edit('.$categoriy->sub_cat_2_id.')"><i class="glyphicon fa fa-edit"></i></a> <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="sub_perm_delete('.$categoriy->sub_cat_2_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }
            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function add_subcategory2($parent_category='')
    {
        $category_id =  $this->category_models->get_catgory_id($parent_category);
        $data = array( 'getCategory' => $this->category_models->get_sub_category($category_id),'sub_cat_id_original'=>$parent_category );
        $this->load->view('product_category/create_sub_category2',$data);
    }

    public function category_sub_2_save()
    {
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('parent_category', 'parent category', 'required');
        $this->form_validation->set_rules('cat_code', 'Sub Category 2 Code', 'required|is_unique[product_sub_category_2.sub_cat_2_code]');
        $this->form_validation->set_rules('cat_name', 'Sub Category 2  Name', 'required');

        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
           if($this->category_models->category_sub_2_save($this->input->post('parent_category'),$this->input->post('cat_code'),$this->input->post('cat_name'),$this->input->post('sub_cat_priority'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
        }
    }

    public function edit_sub_category2($parent_category="")
    {
        $sub_cat_id =  $this->category_models->get_sub_catgory_id($parent_category);
        $category_id =  $this->category_models->get_catgory_id($sub_cat_id);        
        $data = array( 'getCategory' => $this->category_models->get_sub_category($category_id),'sub_cat_id_original'=>$sub_cat_id );
        $data['sub_category_details'] = $this->category_models->get_sub_Category2_by_id($parent_category);
        $this->load->view('product_category/create_sub_category2',$data);
    }

    public function update_sub_category2()
    {
                       if ($this->category_models->sub_category2_update($this->input->post('parent_category') ,$this->input->post('sub_category_tbl_id'), $this->input->post('cat_code'),$this->input->post('cat_name'),$this->input->post('sub_cat_priority'))) {

                               $st = array('status' =>1,'validation' =>'Done!');
                               echo json_encode($st);

                       } else {

                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
    }

    public function sub_category2_permanent_delete()
    {
           if($this->category_models->sub_category2_permanent_delete($this->input->post('sub_cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

//-------------------------------------------------------------------------------------

public function color()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'color';
        $this->load->view('product_category/product_color',$data);
    }

    public function getColor()
    {

       
        $values = $this->category_models->getColorList();
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {

                if ($categoriy->color_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
                $row[] = strtoupper($categoriy->color);
                $row[] = strtoupper($categoriy->color_value);
                $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->color_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->color_id.','.$categoriy->color_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->color_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }

            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function add_color()
    {
        $data['category_id'] = "";
        $this->load->view('product_category/create_color',$data);
    }

    public function edit_color($id)
    {
        $data['category_details'] = $this->category_models->getColor_by_id($id);
        $this->load->view('product_category/create_color',$data);
    }

    public function update_color()
    {             
       $category_tbl_id =$this->input->post('category_tbl_id');
       //$cat_id =$this->input->post('cat_id');
       $cat_name =$this->input->post('cat_name');
       $cat_value =$this->input->post('cat_value');

       $data=array(
        'color'=>$cat_name,
        'color_value'=>$cat_value,
       );
        if ($this->category_models->color_update($category_tbl_id,$data)) {
            $st = array('status' =>1,'validation' =>'Done!');
            echo json_encode($st);
            } else {
                $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                echo json_encode($st);
            }        
    }   

    public function color_save()
    {
        $this->load->library('form_validation'); //form validation lib
        //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
        $this->form_validation->set_rules('cat_name', 'Color Name', 'required');
        $this->form_validation->set_rules('cat_value', 'Color Value', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cat_name =$this->input->post('cat_name');
            $cat_value =$this->input->post('cat_value');
            $data=array(
                'color'=>$cat_name,
                'color_value'=>$cat_value,
               );
                           if ($this->category_models->color_save($data)) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {
                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }   
    }

    public function color_change_status()
    {
        if($this->input->post('status')==1){
            $status=0;
        }
        else{
            $status=1;
        }
        $data=array(
            'color_status'=>$status,           
           );
           if($this->category_models->color_update($this->input->post('cat_id'),$data)) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function color_permanent_delete()
    {
           if($this->category_models->color_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent category with children categorys existing');
                   echo json_encode($st);
           }
    }
    
    //------------------------------------------------------------------------

    public function capacity()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'capacity';
        $this->load->view('product_category/product_capacity',$data);
    }

    public function getCapacity()
    {       
        $values = $this->category_models->getCapacityList();
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {

                if ($categoriy->capacity_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
                $row[] = strtoupper($categoriy->capacity_code);
                $row[] = strtoupper($categoriy->capacity_name);
                $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->capacity_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->capacity_id.','.$categoriy->capacity_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->capacity_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }

            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function add_capacity()
    {
        $data['category_id'] = "";
        $this->load->view('product_category/create_capacity',$data);
    }

    public function edit_capacity($id)
    {
        $data['category_details'] = $this->category_models->getCapacity_by_id($id);
        $this->load->view('product_category/create_capacity',$data);
    }
    

    public function update_capacity()
    {             
       $category_tbl_id =$this->input->post('category_tbl_id');
       //$cat_id =$this->input->post('cat_id');
       $cat_name =$this->input->post('cat_name');
       $cat_value =$this->input->post('cat_value');

       $data=array(
        'capacity_code'=>$cat_name,
        'capacity_name'=>$cat_value,
       );
        if ($this->category_models->capacity_update($category_tbl_id,$data)) {
            $st = array('status' =>1,'validation' =>'Done!');
            echo json_encode($st);
            } else {
                $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                echo json_encode($st);
            }        
    }   

    public function capacity_save()
    {
        $this->load->library('form_validation'); //form validation lib
        //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
        $this->form_validation->set_rules('cat_name', 'Capacity Name', 'required');
        $this->form_validation->set_rules('cat_value', 'Capacity Value', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cat_name =$this->input->post('cat_name');
            $cat_value =$this->input->post('cat_value');
            $data=array(
                'capacity_code'=>$cat_name,
                'capacity_name'=>$cat_value,
               );
                           if ($this->category_models->capacity_save($data)) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {
                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }   
    }
    

    public function capacity_change_status()
    {
        if($this->input->post('status')==1){
            $status=0;
        }
        else{
            $status=1;
        }
        $data=array(
            'capacity_status'=>$status,           
           );
           if($this->category_models->capacity_update($this->input->post('cat_id'),$data)) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function capacity_permanent_delete()
    {
           if($this->category_models->capacity_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent capacity with children categorys existing');
                   echo json_encode($st);
           }
    }


    //----------------------------------------------------------------------
    
    public function storage()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'storage';
        $this->load->view('product_category/product_storage',$data);
    }

    public function getStorage()
    {       
        $values = $this->category_models->getStorageList();
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {

                if ($categoriy->storage_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
                $row[] = strtoupper($categoriy->storage_name);
                $row[] = strtoupper($categoriy->storage_code);
                $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->storage_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->storage_id.','.$categoriy->storage_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->storage_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }

            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function add_storage()
    {
        $data['category_id'] = "";
        $this->load->view('product_category/create_storage',$data);
    }

    public function edit_storage($id)
    {
        $data['category_details'] = $this->category_models->getStorage_by_id($id);
        $this->load->view('product_category/create_storage',$data);
    }
    

    public function update_storage()
    {             
       $category_tbl_id =$this->input->post('category_tbl_id');
       //$cat_id =$this->input->post('cat_id');
       $cat_name =$this->input->post('cat_name');
       $cat_value =$this->input->post('cat_value');

       $data=array(
        'storage_name'=>$cat_name,
        'storage_code'=>$cat_value,
       );
        if ($this->category_models->storage_update($category_tbl_id,$data)) {
            $st = array('status' =>1,'validation' =>'Done!');
            echo json_encode($st);
            } else {
                $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                echo json_encode($st);
            }        
    }   

    public function storage_save()
    {
        $this->load->library('form_validation'); //form validation lib
        //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
        $this->form_validation->set_rules('cat_name', 'Storage Name', 'required');
        $this->form_validation->set_rules('cat_value', 'Storage Value', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cat_name =$this->input->post('cat_name');
            $cat_value =$this->input->post('cat_value');
            $data=array(
                'storage_name'=>$cat_name,
                'storage_code'=>$cat_value,
               );
                           if ($this->category_models->storage_save($data)) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {
                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }   
    }
    

    public function storage_change_status()
    {
        if($this->input->post('status')==1){
            $status=0;
        }
        else{
            $status=1;
        }
        $data=array(
            'storage_status'=>$status,           
           );
           if($this->category_models->storage_update($this->input->post('cat_id'),$data)) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function storage_permanent_delete()
    {
           if($this->category_models->storage_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent capacity with children categorys existing');
                   echo json_encode($st);
           }
    }



    //---------------------------------------------------------------------------
    public function warranty()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'warranty';
        $this->load->view('product_category/product_warranty',$data);
    }
    
    public function getWarranty()
    {       
        $values = $this->category_models->getWarrntyList();
        $data = array();

        if (!empty($values)) {
            foreach ($values as $categoriy) {

                if ($categoriy->warranty_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
            
            $row = array();
                $row[] = strtoupper($categoriy->warranty_code);
                $row[] = strtoupper($categoriy->waranty_name);
                $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->waranty_id.')"><i class="glyphicon fa fa-edit"></i></a>
                <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->waranty_id.','.$categoriy->warranty_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->waranty_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                $data[] = $row;
            }

            $output = array('data' =>$data);
            echo json_encode($output);
        }else{
            $output = array('data' =>'');
            echo json_encode($output);

        }
    }

    public function add_warranty()
    {
        $data['category_id'] = "";
        $this->load->view('product_category/create_warranty',$data);
    }

    public function edit_warranty($id)
    {
        $data['category_details'] = $this->category_models->getWarranty_by_id($id);
        $this->load->view('product_category/create_warranty',$data);
    }
    

    public function update_warranty()
    {             
       $category_tbl_id =$this->input->post('category_tbl_id');
       //$cat_id =$this->input->post('cat_id');
       $cat_name =$this->input->post('cat_name');
       $cat_value =$this->input->post('cat_value');

       $data=array(
        'warranty_code'=>$cat_name,
        'waranty_name'=>$cat_value,
       );
        if ($this->category_models->warranty_update($category_tbl_id,$data)) {
            $st = array('status' =>1,'validation' =>'Done!');
            echo json_encode($st);
            } else {
                $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                echo json_encode($st);
            }        
    }   

    public function warranty_save()
    {
        $this->load->library('form_validation'); //form validation lib
        //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
        $this->form_validation->set_rules('cat_name', 'Warranty code', 'required');
        $this->form_validation->set_rules('cat_value', 'Warranty name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cat_name =$this->input->post('cat_name');
            $cat_value =$this->input->post('cat_value');
            $data=array(
                'warranty_code'=>$cat_name,
                 'waranty_name'=>$cat_value,
               );
                           if ($this->category_models->warranty_save($data)) {

                       $st = array('status' =>1,'validation' =>'Done!');
                       echo json_encode($st);

               } else {
                       $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                       echo json_encode($st);
               }
          }   
    }
    

    public function warranty_change_status()
    {
        if($this->input->post('status')==1){
            $status=0;
        }
        else{
            $status=1;
        }
        $data=array(
            'warranty_status'=>$status,           
           );
           if($this->category_models->warranty_update($this->input->post('cat_id'),$data)) {
                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);
           }else {
                   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                   echo json_encode($st);
           }
    }

    public function warranty_permanent_delete()
    {
           if($this->category_models->warranty_permanent_delete($this->input->post('cat_id'))) {

                   $st = array('status' =>1,'validation' =>'Done!');
                   echo json_encode($st);

           }else {

                   $st = array('status' =>0,'validation' =>'cannot delete parent capacity with children categorys existing');
                   echo json_encode($st);
           }
    }

     //---------------------------------------------------------------------------
     public function distance_category()
     {
         $data['main_menu_name'] = $this->main_menu_name;
         $data['sub_menu_name'] = 'distance_category';
         $this->load->view('product_category/distance_category',$data);
     }
     
     public function getDistance()
     {       
         $values = $this->category_models->getDistanceList();
         $data = array();
 
         if (!empty($values)) {
             foreach ($values as $categoriy) {
 
                 if ($categoriy->distance_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
             
             $row = array();
                 $row[] = strtoupper($categoriy->distance_value);
                 $row[] = strtoupper($categoriy->distance_name);
                 $row[] = ' <a class="btn btn-xs btn-blue" href="#" data-toggle="modal" onclick="category_edit('.$categoriy->distance_id.')"><i class="glyphicon fa fa-edit"></i></a>
                 <a class="btn btn-xs '.$k.'" href="#" data-toggle="modal" onclick="change_status('.$categoriy->distance_id.','.$categoriy->distance_status.')"><i class="glyphicon fa '.$m.'"></i></a>
                 <a class="btn btn-xs btn-bricky" href="#" data-toggle="modal" onclick="perm_delete('.$categoriy->distance_id.')"><i class="glyphicon fa fa-trash-o"></i></a>';
                 $data[] = $row;
             }
 
             $output = array('data' =>$data);
             echo json_encode($output);
         }else{
             $output = array('data' =>'');
             echo json_encode($output);
 
         }
     }
 
     public function add_distance_category()
     {
         $data['category_id'] = "";
         $this->load->view('product_category/create_distance_category',$data);
     }
 
     public function edit_distance_category($id)
     {
         $data['category_details'] = $this->category_models->getDistance_by_id($id);
         $this->load->view('product_category/create_distance_category',$data);
     }
     
 
     public function update_distance_category()
     {             
        $category_tbl_id =$this->input->post('category_tbl_id');
        //$cat_id =$this->input->post('cat_id');
        $cat_name =$this->input->post('cat_name');
        $cat_value =$this->input->post('cat_value');
 
        $data=array(
         'distance_value'=>$cat_name,
         'distance_name'=>$cat_value,
        );
         if ($this->category_models->distance_category_update($category_tbl_id,$data)) {
             $st = array('status' =>1,'validation' =>'Done!');
             echo json_encode($st);
             } else {
                 $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                 echo json_encode($st);
             }        
     }   
 
     public function distance_category_save()
     {
         $this->load->library('form_validation'); //form validation lib
         //$this->form_validation->set_rules('cat_id', 'Category Code', 'required');
         $this->form_validation->set_rules('cat_name', 'distance_category name', 'required');
         $this->form_validation->set_rules('cat_value', 'distance_category value', 'required');
         if ($this->form_validation->run() == FALSE)
         {
            $st = array('status' =>0,'validation' => validation_errors());
            echo json_encode($st);
         }
         else
         {
             $cat_name =$this->input->post('cat_name');
             $cat_value =$this->input->post('cat_value');
             $data=array(
                'distance_value'=>$cat_name,
                'distance_name'=>$cat_value,
                );
                            if ($this->category_models->distance_category_save($data)) {
 
                        $st = array('status' =>1,'validation' =>'Done!');
                        echo json_encode($st);
 
                } else {
                        $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                        echo json_encode($st);
                }
           }   
     }
     
 
     public function distance_category_change_status()
     {
         if($this->input->post('status')==1){
             $status=0;
         }
         else{
             $status=1;
         }
         $data=array(
             'distance_status'=>$status,           
            );
            if($this->category_models->distance_category_update($this->input->post('cat_id'),$data)) {
                    $st = array('status' =>1,'validation' =>'Done!');
                    echo json_encode($st);
            }else {
                    $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                    echo json_encode($st);
            }
     }
 
     public function distance_category_permanent_delete()
     {
            if($this->category_models->distance_category_permanent_delete($this->input->post('cat_id'))) {
 
                    $st = array('status' =>1,'validation' =>'Done!');
                    echo json_encode($st);
 
            }else {
 
                    $st = array('status' =>0,'validation' =>'cannot delete parent capacity with children categorys existing');
                    echo json_encode($st);
            }
     }













}

//--------------------------------------------------------------------------