<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Invoice_Exchange extends CI_Controller {



    var $main_menu_name = "sales";

	var $sub_menu_name = "invoice_exchange";



	public function __construct()

	{

		parent::__construct();



        $this->load->model('Product_Models');

		//$this->load->model('Sales_Rep_Issue_Model');
		//$this->load->model('Location_Issue_Return_Model');

		$this->load->model('Supplier_Model');

		$this->load->model('Warehouse_Model');

		$this->load->model('Common_Model');

		$this->load->model('Tax_Rates_Model');

		$this->load->model('Customer_Model');

		$this->load->model('Sales_Return_Model');

		$this->load->model('User_Model');

		$this->load->model('Transfer_Model');

		$this->load->model('Purchases_Model');

		$this->load->model('Product_Damage_Model');

		//$this->load->model('Fixed_Assets_Model');	

		//$this->load->model('Drivers_Model');

		$this->load->model('Location_Model');
		//$this->load->model('Route_Model');
		$this->load->model('Sales_Model');
		

	}

	

	//Sales list page load

	public function index()

	{
	

		$data['sales_rep_issues']=$this->Sales_Rep_Issue_Model->get_all_sales_rep_issue();

		$data['main_menu_name'] = $this->main_menu_name;

		$data['sub_menu_name'] = 'invoice_exchange';

        $this->load->view('invoice_exchange',$data);

	}	

	

	

	public function manage()
	{	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'invoice_exchange';
		$sale_id =  $this->uri->segment(3);	

					

		//if ($sale_rep_issue_id==0)

		{

			

			

		}

	//	else

			{

			

		//$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['tax_rates_list'] = $this->Tax_Rates_Model->get_all_tax_rates();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		//$data['guaranteer_list'] = $this->Customer_Model->get_all_customers_by_type_id('Guaranteer');
		$data['status_list'] = $this->Common_Model->get_all_status();
		$data['cr_limit_list'] = $this->Common_Model->get_all_cr_limit();
		//$data['routes_list']=$this->Route_Model->get_all_routes();
		//$data['location_list']=$this->Location_Model->get_all_location_for_dropdown();
		$data['btn_txt']='Submit';
		
		$data['sale_item_list']= $this->Sales_Model->get_sale_item_list_by_sale_id($sale_id);
		$data['sale_details']=$this->Sales_Model->get_sale_info($sale_id);
		$data['icus_id']=$data['sale_details']['customer_id'];
		$data['sale_id']=$sale_id;

			$this->load->view('invoice_exchange_manage',$data); 

			

			}

		

	}

	

	function get_all_rep_issue_by_rep_issue_id()

	{

		$sale_rep_issue_id=$this->input->get('SI');

		

		$sale_rep=$this->Sales_Rep_Issue_Model->get_sales_rep_id($sale_rep_issue_id);

		$warehouse=$this->Sales_Rep_Issue_Model->get_warehouse_id_and_date($sale_rep_issue_id);

		$sales_rep_id=$sale_rep['sales_rep_id'];

		$wharehouse_id=$warehouse['wharehouse_id'];

		$sales_rep_issue_date=$warehouse['sales_rep_issue_date'];

		$sale_rep_issue_items=$this->Sales_Rep_Issue_Model->get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);

		

		$json=array();

		

		foreach ($sale_rep_issue_items as $row)

		{

			$product_id= $row['product_id'];

			

			$sales_qty=$this->Sales_Rep_Issue_Model->get_sale_rep_invoice_item_qty($product_id, $sales_rep_id, $wharehouse_id, $sale_rep_issue_id);

		

		if(is_null($sales_qty['quantity']))

						{

						$sales_qty_val=0;

						}

						else

						{

							$sales_qty_val=$sales_qty['quantity'];

						}

		

		 $json_itm=array(

			 		

					'product_id'=> $row['product_id'],

					'product_code'=> $row['product_code'],

					'add_sales_excess_price'=> $row['add_sales_excess_price'],

					'add_sales_discount_price'=> $row['add_sales_discount_price'],

					'product_price'=> $row['product_price'],

					'product_cost'=> $row['product_cost'],

					'salse_rep_issue_qty'=> $row['salse_rep_issue_qty'],

					'product_name'=> $row['product_name'],

					'product_oem_part_number'=> $row['product_oem_part_number'],

					'product_part_no'=> $row['product_part_no'],

					//'item_cost'=> $row['item_cost'],

					'sale_qty'=> $sales_qty_val,

					            

                    );

					//print_r($json_itm);

		

		array_push($json,$json_itm);

						

		}		

		

		echo json_encode($json);		

			

		

		

	}

	

	

	

		function sales_rep_return()

	{

		$sale_rep_issue_id =  $this->uri->segment(3);	

		$data['sale_rep_issue_id']=$this->$sale_rep_issue_id =  $this->uri->segment(3);

			

			$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();

			$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();

			

			$data['type']='E';

			$data['type1']=$sale_rep_issue_id;

			$data['main_menu_name']=$this->main_menu_name;

			$data['sub_menu_name']='manage';

			$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

			$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model->get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);

			$this->load->view('sales_rep_issue_return',$data);

			

			

			 

		

	}

	

	

	

	public function get_next_ref_no()

	{

	

	$query=$this->Sales_Rep_Issue_Model->get_next_ref_no();

	$result=$query->row();

	$sales_rep_issue_next_ref_number=sprintf("%05d", $result->sales_rep_issue_id+1);

	echo json_encode (array('sales_rep_issue_next_ref_number'=>$sales_rep_issue_next_ref_number));

		

	}

	

	public function get_product_suggestion()

	{

		

		$term=$this->input->get('term');

		$data['product']=$this->Sales_Rep_Issue_Model->get_product_suggestion($term);

		$in_type=$this->input->get('t');

		

		$json=array();

		

		foreach ($data['product'] as $row)

		{

		 $product_id=$row['product_id'];

		 $product_code =$row['product_code'];

		 $product_name=$row['product_name'];

		 $product_oem_part_number=$row['product_oem_part_number'];

		 $product_part_no=$row['product_part_no'];

		 $product_cost=$row['product_cost']; 

		 $product_price=$row['product_price'];

		 $wholesale_price=$row['wholesale_price']; 

		 $credit_salling_price=$row['credit_salling_price'];

		 $sendParameters="$product_id,$product_name,$product_code,$product_price";

		 $selling_R_price=" Selling Price: ".number_format($product_price, 2, '.', ',');
		 //.' Cost Price:'.number_format($product_cost, 2, '.', ',');//RETAIL PRICE

		 $selling_W_price=" Selling Price(Wholesale): ".number_format($wholesale_price, 2, '.', ',');//WHOLESALE PRICE

		 $selling_C_price=" Selling Price(Credit): ".number_format($credit_salling_price, 2, '.', ',');//CREDIT PRICE

		 if($product_part_no) $selling_R_price.=" | Warranty(Months): $product_part_no";

		 if($product_oem_part_number) $selling_R_price.=" | Product Model: $product_oem_part_number";

		

		 $json_itm=array(

			 		'id'=> $row['product_id'],

					'product_id'=> $row['product_id'],

					'product_code'=> $row['product_code'],

					'product_name'=> $row['product_name'],

					'product_price'=> $row['product_price'],

					'product_part_no'=> $row['product_part_no'],

					'item_cost'=> $row['product_cost'],

					'product_oem_part_number'=> $row['product_oem_part_number'],                   

					'product_sn_exissts'=> $row['product_sn_exissts'],



                    'value'=> $row['product_name']." (".$row['product_code'].")",

                    'label'=> $row['product_name']." (".$row['product_code'].")$selling_R_price"

                    );

		

		array_push($json,$json_itm);

						

		}		

		echo json_encode($json);		

		



		

	}

	
	function save_exchange()
	{	
		$sale_id=$this->input->post('sale_id');
		$location_id=$this->input->post('location_id');
		$sale_inv_discount=$this->input->post('sale_inv_discount');
		$sale_inv_discount_amount=$this->input->post('sale_inv_discount_amount');
		
		$sale_total=$this->input->post('sale_total');
		$cost_total=$this->input->post('cost_total');
		$rental_days=(int)str_replace(',', '', $this->input->post('rental_days'));
		$term_amount=floatval(str_replace(',', '', $this->input->post('term_amount')));
		
		$error='';
		$lastid='';
		$disMsg='';
		if(!$error)
		{
			
			//Update sale table
			$data_sale=array(
				'sale_total'=>$sale_total,
				'cost_total'=>$cost_total,
				//'no_of_days'=>$rental_days,
				//'term_amount'=>$term_amount,
				'sale_inv_discount'=>$sale_inv_discount,
				'sale_inv_discount_amount'=>$sale_inv_discount_amount,
				
			);
			
			$this->Sales_Model->save_sales($data_sale,$sale_id);
			
			//Insert sale items
			$row=$this->input->post('row');
			$rowCount=$this->input->post('rowCount');
			$data_item=array();
			for($i=1; $i<=$rowCount; $i++){
				//echo "/ $rowCount , Test:".$row[$i]['product_id'][0];
				if(isset($row[$i]['product_id'][0]))
				{	
				//only add new items
				if(!$row[$i]['sale_item_id'][0]){				
				$data_item=array(
					'sale_id'=>$sale_id,
					//'sales_rep_issue_id'=>intval($row[$i]['sales_rep_issue_id'][0]),
					'product_id'=>$row[$i]['product_id'][0],
					'quantity'=>$row[$i]['qty'][0],
					'discount'=>$row[$i]['discount'][0],
					'unit_price'=>$row[$i]['unit_price'][0],
					'item_cost'=>$row[$i]['item_cost'][0],
					'unit_price'=>$row[$i]['unit_price'][0]+$row[$i]['item_price_p'][0],
					'discount_val'=>$row[$i]['discount_val'][0], 
					'gross_total'=>$row[$i]['gross_total'][0],
					//'location_id'=>intval($location_id)
				);
				
					$this->Sales_Model->save_sales_item($data_item);
					$itemid=$this->db->insert_id();
					if($row[$i]['product_sn'][0])
					{
				//add serial numbers
				//exploid serial numbers
				$pieces_sn = explode(",", $row[$i]['product_sn'][0]);
				$status=$this->Sales_Model->get_purchase_status($pieces_sn,$row[$i]['product_id'][0]);
					for($h=0; $h<count($pieces_sn); $h++){
						$sn_data=array(
							'product_id'=>$row[$i]['product_id'][0],	
							'product_w'=>$row[$i]['product_w'][0],	
							'sale_id'=>$sale_id,
							'sale_item_id'=>$itemid,
							'sis_number'=>$pieces_sn[$h],
							'product_status'=>$status,
						);
				  		$this->Sales_Model->save_sale_serial_numbers($sn_data);
						
						
				//update grn serial number sold status
				$pis_number=$pieces_sn[$h];
				$sn_data=array(	
					'sale_inv_id'=>$sale_id,
					'pis_sold'=>1,
				);
				$this->Purchases_Model->update_grn_serial_numbers($sn_data,$pis_number);
					}
				}
				
				
				
				
				
				//insert user activity
				$this->Common_Model->add_user_activitie("Added Sale Item, (Id:$itemid)");
				
				//add reford for f4 table
				$type='sale';
				$ref_id=$sale_id;
				$product=$row[$i]['product_id'][0];
				$quantity=$row[$i]['qty'][0];
				$unit_cost=$row[$i]['unit_price'][0];
				$this->Common_Model->add_fi_table($type,$ref_id,$product,$quantity,$unit_cost);
				}
}
		}
		
		}
		
		//insert user activity
		$this->Common_Model->add_user_activitie("Exchange Invoice, (Id:$sale_id)");
		
		echo json_encode(array('id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
	
	}

	
	function save_exchange_item()
	{	
		$sis_id=$this->input->post('sis_id');
		$sis_number=$this->input->post('sis_number');
		$error='';
		$lastid='';
		$disMsg='';
		if(!$error)
		{
		$data_item=array(
			
			'item_exchanged_user_id'=>$this->session->userdata('ss_user_id'),
			'item_exchanged_status'=>$this->input->post('item_exchanged_status'),
			'item_exchanged_note'=>$this->input->post('item_exchanged_note'),
			'item_exchanged_price'=>$this->input->post('item_exchanged_price'),
			'item_exchanged_date'=>date('Y-m-d H:i:s'),
			'item_exchanged'=>1,
		);

			$_insert=$this->Sales_Model->update_sale_serial_numbers($data_item,$sis_id);

				//update purchase item serial table
				$data_item=array(
					'item_exchanged'=>1,
					'product_status'=>$this->input->post('item_exchanged_status'),
					
				);
				$this->Purchases_Model->update_grn_serial_numbers($data_item,$sis_number);
				
				$this->Common_Model->add_user_activitie("Item Exchanged, (Seria No.:$sis_number)");
				
				
		}
		
		
		
		
		echo json_encode(array('id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
	
	}

	function save_location_rep_issue_return()

	{	
		$lir_id=0;
		$location_id=$this->input->post('location_id');
		if(!$lir_id)
		{
			$result=$this->Location_Issue_Return_Model->get_next_ref_no();
			$lir_ref_no=sprintf("%04d", $result->lir_id+1);
		}


		$error='';

		

		if(!$error)
		{
		$data=array(
			'lir_ref_no'=>$lir_ref_no,
			'user_id'=>$this->session->userdata('ss_user_id'),
			'li_id'=>$this->input->post('sale_rep_issue_id'),
			'warehouse_id'=>$this->input->post('warehouse_id'),
			'sales_rep_id'=>$this->input->post('sales_rep_id'),
			'location_id'=>$this->input->post('location_id'),
			'lir_date'=>date('Y-m-d', strtotime($this->input->post('lir_date'))),
			'lir_added_date_time'=>date('Y-m-d H:i:s'),
			'secondry_sale_rep_id'=>$this->input->post('secondry_sales_rep_id'),
			'driver_id'=>$this->input->post('driver'),
		);
			
			

			$_insert=$this->Location_Issue_Return_Model->save_location_rep_issue_return($data,$lir_id);

			$lastid=$this->db->insert_id();

			
			//print_r($data);
			//die();

			

			if(!$lir_id)
				{
					$lir_id=$lastid;
				}

				else

				{

				
				$this->Sales_Rep_Issue_Model->delete_old_location_issue_items($lir_id);

				}

			

			$row=$this->input->post('row');

			$rowCount=$this->input->post('rowCount');

			$data_items =array();

			

			for($i=1; $i<=$rowCount; $i++){

				

				if(isset($row[$i]['product_id'][0]))

				{					

				$data_item=array(

					

					'lir_id'=>$lir_id,

					'product_id'=>$row[$i]['product_id'][0],

					'liri_qty'=>$row[$i]['qty'][0],

					//'liri_status'=>$row[$i]['liri_status'][0],

							

					//'add_sales_excess_price'=>$row[$i]['item_price_p'][0],

					//'add_sales_discount_price'=>$row[$i]['discount_val'][0],

					//'location_id'=>$location_id,

				);

				$this->Location_Issue_Return_Model->save_location_issue_return_item($data_item);

				$liri_id=$this->db->insert_id();

				if($row[$i]['product_sn'][0])

				{

				//add serial numbers

				//exploid serial numbers

				//sris_id 	product_id 	product_w 	sales_rep_issue_id 	sales_rep_issue_item_id 	sris_number 	product_status 

				$pieces_sn = explode(",",$row[$i]['product_sn'][0]);

				//$status=$this->Sales_Rep_Issue_Model->get_purchase_status($pieces_sn,$row[$i]['product_id'][0]);
				$status='';
					for($h=0; $h<count($pieces_sn); $h++){
						
						//get serial no and status
						$pizza  = $pieces_sn[$h];
						$pieces = explode("-", $pizza);
						$sn=$pieces[0];
						$type=$pieces[1];
                          
						$sn_data=array(
							'product_id'=>$row[$i]['product_id'][0],	
							//'product_w'=>$row[$i]['product_w'][0],	
							'lir_id'=>$lir_id,
							'liri_id'=>$liri_id,
							'liris_snumber'=>$sn,
							'liris_product_status'=>$type,
						);

				  		$this->Location_Issue_Return_Model->save_location_issue_return_serial_numbers($sn_data);

						


				//update grn serial number sold status

				$pis_number=$pieces_sn[$h];

				$sn_data=array(	

					//'sale_rep_issue_id'=>$sales_rep_issue_id,
					'issue_return '=>1,
					'issue_return_from_location_id '=>$location_id,
					'issue_return_to_location_id '=>1,
					'issue_return_to_location_id '=>1,
					'product_status'=>$type

				);

				 $this->Purchases_Model->update_grn_serial_numbers($sn_data,$sn);
				 
				 
					}

				}

				

			}

				

			}			

			 	

			

			

		}else {

			

			$disMsg='Please select these before adding any product:'.$disMsg;

		}	

		

		$this->session->set_flashdata('message', 'Sale successfully added!');

		
		$disMsg='';
		echo json_encode(array('id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));

	}

	

	

	

	

	function save_sales_rep_issue_return_del()

	{	

		$query=$this->Sales_Rep_Issue_Model->get_next_return_ref_no();

		$result=$query->row();

		$sales_rep_issue_next_ref_return_number=sprintf("%06d", $result->sales_rep_issue_return_id+1);

	    

		$warehouse_id=$this->input->post('warehouse_id');

		$sales_rep_id=$this->input->post('sales_rep_id');

		$temp_date=$this->input->post('sales_rep_issue_datetime');

		$sales_rep_issue_id=$this->input->post('sale_reference_no');

		$total_amount=$this->input->post('sale_total');

		$total_cost=$this->input->post('cost_total');

		

		$add_sales_excess_price=$this->input->post('item_price_p_1');

		$add_sales_discount_price=$this->input->post('discount_1');

		$sales_rep_issue_retun_date=date('Y-m-d', strtotime($temp_date));

		$added_date_time =date('Y-m-d H:i:s');

		$last_modified_date_time=date('Y-m-d H:i:s');

		

		$status="returned";

		

		

		

		if($sales_rep_issue_id!=0)

		{

		$sales_rep_issue_next_ref_number=sprintf("%06d", $sales_rep_issue_id);

		}

		

		

		$error='';

		

		if(!$error)

		{

		$data=array(

		

			

			

			'sales_rep_issue_return_ref_no'=>$sales_rep_issue_next_ref_return_number,

			'sales_rep_issue_id 

'=>$sales_rep_issue_id,

			'wharehouse_id'=>$warehouse_id,

			'sales_rep_id'=>$sales_rep_id,

			'sales_rep_issue_date'=>$sales_rep_issue_retun_date,

			'added_date_time'=>$added_date_time,

			'total_amount'=>$total_amount,

			'total_return_cost'=>$total_cost,

			'status'=>$status,

			

			'entered_user_id'=>$this->session->userdata('ss_user_id')

			

			);

			$_insert=$this->Sales_Rep_Issue_Model->save_sales_rep_issue_retrurn($data,$sales_rep_issue_id);

			$lastid=$this->db->insert_id();

			

			//print_r($lastid);

			

		

			

			//insert user activity

			$this->Common_Model->add_user_activitie("Added Sales Rep Issue Return, (Sales Rep Issue No:$sales_rep_issue_next_ref_return_number)");

			$disMsg='Return successfully added';

			

			

			$row=$this->input->post('row');

			$rowCount=$this->input->post('rowCount');

			$data_items =array();

			

			for($i=1; $i<=$rowCount; $i++){

				

				if(isset($row[$i]['product_id'][0]))

				{					

				$data_item=array(

					

					'sales_rep_issue_return_id'=>$lastid,

					'product_id'=>$row[$i]['product_id'][0],

					'salse_rep_issue_qty_r'=>$row[$i]['qty'][0],

					'product_price_r'=>$row[$i]['unit_price'][0],

					'product_cost_r'=>$row[$i]['item_cost'][0],				

					'add_sales_excess_price_r'=>$row[$i]['item_price_p'][0],

					'add_sales_discount_price_r'=>$row[$i]['discount_val'][0],

					'sales_rep_retuned_qty'=>$row[$i]['qty_return'][0],

				);

				$this->Sales_Rep_Issue_Model->save_sales_rep_issue_item_return($data_item);

				$itemid=$this->db->insert_id();

				$this->Sales_Rep_Issue_Model->save_sales_rep_issue_retrurn_complte($sales_rep_issue_id);

				

				

				}

			}			

			 	

			

			

		}else {

			

			$disMsg='Please select these before adding any product:'.$disMsg;

		}	

		

		$this->session->set_flashdata('message', 'Return successfully added!');

		

		echo json_encode(array('sales_rep_issue_id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));

		

		

		

		

	}

	

	

	

	

	

	

	

	

	

	

	

	

	public function location_issue_return_details()

	{

		

		$lir_id =  $this->uri->segment(3);
		
		//get issue return details
		$lir_des=$this->Location_Issue_Return_Model->get_location_issue_detail_by_lir_id($lir_id);
		
		

		//$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		//$whare_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		//$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		
		

		$sales_rep_id=$lir_des['sales_rep_id'];
		$location_id=$lir_des['location_id'];
		$warehouse_id=$lir_des['warehouse_id'];

		

		//$data['SRID']=$sale_rep_issue_id;

		$data['main_menu_name']=$this->main_menu_name;
		$data['lir_id']=$lir_id;
		$data['lir_des']=$lir_des;

		$data['sub_menu_name']='';

		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($warehouse_id);

		$data['sales_rep_details']=$this->User_Model->get_rep_first_and_second_name_by_id($sales_rep_id);

		//$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		$data['location_issue_items_details']=$this->Location_Issue_Return_Model->get_location_issue_return_item_list_by_lir_id($lir_id);	
        $data['location_details']=$this->Location_Model->get_location_info($location_id);
		
		
		 $this->load->view('location_issue_return_details',$data);	
		// print_r($lir_des);

	}

	

	

	public function sales_rep_issue_details_print()

	{

		$data['main_menu_name']=$this->main_menu_name;

		$data['sub_menu_name']='';

		$sale_rep_issue_id=$this->input->get('sale_rep_issue_id');

		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		$whare_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		

		$sales_rep_id=$rep_id['sales_rep_id'];

		$id=$whare_id['wharehouse_id'];

		

		$data['SRID']=$sale_rep_issue_id;

		$data['main_menu_name']=$this->main_menu_name;

		$data['sub_menu_name']='';

		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($id);

		$data['sales_rep_details']=$this->User_Model->get_rep_first_and_second_name_by_id($sales_rep_id);

		$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);

		$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model-> get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);	

		 

		 $this->load->view('models/sales_rep_issue_details_print',$data);

	}

	

	

	

	public function get_all_issue_return_list()

	{	

	

	$data=array();

	

	$sales_rep_issue=$this->Location_Issue_Return_Model->get_all_issue_return_list();

	

	foreach ( $sales_rep_issue as $row)

	{

		$lir_id=$row['lir_id'];

		

		$pay_st = '<span class="label label-danger">Error</span>';

		


			$pay_st = '<span class="label label-success">Completed</span>';	

			$action='<div class="btn-group text-left">

                       

					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>

                            <ul role="menu" class="dropdown-menu pull-right">

                            <li><a href="'.base_url().'location_issue_return/location_issue_return_details/'.$lir_id.'"><i class="fa fa-file-text-o"></i>Location Issue Return Details</a></li>
                            </ul></div>';




		
      //$location_name=$this->Location_Model->get_location_name_by_id($row['location_id']);
		

		

		$nestedData=array();

		
		//get user name
		$sales_rep_name='';
		if(!empty($row['sales_rep_id'])){
			$sales_rep_des=$this->User_Model->get_user_info($row['sales_rep_id']);
			$sales_rep_name=$sales_rep_des['user_first_name'].' '.$sales_rep_des['user_last_name'];
		}
		$secondry_sale_rep_name='';
		if(!empty($row['secondry_sale_rep_id'])){
			$secondry_sale_rep_des=$this->User_Model->get_user_info($row['secondry_sale_rep_id']);
			$secondry_sale_rep_name=$secondry_sale_rep_des['user_first_name'].' '.$secondry_sale_rep_des['user_last_name'];
		}
		

		$nestedData[]=$row['lir_date'];
		$nestedData[]=$row['lir_ref_no'];
		$nestedData[]=$row['location_name'];
		$nestedData[]=$sales_rep_name;
		$nestedData[]=$secondry_sale_rep_name;
		$nestedData[]=$row['driver_name'];
		//$nestedData[]=$row['secondry_sale_rep_id'];
		$nestedData[]=$row['user_first_name'];

		

		$nestedData[]=$action;

	

		$data[]=$nestedData;

	}	

	

	

	$json_data = array(

	"data"=>$data

	);

	

	echo json_encode($json_data);

	

		

	}

 public function add_serial_no()

    {


    $data['row'] = $this->uri->segment(3);

	$data['qty'] = $this->uri->segment(4);

	$product_id = $this->uri->segment(5);
	$location_id = $this->uri->segment(6);

    $data['product_id']=$product_id;

	$product_des=$this->Product_Models->get_product_by_id($product_id);

	$data['product_dis_name']=$product_des->product_code." ".$product_des->product_name;

		   

		

		//echo "test:".$this->uri->segment(3);

		$data['btnText'] = 'Submit';

		$data['sn_list'] = $this->Purchases_Model->get_serial_no_by_product_id_and_location_to_issue_return($product_id,$location_id);

        $this->load->view('models/serial_no_add_rep_issue_return',$data);

    }		

	
/*


*/
 	public function exchange_item_by_sn()
    {
		$sis_id=$this->uri->segment(3);
		if($sis_id){
		$data['sis_id'] = $sis_id;
		$sis_details=$this->Sales_Model->get_sale_items_serial_details_by_sis_id($sis_id);
		$product_id=$sis_details[0]->product_id;
		//print_r($sis_details);
		$product_des=$this->Product_Models->get_product_by_id($product_id);
		$data['product_dis_name']=$product_des->product_code." ".$product_des->product_name;
		$data['btnText']='Exchange Item';
		$data['sis_details'] = $sis_details;
		$this->load->view('models/exchange_item',$data);
		}
    }	
	

}