<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class product_model extends CI_Model {
    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->table = 'product';
    }

    public function get_product($data) {
        $this->db->select('product.*');
        if (isset($data['cat_id'])) {
            $this->db->where('cat_id', $data['cat_id']);
        }
        $query = $this->db->get($this->table);
        return $query->result();
    }
    
    public function get_product_details($pid){
        $this->db->select('p.*');
		$this->db->select('pc.cat_name');
		$this->db->select('psc.sub_cat_name');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('ms.storage_name');
		$this->db->select('mc.capacity_name');
		$this->db->select('mw.waranty_name');
        $this->db->from('product p');
		$this->db->join("product_category pc",'p.cat_id=pc.cat_id','left');
		$this->db->join("product_sub_category psc",'p.sub_cat_id=psc.sub_cat_id','left');
		$this->db->join('color c','p.color_id=c.color_id','left');
		$this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
		$this->db->join('mstr_storage ms','p.storage_id=ms.storage_id','left');
		$this->db->join('mstr_capacity mc','p.capacity_id=mc.capacity_id','left');
		$this->db->join('mstr_waranty mw','p.warranty_id=mw.waranty_id','left');
        $this->db->where('p.product_id' , $pid);
        $query = $this->db->get();
        return $query->row_array();
    }
	
	 public function get_product_list($cat_id='',$sub_cat_id='',$keyword=''){
        $this->db->select('p.*');
		$this->db->select('pc.cat_name');
		$this->db->select('psc.sub_cat_name');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
        $this->db->from('product p');
		$this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
		$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
		$this->db->join('color c','c.color_id = p.color_id','left');
		$this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
		 if($cat_id){
			$this->db->where('p.cat_id' , $cat_id); 
		 }
		 if($sub_cat_id){
			$this->db->where('p.sub_cat_id' , $sub_cat_id); 
         }
         if($keyword){
			$this->db->like('p.product_name', $keyword);
         }
         
         
        
        $query = $this->db->get();
        return $query->result_array();
    }
	//------------------------------------------------
    
    public function get_group_products($gid){
        
        $this->db->select('product.*,color.color,memory.memory');
//        $this->db->join('product_attribute' , 'product.product_id = product_attribute.product_id', 'left outer');
        $this->db->join('color' , 'color.color_id = product.color_id', 'left outer');
        $this->db->join('memory' , 'memory.memory_id = product.storage_id', 'left outer');
        $this->db->where('product.group_id',$gid);
        $query = $this->db->get('product');
        return $query->result_array();
    }  

   

    public function get_product_group($data) {
        $this->db->select('product_groups.*');
        $this->db->from('product_groups');
        $this->db->join("product",'product_groups.product_g_id = product.group_id');
        if (isset($data['cat_id'])) {
            $this->db->where('cat_id', $data['cat_id']);
        }
        $query = $this->db->get($this->table);
        return $query->result();
    }

    public function get_product_byid($p_id) {
        $this->db->select();
        $this->db->where('product_id', $p_id);
        $query1 = $this->db->get($this->table)->first_row('array');
        return $query1;
    }
	
    public function get_category() {
        $query = $this->db->get('product_category');
        return $query->result();
    }

    public function get_subcategory() {
        $query = $this->db->get('product_sub_category');
        return $query->result();
    }

    //----------------------------------------------------------------------
	
	public function get_single_product($product_id)
	{
		//get new arrival product 
        $new_arraival=$this->get_single_product_details($product_id);
        
      //  echo "test";

        $new_arrival_data=array();
        foreach($new_arraival as $na){
			$di_de_dis		=0;
			$di_de_dis_id	=0;
			$sp_of_dis		=0;
			$sp_of_dis_id	=0;
			$discount_value	=0;
			$discount_id	=0;
			$discount_type	=0;
			$di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);				
			$availble_qty=$this->get_available_qty($na['product_id']);
			$sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
			if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
			if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];}
			if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
			if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

			$discount_price=($na['product_price']/100)*$discount_value;
			$product_price=$na['product_price']-$discount_price;

            $nested_data=array(
                'product_name'=>$na['product_name'],
                'product_code'=>$na['product_code'],
                'product_thumb'=>$na['product_thumb'],
				'product_image'=>$na['product_image'],
				'cat_name'=>$na['cat_name'],
                'product_price'=>$product_price,
                'product_cost'=>$na['product_cost'],
                'product_details'=>$na['product_details'],
                'product_specification'=>$na['product_specification'],
                'product_id'=>$na['product_id'],
				'discount_value'=>$discount_price,
				'original_price'=>$na['product_price'],
				'accessories'=>$na['accessories'],
				'brand_name'=>$na['brand_name'],
				'model_number'=>$na['model_number'],
				'color'=>$na['color'],	
				'sh_cat_value'=>$na['sh_cat_value'],
				'product_discount_id'=>$discount_id,	
				'product_discount'=>$discount_value."%",
				'availble_qty'=>$availble_qty,
				'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
				'image_path'=>base_url()."admin/uploads/product/image/",
				'waranty_conditions'=>$na['waranty_conditions'],
				'stock_availability'=>$na['stock_availability'],
				'sold_qty'=>$na['sold_qty'],
				'return_policy'=>$na['return_policy'],

            );
            $new_arrival_data=$nested_data;
		}		
		return  $new_arrival_data;
	}	


	//----------------------------------------------------------------------
	
	public function get_muliti_product($data)
	{
        $product_list=array();
        foreach($data as $na){
			$di_de_dis		=0;
			$di_de_dis_id	=0;
			$sp_of_dis		=0;
			$sp_of_dis_id	=0;
			$discount_value	=0;
			$discount_id	=0;
			$discount_type	=0;
			$di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);				
			$availble_qty=$this->get_available_qty($na['product_id']);
			$sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
			if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
			if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];}
			if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
			if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

			$discount_price=($na['product_price']/100)*$discount_value;
			$product_price=$na['product_price']-$discount_price;

            $nested_data=array(
                'product_name'=>$na['product_name'],
                'product_code'=>$na['product_code'],
                'product_thumb'=>$na['product_thumb'],
				'product_image'=>$na['product_image'],
				'cat_name'=>$na['cat_name'],
                'product_price'=>$product_price,
                'product_cost'=>$na['product_cost'],
                'product_details'=>$na['product_details'],
                'product_specification'=>$na['product_specification'],
                'product_id'=>$na['product_id'],
				'discount_value'=>$discount_price,
				'original_price'=>$na['product_price'],
				'accessories'=>$na['accessories'],
				'brand_name'=>$na['brand_name'],
				'model_number'=>$na['model_number'],
				'color'=>$na['color'],	
				'sh_cat_value'=>$na['sh_cat_value'],
				'product_discount_id'=>$discount_id,	
				'product_discount'=>$discount_value."%",
				'availble_qty'=>$availble_qty,
				'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
				'image_path'=>base_url()."admin/uploads/product/image/",
				'waranty_conditions'=>$na['waranty_conditions'],
				'stock_availability'=>$na['stock_availability'],
				'sold_qty'=>$na['sold_qty'],
				'return_policy'=>$na['return_policy'],
				
            );
            $product_list[]=$nested_data;
		}		
		return  $product_list;
	}	
	
	
	
	public function get_single_product_details($product_id)
	{
		$this->db->select('pc.*');
		$this->db->select('p.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('product p');
		$this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
		$this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
		$this->db->join('color c','p.color_id=c.color_id','left');
		$this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
		$this->db->where("p.product_status",1);
		$this->db->where("pc.cat_status",1);
		$this->db->where("p.product_id",$product_id);	
		$query=$this->db->get();
		
		//echo "test";
		//echo $this->db->last_query();
		return $query->result_array();
	}
	//----------------------------------------------------------------------------
	//get product daily deal disount 
	public function get_daily_deal_disount($product_id)
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.daily_deal_id');
		$this->db->from('daily_deals_product dp');
		$this->db->where("dp.is_remove",0);
		$this->db->where("dp.approval_status",1);	
		$this->db->where("dp.product_id",$product_id);	
		$this->db->order_by('dp.daily_deal_id','desc');		
		$query=$this->db->get();
		return $query->row_array();
	}
	//get product special offer  disount 
	public function get_speciacl_offer_disount($product_id)
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.sp_dis_id');
		$this->db->from('specical_offer_product dp');
		$this->db->where("dp.is_remove",0);
		$this->db->where("dp.approval_status",1);	
		$this->db->where("dp.product_id",$product_id);	
		$this->db->order_by('dp.sp_dis_id','desc');		
		$query=$this->db->get();
		return $query->row_array();
	}
	//--get product spesifications
	public function get_single_product_spesification($product_id)
	{
		$this->db->select('p.*');
		$this->db->from('product_specification p');
		//$this->db->where("p.product_status",1);
		$this->db->where("p.product_id",$product_id);	
		$query=$this->db->get();
		return $query->result_array();
	}

	public function get_single_product_connectivity($product_id)
	{
		$this->db->select('p.*');
		$this->db->from('product_connectivity p');
		//$this->db->where("p.product_status",1);
		$this->db->where("p.product_id",$product_id);	
		$query=$this->db->get();
		return $query->result_array();
	}

	public function get_single_product_accessories($product_id)
	{
		$this->db->select('p.*');
		$this->db->from('product_accessories p');
		//$this->db->where("p.product_status",1);
		$this->db->where("p.product_id",$product_id);	
		$query=$this->db->get();
		return $query->result_array();
	}


	
	public function get_image_list($product_id)
	{
		$this->db->select('p.*');
		$this->db->from('product_images p');
		//$this->db->where("p.product_status",1);
		$this->db->where("p.product_id",$product_id);	
		$query=$this->db->get();
		return $query->result_array();
	}


	public function get_available_qty($product_id)
	{

		$qty= 1000;
		$order_qty=$this->get_order_qty($product_id);
		return $qty-$order_qty;

	}

	public function get_order_qty($product_id)
	{
		$this->db->select_sum('oci.product_qty');
		$this->db->from('order_customer_item oci');
		$this->db->join("order_customer oc",'oc.ord_cus_id = oci.order_cus_id','left');
		$this->db->where("oci.product_status",1);
		$this->db->where("oc.is_cancelled",0);	
		$this->db->where("oci.product_id",$product_id);				
		$query=$this->db->get();
		$result= $query->row_array();
		if($result['product_qty']){
			return $result['product_qty'];
		}else{
			return 0;
		}
	}

	public function get_shop_product_list($cat_id='',$sub_cat_id='',$sub_cat_2_id='',$keyword=''){
		$this->db->select('p.*');
		$this->db->select('pc.cat_name');
		$this->db->select('psc.sub_cat_name');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
        $this->db->from('product p');
		$this->db->join("product_category pc",'pc.cat_id = p.cat_id','left');
		$this->db->join("product_sub_category psc",'psc.sub_cat_id = p.sub_cat_id','left');
		$this->db->join('color c','c.color_id = p.color_id','left');
		$this->db->join('mstr_brand b','b.brand_id = p.brand_id','left');
		$this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
		$this->db->where("p.product_status",1);
		$this->db->where("pc.cat_status",1);
		 if($cat_id){
			$this->db->where('p.cat_id' , $cat_id); 
		 }
		 if($sub_cat_id){
			$this->db->where('p.sub_cat_id' , $sub_cat_id); 
		 }
		 if($sub_cat_2_id){
			$this->db->where('p.sub_cat_2_id' , $sub_cat_2_id); 
         }
         if($keyword){
			$this->db->like('p.product_name', $keyword);
         }
        $query = $this->db->get();
        return $query->result_array();       
    }
	//----------------------------------------------------------------------------- moblie part

	function getTopDeals($dis_level){
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->select('pc.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('daily_deals_product a');	
		$this->db->join('product p','p.product_id=a.product_id','left');
		$this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
		$this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
		$this->db->join('color c','p.color_id=c.color_id','left');
		$this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
		$this->db->where("p.product_status",1);
		$this->db->where("pc.cat_status",1);
		$this->db->where("a.approval_status",1);
		$this->db->where("a.is_remove",0);
		$this->db->where("a.category_top",1);
		$this->db->where("a.discount_level",$dis_level);		
		$this->db->order_by('a.daily_deal_id','desc');
		$this->db->limit(1);
		$query=$this->db->get();
		return $query->result_array();
	}

	function getTopDealsAll($dis_level){
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->select('pc.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('daily_deals_product a');	
		$this->db->join('product p','p.product_id=a.product_id','left');
		$this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
		$this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
		$this->db->join('color c','p.color_id=c.color_id','left');
		$this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
		$this->db->where("p.product_status",1);
		$this->db->where("pc.cat_status",1);
		$this->db->where("a.approval_status",1);
		$this->db->where("a.is_remove",0);
		$this->db->where("a.category_top",1);
		$this->db->where("a.discount_level",$dis_level);		
		$this->db->order_by('a.daily_deal_id','desc');
		//$this->db->limit(1);
		$query=$this->db->get();
		return $query->result_array();
	}

	public function flash_deal_multi_product($data)
	{
		$product_list=array();
        foreach($data as $na){
			$di_de_dis		=0;
			$di_de_dis_id	=0;
			$sp_of_dis		=0;
			$sp_of_dis_id	=0;
			$discount_value	=0;
			$discount_id	=0;
			$discount_type	=0;
			$di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);				
			$availble_qty=$this->get_available_qty($na['product_id']);
			$sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
			if(isset($di_de_dis_data['discount_value'])){$di_de_dis=$di_de_dis_data['discount_value'];$di_de_dis_id=$di_de_dis_data['daily_deal_id'];}
			if(isset($sp_of_dis_data['discount_value'])){$sp_of_dis=$sp_of_dis_data['discount_value'];$sp_of_dis_id=$sp_of_dis_data['sp_dis_id'];}
			if($di_de_dis>$sp_of_dis){$discount_value=$di_de_dis;$discount_id=$di_de_dis_id;$discount_type=1;}
			if($sp_of_dis>=$di_de_dis){$discount_value=$sp_of_dis;$discount_id=$sp_of_dis_id;$discount_type=2;}

			$discount_price=($na['product_price']/100)*$discount_value;
			$product_price=$na['product_price']-$discount_price;

            $nested_data=array(
                'product_name'=>$na['product_name'],
                'product_code'=>$na['product_code'],
                'product_thumb'=>$na['product_thumb'],
				'product_image'=>$na['product_image'],
				'cat_name'=>$na['cat_name'],
                'product_price'=>number_format($product_price, 2, '.', ''),
                'product_cost'=>$na['product_cost'],
                //'product_details'=>$na['product_details'],
                //'product_specification'=>$na['product_specification'],
                'product_id'=>$na['product_id'],
				'discount_value'=>number_format($discount_price, 2, '.', ''),
				'original_price'=>$na['product_price'],
				'accessories'=>$na['accessories'],
				'brand_name'=>$na['brand_name'],
				'model_number'=>$na['model_number'],
				'color'=>$na['color'],	
				'sh_cat_value'=>$na['sh_cat_value'],
				'product_discount_id'=>$discount_id,	
				'product_discount'=>$discount_value."%",
				'availble_qty'=>$availble_qty,
				'thumb_path'=>base_url()."admin/uploads/product/image/thumbs/",
				'image_path'=>base_url()."admin/uploads/product/image/",
				'waranty_conditions'=>$na['waranty_conditions'],
				'stock_availability'=>$na['stock_availability'],
				'sold_qty'=>$na['sold_qty'],
				'return_policy'=>$na['return_policy'],
				
            );
            $product_list[]=$nested_data;
		}		
		return  $product_list;
	}	

	public function getFlashDealCategories()
	{
		$this->db->select('pc.cat_name,pc.cat_image_thumb,pc.cat_image,pc.cat_id,pc.image_path,pc.thumb_path');
		$this->db->from('specical_offer_product sop');		
		$this->db->join("product p",'p.product_id = sop.product_id','inner');
		$this->db->join("product_category pc",'p.cat_id = pc.cat_id','inner');		
		$this->db->where("pc.cat_status",1);
		$this->db->where("sop.is_remove",0);
		$this->db->where("sop.approval_status",1);	
		$this->db->order_by('pc.cat_priority','asc');	
		$this->db->group_by('pc.cat_id');		
		$query=$this->db->get();
		$result= $query->result_array();
		if($result){
			return $result;
		}else{
			return false;
		}
	}

	public function getFlashDealCategoriesItems($cat_id)
	{
		$this->db->select('p.*,sop.discount_presentage,sop.discount_value,sop.category_top');
		$this->db->from('specical_offer_product sop');		
		$this->db->join("product p",'p.product_id = sop.product_id','inner');
		$this->db->join("product_category pc",'p.cat_id = pc.cat_id','inner');		
		$this->db->where("pc.cat_status",1);
		$this->db->where("sop.is_remove",0);
		$this->db->where("sop.approval_status",1);	
		$this->db->where("p.cat_id",$cat_id);			
		$query=$this->db->get();
		$result= $query->result_array();
		return $result;			
		
	}
    
   


}

