<?php defined('BASEPATH') or exit('No direct script access allowed');

class Myorder_Model extends CI_Model

{

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->table = 'sale';
		date_default_timezone_set("asia/Colombo");
	}

	public function get_top_product($data)
	{
		return $this->db->get_where('product', $data, 8)->result('array');
	}

	public function get_sale_list_by_service_id($service_id)
	{
		$this->db->select('sales.*');
		$this->db->from('sales');
		//$this->db->join('product', 'sale_items.product_id = product.product_id', 'left');
		//	$this->db->join('sales', 'sale_items.sale_id = sales.sale_id', 'left');
		$this->db->order_by("sales.sale_id", "asc");
		$this->db->where("sales.service_id", $service_id); //("id !=",$id);
		$query = $this->db->get();
		//	echo $this->db->last_query();
		return $query->result_array();
	}

//dakshina 10/10/2023
	public function insert_customer($data) {
      

        $this->db->insert('customer', $data);

        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
	
	public function count_customers() {
		$query = $this->db->get('customer');
		return $query->num_rows();
	}





	  public function contact_customer($data) {
        $this->db->insert('customer_inquiry', $data);
        return $this->db->affected_rows() > 0;
    }


//Dakshina 11/07/2023


		// public function get_order_list() {
		// 	$query = $this->db->get('order_customer'); 
	
		// 	if($query->num_rows() > 0) {
		// 		return $query->result_array();
		// 	} else {
		// 		return array(); 
		// 	}
		// }



		public function get_order_list($customer_id)
{
    $this->db->select('oc.*,dt.delivery_type,mos.status_name');  
    $this->db->from('order_customer oc');
	$this->db->join('master_delivery_type dt','oc.delivery_type = dt.delivery_type_id' ,'left');
	$this->db->join('mstr_order_status mos','oc.order_status = mos.status_id' ,'left');
	$this->db->where("customer_id",$customer_id);

    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}
	
//end Dakshina 11/07/2023
    
	public function get_return_sale_info_sale_id($id)
	{
		$this->db->select('*');
		$this->db->from('sales_return');
		$this->db->where("sale_id", $id);
		$this->db->order_by("sale_id", "desc");
		$query = $this->db->get();
		return $query->result();
	}

	//get home page catogory list by given priority
	public function get_category_for_homepage()
	{
		$this->db->select('pc.*');
		$this->db->from('product_category pc');
		$this->db->where("pc.cat_status", 1);
		$this->db->order_by('pc.cat_priority', 'desc');
		//$this->db->limit(11, 0);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_category_for_specical_offer()
	{
		$date = date("Y-m-d H:i:s");
		$this->db->select('pc.*');
		$this->db->from('specical_offer_product sp');;
		$this->db->join('product p', 'sp.product_id=p.product_id', 'inner');
		$this->db->join('product_category pc', 'pc.cat_id=p.cat_id', 'inner');
		$this->db->where("pc.cat_status", 1);
		$this->db->where("sp.is_remove", 0);
		$this->db->where("sp.approval_status", 1);
		$this->db->where("sp.start_date_time <=", $date);
		$this->db->where("sp.end_date_time >", $date);
		$this->db->order_by('pc.cat_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_sub_category_for_homepage()
	{
		$this->db->select('psc.*');
		$this->db->from('product_sub_category psc');
		$this->db->where("psc.sub_cat_status", 1);
		$this->db->order_by('psc.sub_cat_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_sub_category_child_for_homepage()
	{
		$this->db->select('pscc.*');
		$this->db->from('product_sub_category_2 pscc');
		$this->db->where("pscc.sub_cat_2_status", 1);
		$this->db->order_by('pscc.sub_cat_2_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_top_category_for_homepage()
	{
		//$this->db->select('pc.*');
		//$this->db->select('pc.*');
		$this->db->select('pc.cat_id,pc.cat_name,pc.cat_image');
		$this->db->from('week_top_category wt');
		$this->db->join('product_category pc', 'wt.cat_id=pc.cat_id', 'left');
		$this->db->where("wt.status", 1);
		$this->db->where("wt.is_remove", 0);
		$this->db->order_by('wt.priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	//----------------------------------------------------------------------
	
		public function get_new_arraival_product_new_top()
	{
		$this->db->select('pc.*');
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->join('product_category pc', 'p.cat_id=pc.cat_id', 'left');
		$this->db->where_in('p.cat_id', array(3,4,16,34,83));
		$this->db->where("p.product_status", 1);
		$this->db->where("p.show_website", 1);
		$this->db->where("pc.cat_status", 1);
		$this->db->group_by('p.product_id');
		$this->db->order_by('p.product_id', 'desc');
		$this->db->limit(20);
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		if ($query->num_rows() > 0) {
			$data = array();
			foreach ($query->result_array() as $row) {
				$data[$row['cat_id']][] = $row;
			}
			return $data;
		} else {
			return false;
		}
	}

	public function get_new_arraival_product_new()
	{
		$this->db->select('pc.*');
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->join('product_category pc', 'p.cat_id=pc.cat_id', 'left');
		$this->db->where_in('p.cat_id', array(3,4,16,34,83));
		$this->db->where("p.product_status", 1);
		$this->db->where("p.show_website", 1);
		$this->db->where("pc.cat_status", 1);
		$this->db->group_by('p.product_id');
		$this->db->order_by('p.product_id', 'desc');
		//$this->db->limit(20);
		$query = $this->db->get();
		$i_3=0;
		$i_4=0;
		$i_16=0;
		$i_34=0;
		$i_83=0;
		//echo $this->db->last_query(); die();
		if ($query->num_rows() > 0) {
			$data = array();
			foreach ($query->result_array() as $row) {
			    
				//$data[$row['cat_id']][] = $row;
				
				switch($row['cat_id']){
				   case 3:
				       if($i_3 < 20){
				           $data[$row['cat_id']][] = $row;
				       }
				       $i_3++;
				       break;
				    case 4:
				        if($i_4 < 20){
				           $data[$row['cat_id']][] = $row;
				       }
				        $i_4++;
				        break;
				        
				    case 16:
				        if($i_16 < 20){
				           $data[$row['cat_id']][] = $row;
				       }
				        $i_16++;
				        break;
				        
				    case 34:
				        if($i_34 < 20){
				           $data[$row['cat_id']][] = $row;
				       }
				        $i_34++;
				        break;
				        
				    case 83:
				        if($i_83 < 20){
				           $data[$row['cat_id']][] = $row;
				       }
				        $i_83++;
				        break; 
				}
			}
			return $data;
		} else {
			return false;
		}
	}
	
	

	public function get_daily_deal_disount_new()
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.daily_deal_id,dp.product_id');
		$this->db->from('daily_deals_product dp');
		$this->db->where("dp.is_remove", 0);
		$this->db->where("dp.approval_status", 1);
		//$this->db->where("dp.product_id",$product_id);	
		$this->db->order_by('dp.daily_deal_id', 'desc');
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			$data = array();
			foreach ($query->result_array() as $row) {
				$data[$row['product_id']] = $row;
			}
			return $data;
		} else {
			return false;
		}
	}

	public function get_speciacl_offer_disount_new()
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.sp_dis_id,dp.product_id');
		$this->db->from('specical_offer_product dp');
		$this->db->where("dp.is_remove", 0);
		$this->db->where("dp.approval_status", 1);
		//$this->db->where("dp.product_id",$product_id);	
		$this->db->order_by('dp.sp_dis_id', 'desc');
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			$data = array();
			foreach ($query->result_array() as $row) {
				$data[$row['product_id']] = $row;
			}
			return $data;
		} else {
			return false;
		}
	}

	public function get_new_arrival_for_homepage_new()
	{
		//get new arrival product 
		$new_arraival = $this->get_new_arraival_product_new();

		$di_de_dis_datas = $this->get_daily_deal_disount_new();
		$sp_of_dis_datas = $this->get_speciacl_offer_disount_new();
		//echo '<pre>',print_r($new_arraival); die();
		$new_arrival_data = array();
		foreach ($new_arraival as $rows) {
			foreach ($rows as $na) {
				$di_de_dis		= 0;
				$di_de_dis_id	= 0;
				$sp_of_dis		= 0;
				$sp_of_dis_id	= 0;
				$discount_value	= 0;
				$discount_id	= 0;
				$discount_type	= 0;
				//$di_de_dis_data=$this->get_daily_deal_disount($na['product_id']);
				//$sp_of_dis_data=$this->get_speciacl_offer_disount($na['product_id']);
				//echo '<pre>', print_r($na);die();
				$di_de_dis_data = (isset($di_de_dis_datas[$na['product_id']])) ? $di_de_dis_datas[$na['product_id']] : array();
				$sp_of_dis_data = (isset($sp_of_dis_datas[$na['product_id']])) ? $sp_of_dis_datas[$na['product_id']] : array();
				if (isset($di_de_dis_data['discount_value'])) {
					$di_de_dis = $di_de_dis_data['discount_value'];
					$di_de_dis_id = $di_de_dis_data['daily_deal_id'];
				}
				if (isset($sp_of_dis_data['discount_value'])) {
					$sp_of_dis = $sp_of_dis_data['discount_value'];
					$sp_of_dis_id = $sp_of_dis_data['sp_dis_id'];
				}
				if ($di_de_dis > $sp_of_dis) {
					$discount_value = $di_de_dis;
					$discount_id = $di_de_dis_id;
					$discount_type = 1;
				}
				if ($sp_of_dis >= $di_de_dis) {
					$discount_value = $sp_of_dis;
					$discount_id = $sp_of_dis_id;
					$discount_type = 2;
				}

				$discount_price = ($na['product_price'] / 100) * $discount_value;
				$product_price = $na['product_price'] - $discount_price;

				$nested_data = array(
					'product_name' => $na['product_name'],
					'product_code' => $na['product_code'],
					'product_thumb' => $na['product_thumb'],
					'product_image' => $na['product_image'],
					'product_price' => $product_price,
					'product_cost' => $na['product_cost'],
					'product_details' => $na['product_details'],
					'product_specification' => $na['product_specification'],
					'product_id' => $na['product_id'],
					'discount_value' => $discount_price,
					'original_price' => $na['product_price']
				);
				$new_arrival_data[$na['cat_id']][] = $nested_data;
			}
		}
		return  $new_arrival_data;
	}

	public function get_new_arrival_for_homepage($cat_id = '')
	{
		//get new arrival product 
		$new_arraival = $this->get_new_arraival_product($cat_id);
		//echo '<pre>', print_r($new_arraival);
		//die();

		$new_arrival_data = array();
		foreach ($new_arraival as $na) {
			$di_de_dis		= 0;
			$di_de_dis_id	= 0;
			$sp_of_dis		= 0;
			$sp_of_dis_id	= 0;
			$discount_value	= 0;
			$discount_id	= 0;
			$discount_type	= 0;
			$di_de_dis_data = $this->get_daily_deal_disount($na['product_id']);
			$sp_of_dis_data = $this->get_speciacl_offer_disount($na['product_id']);
			if (isset($di_de_dis_data['discount_value'])) {
				$di_de_dis = $di_de_dis_data['discount_value'];
				$di_de_dis_id = $di_de_dis_data['daily_deal_id'];
			}
			if (isset($sp_of_dis_data['discount_value'])) {
				$sp_of_dis = $sp_of_dis_data['discount_value'];
				$sp_of_dis_id = $sp_of_dis_data['sp_dis_id'];
			}
			if ($di_de_dis > $sp_of_dis) {
				$discount_value = $di_de_dis;
				$discount_id = $di_de_dis_id;
				$discount_type = 1;
			}
			if ($sp_of_dis >= $di_de_dis) {
				$discount_value = $sp_of_dis;
				$discount_id = $sp_of_dis_id;
				$discount_type = 2;
			}

			$discount_price = ($na['product_price'] / 100) * $discount_value;
			$product_price = $na['product_price'] - $discount_price;

			$nested_data = array(
				'product_name' => $na['product_name'],
				'product_code' => $na['product_code'],
				'product_thumb' => $na['product_thumb'],
				'product_image' => $na['product_image'],
				'product_price' => $product_price,
				'product_cost' => $na['product_cost'],
				'product_details' => $na['product_details'],
				'product_specification' => $na['product_specification'],
				'product_id' => $na['product_id'],
				'discount_value' => $discount_price,
				'original_price' => $na['product_price']
			);
			$new_arrival_data[] = $nested_data;
		}
		return  $new_arrival_data;
	}

	public function get_new_arraival_product($cat_id = '')
	{
		$this->db->select('pc.*');
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->join('product_category pc', 'p.cat_id=pc.cat_id', 'left');
		$this->db->where("p.product_status", 1);
		$this->db->where("p.show_website", 1);
		$this->db->where("pc.cat_status", 1);
		if ($cat_id) {
			$this->db->where("p.cat_id", $cat_id);
		}
		$this->db->group_by('p.product_id');
		$this->db->order_by('p.product_id', 'desc');
		$this->db->limit(20);
		$query = $this->db->get();
		return $query->result_array();
	}


	public function get_job_info_by_id($service_reference_no)
	{
		$this->db->select('s.*,c.cus_name');
		$this->db->from('service s');
		//$this->db->where("dp.is_remove",0);
		//$this->db->where("dp.approval_status",1);	
		$this->db->join('customer c', 's.service_customer_id=c.cus_id', 'left');
		$this->db->where("s.service_reference_no", $service_reference_no);
		//$this->db->order_by('dp.daily_deal_id','desc');		
		$query = $this->db->get();
		return $query->row_array();
	}


	//----------------------------------------------------------------------------
	//get product daily deal disount 
	public function get_daily_deal_disount($product_id)
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.daily_deal_id');
		$this->db->from('daily_deals_product dp');
		$this->db->where("dp.is_remove", 0);
		$this->db->where("dp.approval_status", 1);
		$this->db->where("dp.product_id", $product_id);
		$this->db->order_by('dp.daily_deal_id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	//get product special offer  disount 
	public function get_speciacl_offer_disount($product_id)
	{
		$this->db->select('dp.discount_value,dp.discount_presentage,dp.sp_dis_id');
		$this->db->from('specical_offer_product dp');
		$this->db->where("dp.is_remove", 0);
		$this->db->where("dp.approval_status", 1);
		$this->db->where("dp.product_id", $product_id);
		$this->db->order_by('dp.sp_dis_id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	//-----------------------------------------------------------------------------
	function get_advertisments()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		//$this->db->where("a.add_type",1);		
		$this->db->order_by('a.add_type', 'asc');
		$this->db->order_by('a.adv_id', 'desc');

		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			$data = array();
			foreach ($query->result_array() as $row) {
				$data[$row['add_type']][] = $row;
			}
			return $data;
		} else {
			return false;
		}
		//return $query->result_array();
	}



	function get_top_advertisment_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 1);
		$this->db->order_by('a.adv_id', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_top_left_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 2);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_top_right_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 3);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_middele_left_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 4);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}
	function get_middele_center_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 5);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_middele_center_banner_2()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 5);
		$this->db->order_by('a.adv_id', 'desc');
		//$this->db->limit(1);
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_middele_right_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 6);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}
	function get_footer_banner()
	{
		$this->db->select('a.*');
		$this->db->from('top_advertisement_banner a');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.add_type", 7);
		$this->db->order_by('a.adv_id', 'desc');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row_array();
	}
	/*function get_top_daily_deals($dis_level){
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->from('daily_deals_top_product a');	
		$this->db->join('product p','p.product_id=a.product_id','left');
		$this->db->where("a.approval_status",1);
		$this->db->where("a.is_remove",0);	
		$this->db->where("a.discount_level",$dis_level);	
		$query=$this->db->get();
		return $query->row_array();
	}*/

	function get_top_daily_deals($dis_level)
	{
		$date = date("Y-m-d H:i:s");
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->from('daily_deals_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.category_top", 1);
		$this->db->where("a.start_date_time <=", $date);
		$this->db->where("a.end_date_time >", $date);
		$this->db->where("a.discount_level", $dis_level);
		$this->db->order_by('a.daily_deal_id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_daily_deals($dis_level)
	{
		$date = date("Y-m-d H:i:s");
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->from('daily_deals_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		//$this->db->where("a.approval_status",1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.start_date_time <=", $date);
		$this->db->where("a.end_date_time >", $date);
		$this->db->where("a.discount_level", $dis_level);
		$this->db->where("a.category_top", 0);
		$this->db->order_by('a.daily_deal_id', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}


	function get_specical_offer()
	{
		$date = date("Y-m-d H:i:s");
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->from('specical_offer_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.category_top", 0);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.start_date_time <=", $date);
		$this->db->where("a.end_date_time >", $date);
		$this->db->order_by('a.sp_dis_id', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_specical_offer_top_list()
	{
		$date = date("Y-m-d H:i:s");
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->from('specical_offer_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		//$this->db->where("a.category_top",1);
		$this->db->where("a.start_date_time <=", $date);
		$this->db->where("a.end_date_time >", $date);
		$this->db->order_by('a.sp_dis_id', 'desc');
		$this->db->limit(9);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_specical_offer_top_list_mobile()
	{
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->select('pc.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('specical_offer_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		$this->db->join('product_category pc', 'pc.cat_id=p.cat_id', 'left');
		$this->db->join('mstr_brand b', 'p.brand_id=b.brand_id', 'left');
		$this->db->join('color c', 'p.color_id=c.color_id', 'left');
		$this->db->join('shipping_cost_category sh', 'p.shipping_cost_category=sh.shc_cat_id', 'left');
		$this->db->where("p.product_status", 1);
		$this->db->where("pc.cat_status", 1);
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.category_top", 1);
		$this->db->order_by('a.sp_dis_id', 'desc');
		$this->db->limit(3);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_city_list()
	{
		$this->db->select('a.*');
		$this->db->select('po.province_name');
		$this->db->select('p.district_name');
		$this->db->select('di.distance_value,di.distance_name');
		$this->db->from('mstr_city a');
		$this->db->join('master_district p', 'p.district_id=a.district_id', 'left');
		$this->db->join('master_province po', 'po.province_id=p.province_id', 'left');
		$this->db->join('distance_category di', 'di.distance_id=a.distance_id', 'left');

		$this->db->where("a.status", 1);
		$this->db->order_by('a.cname', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_specical_image_list()
	{
		$this->db->select('p.*');
		$this->db->from('product_images p');
		$this->db->join('specical_offer_product a', 'p.product_id=a.product_id', 'inner');
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		$this->db->where("a.category_top", 1);
		//$this->db->order_by('a.sp_dis_id','desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_sub_category_by_category_id($id = '')
	{
		$this->db->select('psc.*');
		$this->db->from('product_sub_category psc');
		$this->db->where("psc.sub_cat_status", 1);
		if ($id) {
			$this->db->where("psc.cat_id", $id);
		}
		$this->db->order_by('psc.sub_cat_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_specical_offer_sub_list_mobile($id = '')
	{
		$this->db->select('a.*');
		$this->db->select('p.*');
		$this->db->select('pc.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('specical_offer_product a');
		$this->db->join('product p', 'p.product_id=a.product_id', 'left');
		$this->db->join('product_category pc', 'p.cat_id=pc.cat_id', 'left');
		$this->db->join('mstr_brand b', 'p.brand_id=b.brand_id', 'left');
		$this->db->join('color c', 'p.color_id=c.color_id', 'left');
		$this->db->join('shipping_cost_category sh', 'p.shipping_cost_category=sh.shc_cat_id', 'left');
		$this->db->where("p.product_status", 1);
		if ($id) {
			$this->db->where("p.cat_id", $id);
		}
		$this->db->where("pc.cat_status", 1);
		$this->db->where("a.approval_status", 1);
		$this->db->where("a.is_remove", 0);
		//$this->db->where("a.category_top",0);
		$this->db->order_by('a.sp_dis_id', 'desc');
		if ($id == "") {
			$this->db->limit(3);
		}

		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_sub_category_by_category_id_for_ad_search($id = '')
	{
		$this->db->select('psc.*');
		$this->db->from('product_sub_category psc');
		$this->db->where("psc.sub_cat_status", 1);
		if ($id) {
			$this->db->where("psc.cat_id", $id);
		} else {
			$this->db->where("psc.cat_id", 0);
		}
		$this->db->order_by('psc.sub_cat_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_sub_category2_by_category_id_for_ad_search($id = '')
	{
		$this->db->select('psc.sub_cat_2_name,psc.sub_cat_2_id');
		$this->db->from('product_sub_category_2 psc');
		$this->db->where("psc.sub_cat_2_status", 1);
		if ($id) {
			$this->db->where("psc.sub_cat_id", $id);
		} else {
			$this->db->where("psc.sub_cat_id", 0);
		}
		$this->db->order_by('psc.sub_cat_2_priority', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}
}
