<?php $this->load->view("common/header"); ?>
<!-- end: HEAD -->

<!-- start: CSS REQUIRED FOR THIS PAGE ONLY -->
<?php /*?><link rel="stylesheet" type="text/css" href="<?php echo asset_url(); ?>plugins/select2/select2.css" />
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/DataTables/media/css/DT_bootstrap.css" />
		<link href="<?php echo asset_url(); ?>plugins/bootstrap-modal/css/bootstrap-modal-bs3patch.css" rel="stylesheet" type="text/css"/>
		<link href="<?php echo asset_url(); ?>plugins/bootstrap-modal/css/bootstrap-modal.css" rel="stylesheet" type="text/css"/>
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/bootstrap-fileupload/bootstrap-fileupload.min.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/datepicker/css/datepicker.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/bootstrap-daterangepicker/daterangepicker-bs3.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/jQuery-Tags-Input/jquery.tagsinput.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/bootstrap-fileupload/bootstrap-fileupload.min.css">
		<link rel="stylesheet" href="<?php echo asset_url(); ?>plugins/summernote/build/summernote.css"><?php */?>
<style type="text/css">
.table > thead:first-child > tr:first-child > th, .table > thead:first-child > tr:first-child > td, .table-striped thead tr.primary:nth-child(2n+1) th {
	background-color: #428bca;
	border-color: #357ebd;
	border-top: 1px solid #357ebd;
	color: white;
	text-align: center;
}
</style>
<!-- end: CSS REQUIRED FOR THIS PAGE ONLY -->
<!-- end: HEAD -->
<!-- start: BODY -->
<body>
<!-- start: HEADER -->
<div class="navbar navbar-inverse navbar-fixed-top"> 
  <!-- start: TOP NAVIGATION CONTAINER -->
  <div class="container">
    <div class="navbar-header"> 
      <!-- start: RESPONSIVE MENU TOGGLER -->
      <button data-target=".navbar-collapse" data-toggle="collapse" class="navbar-toggle" type="button"> <span class="clip-list-2"></span> </button>
      <!-- end: RESPONSIVE MENU TOGGLER --> 
      <!-- start: LOGO -->
      <?php $this->load->view("common/logo"); ?>
      <!-- end: LOGO --> 
    </div>
    <div class="navbar-tools"> 
      <!-- start: TOP NAVIGATION MENU -->
      <?php $this->load->view("common/notifications.php"); ?>
      <!-- end: TOP NAVIGATION MENU --> 
    </div>
  </div>
  <!-- end: TOP NAVIGATION CONTAINER --> 
</div>
<!-- end: HEADER --> 
<!-- start: MAIN CONTAINER -->
<div class="main-container">
  <div class="navbar-content"> 
    <!-- start: SIDEBAR -->
    <?php $this->load->view("common/navigation"); ?>
    <!-- end: SIDEBAR --> 
  </div>
  <!-- start: PAGE -->
  <div class="main-content"> 
    <!-- end: SPANEL CONFIGURATION MODAL FORM -->
    <div class="container"> 
      <!-- start: PAGE HEADER -->
      <div class="row">
        <div class="col-sm-12"> 
          <!-- start: PAGE TITLE & BREADCRUMB -->
          <ol class="breadcrumb">
            <li> <a href="<?php echo base_url('dashboard'); ?>"> Dashboard </a> </li>
            <li> <a href="#"> Reports </a> </li>
            <li class="active"> Sales Report </li>
            <li class="search-box">
              <form class="sidebar-search">
                <div class="form-group">
                  <input type="text" placeholder="Start Searching...">
                  <button class="submit"> <i class="fa fa-search"></i> </button>
                </div>
              </form>
            </li>
          </ol>
        </div>
      </div>
      <div id="print-section">
        <div class="page-header">
          <h1>Daily Sales Report</h1>
        </div>
        <p>Please use the table below to navigate or filter the results. </p>
        
        <!-- end: PAGE HEADER --> 
        <!-- start: PAGE CONTENT 
                    <!-- start grid -->
        <div class="row">
          <div class="col-md-12"> 
            <!-- start: DYNAMIC TABLE PANEL -->
            <div class="panel panel-default">
              <div class="panel-heading"> <i class="fa fa-external-link-square"></i> Sales Report
                <div class="panel-tools" style="top:2px;">
                  <button onClick="printDiv('printableArea')" class="btn btn-blue dropdown-toggle" data-toggle="dropdown"> <i class="fa fa-print"></i> </button>
                </div>
              </div>
            </div>
            <div class="panel-body">
              <div id="error"></div>
              <div class="col-md-12">
                <div class="panel panel-default">
                  <div style="font-weight: 700;" class="panel-heading"></div>
                  <div class="panel-body">
                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Warehouse </label>
                        <select id="srh_warehouse_id" class="form-control" name="srh_warehouse_id">
                          <!-- <option value="">-- Select Warehouse --</option>-->
                          <?php 
																 $ss_warehouse_id=$this->session->userdata('ss_warehouse_id'); 
                                                              foreach ($warehouse_list as $row)
                                                              {
																  $sel='';
																  if($ss_warehouse_id==$row->id)
																  {
																	  $sel=' selected="selected"';
																  }
                                                              ?>
                          <option value="<?php echo $row->id; ?>" <?php echo $sel; ?>> <?php echo $row->name; ?> </option>
                          <?php }?>
                        </select>
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>From Date </label>
                        <input id="srh_from_date" name="srh_from_date" type='text' class="form-control date" value="" data-bv-field="date"/>
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <div class="form-group">
                        <label for="s2id_autogen1">To Date </label>
                        <input id="srh_to_date" name="srh_to_date" type='text' class="form-control date" value="" data-bv-field="date"/>
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <div class="form-group">
                        <label for="dine_type">Order Type </label>
                        <select class="form-control" id="dine_type">
                            <option value="">-all-</option>
                            <option value="1">dine in</option>
                            <option value="2">take away</option>
                            <option value="3">delivery</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-sm-4 pull-right">
                      <div class="form-group">
                        <label for="s2id_autogen1">&nbsp;<br>
                          <br>
                        </label>
                        <input type="submit" name="add_category" value="Search" class="btn btn-primary" onClick="searchDetails()">
                        &nbsp;&nbsp;
                        <input type="submit" name="add_category" value="Reset" class="btn btn-danger" onClick="searchDetailsReset()">
                      </div>
                    </div>
                  </div>
                </div>
                <div id="printableArea"><tr>
                        <td></td>
                        <td id="f-date-td" class="text-right">From Date: <span id="f-date-txt"></span>, To Date: <span id="t-date-txt"></span></td>
                      </tr>
                  <table class="table table-bordered table-condensed table-hover table-striped dataTable" id="summary_table">
                    <thead>
                    <th>Description</th>
                      <th>Values</th>
                      </thead>
                    <tbody>
                      
                      <tr>
                        <th>Sales</th>
                        <td><div id="sale-tbl"></div></td>
                      </tr>
                      <!--<tr>-->
                      <!--  <th>Sales Return</th>-->
                      <!--  <td><div id="sales-rtn-val-tbl"></div></td>-->
                      <!--</tr>-->
                      <tr>
                        <th>Cancelled Sales</th>
                        <td><div id="sales-rtn-val-tbl"></div></td>
                      </tr>
                      <tr>
                        <th style="background-color:#C93">Net Sales</th>
                        <td style="background-color:#C93"><div id="net-sales"></div></td>
                      </tr>
                      <tr>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                      </tr>
                      <tr>
                        <th width="50%">Cost of Sales</th>
                        <td width="50%"><div id="cost-tbl"></div></td>
                      </tr>
                      <tr class="collapse">
                        <th>Cost of Sales Return</th>
                        <td><div id="sales-rtn-cost-tbl"></div></td>
                      </tr>
                      <tr class="collapse">
                        <th style="background-color:#C93">Net Cost of Sales Return</th>
                        <td style="background-color:#C93"><div id="net-cost-of-sales-return"></div></td>
                      </tr>
                      
                      <tr>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                      </tr>
                      
                      <tr>
                        <th style="background-color:#093">Net Margin</th>
                        <td style="background-color:#093"><div id="profit-tbl"></div></td>
                      </tr>
                      <tr>
                        <th>Percentage (%)</th>
                        <td><div id="percentage-tbl"></div></td>
                      </tr>
                    </tbody>
                    <tfoot>
                    </tfoot>
                  </table>
                </div>
                <br>
                <br>
                <br>
                <div class="panel-heading"> <i class="fa fa-external-link-square"></i> Sales List </div>
                <br>
                <table class="table table-bordered table-condensed table-hover table-striped dataTable" id="warehouse_table">
                  <thead>
                    <tr>
                      <th>Date</th>
                      <th>Invoice No</th>
                      <th>Customer</th>
                      <th>Invoice Type</th>
                      <th>Cost</th>
                      <th>Grand Total</th>
                      <th>Profit or Loss</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>Date</th>
                      <th>Invoice No</th>
                      <th>Customer</th>
                      <th>Invoice Type</th>
                      <th>Cost</th>
                      <th>Grand Total</th>
                      <th>Profit or Loss</th>
                    </tr>
                  </tfoot>
                </table>
                <br>
                <div class="panel-heading"> <i class="fa fa-external-link-square"></i> Cancelled Sales </div>
                <br>
                <table class="table table-bordered table-condensed table-hover table-striped dataTable" id="sales_return_table">
                  <thead>
                    <tr>
                      <th>Date</th>
                      <th>Invoice No</th>
                      <th>Customer</th>
                      <th>Invoice Type</th>
                      <th>Cost</th>
                      <th>Grand Total</th>
                      <th>Profit or Loss</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>Date</th>
                      <th>Invoice No</th>
                      <th>Customer</th>
                      <th>Invoice Type</th>
                      <th>Cost</th>
                      <th>Grand Total</th>
                      <th>Profit or Loss</th>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>
            <!-- end: DYNAMIC TABLE PANEL --> 
          </div>
        </div>
        
        <!-- end grid --> 
        
      </div>
      <!-- end: PAGE --> 
    </div>
  </div>
  <!-- end: MAIN CONTAINER --> 
  <!-- start: FOOTER -->
  <div class="footer clearfix">
    <div class="footer-inner"> 2018 &copy; smartsalleepos.com </div>
    <div class="footer-items"> <span class="go-top"><i class="clip-chevron-up"></i></span> </div>
  </div>
</div>
<!-- end: FOOTER --> 
<!-- start: RIGHT SIDEBAR --> 
<!-- end: RIGHT SIDEBAR -->
<div id="event-management" class="modal fade" tabindex="-1" data-width="760" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"> &times; </button>
        <h4 class="modal-title">Event Management</h4>
      </div>
      <div class="modal-body"></div>
      <div class="modal-footer">
        <button type="button" data-dismiss="modal" class="btn btn-light-grey"> Close </button>
        <button type="button" class="btn btn-danger remove-event no-display"> <i class='fa fa-trash-o'></i> Delete Event </button>
        <button type='submit' class='btn btn-success save-event'> <i class='fa fa-check'></i> Save </button>
      </div>
    </div>
  </div>
</div>
<input name="sales-rtn-val-cost" type="hidden" id="sales-rtn-cost-fld" value="0">
<input name="sales-rtn-val-fld" type="hidden" id="sales-rtn-val-fld" value="0">
<input name="sale-fld" type="hidden" id="sale-fld" value="0">
<input name="cost-fld" type="hidden" id="cost-fld" value="0">

<!-- start ajax model -->
<div id="ajax-modal" class="modal fade" data-backdrop="static" data-keyboard="false" tabindex="-1" style="display: none;"></div>
<!-- end ajax model --> 

<!-- start: MAIN JAVASCRIPTS -->
<?php $this->load->view("common/footer"); ?>
<script src="<?php echo asset_url(); ?>js/jquery-ui.js" ></script> 
<script src="<?php echo asset_url(); ?>js/moment-with-locales.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/bootstrap-datetimepicker.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/bootstrap-datepicker.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/bootbox.min.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/accounting.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/accounting.min.js"></script> 
<!-- <script src="<?php echo asset_url(); ?>js/main.js"></script>--> 
<!-- end: MAIN JAVASCRIPTS --> 
<script>
function printDiv(divName) {
    var printContents = document.getElementById(divName).innerHTML;
    var originalContents = document.body.innerHTML;
    document.body.innerHTML = printContents;
    window.print();
    document.body.innerHTML = originalContents;
}

function searchDetailsReset() {
    $('#srh_to_date').val('');
    $('#srh_from_date').val('');
}

function searchDetails() {
    loadGrid();
    loadGridSalesReturn();
}
jQuery(document).ready(function() {
    //var currentDate = new Date();
    var tomorrow = new Date();
    currentDate = tomorrow.setDate(tomorrow.getDate() + 1);
    $('#srh_to_date').datetimepicker({
        defaultDate: currentDate,
        format: "YYYY/MM/DD"
    });
    $('#srh_from_date').datetimepicker({
        defaultDate: new Date(),
        format: "YYYY/MM/DD"
    });
    //TableData.init();
    /*loadGrid();
    loadGridSalesReturn();
    loadsummary();*/
});
var test1 = 1;

function loadGridSalesReturn() {
    test1 = 2;
    var srh_from_date = $('#srh_from_date').val();
    var srh_to_date = $('#srh_to_date').val();
    var srh_warehouse_id = $('#srh_warehouse_id').val();
    $('#sales_return_table').DataTable({
        "ajax": {
            'type': 'POST',
            'url': '<?php echo base_url('reports/get_list_cancelled_sales_for_print_daily');?>',
            'data': {
                srh_from_date: srh_from_date,
                srh_to_date: srh_to_date,
                srh_warehouse_id: srh_warehouse_id,
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10,
        "bDestroy": true,
        "iDisplayLength": 20,
        "order": [
            [1, "desc"]
        ],
        "fnFooterCallback": function(nRow, aaData, iStart, iEnd, aiDisplay) {
            var pq = 0,
                sq = 0,
                bq = 0,
                pa = 0,
                grand_tot = 0,
                tech_tot = 0,
                parts_tot = 0,
                ser_tot = 0;
            //alert(aaData.length);
            var ser_tot3 = 0;
            var ser_tot2 = 0;
            var ser_tot1 = 0;
            var ser_tot4 = 0;
            //var sales_rtn=0;
            for (var i = 0; i < aaData.length; i++) {
                //alert(aaData[[i]][5]);
                // p = (aaData[aiDisplay[i]][2]).split('__');
                ser_tot1 += parseFloat(aaData[[i]][4]);
                ser_tot2 += parseFloat(aaData[[i]][5]);
                ser_tot3 += parseFloat(aaData[[i]][6]);
            }
            var nCells = nRow.getElementsByTagName('th');
            nCells[4].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot1, "", 2, ",", ".") + ' </div>';
            nCells[5].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot2, "", 2, ",", ".") + ' </div>';
            nCells[6].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot3, "", 2, ",", ".") + ' </div>';
            var sales_rtn_tot_cost = ser_tot1;
            var sales_rtn_tot_val = ser_tot2;
            $('#sales-rtn-cost-fld').val(accounting.formatMoney(sales_rtn_tot_cost, "", 2, ",", "."));
            $('#sales-rtn-val-fld').val(accounting.formatMoney(sales_rtn_tot_val, "", 2, ",", "."));
            $('#sales-rtn-cost-tbl').text(accounting.formatMoney(sales_rtn_tot_cost, "", 2, ",", "."));
            $('#sales-rtn-val-tbl').text(accounting.formatMoney(sales_rtn_tot_val, "", 2, ",", "."));
        }
    });
}
var sumry_tbl = '';

function loadGrid() {
    var srh_from_date = $('#srh_from_date').val();
    var srh_to_date = $('#srh_to_date').val();
    var srh_warehouse_id = $('#srh_warehouse_id').val();
    $('#warehouse_table').DataTable({
        "ajax": {
            'type': 'POST',
            'url': '<?php echo base_url('reports/get_list_sales_for_print_daily');?>',
            'data': {
                srh_from_date: srh_from_date,
                srh_to_date: srh_to_date,
                srh_warehouse_id: srh_warehouse_id,
                dine_type: $('#dine_type').val()
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10,
        "bDestroy": true,
        "iDisplayLength": 20,
        "order": [
            [1, "desc"]
        ],
        "fnFooterCallback": function(nRow, aaData, iStart, iEnd, aiDisplay) {
            var pq = 0,
                sq = 0,
                bq = 0,
                pa = 0,
                grand_tot = 0,
                tech_tot = 0,
                parts_tot = 0,
                ser_tot = 0;
            //alert(aaData.length);
            var ser_tot3 = 0;
            var ser_tot2 = 0;
            var ser_tot1 = 0;
            var ser_tot4 = 0;
            //var sales_rtn=0;
            for (var i = 0; i < aaData.length; i++) {
                // p = (aaData[aiDisplay[i]][2]).split('__');
                ser_tot1 += parseFloat(aaData[[i]][4]);
                ser_tot2 += parseFloat(aaData[[i]][5]);
                ser_tot3 += parseFloat(aaData[[i]][6]);
            }
            //alert($('#sales_rtn_tot_cost').val());
            var sales_rtn_cost_fld = $('#sales-rtn-cost-fld').val();
            //alert(sales_rtn_cost_fld);
            var sales_rtn_val_fld = $('#sales-rtn-val-fld').val();
            var sales_rtn_profilt = sales_rtn_val_fld - sales_rtn_cost_fld;
            //alert(sales_rtn_profilt);
            var tot_profit = ser_tot3 - sales_rtn_profilt;
            var nCells = nRow.getElementsByTagName('th');
            nCells[4].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot1, "", 2, ",", ".") + ' </div>';
            nCells[5].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot2, "", 2, ",", ".") + ' </div>';
            nCells[6].innerHTML = '<div class="text-right">' + accounting.formatMoney(ser_tot3, "", 2, ",", ".") + ' </div>';
            $('#cost-tbl').text(accounting.formatMoney(ser_tot1, "", 2, ",", "."));
            $('#cost-fld').val(ser_tot1);
            $('#sale-tbl').text(accounting.formatMoney(ser_tot2, "", 2, ",", "."));
            $('#sale-fld').val(ser_tot2);
            $('#profit-tbl').text(accounting.formatMoney(tot_profit, "", 2, ",", "."));
            //$('#sales-rtn-tbl').text(accounting.formatMoney(sales_rtn, "", 2, ",", "."));
            var precentg = (tot_profit / (ser_tot2 - sales_rtn_val_fld)) * 100;
            $('#percentage-tbl').text(accounting.formatMoney(precentg, "", 2, ",", ".") + '%');
            $('#f-date-txt').text($('#srh_from_date').val());
            $('#t-date-txt').text($('#srh_to_date').val());
            //sumry_tbl.reload;
            loadsummary();
        }
    });
}

function loadsummary() {
    var sales = $('#sale-fld').val();
    var sales_return = 0;//$('#sales-rtn-val-fld').val();
    $('#net-sales').text(accounting.formatMoney(sales - sales_return, "", 2, ",", "."));
    var cost_of_sales = $('#cost-fld').val();
    var cost_of_sales_rtn = $('#sales-rtn-cost-fld').val();
    $('#net-cost-of-sales-return').text(accounting.formatMoney(cost_of_sales - cost_of_sales_rtn, "", 2, ",", "."));
    $('#summary_table').DataTable({
        dom: 'Bfrtip',
        searching: false,
        paginate: false,
        bInfo: false,
        bSort: false,
        bDestroy: true,
        /*bLengthChange: false,
    						bFilter: true,*/
        buttons: [{
                extend: 'print',
                text: '<i class="fa fa-print fa-2x">',
                //header: true,
                //footer: true,
                //autoPrint: false,
                title: "Baker's Choice Daily Sales Reports",
                message: 'From date: ' + $('#f-date-txt').text() + '- To Date:' + $('#t-date-txt').text(),
                customize: function(win) {
                    $(win.document.body)
                        .css('font-size', '12pt')
                        .prepend(
                            '<img src="<?php echo asset_url(); ?>images/logo.png" style="position:absolute; top:0; left:0; height:60px;" />'
                        );
                    $(win.document.body).find('table')
                        .addClass('compact')
                        .css('font-size', 'inherit');
                    //$(win.document.body).find( 'h1' ).prepend("<center>");
                    //$(win.document.body).find( 'h1' ).html("<center>Baker's Choice Daily Sales Reporst <br/></h1><h3 style='margin-top:-5px;'><?php echo $warehouse_details['address']; ?><br/><?php echo $warehouse_details['email']; ?><br/> <?php echo $warehouse_details['phone']; ?></h3></center>");
                    $(win.document.body).find('h1').append("<h3 style='margin-top:-5px;'><?php echo $warehouse_details['address']; ?><br/><?php echo $warehouse_details['email']; ?><br/> <?php echo $warehouse_details['phone']; ?></h3>").css("text-align", "center");
                }
            },
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel-o fa-2x">',
                message: 'From date: ' + $('#f-date-txt').text() + '- To Date:' + $('#t-date-txt').text(),
                footer: true
            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o fa-2x"></i>',
                orientation: 'landscape',
                footer: true,
                title: "Baker's Choice Daily Sales Report, \n <?php echo $warehouse_details['address']; ?> \n From date: " + $('#f-date-txt').text() + "- To Date:" + $('#t-date-txt').text(),
                //message:,
                customize: function(doc) {}
            }
        ]
    });
}

function fbs_click(url) {
    var srh_from_date = $('#srh_from_date').val();
    var srh_to_date = $('#srh_to_date').val();
    var srh_warehouse_id = $('#srh_warehouse_id').val();
    u = location.href;
    t = document.title;
    url = '<?php echo base_url();?>' + 'reports/print_sale?srh_warehouse_id=' + srh_warehouse_id + '&srh_from_date=' + srh_from_date + '&srh_to_date=' + srh_to_date;
    window.open(url, 'sharer', 'toolbar=0,status=0,width=750,height=436, left=10, top=10,scrollbars=yes');
    return false;
}
</script>
</body>
<!-- end: BODY -->
</html>