<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
   
class Product_Material_Core extends CI_Controller
{
    var $main_menu_name = "product_material";
    var $sub_menu_name = "product_material";
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('common_model');
        $this->load->model('Stock_Counter_Model');
    }
    public function index()
    {
       echo "Parant";
    }
    //basic common function start
    
     private function cleanAndValidateNumber($id){
        $this->load->helper("security");
        $recode_id = $this->security->xss_clean($id); 
       
        if($recode_id>=0&&$recode_id<999999){
            return $recode_id;
        }else{
            echo "invalid Number ";
            exit();
            return false;
        }
    }
    private function cleanAndValidateText($text){
        $this->load->helper("security");
        $text = $this->security->xss_clean($text); 
        $text= preg_replace('/[^A-Za-z0-9\-]/', '', $text);
        return substr($text, 0, 255);
    }
    private function cleanAndValidateArray($data){
        //$this->load->helper("security");
        //$data = $this->security->xss_clean($data); 
        return $data;
    }
     protected function getClientSideDataTableParameters()
    {
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $data=array();
        $data['start']=$this->cleanAndValidateNumber($start);
        $data['length']=$this->cleanAndValidateNumber($length);
        $data['search_key_val']=$this->cleanAndValidateText($search_key['value']);
        $data['custom_condition']=array();
        return $data;
    }
    //basic common function end
    protected function setBasicSelectOptionDataForMaterial($data)
    {
        $this->load->model('Unit_Model');
        $this->load->model('category_models');
        $this->load->model('Product_Type_Model');
        $data['main_category']  = $this->category_models->getCategory();
        $data['unit_type']      = $this->Unit_Model->getActiveUnitList();
        $data['product_type']    = $this->Product_Type_Model->getActiveProductMatarialTypeList();
        return $data;
    }
    protected function setMAterialBasicDataUsingMasterID($id,$data)
    {
        $this->load->model('Product_Material_Model');
        $recode_id=$this->cleanAndValidateNumber($id);
        $data['product_details'] =$this->Product_Material_Model->loadBasicProductMaterialMasterData($recode_id);
        return $data;
    }
    protected function getMaterialDataListForBasicDataTableOnServerSide($param_data)
    {
        $this->load->model('Product_Material_Model');
        $values         = $this->Product_Material_Model->loadGetProductMaterialListServerSide($param_data['start'], $param_data['length'], $param_data['search_key_val'],$param_data['custom_condition']);
        if ($param_data['search_key_val']) {
            $value_count  = $this->Product_Material_Model->loadGetProductMaterialListServerSide('', '', $param_data['search_key_val'],$param_data['custom_condition']);
        }else{
            $value_count    = $this->Product_Material_Model->loadGetProductMaterialListServerSide('', '', '',$param_data['custom_condition']);
        }
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=$value_count;
        return $return_data;
    }
    protected function saveProductMaterial()
    {
        $this->load->library('form_validation'); 
        $this->form_validation->set_rules('product_name', 'Material Name', 'required|xss_clean');
        $product_code            = $this->input->post('product_code');
        if($product_code){
           $this->form_validation->set_rules('product_code', 'Material Code', 'is_unique[product_material.product_mat_code]|xss_clean'); 
        }
        $this->form_validation->set_rules('product_cost', 'Material Cost', 'required|xss_clean');
        $this->form_validation->set_rules('product_type', 'Material Type', 'required|xss_clean');
        $this->form_validation->set_rules('category', 'Category', 'required|xss_clean');
        $this->form_validation->set_rules('subcategory', '', 'xss_clean');
        $this->form_validation->set_rules('unit', 'Unit', 'required|xss_clean');
        $this->form_validation->set_rules('product_price', '', 'xss_clean');
        $this->form_validation->set_rules('credit_salling_price', '', 'xss_clean');
        $this->form_validation->set_rules('wholesale_price', '', 'xss_clean');
        $this->form_validation->set_rules('brand_id', '', '|xss_clean');
        $this->form_validation->set_rules('tax', '', 'xss_clean');
        $this->form_validation->set_rules('alert_quty', '', 'xss_clean');
        $this->form_validation->set_rules('product_details', '', 'xss_clean');
        $this->form_validation->set_rules('product_part_no', '', 'xss_clean');
        $this->form_validation->set_rules('product_oem_part_number', '', 'xss_clean');
        $this->form_validation->set_rules('product_id', '', 'xss_clean');
        $this->form_validation->set_rules('store_position', '', 'xss_clean');
        $this->form_validation->set_rules('store_position', '', 'xss_clean');
        $this->form_validation->set_rules('pr_quantity', '', 'xss_clean');
        $this->form_validation->set_rules('is_export_scale', '', 'xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
            
            $this->load->model('Product_Material_Core_Model');
            $product_name            = $this->input->post('product_name');
            $product_code            = $this->input->post('product_code');
            $category                = $this->input->post('category');
            $subcategory             = $this->input->post('subcategory');
            $unit                    = $this->input->post('unit');
            $product_cost            = $this->priceFilter($this->input->post('product_cost'));
			$product_price           = $this->input->post('product_price');
				if($product_price)$product_price = $this->priceFilter($product_price);
            $wholesale_price         = $this->input->post('wholesale_price');
				if($wholesale_price)$wholesale_price = $this->priceFilter($wholesale_price);
            $credit_salling_price    = $this->input->post('credit_salling_price');
            	if($credit_salling_price)$credit_salling_price = $this->priceFilter($credit_salling_price);
            $brand_id                = $this->input->post('brand_id');
            $tax                     = $this->input->post('tax');
            $alert_quty              = $this->input->post('alert_quty');
            //$image_name             = $this->input->post('product_image');
            $product_details         = $this->input->post('product_details');
            $product_part_no         = $this->input->post('product_part_no');
            $product_oem_part_number = $this->input->post('product_oem_part_number');
            $product_id              = $this->input->post('product_id');
            $store_position          = $this->input->post('store_position');
            $product_max_qty         = $this->input->post('product_max_qty');
            $product_type = $this->input->post("product_type");
            $quantity = $this->input->post("pr_quantity");
            $is_export_scale = $this->input->post('is_export_scale');
            if($product_type==2){
                $pre_code='IP';
                $pre_code_no='003';
                if(!$product_code){
                $product_code=$this->common_model->gen_ref_number('product_id','product',$pre_code);
                }
                if($is_export_scale==1){
                $product_code=$this->common_model->gen_product_scale_ref_number('product_id','product',$pre_code_no);  
                }
            }else{
                $pre_code='PM';
                $pre_code_no='001';
                if(!$product_code){
                $product_code=$this->common_model->gen_ref_number('product_mat_id','product_material',$pre_code);
                }
                if($is_export_scale==1){
                $product_code=$this->common_model->gen_product_scale_ref_number('product_mat_id','product_material',$pre_code_no);  
                }
            }
             
            $pd = array(
            'mat_cat_id' => $category,
            'mat_sub_cat_id' => $subcategory,
            'product_mat_name' => $product_name,
            'product_mat_code' => $product_code,
            'product_mat_alert_qty' => $alert_quty,
            'product_mat_unit' => $unit,
            'product_mat_cost' => $product_cost,
            'product_mat_price' => $product_price,
           // 'mat_wholesale_price' => $wholesale_price,
           // 'mat_credit_salling_price' => $credit_salling_price,
            'mat_tax' => $tax,
            'product_mat_details' => $product_details,
            'product_mat_part_no' => $product_part_no,
            'product_mat_oem_part_number' => $product_oem_part_number,
            'mat_store_position' => $store_position,
            'product_mat_max_qty' => $product_max_qty,
            'mat_brand_id' => $brand_id,
			'product_mat_type_id'=>$product_type,
			'mat_pr_quantity'=>$quantity,
			'mat_is_export_scale'=>$is_export_scale
        );
        $last_id    = $this->Product_Material_Core_Model->saveProductMaterial($pd);
            if($product_type==2){
            $pd_table = array(
            'cat_id' => $category,
            'sub_cat_id' => $subcategory,
            'product_name' => $product_name,
            'product_code' => $product_code,
            'product_alert_qty' => $alert_quty,
            'product_unit' => $unit,
            'product_cost' => $product_cost,
            'product_price' => 0,
            //'wholesale_price' => 0,
            //'credit_salling_price' => 0,
            'tax' => $tax,
            'product_details' => $product_details,
            'store_position' => $store_position,
            'product_max_qty' => $product_max_qty,
            'brand_id' => $brand_id,
			'product_type_id'=>$product_type,
			'pr_quantity'=>$quantity,
			'is_export_scale'=>$is_export_scale,
			'sub_product_of'=>$last_id
            );
            $last_id    = $this->Product_Material_Core_Model->saveFinalProduct($pd_table);
             }
            if ($last_id) {
                $st = array(
                    'status' => 1,
                    'validation' => 'Done!',
                    'last_id' => $product_code
                );
                echo json_encode($st);
            } else {
                $st = array(
                    'status' => 0,
                    'validation' => 'error occurred please contact your system administrator'
                );
                echo json_encode($st);
            }
        }
    }
     function priceFilter($amount = '')
    {
        $s = explode("Rs.", $amount);
        return str_replace(',', '', $s[1]);
    }
    
    
     protected function updateProductMaterial()
    {
        $this->load->library('form_validation'); 
        $this->form_validation->set_rules('product_name', 'Material Name', 'required|xss_clean');
         $this->form_validation->set_rules('product_id', 'Material Id', 'required|xss_clean');
        $product_code            = $this->input->post('product_code');
        if($product_code){
           $this->form_validation->set_rules('product_code', 'Material Code', 'required|xss_clean'); 
        }
        $this->form_validation->set_rules('product_cost', 'Material Cost', 'required|xss_clean');
        $this->form_validation->set_rules('product_type', 'Material Type', 'required|xss_clean');
        $this->form_validation->set_rules('category', 'Category', 'required|xss_clean');
        $this->form_validation->set_rules('subcategory', '', 'xss_clean');
        $this->form_validation->set_rules('unit', 'Unit', 'required|xss_clean');
        $this->form_validation->set_rules('product_price', '', 'xss_clean');
        $this->form_validation->set_rules('credit_salling_price', '', 'xss_clean');
        $this->form_validation->set_rules('wholesale_price', '', 'xss_clean');
        $this->form_validation->set_rules('brand_id', '', '|xss_clean');
        $this->form_validation->set_rules('tax', '', 'xss_clean');
        $this->form_validation->set_rules('alert_quty', '', 'xss_clean');
        $this->form_validation->set_rules('product_details', '', 'xss_clean');
        $this->form_validation->set_rules('product_part_no', '', 'xss_clean');
        $this->form_validation->set_rules('product_oem_part_number', '', 'xss_clean');
        $this->form_validation->set_rules('store_position', '', 'xss_clean');
        $this->form_validation->set_rules('store_position', '', 'xss_clean');
        $this->form_validation->set_rules('pr_quantity', '', 'xss_clean');
        $this->form_validation->set_rules('is_export_scale', '', 'xss_clean');
        $this->form_validation->set_rules('allow_convert', '', 'xss_clean');
        $this->form_validation->set_rules('conert_to_product_id', '', 'xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
            
            $this->load->model('Product_Material_Core_Model');
            $product_name            = $this->input->post('product_name');
            $product_code            = $this->input->post('product_code');
            $category                = $this->input->post('category');
            $subcategory             = $this->input->post('subcategory');
            $unit                    = $this->input->post('unit');
            $product_cost            = $this->priceFilter($this->input->post('product_cost'));
			$product_price           = $this->input->post('product_price');
				if($product_price)$product_price = $this->priceFilter($product_price);
            $wholesale_price         = $this->input->post('wholesale_price');
				if($wholesale_price)$wholesale_price = $this->priceFilter($wholesale_price);
            $credit_salling_price    = $this->input->post('credit_salling_price');
            	if($credit_salling_price)$credit_salling_price = $this->priceFilter($credit_salling_price);
            $brand_id                = $this->input->post('brand_id');
            $tax                     = $this->input->post('tax');
            $alert_quty              = $this->input->post('alert_quty');
            //$image_name             = $this->input->post('product_image');
            $product_details         = $this->input->post('product_details');
            $product_part_no         = $this->input->post('product_part_no');
            $product_oem_part_number = $this->input->post('product_oem_part_number');
            $product_id              = $this->input->post('product_id');
            $store_position          = $this->input->post('store_position');
            $product_max_qty         = $this->input->post('product_max_qty');
            $product_type = $this->input->post("product_type");
            $quantity = $this->input->post("pr_quantity");
            $is_export_scale = $this->input->post('is_export_scale');
            $allow_convert = $this->input->post('allow_convert'); 
            $conert_to_product_id = $this->input->post('conert_to_product_id');
            
            $pd = array(
            'mat_cat_id' => $category,
            'mat_sub_cat_id' => $subcategory,
            'product_mat_name' => $product_name,
            'product_mat_code' => $product_code,
            'product_mat_alert_qty' => $alert_quty,
            'product_mat_unit' => $unit,
            'product_mat_cost' => $product_cost,
            //'product_mat_price' => $product_price,
            //'mat_wholesale_price' => $wholesale_price,
            //'mat_credit_salling_price' => $credit_salling_price,
            'mat_tax' => $tax,
            'product_mat_details' => $product_details,
            'product_mat_part_no' => $product_part_no,
            'product_mat_oem_part_number' => $product_oem_part_number,
            'mat_store_position' => $store_position,
            'product_mat_max_qty' => $product_max_qty,
            'mat_brand_id' => $brand_id,
			'product_mat_type_id'=>$product_type,
			'mat_pr_quantity'=>$quantity,
			'mat_is_export_scale'=>$is_export_scale,
			'allow_convert'=>$allow_convert,
			//'conert_to_product_id'=>$conert_to_product_id
        );
        $last_id    = $this->Product_Material_Core_Model->updateProductMaterial($product_id,$pd);
        if($product_type==2){
         $pd_table = array(
            'cat_id' => $category,
            'sub_cat_id' => $subcategory,
            'product_name' => $product_name,
            'product_code' => $product_code,
            'product_alert_qty' => $alert_quty,
            'product_unit' => $unit,
            'product_cost' => $product_cost,
            'product_price' => 0,
            'wholesale_price' => 0,
            'credit_salling_price' => 0,
            'tax' => $tax,
            'product_details' => $product_details,
            'store_position' => $store_position,
            'product_max_qty' => $product_max_qty,
            'brand_id' => $brand_id,
			'product_type_id'=>$product_type,
			'pr_quantity'=>$quantity,
			'is_export_scale'=>$is_export_scale,
			'sub_product_of'=>$last_id
        );
        $last_id2    = $this->Product_Material_Core_Model->updateFinalProduct($product_id,$pd_table);
        }
            if ($last_id) {
                $st = array(
                    'status' => 1,
                    'validation' => 'Done!',
                    'last_id' => $product_code
                );
                echo json_encode($st);
            } else {
                $st = array(
                    'status' => 0,
                    'validation' => 'error occurred please contact your system administrator'
                );
                echo json_encode($st);
            }
        }
    }
    protected function updateProductMaterialTable($id,$data) {
        $data=$this->cleanAndValidateArray($data);
        $id=$this->cleanAndValidateNumber($id);
        $this->load->model('Product_Material_Core_Model');
        $result = $this->Product_Material_Core_Model->updateProductMaterial($id,$data);
        return $result;
    }
   
  
}