<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bank_Model extends CI_Model {
  
  private $tableName = 'mstr_bank';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_bank(&$bank_data,$bank_id=false)
	{
		if (!$bank_id)
		{
			$this->db->insert($this->tableName,$bank_data);
		}else {
			$this->db->where('id', $bank_id);
			return $this->db->update($this->tableName,$bank_data);
			
		}
		
	}	
	
	function get_all_bank() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("bank_id", "desc");
		$this->db->where("bank_status",1);//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
		function get_all_bank_account() {
		$this->db->select('mstr_bank_account.*');
		$this->db->order_by("mba_id", "desc");
		$this->db->where("mba_status",1);//("id !=",$id);
		$query = $this->db->get('mstr_bank_account');
		return $query->result_array();
	}
	
	public function get_bank_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("bank_id", $id);
		$this->db->order_by("bank_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	
	public function delete_bank($bank_id)
	{
		$this->db->where('bank_id', $bank_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_bank($bank_id)
	{
		$data = array(
			'status' => 0
		);	
		$this->db->where('id', $bank_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_bank($bank_id)
	{
		$data = array(
			'status' => 1
		);	
		$this->db->where('id', $bank_id);
		$this->db->update($this->tableName, $data);
		
	}
}