<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Pos_API extends CI_Controller
{
    var $main_menu_name = "";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        ini_set('display_errors', '1');
        ini_set('display_startup_errors', '1');
        error_reporting(E_ALL);
        date_default_timezone_set("Asia/Colombo");
        //$this->content_type_check();
        $this->load->model('common_model');
        $this->load->model('customer_model');
        $this->load->model('Android_Model');
    }
    
    //this function should call from constructor
    function content_type_check(){
        if ($this->router->method != "paycorp_view") {
            header('Content-Type: application/json');
            if (!isset($_SERVER['CONTENT_TYPE'])) {
                $data = array(
                    "status" => 0,
                    "msg" => "Content Type undefined.",
                    "err_code" => "ipasop400-i"
                );
                echo json_encode($data);
                exit();
            }
            if ($_SERVER['CONTENT_TYPE'] !== "application/json" && $_SERVER['CONTENT_TYPE'] !== "application/json; charset=utf-8") {
                $data = array(
                    "status" => 0,
                    "msg" => "Invalid content type! JSON required. Received:" . $_SERVER['CONTENT_TYPE'],
                    "err_code" => "ipasop401-i"
                );
                echo json_encode($data);
                exit();
            }
            $_POST = json_decode(file_get_contents("php://input"), true);
        }
    }
   
    public function index()
    {
        $data = array(
            "status" => 0,
            "msg" => "Error",
            "err_code" => "ipasop200-a"
        );
        echo json_encode($data);
    }
    //get product_list for app
     function get_product_list(){
        $data=array();
        $product_list=$this->Android_Model->get_product_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'cat_id' => $row['cat_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'take_away_price' => $row['product_price'], 
                'dine_in_price' => $row['credit_salling_price'],
                'uber_price' => $row['wholesale_price'],
                'pick_me_price' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
                'product_thumb'=>asset_url() . "uploads/thumbs/".$row['product_thumb'],
                
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_product_batch_list(){
        $data=array();
        $product_list=$this->Android_Model->get_product_batch_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'batch_id' => $row['batch_id'],
                'take_away_price' => $row['product_price'], 
                'dine_in_price' => $row['credit_salling_price'],
                'uber_price' => $row['wholesale_price'],
                'pick_me_price' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_category_list(){
        $data=array();
        $product_list=$this->Android_Model->get_category_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'cat_id' => $row['cat_id'],
                'cat_name' => $row['cat_name'],
                'cat_code' => $row['cat_code'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_sale_type_list(){
        $data=array();
        $product_list=$this->Android_Model->get_sale_type_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'invoice_type_id' => $row['invoice_type_id'],
                'invoice_type_name' => $row['invoice_type_name'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_payment_type_list(){
        $data=array();
        $product_list=$this->Android_Model->get_payment_type_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'p_type_id' => $row['p_type_id'],
                'p_type_name' => $row['p_type_name'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_price_type_list(){
        $data=array();
        $product_list=$this->Android_Model->get_price_type_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'pri_type_id' => $row['pri_type_id'],
                'pri_type_name' => $row['pri_type_name'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_transaction_type_list(){
        $data=array();
        $product_list=$this->Android_Model->get_transaction_type_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'fxd_ass_id' => $row['fxd_ass_id'],
                'fxd_ass_name' => $row['fxd_ass_name'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    
    
    function get_expencess_type_list(){
        $data=array();
        $product_list=$this->Android_Model->get_expencess_type_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'etp_id' => $row['etp_id'],
                'etp_name' => $row['etp_name'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_customer_list(){
        $data=array();
        $wareshouse_id=$this->input->post('warehouse_id');
        $product_list=$this->Android_Model->get_customer_list($wareshouse_id);
        foreach ($product_list as $row) {
            $nested_date = array(
                'cus_id' => $row['cus_id'],
                'cus_code' => $row['cus_code'],
                'cus_name' => $row['cus_name'],
                'cus_phone' => $row['cus_phone'],
                'cus_address' => $row['cus_address'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_warehouse_list(){
        $data=array();
        $product_list=$this->Android_Model->get_warehouse_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'warehouse_id' => $row['id'],
                'warehouse_code' => $row['code'],
                'warehouse_name' => $row['name'],
                'invoice_name' => $row['invoice_name'],
                'warehouse_address' => $row['address'],
                'warehouse_tp' => $row['phone'],
                'warehouse_email' => $row['email'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    
    public function login()
    //get user name and password
    {
        $user_username = $this->input->post('user_name');
        $password      = $this->input->post('password');
        //get user id
        $this->load->model('User_Model');
        $user_id = $this->User_Model->login($user_username, $password);
        if ($user_id) {
            $data['user_details'] = $this->User_Model->get_user_info($user_id);
            $ss_user_username     = $data['user_details']['user_username'];
            $ss_user_id           = $data['user_details']['user_id'];
            $ss_group_id          = $data['user_details']['group_id'];
            $ss_warehouse_id      = $data['user_details']['warehouse_id'];
            $ss_user_first_name   = $data['user_details']['user_first_name'];
            $ss_user_last_name    = $data['user_details']['user_last_name'];
            $ss_user_group_name   = $data['user_details']['user_group_name'];
            $code                 = $data['user_details']['code'];
            //if cash collector owener super admin
            $check_chashier_float=$this->User_Model->get_user_chashier_float($user_id);
			    $float_status=0;
			    if($check_chashier_float>0){
			       $float_status=1; 
			    }
            if ($ss_group_id == 4 || $ss_group_id == 6) {
                $stutus = 1;
                $user   = array(
                    'ss_stutus' => $stutus,
                    'ss_user_id' => $user_id,
                    'ss_group_id' => $ss_group_id,
                    'ss_warehouse_id' => $ss_warehouse_id,
                    'ss_user_first_name' => $ss_user_first_name,
                    'ss_user_group_name' => $ss_user_group_name,
                    'ss_user_float_status' => $float_status,
                    'float_id' => $check_chashier_float,
                    'ss_message' => "LOGGING SUCCESS",
                    'code'=>$code
                );
                echo json_encode($user);
            } else {
                $stutus = 0;
                $user   = array(
                    'ss_stutus' => $stutus,
                    'ss_message' => "USER NOT ALLOWED TO LOGIN THIS INTERFACE !",
                );
                echo json_encode($user);
            }
        } else {
            $stutus = 0;
            $user   = array(
                'ss_stutus' => $stutus,
                'ss_message' => "USER NOT FOUND !",
            );
            echo json_encode($user);
        }
    }
    
     function save_pos_invoice(){
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $this->load->model('Delivery_Invoice_Model');
        $this->load->model('Common_Model');
        $this->load->model('Sale_Multiple_Payment_Model');
        $tracking_id=$this->input->post('tracking_id');
        $sale_datetime_1=$this->input->post('invoice_date_time');
		$sale_datetime=date('Y-m-d H:i:s', strtotime($sale_datetime_1));
		$user_id=$this->input->post('user_id');
		$cus_id=$this->input->post('cus_id');
		$total_gross_amount=$this->input->post('total_gross_amount');
		$discount_total_amount=$this->input->post('discount_total_amount');
		$total_net_amount=$this->input->post('total_net_amount');
		$warehouse_id=$this->input->post('warehouse_id');
		$invoice_type_id	=$this->input->post('invoice_type_id');
		$price_type_id	=$this->input->post('price_type_id');
		$delivery_id = $this->input->post('delivery_id');
		$dispatch_id = $this->input->post('dispatch_id');
		$cost_total= $this->input->post('cost_total');
		$total_collectable_value= $this->input->post('total_collectable_value');
		$total_claiming_value= $this->input->post('total_claiming_value');
		$exchange_product_details= $this->input->post('exchange_product_details');
		$paymet_term_id = $this->input->post('payment_term_id');
		$payment_date_count=1;//$this->Delivery_Invoice_Model->get_payment_term_date_count($paymet_term_id);
		$float_id = $this->input->post('float_id');
		$product = $this->input->post('invoiced_products');
		$invoiced_items=stripslashes($product);
		$products = json_decode($invoiced_items);
	    $payment_details= $this->input->post('payment_details');
	    $payment_items=stripslashes($payment_details);
		$payment = json_decode($payment_items);
	    $invoice_generate_type=$this->input->post('sale_gen_type');
	    $odr_ref_no=$this->input->post('odr_ref_no');
	    
	    $last_result=0;
	    $result=0;
	    $sale_reference_no	= $this->Common_Model->gen_ref_number('sale_id','sales','INV'); 
        $sale_datetime_created = date('Y-m-d H:i:s'); 
		$data=array(
				'tracking_id'=>$tracking_id,
				'invoice_date_time'=>$sale_datetime,
				'sale_datetime'=>$sale_datetime,
				'user'=>$user_id,
				'customer_id'=>$cus_id,
				'warehouse_id'=>$warehouse_id,
				'invoice_type'=>$invoice_type_id,
				'price_type'=>$price_type_id,
				'cost_total'=>$cost_total,
				'card_ref_number' =>$tracking_id,
				'sale_reference_no' =>$sale_reference_no,
				'sale_datetime_created' => $sale_datetime_created,
                'delivery_id' => $delivery_id,
                'direct_sale' => 0,
                'due_date' => date('Y-m-d', strtotime("+".$payment_date_count." days", strtotime(date("Y-m-d")))),
				'sales_rep_id' => $user_id,
				'sale_status' => 0,
                'payment_status' => 0,
                'sale_total' => $total_net_amount,
                'sale_inv_gross_total' => $total_gross_amount,
                'sale_inv_total' => $total_gross_amount,
				'dpn_id'=>$dispatch_id,
				'bill_no'=>$tracking_id,
				'total_collectble'=>$total_collectable_value,
				'total_cliamble'=>$total_claiming_value,
				'invoice_generate_type'=>3,
				'paymet_term_id'=>$paymet_term_id,
				'paymet_term_days'=>$payment_date_count,
				'float_id'=>$float_id,
				'invoice_generate_type'=>$invoice_generate_type,
				'odr_ref_no'=>$odr_ref_no
			);
			$_insert=$this->Sales_Model->save_sales($data);
			$lastid=$this->db->insert_id();
			$sale_id=$lastid;
			//insert sale item data
			foreach($products as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->product_id)){}else{continue;}
			        $data_item=array(
    					'sale_id'=>$sale_id,
    					'product_id'=>$obj->product_id,
    					'batch_id'=>$obj->batch_id,
    					'product_unit'=>6,
    					'quantity'=>$obj->invoiced_qty,
    					'unit_price'=>$obj->product_price,
    					'net_price'=>$obj->selling_price,
    					'item_cost'=>$obj->product_cost,
    					'added_discount_val'=>0,//$obj->item_discount,
    					'discount_val'=>0,//$obj->total_item_discount_amount,
    					'total_item_cost'=>$obj->total_item_cost,
    					'gross_total'=>$obj->total_item_gross_amount,
    					'net_total'=>$obj->total_item_net_amount,
    					'delivery_id'=>0,//$obj->delivery_id,
    					'dpn_id'=>0,//$obj->delivery_dispatch_id,
    					'collectable_value'=>$obj->total_item_net_amount,
    					'claimble_value'=>0,
    					'cus_default_price'=>$obj->product_price,
    				);
    			$last_result=$this->Sales_Model->save_sales_item($data_item);
			    }
			}
			foreach($payment as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->payment_ref_no)){}else{continue;}
			        $sp_data_item       = array(
                    'smp_no' => $this->Common_Model->gen_ref_number('smp_id','sale_multiple_payment','PAY'),
                    'smp_last_id' => 0,
                    'smp_amount' => floatval($obj->invoice_allocated_amount),
                    'user_id' => $obj->user_id,
			        'bank_id' => null,
                    'customer_id' => $obj->cus_id,
                    'smp_added_date' => date("Y-m-d h:i:s") ,
                    'warehouse_id' => $obj->warehouse_id,
                    'payment_method' => null,
                    'payment_type' => $obj->payment_type_id,
                    'payment_expire_date_cq' => null,
                    'payment_status' => 1,            
                    'payee_name' => null,
                    'credit_card_expire_month' => null,
                    'credit_card_expire_year' => null, 
                    'payment_ref_no' => $obj->payment_ref_no,     
                    'payment_date' => date('Y-m-d H:i:s', strtotime($obj->payment_date_time)) ,  
                    'ref_no' => $obj->sale_ref_no ,
                    'collector_id' => $obj->user_id , 
                    'note' => null ,
                    'is_claim' => 0 ,
                    'float_id'=>$obj->float_id
                    );
                    if($obj->is_advance_payment==1){
                     $smp_id=$obj->smp_id;
                    }else{
                     $smp_id=$this->Sale_Multiple_Payment_Model->save_sale_multiple_payment_header($sp_data_item);   
                    }
                    $data_item = array(
                    'sale_id' => $sale_id,
                    'sale_pymnt_amount' => floatval($obj->invoice_allocated_amount),
                    'sale_pymnt_paying_by' => $obj->payment_type_id,
                    'user_id' => $obj->user_id,
					'bank_id' => null,
                    'sale_pymnt_added_date_time' => date("Y-m-d h:i:s"),
                    'sale_payment_type' => 'sale',
                    'sale_pymnt_cheque_no' => null,
                    'sale_pymnt_crdt_card_no' => null,
                    'sale_pymnt_crdt_card_holder_name' => null,
                    'sale_pymnt_crdt_card_type' => null,
                    'sale_pymnt_crdt_card_month' => null,
                    'sale_pymnt_crdt_card_year' => null,
                    'sale_pymnt_date_time' => date('Y-m-d H:i:s', strtotime($obj->payment_date_time)),
                    'smp_id' => $smp_id,
					'sale_pymnt_note' => null,
					'sale_pymnt_note_two' => null,
					'is_claim' => 0 ,
					'float_id'=>$obj->float_id,
					'customer_given_amount'=>floatval($obj->customer_given_amount),
					'cash_change_amount'=>floatval(($obj->cash_change_amount))
                );
                $this->Sale_Multiple_Payment_Model->save_sale_multiple_payment($data_item);
			    }
			}
			if($last_result==true){
			    $result=1;
			}
			$st = array(
                'status' => 1,
                'msg' => "",
                'data' => "done"
        );
        echo json_encode($st);
    }
    
    public function save_new_cash_float_open()
    {
            $this->load->model('Cash_Balance_Model');
            $this->load->model('Common_Model');
            $acctrnss_id      = $this->input->post('acctrnss_id');
            $acctrnss_amount  = $this->input->post('cash_in_hand');
            $warehouse_id     = $this->input->post('warehouse_id');
            $date             = date('Y-m-d', strtotime($this->input->post('acctrnss_date')));
            $user_id          = $this->input->post('user_id');
            $remarks = $this->input->post('remarks');
            $this->load->library('form_validation'); //form validation lib
            $this->form_validation->set_rules('user_id', 'USER ID','required');
            $this->form_validation->set_rules('warehouse_id','WAREHOUSE', 'required');
            $this->form_validation->set_rules('acctrnss_date','DATE', 'required');
            if ($this->form_validation->run() == FALSE) {
                $st = array(
                    'status' => 0,
                    'disMsg' => validation_errors(),
                    'error' => 1,
                    'ss_user_float_status'=>0,
                    'float_id'=>false,
                );
                echo json_encode($st);
            } else {
                $ref_no     = $this->Common_Model->gen_ref_number('c_float_mstr_id', 'cashier_float_master', 'CFL');
                $data       = array(
                    'warehouse_id' => $warehouse_id,
                    'c_f_m_date_time' => date("Y-m-d H:i:s"),
                    'float_status' => 1,
                    'user_id' => $user_id,
                    'ref_no' => $ref_no
                );
                $last_id    = $this->Cash_Balance_Model->save_cashier_float_master($data);
                $data_items = array(
                    'c_float_mstr_id' => $last_id,
                    'float_type' => 1,
                    'c_count_5000' => $this->input->post('count_5000'),
                    'c_count_1000' => $this->input->post('count_1000'),
                    'c_count_500' => $this->input->post('count_500'),
                    'c_count_100' => $this->input->post('count_100'),
                    'c_count_50' => $this->input->post('count_50'),
                    'c_count_20' => $this->input->post('count_20'),
                    'c_count_10' => $this->input->post('count_10'),
                    'c_count_10_c' => $this->input->post('count_10_c'),
                    'c_count_5_c' => $this->input->post('count_5'),
                    'c_count_2_c' => $this->input->post('count_2'),
                    'c_count_1_c' => $this->input->post('count_1'),
                    'float_item_details' => $remarks,
                    'recode_date_time' => date("Y-m-d H:i:s"),
                    'cash_on_hand' => $acctrnss_amount,
                    'total_recived_payment' => $acctrnss_amount
                );
                $this->Cash_Balance_Model->save_cashier_float_item($data_items);
                 $st = array(
                    'status' => 1,
                    'disMsg' => "SUCCESS",
                    'error' => 0,
                    'ss_user_float_status'=>1,
                    'float_id'=>$last_id,
                );
                echo json_encode($st);
            }
        
    }
    
    
    public function save_cash_float_close()
    {
            $this->load->model('Cash_Balance_Model');
            $this->load->model('Common_Model');
            $acctrnss_id      = $this->input->post('acctrnss_id');
            $type             = $this->input->post('type');
            $fxd_ass_id       = $this->input->post('fxd_ass_id');
            $acctrnss_amount  = $this->input->post('cash_in_hand');
            $etp_id           = $this->input->post('etp_id');
            $warehouse_id     = $this->input->post('warehouse_id');
            $acctrnss_date    = date('Y-m-d', strtotime($this->input->post('acctrnss_date')));
            $acctrnss_details = $this->input->post('remarks');
            $cheque           = $this->input->post('cheque');
            $visa_card        = $this->input->post('visa_card');
            $master_card      = $this->input->post('master_card');
            $amex_card        = $this->input->post('amex_card');
            $user_id        = $this->input->post('user_id');
            $float_id        = $this->input->post('float_id');
            $this->load->library('form_validation'); //form validation lib
            $this->form_validation->set_rules('float_id','FLOAT', 'required');
            $this->form_validation->set_rules('user_id', 'USER','required');
            if ($this->form_validation->run() == FALSE) {
                $st = array(
                    'status' => 0,
                    'disMsg' => validation_errors(),
                    'error' => 1
                );
                echo json_encode($st);
            } else {
                $last_id = $float_id;
                 $data    = array(
                    'float_status' => 2
                );
                $this->Cash_Balance_Model->update_cashier_float_master($data, $float_id);
                $data_items = array(
                    'c_float_mstr_id' => $float_id,
                    'float_type' => 2,
                    'c_count_5000' => $this->input->post('count_5000'),
                    'c_count_1000' => $this->input->post('count_1000'),
                    'c_count_500' => $this->input->post('count_500'),
                    'c_count_100' => $this->input->post('count_100'),
                    'c_count_50' => $this->input->post('count_50'),
                    'c_count_20' => $this->input->post('count_20'),
                    'c_count_10' => $this->input->post('count_10'),
                    'c_count_10_c' => $this->input->post('count_10_c'),
                    'c_count_5_c' => $this->input->post('count_5'),
                    'c_count_2_c' => $this->input->post('count_2'),
                    'c_count_1_c' => $this->input->post('count_1'),
                    'float_item_details' => $acctrnss_details,
                    'recode_date_time' => date("Y-m-d H:i:s"),
                    'cash_on_hand' => $acctrnss_amount,
                    'cheque_on_hand' => $cheque,
                    'visa_card_on_hand' => $visa_card,
                    'master_card_on_hand' => $master_card,
                    'amex_card_on_hand' => $amex_card,
                    'total_card_on_hand' => (float) $visa_card + (float) $master_card + (float) $amex_card,
                    'total_recived_payment' => (float)  $acctrnss_amount + (float) $visa_card + (float) $master_card + (float) $amex_card + (float) $cheque
                );
                $this->Cash_Balance_Model->save_cashier_float_item($data_items);
                echo json_encode(array(
                            'id' => $last_id,
                            'type' => $type,
                            'status' => 1,
                            'error' => 0,
                            'disMsg' => "SUCCESS"
                        ));
                    
              
        }
    }
    public function chashier_float_summay()
    {
        $this->load->model('Cash_Balance_Model');
        $this->load->model('Common_Model');
        $id                                = $this->input->get('id');
        $data['transactions_details']      = $this->Cash_Balance_Model->get_chashier_foat_full_details($id);
        $data['transactions_items']        = $this->Cash_Balance_Model->get_chashier_foat_items_details($id);
        $data['opening_balance']           = 0;
        $data['closing_balance']           = 0;
        $data['tranfer_pettycash_total']   = $this->Cash_Balance_Model->get_tranfer_pettycash_total($id);
        $data['expencess_total']           = $this->Cash_Balance_Model->get_expencess_total($id);
        $data['withdraval_total']          = $this->Cash_Balance_Model->get_withdrowal_total($id);
        $data['master_card']               = 0;
        $data['visa_card']                 = 0;
        $data['amex_card']                 = 0;
        $data['total_card']                = 0;
        $data['total_cheque']              = 0;
        $data['total_cash']                = 0;
        $data['end_date_time']             = "";
        $data['master_card_system']        = $this->Cash_Balance_Model->get_float_payment_total($id, "3", "MasterCard");
        $data['visa_card_system']          = $this->Cash_Balance_Model->get_float_payment_total($id, "3", "");
        $data['amex_card_system']          = $this->Cash_Balance_Model->get_float_payment_total($id, "3", "Amex");
        $data['total_card_system']         = $this->Cash_Balance_Model->get_float_payment_total($id, "3", "");
        
        $data['total_cheque_system2']             = $this->Cash_Balance_Model->get_float_payment_total($id, "Cheque", "");
        $data['total_online_pay_system']         = $this->Cash_Balance_Model->get_float_payment_total($id, "OP", "");
        $data['total_bank_deposit_pay_system']   = $this->Cash_Balance_Model->get_float_payment_total($id, "BD", "");
        
        
        $data['total_cheque_system']       = 0;
        $data['sale_cash_total']           = $this->Cash_Balance_Model->get_float_payment_total($id, "1", "");
        $data['sale_return_cash_total']    = $this->Cash_Balance_Model->get_float_payment_return_total($id, "CASH_REFUND");
        $data['retail_sale_total']         = $this->Cash_Balance_Model->get_float_retail_sale_total($id);
        $data['retail_sale_return__total'] = $this->Cash_Balance_Model->get_float_return_retail_sale_total($id);
        $data['retail_given_discount']         = $this->Cash_Balance_Model->get_float_discount_total($id);
        $data['wholesale_sale_total']      = 0;
        $data['withdraval_list']           = $this->Cash_Balance_Model->get_withdrowal_list($id);
        foreach ($data['transactions_items'] as $row) {
            if ($row['float_type'] == 1) {
                $data['opening_balance'] = $row['total_recived_payment'];
            }
            if ($row['float_type'] == 2) {
                $data['closing_balance'] = $row['cash_on_hand'];
                $data['master_card']     = $row['master_card_on_hand'];
                $data['visa_card']       = $row['visa_card_on_hand'];
                $data['amex_card']       = $row['amex_card_on_hand'];
                $data['total_card']      = $row['total_card_on_hand'];
                $data['total_cheque']    = $row['cheque_on_hand'];
                $data['total_cash']      = $row['cash_on_hand'];
                $data['end_date_time']   = $row['recode_date_time'];
            }
        }
        $data['dulpicate_list'] = $this->Cash_Balance_Model->duplicate_m($id);
        
         echo json_encode(array(
                           
                            'data' => $data,
                            'status' => 1,
                            'error' => 0,
                            'disMsg' => "SUCCESS"
                        ));
        
    }
    
    function save_pos_order(){
        $this->load->model('Order_Model');
        $this->load->model('Android_Model');
        $this->load->model('Common_Model');
        $this->load->model('Sale_Multiple_Payment_Model');
        $tracking_id=$this->input->post('tracking_id');
        $sale_datetime_1=$this->input->post('invoice_date_time');
		$sale_datetime=date('Y-m-d H:i:s', strtotime($sale_datetime_1));
		$user_id=$this->input->post('user_id');
		$cus_id=$this->input->post('cus_id');
		$total_gross_amount=$this->input->post('total_gross_amount');
		$discount_total_amount=$this->input->post('discount_total_amount');
		$total_net_amount=$this->input->post('total_net_amount');
		$warehouse_id=$this->input->post('warehouse_id');
		$invoice_type_id	=$this->input->post('invoice_type_id');
		$price_type_id	=$this->input->post('price_type_id');
		$delivery_charge = $this->input->post('delivery_charge');
		$dispatch_id = $this->input->post('dispatch_id');
		$cost_total= $this->input->post('cost_total');
		$total_collectable_value= $this->input->post('total_collectable_value');
		$total_claiming_value= $this->input->post('total_claiming_value');
		$exchange_product_details= $this->input->post('exchange_product_details');
		$paymet_term_id = $this->input->post('payment_term_id');
		$payment_date_count=1;
		$float_id = $this->input->post('float_id');
		$product = $this->input->post('invoiced_products');
		$order_date_time=$this->input->post('order_date_time');
		$order_date_time=date('Y-m-d', strtotime($order_date_time));
		$invoiced_items=stripslashes($product);
		$products = json_decode($invoiced_items);
	    $payment_details= $this->input->post('payment_details');
	    $payment_items=stripslashes($payment_details);
		$payment = json_decode($payment_items);
	    $last_result=0;
	    $result=0;
	    //$sale_reference_no	= $this->Common_Model->gen_ref_number('odr_id','order_master','ODR'); 
        $sale_datetime_created = date('Y-m-d H:i:s'); 
		$data=array(
		        'odr_ref_no'=>$tracking_id,
				'odr_manual_ref_no'=>$tracking_id,
				'added_date_time'=>$sale_datetime,
				'order_date_time'=>$order_date_time,
				'added_user_id'=>$user_id,
				'odr_customer_id'=>$cus_id,
				'odr_warehouse_id'=>$warehouse_id,
				'invoice_type_id'=>$invoice_type_id,
				'price_type_id'=>$price_type_id,
				'odr_payment_term'=>$paymet_term_id,
				'delivery_charge' => $delivery_charge,
				'total_odr_cost'=>$cost_total,
				'odr_sale_rep_id' => $user_id,
				'odr_status' => 0,
                'total_odr_price' => $total_net_amount,
                'odr_discount_amount'=>$discount_total_amount,
                'odr_gross_amount'=>$total_gross_amount,
				'float_id'=>$float_id
			);
			$lastid=$this->Order_Model->save_order($data);
			$sale_id=$lastid;
			//insert sale item data
			foreach($products as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->product_id)){}else{continue;}
			        $data_item=array(
    					'odr_id'=>$sale_id,
    					'product_id'=>$obj->product_id,
    					'batch_id'=>$obj->batch_id,
    					//'product_unit'=>6,
    					'request_qty'=>$obj->invoiced_qty,
    					'approved_qty'=>$obj->invoiced_qty,
    					'uom_price'=>$obj->product_price,
    					//'net_price'=>$obj->selling_price,
    					'uom_cost'=>$obj->product_cost,
    					//'added_discount_val'=>0,//$obj->item_discount,
    					//'discount_val'=>0,//$obj->total_item_discount_amount,
    					'total_cost'=>$obj->total_item_cost,
    					'total_price'=>$obj->total_item_gross_amount,
    					//'net_total'=>$obj->total_item_net_amount,
    					//'delivery_id'=>0,//$obj->delivery_id,
    					//'dpn_id'=>0,//$obj->delivery_dispatch_id,
    					//'collectable_value'=>$obj->total_item_net_amount,
    					//'claimble_value'=>0,
    					'original_uom_price'=>$obj->product_price,
    				);
    			$last_result=$this->Order_Model->save_order_item($data_item);
			    }
			}
			foreach($payment as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->payment_ref_no)){}else{continue;}
			        $sp_data_item       = array(
                    'smp_no' => $this->Common_Model->gen_ref_number('smp_id','sale_multiple_payment','PAY'),
                    'smp_last_id' => 0,
                    'smp_amount' => floatval($obj->invoice_allocated_amount),
                    'user_id' => $obj->user_id,
			        'bank_id' => null,
                    'customer_id' => $obj->cus_id,
                    'smp_added_date' => date("Y-m-d h:i:s") ,
                    'warehouse_id' => $obj->warehouse_id,
                    'payment_method' => null,
                    'payment_type' => $obj->payment_type_id,
                    'payment_expire_date_cq' => null,
                    'payment_status' => 1,            
                    'payee_name' => null,
                    'credit_card_expire_month' => null,
                    'credit_card_expire_year' => null, 
                    'payment_ref_no' => $obj->payment_ref_no,     
                    'payment_date' => date('Y-m-d H:i:s', strtotime($obj->payment_date_time)) ,  
                    'ref_no' => $obj->sale_ref_no ,
                    'collector_id' => $obj->user_id , 
                    'note' => null ,
                    'is_claim' => 0 ,
                    'float_id'=>$obj->float_id,
                    'adv_document_id'=>$sale_id,
                    'is_advance_payment'=>1
                    );
                    $smp_id=$this->Sale_Multiple_Payment_Model->save_sale_multiple_payment_header($sp_data_item);
			    }
			}
			if($last_result==true){
			    $result=1;
			}
			$st = array(
                'status' => 1,
                'msg' => "saved!",
                'data' => "done"
        );
        echo json_encode($st);
    }
    
    public function save_transactions()
	{
	    $this->load->library('form_validation');
		$this->load->model('Transactions_Model');
		$user_id=$this->input->post('user_id');
		$float_id=$this->input->post('float_id');
		$acctrnss_date=date('Y-m-d',strtotime($this->input->post('transaction_date')));
		$fxd_ass_id=$this->input->post('transaction_type_id');
		$acctrnss_amount=$this->input->post('transaction_amount');
		$etp_id=$this->input->post('expenses_id');
		$acctrnss_details=$this->input->post('transaction_details');
		$this->form_validation->set_rules('fxd_ass_id','required');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		$data=array(
			'fxd_ass_id'=>$fxd_ass_id,
			'acctrnss_amount'=>$acctrnss_amount,	
			'acctrnss_date'=>$acctrnss_date,
			'acctrnss_details'=>$acctrnss_details,
			'user_id'=>$user_id,
			'etp_id'=>$etp_id,
			'business'=>1,
			'float_id'	=> $float_id,
		);
		$acctrnss_id=null;
		$_insert=$this->Transactions_Model->save_transactions($data,$acctrnss_id);
	    $st = array('status' =>1,'validation' => 'Saved');
        echo json_encode($st);
        }
	}
    
    public function get_pending_order_list($value = ''){
        $warehouse_id  = $this->input->post('warehouse_id');
        $values = $this->Android_Model->get_order_list($warehouse_id);
        echo json_encode($values);
    }
    
    public function get_pending_order_item_list($value = ''){
        $warehouse_id  = $this->input->post('warehouse_id');
        $values = $this->Android_Model->get_order_product_list($warehouse_id);
        echo json_encode($values);
    }
    public function get_pending_order_payment_list($value = ''){
        $warehouse_id  = $this->input->post('warehouse_id');
        $values = $this->Android_Model->get_order_payment_list($warehouse_id);
        echo json_encode($values);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
   // unconfiemed function
    function login_old()
    {
        $this->load->model('User_Model');
        $incomingContentType = $_SERVER['CONTENT_TYPE'];
        if ($_SERVER['CONTENT_TYPE'] !== "application/json" && $_SERVER['CONTENT_TYPE'] !== "application/json; charset=utf-8") {
            header($_SERVER['SERVER_PROTOCOL'] . '500 Internal Server Error');
            exit();
        }
        $_POST = json_decode(file_get_contents("php://input"), true);
        $this->load->library('form_validation');
        $this->form_validation->set_rules('username', 'Username', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                "status" => 0,
                "msg" => validation_errors()
            );
            echo json_encode($st);
        } else {
            $user_username = $this->input->post('username');
            $password      = $this->input->post('password');
            $user_id       = $this->User_Model->login($user_username, $password);
            if ($user_id) {
                $data['user_details'] = $this->User_Model->get_user_info($user_id);
                $ss_user_username     = $data['user_details']['user_username'];
                $ss_user_id           = $data['user_details']['user_id'];
                $ss_group_id          = $data['user_details']['group_id'];
                $ss_warehouse_id      = $data['user_details']['warehouse_id'];
                $ss_user_first_name   = $data['user_details']['user_first_name'];
                $ss_user_last_name    = $data['user_details']['user_last_name'];
                $ss_user_group_name   = $data['user_details']['user_group_name'];
                $sesdata              = array(
                    'ss_user_username' => $ss_user_username,
                    'ss_user_id' => $ss_user_id,
                    'ss_group_id' => $ss_group_id,
                    'ss_warehouse_id' => $ss_warehouse_id,
                    'ss_user_first_name' => $ss_user_first_name,
                    'ss_user_last_name' => $ss_user_last_name,
                    'ss_user_group_name' => $ss_user_group_name
                );
                $this->User_Model->create_user_sessions($sesdata);
                $st = array(
                    "status" => 1,
                    "msg" => "Done!",
                    "session" => $this->session->userdata
                );
                $this->api_model->add_session("");
                echo json_encode($st);
            } else {
                $st = array(
                    "status" => 0,
                    "msg" => "Invalid username or password!",
                    "err_code" => "ipasop202-a"
                );
                echo json_encode($st);
            }
        }
    }
    function logout()
    {
        $sesdata = array(
            'ss_user_username' => '',
            'ss_user_id' => '',
            'ss_group_id' => '',
            'ss_warehouse_id' => '',
            'ss_user_first_name' => '',
            'ss_user_last_name' => '',
            'ss_user_group_name' => ''
        );
        $this->common_model->add_user_activitie("Logout User");
        $this->session->unset_userdata($sesdata);
        $st = array(
            'status' => 1,
            'msg' => "Logged out successfully!"
        );
        echo json_encode($st);
    }
    function get_cus_like()
    {
        $srh_term = $this->input->post('suggestion');
        $result   = $this->customer_model->get_search_customer($srh_term);
        echo json_encode(array(
            "status" => 1,
            "msg" => "Success",
            "suggetions" => $result
        ));
    }
    function get_categories()
    {
        $this->load->model('category_models');
        $cats = $this->category_models->getCategory();
        $data = array();
        foreach ($cats as $key => $row) {
            $nestedData                   = array();
            $nestedData['app_cat_id']     = $row->cat_id + 0;
            $nestedData['app_cat_name']   = $row->cat_name;
            $nestedData['app_cat_image']  = $row->cat_image;
            $nestedData['app_cat_status'] = $row->cat_status + 0;
            $data[]                       = $nestedData;
        }
        echo json_encode(array(
            "status" => 1,
            "msg" => "Success",
            "categories" => $data
        ));
    }
    function get_products($category_id = "")
    {
        $category_id = $this->input->post('category_id');
        $out_cat     = '';
        $out_sub     = '';
        $d           = $this->api_model->get_product_by_cat_id($category_id);
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                $d[$key]->product_thumb = asset_url() . 'uploads/thumbs/' . $d[$key]->product_thumb;
                $d[$key]->product_image = asset_url() . 'uploads/' . $d[$key]->product_image;
                $d[$key]->product_id    = $d[$key]->product_id + 0;
                $d[$key]->product_price = $d[$key]->product_price + 0;
                $d[$key]->cat_id        = $d[$key]->cat_id + 0;
                $d[$key]->sub_cat_id    = $d[$key]->sub_cat_id + 0;
                $d[$key]->min_order_qty = $d[$key]->min_order_qty + 0;
                $d[$key]->is_kot = $d[$key]->is_kot + 0;
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "products_of_cat" => $d
            ));
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: ipasop403-i)",
                "products_of_cat" => $jproduct
            ));
        }
    }
    function get_product_info()
    {
        $product_id = $this->input->post('product_id');
        $out_cat    = '';
        $out_sub    = '';
        $d          = $this->api_model->get_product_by_product_id($product_id);
        if (!empty($d)) {
            $d['product_thumb'] = asset_url() . 'uploads/thumbs/' . $d['product_thumb'];
            $d['product_image'] = asset_url() . 'uploads/' . $d['product_image'];
            $d['product_id']    = $d['product_id'] + 0;
            $d['product_price'] = $d['product_price'] + 0;
            $d['cat_id']        = $d['cat_id'] + 0;
            $d['sub_cat_id']    = $d['sub_cat_id'] + 0;
            $d['min_order_qty'] = $d['min_order_qty'] + 0;
            $d['sizes']         = json_decode("{}");
            $sizes              = $this->api_model->get_product_sizes_by_product_id($product_id);
            if (!empty($sizes)) {
                $d['sizes'] = $sizes;
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "product_info" => $d
            ));
        } else {
            $jproduct = array();
            $ret      = json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: ipasop404-i)",
                "product_info" => json_decode("{}")
            ));
            echo $ret;
        }
    }
    function get_area_like()
    {
        $cname      = $this->input->post('suggestion');
        $country_id = 251;
        $result     = $this->common_model->search_city_by_name_and_country_id($cname, $country_id);
        echo json_encode(array(
            "status" => 1,
            "msg" => "Success",
            "areas" => $result
        ));
    }
    function save_customer()
    {
        $msg          = "";
        $status       = 0;
        $returndata   = "";
        $cus_name     = $this->input->post('cus_name');
        $cus_phone    = $this->input->post('cus_phone');
        $cus_email    = $this->input->post('cus_email');
        $home_address = $this->input->post('home_address');
        $type         = $this->input->post('type');
        $cus_id       = intval($this->input->post('cus_id'));
        $this->load->library('form_validation');
        if ($type == 'A') {
            $_POST['cus_phone'] = $this->format_phone($this->input->post('cus_phone'));
            $this->form_validation->set_rules('cus_name', 'Name', 'required');
            $this->form_validation->set_rules('cus_phone', 'Phone', 'required|is_unique[customer.cus_phone]');
            $this->form_validation->set_rules('cus_email', 'Email', 'required');
            $this->form_validation->set_rules('home_address', 'Home Address', 'required');
        } else if ($type == 'E') {
            $this->form_validation->set_rules('cus_name', 'Name', 'required');
            $this->form_validation->set_rules('cus_email', 'Email', 'required');
            $this->form_validation->set_rules('home_address', 'Home Address', 'required');
        }
        if (!filter_var($cus_email, FILTER_VALIDATE_EMAIL)) {
            $status = 0;
            $msg    = "Invalid email format. (Error code: ipasop300-v)";
        } else if ($this->form_validation->run() == FALSE) {
            $status = 0;
            $msg    = validation_errors();
        } else {
            $cusdata = "";
            if ($type == 'A') {
                $cus_code = $this->Common_Model->gen_ref_number('cus_id', 'customer', 'CUS/');
                $cusdata  = array(
                    'cus_name' => $cus_name,
                    'cus_code' => $cus_code,
                    'cus_email' => $cus_email,
                    'cus_address' => $home_address,
                    'cus_phone' => $cus_phone,
                    'country_id' => "251"
                );
            }
            if ($type == 'E') {
                $cusdata = array(
                    'cus_name' => $cus_name,
                    'cus_email' => $cus_email,
                    'cus_address' => $home_address
                );
            }
            $result = $this->Customer_Model->save_customer($cusdata, $cus_id);
            if ($type == 'A') {
                $lastid = $this->db->insert_id();
                if ($lastid) {
                    $returndata = array(
                        'cus_id' => $lastid,
                        'type' => $type,
                        'cus_email' => $cus_email,
                        'cus_status' => 1,
                        'cus_name' => $cus_name,
                        'cus_address' => $home_address,
                        'cus_phone' => $cus_phone
                    );
                } else {
                    $returndata = array();
                    $status     = 0;
                    $msg        = "Failed! (Error code: ipasop402-i)";
                }
            } else if ($type == 'E') {
                $returndata = array(
                    'cus_id' => $cus_id,
                    'type' => $type,
                    'cus_email' => $cus_email,
                    'cus_status' => 1,
                    'cus_name' => $cus_name,
                    'cus_address' => $home_address,
                    'cus_phone' => $cus_phone
                );
                $status     = 1;
                $msg        = "Updated successfully!";
            }
        }
        echo json_encode(array(
            "status" => $status,
            "msg" => $msg,
            "cus_data" => $returndata
        ));
    }
    function save_sale()
    {
        $this->load->model('app_model');
        $txt_msg                  = "";
        $status                   = 0;
        $msg                      = "Failed";
        $warn                     = "";
        $return_data              = array();
        $sale_id                  = $this->input->post('sale_id');
        $customer_id              = $this->input->post('cus_id');
        $warehouse_id             = $this->input->post('warehouse_id');
        $sale_date                = date('Y-m-d H:i:s', strtotime($this->input->post('sale_datetime')));
        $dine_type                = $this->input->post('dine_type');
        $discount                 = $this->input->post('discount');
        $discount_amount          = $this->input->post('discount_amount');
        $extra_charges            = $this->input->post('extra_charges');// more_cheese, more_sugar, service_charges
        $extra_charges_amount     = $this->input->post('extra_charges_amount');
        $grand_total              = $this->input->post('grand_total');
        $pay_amount               = $this->input->post('pay_amount');
        $paid_by                  = $this->input->post('paid_by');
        $sale_pymnt_balane_amount = $this->input->post('change');
        $sale_note                = $this->input->post('sale_note');
        $shipping_address         = $this->input->post('delivery_address');
        $shipping_date_time       = $this->input->post('delivery_date_time');
        $delivery_charges         = $this->input->post('delivery_charges');
        $sale_ref                 = $this->input->post('sale_reference_no');
        $table_id                 = $this->input->post('table_id');
        if (!$sale_ref) {
            $query    = $this->api_model->get_next_ref_no();
            $result   = $query->row();
            $sale_ref = sprintf("%05d", $result->sale_id + 1);
            //$sale_ref = '(' . date('d') . ')-' . $sale_ref;
        }
        if($dine_type == 1){
            $extra_charges = "10%";
            $extra_charges_amount = $grand_total/100*10;
            //remove charge from invoice as request by gihan on 2023-11-21
            $extra_charges_amount=0;
            //$grand_total = $grand_total*1.1;
        }else{
            $extra_charges = "";
            $extra_charges_amount = 0;
        }
        $products   = $this->input->post('products');
        $sales_data = array(
            'sale_id' => $sale_id,
            'sale_reference_no' => $sale_ref,
            'warehouse_id' => $warehouse_id,
            'customer_id' => $customer_id,
            'sale_datetime' => $sale_date,
            'invoice_type' => 5,
            'sale_type' => "android_pos_sale",
            'sale_note' => $sale_note,
            'sale_total' => $grand_total,
            'sale_status'=> 0,
            'sale_inv_discount' => $discount,
            'sale_inv_discount_amount' => $discount_amount,
            'sale_datetime_created' => $sale_date,
            'sale_shipping' => $delivery_charges,
            'shipping_address' => $shipping_address,
            'dine_type' => $dine_type,
            'sale_extra_charges' => $extra_charges,
            'sale_extra_charges_amount' => $extra_charges_amount,
            'user' => 1,
            'table_id' => $table_id
        );
        $sale_id    = $this->api_model->save_sale_header($sales_data, $sale_id);
        if ($sale_id) {
            for ($i = 0; $i < count($products); $i++) {
                if (!isset($products[$i]['product_id']))
                    continue;
                $item_details  = $this->app_model->get_product_details_by_id($products[$i]['product_id']);
                $selling_price = $item_details['product_price'];
                $size_id       = 0;
                if (isset($products[$i]['size_id'])) {
                    if ($products[$i]['size_id']) {
                        $size_price = $this->app_model->get_price_by_size_id($products[$i]['size_id']);
                        if ($size_price->size_price) {
                            $size_id       = $products[$i]['size_id'];
                            $selling_price = $size_price->size_price;
                            $product_name .= "-" . $size_price->size_name;
                        }
                    }
                }
                $error     = 0;
                $tmpDisVal = 0;
                $discount  = "";
                if (isset($products[$i]['discount']))
                    $discount = $products[$i]['discount'];
                $discount_value = 0;
                if ($discount) {
                    if (strpos($discount, "%") !== false) {
                        $pds = explode("%", $discount);
                        if (!is_nan($pds[0])) {
                            $selling_price  = $selling_price - ($selling_price * $pds[0] / 100);
                            $discount_value = $selling_price * $pds[0] / 100;
                        } else {
                            $error = 1;
                        }
                    } else {
                        if (!is_nan($discount)) {
                            $selling_price  = $selling_price - $discount;
                            $discount_value = $discount;
                        } else {
                            $error = 1;
                        }
                    }
                }
                $print_status = 0;
                if(isset($products[$i]['print_status']))
                    $print_status = $products[$i]['print_status'];
                
                $data_item = array(
                    'sale_id' => $sale_id,
                    'product_id' => $products[$i]['product_id'],
                    'size_id' => $size_id,
                    'product_name' => $item_details['product_name'],
                    'product_code' => $item_details['product_code'],
                    'quantity' => $products[$i]['qty'],
                    'print_status' => $print_status,
                    'unit_price' => $selling_price,
                    'item_cost' => $item_details['product_cost'],
                    'gross_total' => $selling_price * $products[$i]['qty'],
                    'discount' => $discount,
                    'discount_val' => $discount_value
                );
                
                $txt_msg .= "  *" . $item_details['product_name'] . "-" . $products[$i]['qty'] . "\n";
                $result = $this->api_model->sale_items_in($data_item);
            }
            $total_paid = 0;
            $payments = array();
                if($this->input->post('payments'))
                    $payments = $this->input->post('payments');
            for ($i = 0; $i < count($payments); $i++) {
                if (!isset($payments[$i]['type']))
                    continue;
                if (!isset($payments[$i]['pay_amount']))
                    continue;
                $paid_by                   = $payments[$i]['type'];
                $pay_amount                = $payments[$i]['pay_amount'];
                $sale_pymnt_given_amount   = ($payments[$i]['given_amount']) ? $payments[$i]['given_amount'] : 0;
                $sale_pymnt_balance_amount = ($payments[$i]['change']) ? $payments[$i]['change'] : 0;
                $pymnt_data                = array(
                    'sale_id' => $sale_id,
                    'sale_pymnt_paying_by' => $paid_by,
                    'sale_pymnt_amount' => $pay_amount,
                    'sale_pymnt_date_time' => $sale_date,
                    'sale_pymnt_added_date_time' => $sale_date,
                    'sale_payment_type' => "sale",
                    'sale_pymnt_given_amount' => $sale_pymnt_given_amount,
                    'sale_pymnt_balance_amount' => $sale_pymnt_balance_amount,
                    'user_id' => $this->session->userdata('ss_user_id')
                );
                $t                         = $this->api_model->sales_payment($pymnt_data);
                if($t)$total_paid += $pay_amount;
            }
            if($total_paid >= $grand_total){
                $this->api_model->complete_sale($sale_id);
            }
            $status = 1;
            $msg = "Success";
            $return_data['sale_id'] = $sale_id;
            $return_data['sale_ref_no'] = $sale_ref;
            // $return_data['sale_status'] = $sale_ref;
        }
        echo json_encode(array(
            "status" => $status,
            "msg" => $msg,
            "sale_data" => $return_data
        ));
    }
    function is_api_logged_in($session_id)
    {
        $logged_in = false;
        $ss_data   =1;// $this->api_model->get_session($session_id);
        if ($ss_data) {
            $logged_in = true;
        }
        return $logged_in;
    }
    /*PAYCORP*/
    function paycorp_view(){
        $data = array();
        //$_POST = json_decode(file_get_contents("php://input"), true);
        
        $amount = $this->input->get('amount');
        $sale_ref = $this->input->get('sale_reference_no');
        
        $amount = base64_decode($amount);
        $sale_ref = base64_decode($sale_ref);
        
        
        
        //$amount = $this->input->get('amount');
        //$sale_ref = $this->input->get('sale_reference_no');
        
        if($amount == "" && $sale_ref == "")
        {
            echo json_encode(array(
                "status" => 0,
                "msg" => "Missing Required data!"
            ));
            exit;
        }else if(!$amount > 0){
            echo json_encode(array(
                "status" => 0,
                "msg" => "Invalid amount!"
            ));
            exit;
        }
        // MTAwMA==
        $data['paymentAmount'] = $amount;
        $data['clientRef'] = $sale_ref;
        $data['comment'] = "";
        $data['returnUrl'] = base_url();
        
        $this->load->view("paycorp/view",$data);
    }
    function table_list(){
        $data = array();
        for($table_id = 1; $table_id <= 50; $table_id++ ){
            $nestedData                   = array();
            $nestedData['table_id']       = $table_id;
            $nestedData['table_name']     = "Table ".$table_id;
            $data[]                       = $nestedData;
        }
        echo json_encode(array(
            "status" => 1,
            "msg" => "Success",
            "valies" => $data
        ));
    }
    function list_sales()
    {
        $dine_type      = $this->input->post('dine_type');
        $d              = $this->api_model->get_all_sales($dine_type);
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                /*$d[$key]->product_thumb = asset_url() . 'uploads/thumbs/' . $d[$key]->product_thumb;
                $d[$key]->product_image = asset_url() . 'uploads/' . $d[$key]->product_image;
                $d[$key]->product_id    = $d[$key]->product_id + 0;
                $d[$key]->product_price = $d[$key]->product_price + 0;
                $d[$key]->cat_id        = $d[$key]->cat_id + 0;
                $d[$key]->sub_cat_id    = $d[$key]->sub_cat_id + 0;
                */
                
                $d[$key]->table_name = "Table ".$d[$key]->table_id;
                $d[$key]->sale_items = $this->api_model->get_sale_items_by_sale_id($row->sale_id);
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "sales" => $d
            ));
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: ipasop403-i)",
                "sales" => $jproduct
            ));
        }
    }
    function check_juice(){
        $success = 0;
        $sale_id = 0;
        $cat_id             = $this->input->post('cat_id');
        $sale_data = $this->api_model->check_juices($cat_id);
        if(!empty($sale_data)){
            foreach ($sale_data as $key => $row) {
                $sale_data[$key]->sale_items = $this->api_model->get_sale_items_by_sale_id_n_cat($row->sale_id,$cat_id);
            }
            $success = 1;
        }
        echo json_encode(array(
            "status"=> $success,
            "sale_ids"=> $sale_data
        ));
    }
    
    
    function list_sales_by_date()
    {
        $date                = date('Y-m-d', strtotime($this->input->post('date'))); 
        $d              = $this->api_model->get_all_sales_by_date($date);
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                $d[$key]->sale_id = $d[$key]->sale_id+0;
                $d[$key]->sale_reference_no = $d[$key]->sale_reference_no;
                $d[$key]->sale_total = $d[$key]->sale_total;
                $d[$key]->dine_type = $d[$key]->dine_type+0;
                $d[$key]->sale_extra_charges_amount = $d[$key]->sale_extra_charges_amount;
                $d[$key]->total_cash_payment=$d[$key]->sale_total;
                $d[$key]->total_cc_payment=0;
                $d[$key]->total_other_payment=0;
                $d[$key]->sale_list=$this->api_model->get_sale_items_by_sale_id($d[$key]->sale_id);
               
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "sales" => $d
            ));
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: ipasop403-i)",
                "sales" => $jproduct
            ));
        }
    }
    
    function list_sales_items_by_date()
    {
        $date   = date('Y-m-d', strtotime($this->input->post('date'))); 
        $d      = $this->api_model->get_all_sales_items_by_date($date);
        if (!empty($d)) {
            foreach ($d as $key => $row) {
                $d[$key]->sale_id = $d[$key]->sale_id+0;
                $d[$key]->product_id = $d[$key]->product_id+0;
                $d[$key]->product_code = $d[$key]->product_code;
                $d[$key]->quantity = $d[$key]->quantity+0;
                $d[$key]->unit_price = $d[$key]->unit_price+0;
                $d[$key]->item_cost=$d[$key]->item_cost+0;
                $d[$key]->gross_total=$d[$key]->gross_total+0;
                $d[$key]->item_cost=$d[$key]->item_cost+0;
            }
            echo json_encode(array(
                "status" => 1,
                "msg" => "Success",
                "sales" => $d
            ));
        } else {
            $jproduct = array();
            echo json_encode(array(
                "status" => 0,
                "msg" => "Failed. (Error code: ipasop403-i)",
                "sales" => $jproduct
            ));
        }
    }
    
    
   
}