<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Android_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_product_list(){
	    $this->db->select('p.*');	
	    $this->db->from('product p');
	    $this->db->where("p.product_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_category_list(){
	    $this->db->select('p.*');	
	    $this->db->from('product_category p');
	    $this->db->where("p.cat_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_sale_type_list(){
	    $this->db->select('p.*');	
	    $this->db->from('master_invoice_type p');
	    $this->db->where("p.status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_price_type_list(){
	    $this->db->select('p.*');	
	    $this->db->from('master_price_type p');
	    $this->db->where("p.pri_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_payment_type_list(){
	    $this->db->select('p.*');	
	    $this->db->from('mstr_payment_type p');
	    $this->db->where("p.p_type_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_transaction_type_list(){
	    $this->db->select('p.*');	
	    $this->db->from('fixed_asset p');
	    $this->db->where("p.fxd_ass_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_expencess_type_list(){
	    $this->db->select('p.*');	
	    $this->db->from('mstr_expences_type p');
	    $this->db->where("p.etp_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	
	
	function get_customer_list($warehouse_id){
	    $this->db->select('p.*');	
	    $this->db->from('customer p');
	    if($warehouse_id){
	    $this->db->where("p.cus_warehouse_id",$warehouse_id);
	    }
	    $this->db->where("p.cus_credit_status",1);
	    $this->db->where("p.cus_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_warehouse_list(){
	    $this->db->select('p.*');	
	    $this->db->from('warehouses p');
	    $this->db->where("p.status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_product_batch_list(){
	    $this->db->select('p.*');	
	    $this->db->from('batch_product p');
	    $this->db->where("p.batch_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
  
  
  function get_order_list($warehouse_id=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,d.dpn_ref_no,d.added_date_time AS dpn_date_time,d.pickup_status,d.pickup_date_time,d.invoice_status,d.invoice_on");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
       	$this->db->select('s.sale_reference_no,s.sale_id');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->join('dispatch_note_master d', 'd.order_id = o.odr_id', 'left');
        $this->db->join('sales s', 's.card_ref_number = d.dpn_ref_no', 'left');
        if($warehouse_id){
              $this->db->where('o.odr_warehouse_id',$warehouse_id);  
        }
		$this->db->order_by("o.odr_id", "desc");
        $query = $this->db->get();
        return $query->result();
    }
  
    function get_order_product_list($id=''){
	    $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.product_weight");
        $this->db->from('order_items o');
        $this->db->join("order_master om", "om.odr_id = o.odr_id", "inner");
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        if($id){
        $this->db->where('om.odr_warehouse_id',$id);
        }
        $this->db->order_by('o.odr_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	
	function get_order_payment_list($id=''){
	    $this->db->select("o.*");
        $this->db->from('sale_multiple_payment o');
        $this->db->join("order_master om", "om.odr_id = o.adv_document_id", "inner");
        if($id){
        $this->db->where('om.odr_warehouse_id',$id);
        }
        //$this->db->order_by('o.odr_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  //unconfiermd function
    
    function get_user_active_delivery($user_id){
         $this->db->select('*');
	    $this->db->from('delivery_master o');
	    $this->db->where("o.d_status",2);
	    $this->db->where("o.driver_id",$user_id);
		$query = $this->db->get();
		return $query->row_array();
        
    }
   
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');		
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_type","normal");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function order_price_type(){
	    $this->db->select('*');		
		$query = $this->db->get('order_price_type');
		return $query->result_array();
	}
	
	
	function peyment_term(){
	    $this->db->select('pay_term_id,pay_term_name,pay_term_in_days');		
		$query = $this->db->get('master_payment_term');
		return $query->result_array();
	}
	
	
	function get_validated_product_batch_list(){
	    $this->db->select('b.*');
	    $this->db->from('batch_product b');
	    $this->db->join('product p','p.product_id=b.product_id','inner');
	    $this->db->where("b.batch_status",1);
	    $this->db->where("p.is_batch_validate",1);
	    $this->db->where("p.product_status",1);
	    $this->db->group_by('b.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}


	
   function save_log_android_transaction ($data)
   {
	 $result=$this->db->insert('log_android',$data);
	 return  $result;	   
   }
   
   function save_transaction_log ($data)
   {
	 $result=$this->db->insert('transaction_log',$data);
	 return  $result;	   
   }
   function save_visitlocation_log ($data)
   {
	 $result=$this->db->insert('visit_location',$data);
	 return  $result;	   
   }
     public function get_registered_device($user_id,$device_id,$code)
	{
	    $this->db->select('m.mr_id,m.activation_status');  
		$this->db->from('mobile_register m');
		$this->db->where("m.activation_code",$code);	
		$this->db->where("m.device_id",$device_id);
		$this->db->where("m.user_id",$user_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	function save_activation_code($data)
	{
		return $this->db->insert('mobile_register',$data);
	}
	function save_sales($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_master',$data);
	}
	function save_sales_item($data)
	{
		return $this->db->insert('mobile_invoice_data_backup_item',$data);
	}
	function save_backup_payment($data)
	{
		return $this->db->insert('mobile_payment_backup_master',$data);
	}
	function save_backup_payment_items($data)
	{
		return $this->db->insert('mobile_payment_backup_item',$data);
	}

    function get_pending_order_list($user_id='',$date=''){
	    $this->db->select('o.*,c.cus_name,c.cus_code');
	    $this->db->from('order_master o');
	    $this->db->join('customer c','c.cus_id=o.odr_customer_id','inner');
	    $this->db->where("o.odr_status",1);
	   // $this->db->where("o.pickup_status",0);
	    // $this->db->where("o.odr_approval_status",1);
	    if($user_id){
	     $this->db->where("o.odr_sale_rep_id ",$user_id);
	    }
	     if($date){
	         $this->db->where("date(o.added_date_time)",$date);
	     }
		$query = $this->db->get();
		return $query->result_array();
	}
	
		function get_delivery_product_list($delivery_id){
	    $this->db->select('p.*,dni.*');	
	    $this->db->from('dispatch_note_item dni');
	      $this->db->join('dispatch_note_master dnm','dni.dnm_id=dnm.dpn_id','inner');
	      $this->db->join('product p','p.product_id=dni.product_id','inner');
	      $this->db->where("dnm.delivery_id",$delivery_id);
	      $this->db->group_by('dni.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}
   
   function get_currant_delivery($user_id){
         $this->db->select('dnm.delivery_id,dnm.dpn_id');
          $this->db->from('dispatch_note_master dnm');
         $this->db->join('delivery_master o','o.d_id=dnm.delivery_id','inner');
	    $this->db->where("o.d_status",2);
	    $this->db->where("o.driver_id",$user_id);
	    $this->db->order_by('o.d_id','asc');
		$query = $this->db->get();
		return $query->row_array();
        
    }
    
function get_company_product_batch_list(){
	    $this->db->select('bp.*,p.excchange_id');	
	    $this->db->from('batch_product bp');
	      $this->db->group_by('bp.product_id');
	      $this->db->join('product p','p.product_id=bp.product_id','inner');
		$query = $this->db->get();
		return $query->result_array();
	}
   
   
}