<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Cash_Balance_Model extends CI_Model
{
    private $mastertableName = 'cashier_float_master';
    private $itemtableName = 'cashier_float_item';
    function __construct()
    {
        /* Call the Model constructor */
        parent::__construct();
    }
    function save_cashier_float_master($data)
    {
        $this->db->insert($this->mastertableName, $data);
        return $this->db->insert_id();
    }
    function save_cashier_float_item($data)
    {
        return $this->db->insert($this->itemtableName, $data);
    }
    function update_cashier_float_master($data, $id)
    {
        if ($id > 0) {
            $this->db->where('c_float_mstr_id', $id);
            return $this->db->update($this->mastertableName, $data);
        } else {
            return false;
        }
    }
    public function get_chashier_foat_full_details($id)
    {
        $this->db->select('cm.*,u.user_first_name,ug.user_group_name,w.*');
        $this->db->from('cashier_float_master cm');
        $this->db->join('user u', 'cm.user_id = u.user_id', 'left');
        $this->db->join('user_group ug', 'u.group_id = ug.user_group_id ', 'left');
        $this->db->join('warehouses w', 'cm.warehouse_id = w.id', 'left');
        $this->db->where("cm.c_float_mstr_id", $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function get_chashier_foat_items_details($id)
    {
        $this->db->select('cmi.*');
        $this->db->from('cashier_float_item cmi');
        $this->db->where("cmi.c_float_mstr_id", $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_float_payment_total($id = '', $payment_type = '', $card_type = "")
    {
        $this->db->select_sum('p.sale_pymnt_amount');
        $this->db->from('sale_payments p');
        $this->db->where("p.sale_payment_type", "sale");
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        if ($payment_type) {
            $this->db->where("p.sale_pymnt_paying_by", $payment_type);
        }
        if ($card_type) {
            $this->db->where("p.sale_pymnt_crdt_card_type", $card_type);
        }
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['sale_pymnt_amount'])) {
            return $result['sale_pymnt_amount'];
        } else {
            return 0;
        }
    }
    function get_float_retail_sale_total($id = '')
    {
        $this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
        if ($id) {
            $this->db->where("s.float_id", $id);
        }
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['sale_total'])) {
            return $result['sale_total'];
        } else {
            return 0;
        }
    }
    function get_expencess_total($id = '')
    {
        $this->db->select_sum('p.acctrnss_amount');
        $this->db->from('acc_transactions p');
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        $this->db->where("p.fxd_ass_id", 5);
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['acctrnss_amount'])) {
            return $result['acctrnss_amount'];
        } else {
            return 0;
        }
    }
    function get_tranfer_pettycash_total($id = '')
    {
        $this->db->select_sum('p.acctrnss_amount');
        $this->db->from('acc_transactions p');
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        $this->db->where("p.fxd_ass_id", 1);
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['acctrnss_amount'])) {
            return $result['acctrnss_amount'];
        } else {
            return 0;
        }
    }
    function get_withdrowal_total($id = '')
    {
        $this->db->select_sum('p.acctrnss_amount');
        $this->db->from('acc_transactions p');
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        $this->db->where("p.fxd_ass_id", 6);
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['acctrnss_amount'])) {
            return $result['acctrnss_amount'];
        } else {
            return 0;
        }
    }
    function get_withdrowal_list($id = '')
    {
        $this->db->select('p.*');
        $this->db->from('acc_transactions p');
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        $this->db->where("p.fxd_ass_id", 6);
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_float_payment_return_total($id = '', $payment_type = '')
    {
        $this->db->select_sum('p.sale_pymnt_amount');
        $this->db->from('sale_payments p');
        $this->db->where("p.sale_payment_type", "hw_sales_return");
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        if ($payment_type) {
            $this->db->where("p.sale_pymnt_paying_by", $payment_type);
        }
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['sale_pymnt_amount'])) {
            return $result['sale_pymnt_amount'];
        } else {
            return 0;
        }
    }
    function get_float_return_retail_sale_total($id = '')
    {
        $this->db->select_sum('s.sl_rtn_total');
        $this->db->from('sales_return s');
        if ($id) {
            $this->db->where("s.float_id", $id);
        }
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['sl_rtn_total'])) {
            return $result['sl_rtn_total'];
        } else {
            return 0;
        }
    }
    function duplicate_m($id = '')
    {
        $q;
        $this->db->select('count(*) as cnt');
        $this->db->select('sale_reference_no,card_ref_number,sale_total');
        if ($id) {
            $this->db->where('float_id', $id);
        }
        $this->db->group_by(array(
            "card_ref_number"
        ));
        $this->db->having("cnt > 1", null, false);
        $this->db->limit(10000000);
        $q = $this->db->get("sales");
        return $q->result();
    }
    
    
    
    
    
    function get_float_discount_total($id = '')
    {
        $this->db->select_sum('si.extra_discount');
        $this->db->from('sale_items si');
        $this->db->join('sales s','s.sale_id=si.sale_id','inner');
        
        if ($id) {
            $this->db->where("s.float_id", $id);
        }
        $this->db->group_by("s.float_id");
        $query  = $this->db->get();
        
        $result = $query->row_array();
        if (isset($result['extra_discount'])) {
            return $result['extra_discount'];
        } else {
            return 0;
        }
    }
    
    //new implimentation with multiple payment 2023-02-15 sachith eranga
      function get_float_multiple_payment_total($id = '', $payment_type = '', $card_type = "")
    {
        $this->db->select_sum('p.smp_amount');
        $this->db->from('sale_multiple_payment p');
       // $this->db->where("p.bussiness_type", 2);
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        if ($payment_type) {
            $this->db->where("p.payment_type", $payment_type);
        }
        if ($card_type) {
            $this->db->where("p.credit_card_type", $card_type);
        }
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['smp_amount'])) {
            return $result['smp_amount'];
        } else {
            return 0;
        }
    }
    
      function get_float_advance_multiple_payment_total($id = '', $payment_type = '')
    {
        $this->db->select_sum('p.smp_amount');
        $this->db->from('sale_multiple_payment p');
      // $this->db->where("p.bussiness_type", 2);
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        if ($payment_type) {
            $this->db->where("p.payment_type", $payment_type);
        }
            $this->db->where("p.is_advance_payment", 1);
      
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['smp_amount'])) {
            return $result['smp_amount'];
        } else {
            return 0;
        }
    }
    
     function get_withdrowal_total_by_type($id = '',$type='')
    {
        $this->db->select_sum('p.acctrnss_amount');
        $this->db->from('acc_transactions p');
        if ($id) {
            $this->db->where("p.float_id", $id);
        }
        $this->db->where("p.fxd_ass_id", 6);
        $this->db->where("p.pay_methord", $type);
        $query  = $this->db->get();
        $result = $query->row_array();
        if (isset($result['acctrnss_amount'])) {
            return $result['acctrnss_amount'];
        } else {
            return 0;
        }
    }
    
    
}