<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('core_model.php');
class Dispatch_Model extends Core_Model {
 
  public $table_config=array(
      'mater_table'=>'dispatch_note_master',
      'master_table_primary_id'=>'dpn_id',
      'master_table_seconrary_id'=>'order_id',
      'item_table'=>'dispatch_note_item',
      'item_table_primary_id'=>'dni_id',
      'item_table_seconrary_id'=>'dnm_id',
      'sub_item_table'=>'dispatch_note_batch',
      'sub_item_table_primary_id'=>'dnb_id',
      'sub_item_table_seconrary_id'=>'dni_id',
      );
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct($this->table_config);
  }

	function save_dispach_note($data)
	{
		return $this->save_master_table($data);
	}
	function save_dispach_note_item($data)
	{
		return $this->save_item_table($data);
	}
	function get_list_dispach_note() {
	    return $this->get_result_mater_record_data();
	}
	public function get_row_order_info($id)
	 {
	     return $this->get_row_array_mater_record_data_by_primary_id($id);
	 }
	public function delete_dispach_note($id)
	{
	    return $this->delete_master_table_by_primary_id($id);
	}
	public function delete_dispach_note_item($id)
	{
	    return $this->delete_item_table_by_primary_id($id);
	}
	public function update_dispach_note_master($id,$data)
	{
		return  $this->update_master_table_by_primary_id($id,$data);
	}
	function update_dispach_note_item($id,$data){
	    	return  $this->update_item_table_by_primary_id($id,$data);
	}
	
	function get_dispatch_list($start, $length, $search_key_val)
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('dispatch_note_master o');
        $this->db->join("customer c", "c.cus_id = o.dpn_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.dpn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.dpn_warehouse_id", "inner");
        if ($search_key_val) {
             $this->db->where("o.dpn_type_id = 2 AND o.dpn_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("o.dpn_type_id = 2 AND c.cus_name LIKE '$search_key_val%'");
             $this->db->or_where("o.dpn_type_id = 2 AND c.cus_code LIKE '$search_key_val%'");
        }else{
            $this->db->where("o.dpn_type_id",2);
        }
		$this->db->order_by("o.dpn_id", "desc");
		$this->db->group_by('o.dpn_id');
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    function get_all_dipatch_details($id)
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,c.cus_phone,c.cus_address,c.cus_email,u.user_first_name,u.user_last_name,w.name,w.email,w.code,w.address,w.phone ,om.odr_ref_no,m.pri_type_name,dm.d_ref_no,v.vehicle_code,u.invoice_name,dm.area_id");
        $this->db->from('dispatch_note_master o');
        $this->db->join("order_master om", "om.odr_id = o.order_id", "inner");
        $this->db->join('master_price_type m', 'm.pri_type_id=o.dpn_price_type_id', 'left');
        $this->db->join("customer c", "c.cus_id = o.dpn_customer_id", "left");
        $this->db->join("user u", "u.user_id = o.dpn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.dpn_warehouse_id", "inner");
        $this->db->join("dispatch_note_item dni", "dni.dnm_id = o.dpn_id", "inner");
        $this->db->join('delivery_master dm', 'dm.d_id=o.delivery_id', 'left');
        $this->db->join('vehicles v', 'v.vehicle_id=dm.vehicle_id', 'left');
        
        $this->db->where("o.dpn_id",$id);
        $this->db->group_by('o.dpn_id');
        $query = $this->db->get();
        return $query->row_array();
    }
    function get_order_dispatch_item_list($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.pr_quantity,p.product_weight,p.product_name_other");
        $this->db->from('dispatch_note_item o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.dnm_id',$id);
        $this->db->order_by('o.dni_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	function get_original_item_data($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.pr_quantity,p.product_weight");
        $this->db->from('splitted_dispatch_note_item o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.dni_id',$id);
        $this->db->order_by('o.dni_id','desc');
        $query = $this->db->get();
        return $query->row_array();
	}
	function get_dispatch_note_total_values($id)
	{
		$this->db->select_sum("p.total_price");
		$this->db->select_sum("p.total_cost");
		$this->db->select_sum("p.total_weight");
        $this->db->from('dispatch_note_item p');
        $this->db->where('p.dnm_id',$id);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['total_cost'])){
            $return_data=array(
                'total_cost'=>$result['total_cost'],
                'total_price'=>$result['total_price'],
                'total_weight'=>$result['total_weight'],
                );
                return $return_data;
        }else{
            $return_data=array(
                'total_cost'=>0,
                'total_price'=>0,
                'total_weight'=>0
                );
                return $return_data;
        }
	}
	function get_loading_unloading_charge(){
	    $this->db->select("o.*");
        $this->db->from('loading_and_unloading_chagers o');
        $this->db->where('o.id',1);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['unit_qty'])&&isset($result['charge'])){
           return $return_data=array('unit_qty'=>$result['unit_qty'],'charge'=>$result['charge']);
        }else{
            return $return_data=array('unit_qty'=>0,'charge'=>0);
        }
	}
	function get_original_master_data($id){
	    $this->db->select("o.*");
        $this->db->from('splitted_dispatch_note_master o');
        $this->db->where('o.dpn_id',$id);
        $query = $this->db->get();
        return $query->row_array();
	}
	function get_original_item_data_list($id){
	    $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.pr_quantity,p.product_weight");
        $this->db->from('splitted_dispatch_note_item o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.dnm_id',$id);
        $this->db->order_by('o.dni_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	function get_issued_item_data($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.pr_quantity,p.product_weight");
        $this->db->from('dispatch_note_item o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.dni_id',$id);
        $this->db->order_by('o.dni_id','desc');
        $query = $this->db->get();
        return $query->row_array();
	}
	
	function get_issued_item_list_data($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.pr_quantity,p.product_weight");
        $this->db->from('dispatch_note_item o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "left");
        $this->db->where('o.dnm_id',$id);
        $this->db->order_by('o.dni_id','asc');
        $query = $this->db->get();
        return $query->result_array();
	}
	
		function save_invoice_master($data){
	    $this->db->insert('sales',$data);
		 return $this->db->insert_id();
	}
	
	
	
		function get_issued_all_avg_batch_cost($id)
	{
		$this->db->select_sum("p.batch_qty");
		$this->db->select_sum("p.total_cost");
        $this->db->from('dispatch_note_batch p');
        $this->db->where('p.dni_id',$id);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['batch_qty'])){
            return $result['total_cost']/$result['batch_qty'];
        }else{
           return 0;
        }
	}
	
	
	function save_invoice_item($data){
	   return $this->db->insert('sale_items',$data);
		//return $this->db->insert_id();
	}
	
	function save_dispatch_return_batch_item($data){
	   return $this->db->insert('dispatch_note_return_batch',$data);
		//return $this->db->insert_id();
	}
	
	function get_invoice_total_values($id)
	{
		$this->db->select_sum("p.total_item_cost");
		$this->db->select_sum("p.net_total");
		$this->db->select_sum("p.gross_total");
        $this->db->from('sale_items p');
        $this->db->where('p.sale_id',$id);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['total_item_cost'])){
            $return_data=array(
                'total_item_cost'=>$result['total_item_cost'],
                'gross_total'=>$result['gross_total'],
                'net_total'=>$result['net_total'],
                );
                return $return_data;
        }else{
            $return_data=array(
                'total_item_cost'=>0,
                'gross_total'=>0,
                'net_total'=>0
                );
                return $return_data;
        }
	}
	
	
	
	
	
	public function update_sale_master($id,$data)
	{
	     if($id>0){
	   	$this->db->where('sale_id', $id);
		return $this->db->update('sales',$data);
	     }else{
	        return false;
	    }
	}
	
	
	function get_return_item_list($id){
	    $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,p.product_name_other");
        $this->db->from('return_items o');
        $this->db->join("return_master r", "r.rtn_id = o.rtn_id", "inner");
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('r.allocated_dispatch_note',$id);
        $this->db->order_by('o.rtni_id','asc');
        $query = $this->db->get();
        return $query->result_array();
	}
	
	function get_return_master_list($id){
	    $this->db->select("o.*");
        $this->db->from('return_master o');
        $this->db->where('o.allocated_dispatch_note',$id);
        $query = $this->db->get();
        return $query->result_array();
	}
	
	
	function get_issued_batch_order_desc($id){
	     $this->db->select("o.*");
        $this->db->from('dispatch_note_batch o');
        $this->db->where('o.dni_id',$id);
        $this->db->order_by('o.dnb_id','desc');
        $query = $this->db->get();
        return $query->result();
	    
	}
	
	function get_dispatch_note_gross_value($id){
	    $this->db->select("o.total_dpn_price");
        $this->db->from('dispatch_note_master o');
        $this->db->where('o.dpn_id',$id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['total_dpn_price'])){
            return $result['total_dpn_price'];
        }else{
            return 0;
        }
	}
	
	
	 public function delete_dispach_note_master($id)
	{
	    if($id>0){
	       $this->db->where('dpn_id', $id);
		return $this->db->delete('dispatch_note_master'); 
	    }else{
	        return false;
	    }
	}
	
	 public function delete_dispach_note_items($id)
	{
	    if($id>0){
	       $this->db->where('dnm_id', $id);
		return $this->db->delete('dispatch_note_item'); 
	    }else{
	        return false;
	    }
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	public function get_order_info($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "left");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "left");
        
        $this->db->where('o.odr_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	public function get_order_type()
	{
		 $this->db->select("o.*");
        $this->db->from('master_order_type o');
        $this->db->where('o.odr_status',1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	function get_search_order_price_type($search_key_val,$odr_type){
	    $this->db->select("o.*");
        $this->db->from('master_price_type o');
        $this->db->join("order_price_type opt", "opt.pri_type_id = o.pri_type_id", "inner");
        //$this->db->where('opt.odr_type_id',$odr_type);
        $this->db->where("opt.odr_type_id = ".$odr_type."  AND  o.pri_type_name LIKE '%$search_key_val%'");
        $this->db->group_by('o.pri_type_id');
        $query = $this->db->get();
        return $query->result_array();
	}
	
	
	public function get_order_product_price_cost($product_id)
	{
		$this->db->select("p.product_price,p.credit_salling_price,p.wholesale_price,p.product_cost");
        $this->db->from('product p');
        $this->db->where('p.product_id',$product_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	
	function get_order_item_price_cost($id)
	{
		$this->db->select("p.*");
        $this->db->from('order_items p');
        $this->db->where('p.odri_id',$id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	
	
	function get_order_product_list($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where('o.odr_id',$id);
        $this->db->order_by('o.odr_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	
	
		public function get_order_list_pp($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
	}
	
	 function get_order_list($start, $length, $search_key_val)
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.odr_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("c.cus_name LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
	 function get_order_approval_pending_list($start, $length, $search_key_val)
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.odr_approval_status = 0 AND o.odr_status = 1 AND o.odr_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("o.odr_approval_status = 0 AND o.odr_status = 1 AND c.cus_name LIKE '$search_key_val%'");
        }else{
                $this->db->where("o.odr_approval_status = 0 AND o.odr_status = 1");
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    
    function get_order_approved_pending_pickup_list()
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
		
        $query = $this->db->get();
        return $query->result();
    }
    
    function get_order_approved_pending_pickup_item_list(){
       
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
     function get_order_approved_pending_pickup_products(){
       $this->db->select("oi.product_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->group_by('oi.product_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    function save_order_plan($data)
	{
		 $this->db->insert('order_plan_master',$data);
		 return $this->db->insert_id();
	}
	
	 function save_order_plan_item($data)
	{
		 $this->db->insert('order_plan_item',$data);
		 return $this->db->insert_id();
	}
	 function get_order_plan_list($start, $length, $search_key_val)
    {
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where(" p.prm_ref_no LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("p.opm_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
     function get_order_approved_completed_pickup_list($id)
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,opm.opm_approval_status");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_item opi');
        $this->db->join("order_plan_master opm", "opm.opm_id = opi.opm_id", "inner");
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("opi.opm_id",$id);
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    
     public function get_order_approved_completed_pickup_item_list($id){
       
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_plan_item o", "o.order_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where("o.opm_id",$id);
        $this->db->order_by('o.order_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function delete_order_plan_item($id)
	{
	    if($id>0){
	       $this->db->where('order_id', $id);
		return $this->db->delete('order_plan_item'); 
	    }else{
	        return false;
	    }
	}
	
	 public function update_order_plan_master($id,$data)
	{
	     if($id>0){
	   	$this->db->where('opm_id', $id);
		return $this->db->update('order_plan_master',$data);
	     }else{
	        return false;
	    }
	}
	public function get_planned_order_list($id){
	    
	    $this->db->select("o.*");
        $this->db->from('order_plan_item opi');
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->where("opi.opm_id",$id);
       $this->db->group_by("o.odr_id");
        $query = $this->db->get();
        return $query->result_array();
	    
	}
	
	 function get_planned_order_item_list($id){
       
       $this->db->select("oi.*,p.product_price,p.wholesale_price,p.credit_salling_price,p.product_weight,,p.product_cost,o.price_type_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->where("oi.odr_id",$id);
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
	
	
	
	 function get_order_plan_details($id)
    {
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $this->db->where("p.opm_id",$id);
        $query = $this->db->get();
        return $query->row_array();
           
    }
	
}