<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual_Function_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	
	

	public function enable_product($id)
	{
		$data = array(
			'product_status' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function get_invoice_list()
	{		
		$this->db->select('s.*');
		$this->db->from('invoice_upload s');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	public function get_customer_id($code)
	{		
		$this->db->select('s.cus_id');
		$this->db->from('customer s');
		$this->db->where('s.cus_code',$code);
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['cus_id'])){
		    return $result['cus_id'];
		}else{
		    return false;
		}
	}
	public function get_rep_id($code)
	{		
		$this->db->select('s.user_id');
		$this->db->from('user s');
		$this->db->where('s.user_first_name',$code);
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['user_id'])){
		    return $result['user_id'];
		}else{
		    return false;
		}
	}
	function insert_initial_grn($data)
	{
		if ($data)
		{
			$this->db->insert('purchase_items',$data);
			$id = $this->db->insert_id();
			return $id;
		}else{
		    return false;
		}
	}
	
	public function delete_grn_1()
	{
		$this->db->where('purchase_id', 1);
		$this->db->delete('purchase_items');
	}
	
	function get_sale_items(){
	    	$this->db->select('s.*');
		$this->db->from('sale_items s');
		$query = $this->db->get();
		return $query->result_array();
	    
	}
	
	public function update_sale_item_table($id,$data)
	{
		if($id>0){
		    $this->db->where('id', $id);
		    return $this->db->update('sale_items', $data);
		}else{
		    return false;
		}
		
	}
	
	public function get_sale_master_list(){
	    $this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->join('sale_items si','si.sale_id = s.sale_id','inner');
		$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_sale_items_total_cost($sale_id){
	  	$this->db->select_sum('s.total_item_cost');
		$this->db->from('sale_items s');
		$this->db->where('s.sale_id', $sale_id);
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['total_item_cost'])){
		    return $result['total_item_cost'];
		}else{
		    return 0;
		}
	}
	
		public function update_sale_master_table($id,$data)
	{
		if($id>0){
		    $this->db->where('sale_id', $id);
		    return $this->db->update('sales', $data);
		}else{
		    return false;
		}
		
	}
	
	
	function get_cus_master_list(){
	    	$this->db->select('s.*');
		$this->db->from('customer s');
		$this->db->where('route_id', 0);
		$query = $this->db->get();
		return $query->result_array();
	}
	
		public function get_cus_route_id($code)
	{		
		$this->db->select('s.route_id');
		$this->db->from('routes s');
		$this->db->where('s.route_name',$code);
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['route_id'])){
		    return $result['route_id'];
		}else{
		    return false;
		}
	}
	
	public function update_cus_master_table($id,$data)
	{
		if($id>0){
		    $this->db->where('cus_id', $id);
		    return $this->db->update('customer', $data);
		}else{
		    return false;
		}
		
	}
	
		public function get_return_list()
	{		
		$this->db->select('s.*');
		$this->db->from('return_data_import_temp s');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	public function get_uncomplte_multiple_payment()
	{		
		$this->db->select('s.*');
		$this->db->from('sale_multiple_payment s');
		$this->db->where("s.payment_settlement_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	public function close_payment($id)
	{
		if($id>0){
			$data = array(
			'payment_settlement_status' => 1
		);	
		$this->db->where('smp_id', $id);
		$this->db->update('sale_multiple_payment', $data);
		}else{
			return false;
		}		
	}
	
	
	public function get_uncomplte_invoices()
	{		
		$this->db->select('s.sale_id,s.sale_total,s.sale_reference_no,s.card_ref_number');
		$this->db->from('sales s');
		$this->db->where("s.payment_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	function get_total_sale_paid_by_invoice_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.sale_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
		public function get_last_payment_date($id)
	{		
		$this->db->select('s.sale_pymnt_date_time');
		$this->db->from('sale_payments s');
		$this->db->where("s.sale_id", $id);
		$this->db->order_by('s.sale_pymnt_date_time','desc');
		$query = $this->db->get();
		$result= $query->row_array(); 	
		if(isset($result['sale_pymnt_date_time'])){
		    return $result['sale_pymnt_date_time'];
		}else{
		    return false;
		}
	}
		public function close_invoice($id,$date)
	{
		if($id>0){
			$data = array(
			'payment_status' => 1,
			'closed_date'=>$date
		);	
		$this->db->where('sale_id', $id);
		$this->db->update('sales', $data);
		}else{
			return false;
		}		
	}
	
	function get_cus_upload_list(){
	    $this->db->select('s.*');
		$this->db->from('upload_customer s');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function insertRoute($data)
	{
		if ($data)
		{
			$this->db->insert('routes',$data);
			$id = $this->db->insert_id();
			return $id;
		}else{
		    return false;
		}
	}
	
		function insertCustomer($data)
	{
		if ($data)
		{
			$this->db->insert('customer',$data);
			$id = $this->db->insert_id();
			return $id;
		}else{
		    return false;
		}
	}
		public function get_manual_updated_invoices()
	{		
		$this->db->select('s.sale_id,s.sale_total,s.sale_reference_no,s.card_ref_number');
		$this->db->from('sales s');
		//$this->db->where("s.payment_status", 0);
		$this->db->order_by('s.sale_id','asc');
		$this->db->limit(256);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	
}