<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Rep_Order_Management_Model extends CI_Model {
  
  private $tableName = 'Rep_Order_Management_Model';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_order_product_list($from_date='',$to_date=''){
      $this->db->select('ori.product_id,p.product_code,p.product_name');
      $this->db->from('order_request_item ori');
      $this->db->join('order_request_master orm','orm.orm_id=ori.orm_id','inner');
      $this->db->join('product p','p.product_id=ori.product_id','inner');
      if($from_date){
      $this->db->where('orm.order_date >=',$from_date);
      }
      if($to_date){
      $this->db->where('orm.order_date <=',$to_date);
      }
      $this->db->group_by('ori.product_id');
      $query=$this->db->get();
	  return $query->result_array();
  }
 
 
    function get_order_rep_list($from_date='',$to_date=''){
      $this->db->select('orm.orm_rep_id,u.user_first_name');
      $this->db->from('order_request_master orm');
      $this->db->join('user u','u.user_id=orm.orm_rep_id','inner');
      if($from_date){
      $this->db->where('orm.order_date >=',$from_date);
      }
      if($to_date){
      $this->db->where('orm.order_date <=',$to_date);
      }
      $this->db->group_by('orm.orm_rep_id');
      $query=$this->db->get();
	  return $query->result_array();
  }
  
  
  function get_order_rep_item_list($from_date='',$to_date=''){
      $this->db->select('orm.orm_rep_id,ori.product_id,ori.req_qty');
      $this->db->from('order_request_item ori');
      $this->db->join('order_request_master orm','orm.orm_id=ori.orm_id','inner');
      if($from_date){
      $this->db->where('orm.order_date >=',$from_date);
      }
      if($to_date){
      $this->db->where('orm.order_date <=',$to_date);
      }
      $query=$this->db->get();
	  return $query->result_array();
  }
  
  	function save_bulk_order_item_data($data_item)
	{
		$this->db->insert('bulk_order_item',$data_item);
	}
	function save_bulk_order_master_data($data_item)
	{
		$this->db->insert('bulk_order_master',$data_item);
		return $this->db->insert_id();
	}

 
}