<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 12/03/2018
 * Time: 11:33 AM
 * 
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Company_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    function get_all($comp)
    {
        $this->db->select('t.Dep_code, t.Description, t.Comp_Id, jt.Name');
        $this->db->from("department AS t");
        $this->db->join('comp AS jt', 't.Comp_Id = jt.Code', 'left');
        $this->db->where('t.Status', 1);
        $this->db->where('t.Comp_Id', $comp);
        $query = $this->db->get();
        return $query->result();
    }

    function get_info($company_id = '', $comp = 'rta')
    {
        $this->db->select('*');
        $this->db->from('department');
        $this->db->where('Dep_code', $company_id);
        $this->db->where('Status', 1);
        $this->db->where('Comp_Id', $comp);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return $query->row();
        } else {
            return false;
        }
    }

    public function record_count()
    {
        //$this->db->where('Status','Active');
        $this->db->from('companies');
        return $this->db->count_all_results();
    }

    public function getAllComp($limit, $start)
    {
        $this->db->limit($limit, $start);
        //$this->db->where('Status','Active');
        $query = $this->db->get("companies");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getAll()
    {
        $query = $this->db->get("companies");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getCompByID($id)
    {
        $this->db->select('*')
            ->from('companies')
            ->where('Id',$id);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            $row =  $q->row();
            return $row;
        }
        return FALSE;
    }
    public function getCompanyByCode($code)
    {
        $this->db->select('*')
            ->from('companies')
            ->where('Code',$code);
        $q = $this->db->get();
        if ($q->num_rows() == 1) {
            $row =  $q->row();
            return $row;
        }
        return FALSE;
    }

    public function addComp($data = array())
    {
        if ($this->db->insert('companies', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function updateComp($id,$data = array())
    {
        $this->db->where('Id',$id);
        if ($this->db->update('companies', $data)) {
            return true;
        }
        return false;
    }

    public function updateStatus($id,$status='Pending',$note='')
    {
        $this->db->where('Id', $id);
        if ($this->db->update('companies', array('Status' => $status,'Note' => $note))) {
            return true;
        }
        return false;
    }


    public function change_status($id,$status)
    {
        $this->db->where('Id', $id);
        if ($this->db->update('companies', array('Status'=>$status))) {
            return true;
        }
        return false;
    }



    public function getOrderByID($id)
    {
        $this->db->select("A.first_name,A.last_name,A.email,A.type,A.address,A.city,A.postal_code,A.state,A.phone,C.country_name,B.TotalAmount as grand_total")
            ->from('Comps_users AS A')
            ->join('Comps AS B','A.Comps_id=B.Id','left')
            ->join('countries AS C','A.country=C.id','left')
            ->where('A.Comps_id',$id);
        $q = $this->db->get();
        if ($q->num_rows() == 1) {
            return $q->row();
        }
        return FALSE;
    }


    public function delete($id)
    {
        /*if ($this->_checkInstitute($id)) {
            return false;
        }

        if ($this->_checkParent($id)) {
            return false;
        }*/
        //$Comps =$this->getEventByID($id);
        if ($this->db->delete('companies', array('Id' => $id))) {
            //$this->tmw->file_delete($this->path.'Comps/'.$Comps->FrontImage);
            //$this->tmw->file_delete($this->path.'Comps/'.$Comps->BannerImage);
            return true;
        }
        return FALSE;
    }

    function get_all_company()
    {
        $this->db->select('Code,Name');
        $this->db->from("comp");
        $query = $this->db->get();
        return $query->result();
    }
    
}
?>