<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Shift_transaction extends MY_Controller
{
	//to store model name
	private $model;
	
	 public function __construct()
	{
		parent::__construct();
		if (!$this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('login');
		}
		$this->load->model('shift_transaction_model');
		$this->model=$this->shift_transaction_model;
	} 

	// this function for index page (Home)
	function index()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['message'] = view_error($this->messages->get());
		$data['shifts'] = $this->model->get_all();
		$this->load->view('templates/shift_transaction/shift_trsc_details',$data);
	}
	
	public function post_shift_transaction($shift_code=null,$EmpNo=null,$comp_id=null)
	{
        $this->attn->checkPermissions('shift-transaction');
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'shiftT';
		$data['edit'] = false;
		if($shift_code and $EmpNo and $comp_id and $data['Edit'])
		{
			$data['edit'] = true; 
			$data['shiftT'] = $this->model->get_info($shift_code,$EmpNo,$comp_id);
			//echo '<pre>',print_r($data['shiftT']);die();
		}
		$this->load->model('employee_model');
		$data['employees'] = $this->employee_model->get_all_emp_name($this->attn->getComp());
		$this->load->model('shift_model');
		$data['shtCodes'] = $this->shift_model->get_all_shift_code();
		$data['shiftTs'] = $this->model->get_all();
		//echo '<pre>',print_r($data['shiftTs']); die();
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Shift Entry';
		$data['heading'] = 'Transaction';
		$data['url'] = base_url('shift-transaction');
		$this->load->view('templates/shift_transaction/shift_trsc_add',$data);
	}

	public function post()
	{
		$shift_t_id=$this->input->post('shift_t_id')=='' ? false: $this->input->post('shift_t_id');
		$emp_no=$this->input->post('emp_no')=='' ? false: $this->input->post('emp_no');
		$Comp=$this->input->post('Comp')=='' ? false: $this->input->post('Comp');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('EmpNo', 'Emp No', 'trim|required');
		$this->form_validation->set_rules('Shift_code', 'Shift Code', 'trim|required');
		$this->form_validation->set_rules('StartDate', 'Start Date', 'trim|required');
		$this->form_validation->set_rules('EndDate', 'End Date', 'trim|callback_compareDates');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			redirect('shift_transaction/post_shift_transaction', 'location');
		}
		else
		{
			$shift_data = array(
			'Comp_Id' => ($this->input->post('Comp')!='') ? $this->input->post('Comp'):$this->session->userdata('Comp'),
			'EmpNo' => ($this->input->post('EmpNo')!='') ? $this->input->post('EmpNo'):null,
			'Shift_code' => $this->input->post('Shift_code'),
			'Hours' => $this->input->post('Hours'),
			'StartDate' => $this->input->post('StartDate'),
			'EndDate' => $this->input->post('EndDate'),
			);
			$where = array();
			if($shift_t_id and $emp_no and $Comp)
			{
				$where = array('Shift_code'=>$shift_t_id,'Comp_Id'=>$Comp,'EmpNo'=>$emp_no);
			}
			//echo '<pre>',print_r($where);die();
			//get save id
			$returnId = $this->model->save($shift_data,$where);
			$postType = ($where) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($this->lang->line('success_shiftT_'.$postType), "success");
				redirect('shift-transaction');
			}
			else
			{
				if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_shiftT_'.$postType), "error");
				redirect('shift-transaction');
			}
		}	
	}


	function getRecods()
	{
		$this->load->library('datatables');
		$this->datatables
			->select($this->db->dbprefix('shift_transaction').".EmpNo AS EmpNo,
			".$this->db->dbprefix('employee').".EmpName,
			".$this->db->dbprefix('shift').".Name,
			".$this->db->dbprefix('shift_transaction').".Hours,
			".$this->db->dbprefix('shift_transaction').".StartDate,
			".$this->db->dbprefix('shift_transaction').".EndDate,
			".$this->db->dbprefix('shift_transaction').".Shift_code AS Shift_code,
			".$this->db->dbprefix('shift_transaction').".Comp_Id AS Comp_Id,
			")
			->from("shift_transaction")
			->join('employee', $this->db->dbprefix('shift_transaction').'.EmpNo='.$this->db->dbprefix('employee').'.EmpNo', 'left')
			->join('shift', $this->db->dbprefix('shift_transaction').'.Shift_code='.$this->db->dbprefix('shift').'.shift_code', 'left')
			//->where($this->db->dbprefix('shift_transaction').'.Comp_Id', $this->attn->getComp())
			//->where($this->db->dbprefix('employee').'.Comp', $this->attn->getComp())
			//->where($this->db->dbprefix('shift').'.Comp_Id', $this->attn->getComp())
			->where($this->db->dbprefix('employee').'.Active',1)
			->add_column("Actions", "
			<div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  <a class=\"dropdown-item\" href='" . site_url('attendance/add_attendance?v=1&USER=$1&DATE=$2&Comp=$3') ."'
					><i class=\"bx bx-edit-alt me-1\"></i> Edit</a>
				  <a class=\"dropdown-item\" href='". site_url('shift_transaction/delete/$1/$2/$3') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>", "EmpNo,Shift_code,Comp_Id")
			->unset_column('Shift_code,Comp_Id');
		echo $this->datatables->generate();
	}

	public function get_details_filter()
	{
		$all_data = $this->model->get_all();
		$count = count($all_data);
		$return_data = array();
		$data=array();
		$return_data['recordsTotal'] = intval($count);
		$return_data['recordsFiltered'] = intval($count);
		foreach($all_data as $d):
			array_push($data,
				array(
					$d->EmpName,
					$d->Description,
					$d->Hours,
					$d->StartDate,
					$d->EndDate,
"<center>
			<a class=\"tip\" title='edit customer' href='" . site_url('customers/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a>
			<a class=\"tip\" title='user list' href='" . site_url('customers/users/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-users\"></i></a>
			<a class=\"tip\" title='add user' href='" . site_url('customers/add_user/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-plus-circle\"></i></a>
			<a href='#' class='tip po' title='<b>delete customer </b>' data-content=\"<p>Are you sure?</p>
			<a class='btn btn-danger po-delete' href='" . site_url('customers/delete/$1') . "'>I am sure.</a>
			<button class='btn po-close'>No</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></center>
<div class=\"hidden-phone visible-desktop action-buttons\">
                    ".(($this->Edit)?"<a href=\"".base_url('shift-transaction/'.$d->Shift_code.'/'.$d->EmpNo.'/'.$d->Comp_Id)."\" title=\"Edit\" class=\"green\">
							<i class=\"ace-icon fa fa-pencil bigger-130\"></i>
						</a>":"")."<a href=\"#\" class=\"red\" title=\"Delete\"><i class=\"ace-icon fa fa-trash-o bigger-130\"></i></a></div>"
				));
		endforeach;
		$return_data['data'] = $data;
		echo json_encode($return_data);
	}
	
	function compareDates()
	{
		$start = strtotime($this->input->post('StartDate'));
		$end = strtotime($this->input->post('EndDate'));
		if($start > $end)
		{
			$this->form_validation->set_message('compareDates','Your start date must be earlier than your end date');
			return false;
		}
		return true;
	}

	function delete($EmpNo = NULL,$ShiftCode=NULL,$CompId=NULL)
	{
		if ($this->input->get('EmpNo')) {
			$EmpNo = $this->input->get('EmpNo');
		}
		if ($this->input->get('ShiftCode')) {
			$ShiftCode = $this->input->get('ShiftCode');
		}
		if ($this->input->get('CompId')) {
			$CompId = $this->input->get('CompId');
		}

		if ($this->model->deleteShift($EmpNo,$ShiftCode,$CompId)) {
			echo $this->lang->line("biller_deleted");
			$this->messages->add('Shift Deleted', "success");
			redirect('shift-transaction');
		} else {
			die("<script type='text/javascript'>setTimeout(function(){ window.top.location.href = '" . (isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : site_url('welcome')) . "'; }, 0);</script>");
		}
	}
}
?>