<?php
require_once (APPPATH."models/Main_model.php");
class Leave_transaction_model extends Main_model
{
	private $tableName = 'leave_transaction';
	private $join = 'employee';
	private $join2 = 'leave';
	
	
	public function _construct()
	{
		//$this->load->database();
	}

	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the shifts
	*/
	function get_all()
	{
		$this->db->select('t.EmpNo, t.Leave_Code, t.Days, t.Balance, jt.EmpName, jt2.Description');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
		$this->db->join($this->join2.' AS jt2', 't.Leave_Code = jt2.Leave_code','left');
		$this->db->where('jt.Active',1);
  		$query = $this->db->get();
		return $query->result();
	}

    function get_employee_year_leaves($year,$empNo)
    {
        $this->db->select('t.EmpNo, t.Leave_Code, t.Days,t.LeaveFrom, t.LeaveTo,t.LeaveType, jt.EmpName, jt2.Description');
        $this->db->from($this->tableName." AS t");
        $this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
        $this->db->join($this->join2.' AS jt2', 't.Leave_Code = jt2.Leave_code','left');
        $this->db->where('t.EmpNo', $empNo);
        $this->db->where('t.Year', $year);
        $this->db->where('jt.Active',1);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        if($query->num_rows()> 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    function get_year_applied_leaves($year)
    {
        $this->db->select('t.EmpNo, t.Leave_Code, t.Days,t.LeaveFrom, t.LeaveTo,t.LeaveType, e.EmpName, l.Description');
        $this->db->from("employee AS e");
        $this->db->join('leave_transaction AS t', 'e.EmpNo = t.EmpNo','left');
        $this->db->join('leave AS l', 't.Leave_Code = l.Leave_code','left');
        //$this->db->where('t.Comp_Id', $comp);
        //$this->db->where('t.EmpNo', $empNo);
        $this->db->where('t.Year', $year);
        $this->db->where('e.Active',1);
        $this->db->order_by('t.EmpNo ASC,t.Leave_Code ASC');
        $query = $this->db->get();
        if($query->num_rows()> 0)
        {
           
            return $query->result();
        }
        else
        {
            return false;
        }
    }
	

    function get_employee_month_leaves_details($month,$empNo)
    {
        $this->db->select('t.EmpNo, t.Leave_Code, t.Days,t.LeaveFrom, t.LeaveTo,t.LeaveType');
        $this->db->from($this->tableName." AS t");
        $this->db->join($this->join2.' AS jt2', 't.Leave_Code = jt2.Leave_code','left');
        //$this->db->where('t.Comp_Id', $comp);
        $this->db->where('t.EmpNo', $empNo);
        $this->db->where("DATE_FORMAT(t.LeaveFrom,'%Y-%m')='$month'");
        $this->db->order_by("t.LeaveFrom","ASC");
        $query = $this->db->get();
        if($query->num_rows()> 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }

    function get_month_employee_leave_nopay_details($month,$empNo)
    {
        $this->db->select('*',FALSE);
        $this->db->from('nopay_transaction AS N');
        //$this->db->where('N.Comp_Id', $comp);
        $this->db->where("DATE_FORMAT(N.NopayFrom,'%Y-%m')='$month'");
        $this->db->where('N.EmpNo', $empNo);
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows()> 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }

	function get_info($leaveT_id='')
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where('Leave_Code',$leaveT_id);
		//$this->db->where('Comp_Id', $comp);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

    function get_leave($where=array())
    {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function get_employee_month_leaves($emp,$month)
    {
        $this->db->select('SUM(Days) AS leaves',FALSE);
        $this->db->from('leave_transaction');
        $this->db->where('EmpNo',$emp);
        //$this->db->where('Comp_Id', $comp);
        $this->db->where("DATE_FORMAT(`LeaveFrom`,'%Y-%m')='$month'");
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row()->leaves;
        }
        else
        {
            return false;
        }
    }


    function get_employee_month_nopays($emp,$month)
    {
        $this->db->select('SUM(Days) AS nopay',FALSE);
        $this->db->from('nopay_transaction');
        $this->db->where('EmpNo',$emp);
        //$this->db->where('Comp_Id', $comp);
        $this->db->where("DATE_FORMAT(`NopayFrom`,'%Y-%m')='$month'");
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row()->nopay;
        }
        else
        {
            return false;
        }
    }

    function get_month_leave_nopay($month)
    {
        $this->db->select('SUM(L.Days) AS leaves,SUM(N.Days) AS nopays',FALSE);
        $this->db->from('leave_transaction AS L');
        $this->db->join('nopay_transaction AS N', 'L.EmpNo = N.EmpNo','left');
        //$this->db->where('L.Comp_Id', $comp);
        $this->db->where("DATE_FORMAT(L.LeaveFrom,'%Y-%m')='$month'");
        $this->db->where("DATE_FORMAT(N.NopayFrom,'%Y-%m')='$month'");
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows()> 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
	
	function get_leave_days($where)
    {
        $this->db->select('Days,Balance');
        $this->db->from('leave_year_applied');
        $this->db->where($where);
        $this->db->where('Year', date('Y'));
        $this->db->where('Comp_Id', $this->attn->getComp());
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function get_info_days($where)
    {
        $this->db->select('Balance');
        $this->db->from('leave_year_applied');
        $this->db->where('Leave_code',$where['Leave_Code']);
        $this->db->where('EmpNo', $where['EmpNo']);
        $this->db->where('Year', date('Y'));
        $this->db->where('Comp_Id', $this->attn->getComp());
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
           /* $this->db->trans_start();
            $this->db->select_sum('Days');
            $this->db->from('leave_transaction');
            $this->db->where($where);
            $this->db->where('Comp_Id', $this->attn->getComp());
            $this->db->where('Year', date('Y'));
            $query2 = $this->db->get();
            $this->db->trans_complete();
            $query->row()->Balance =($query->row()->Days) - ($query2->row()->Days);*/
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function get_leave_balance($where)
    {
        $this->db->select('Balance');
        $this->db->from('leave_year_applied');
        $this->db->where('Leave_code',$where['Leave_Code']);
        $this->db->where('EmpNo', $where['EmpNo']);
        $this->db->where('Year', date('Y'));
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
           
            $this->db->select_sum('Days');
            $this->db->from('leave_transaction');
            $this->db->where($where);
            $this->db->where('Status', 'Pending');
            $this->db->where('Year', date('Y'));
            $query2 = $this->db->get();
            $query->row()->Balance =($query->row()->Balance) - ($query2->row()->Days);
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    function apply_leaves($year='')
    {
        $this->db->select('*');
        $this->db->from('leave');
        $query = $this->db->get();
        $leaves = array();
        if($query->num_rows() > 0)
        {
            $lvs = $query->result();
            $this->db->select('EmpNo');
            $this->db->from('employee');
            $q = $this->db->get();
            if($q->num_rows() > 0){
                $employees = $q->result();
                foreach ($employees as $e){
                    foreach ($lvs as $l) {
                        $leaves[] = array(
                            'Comp_Id' => $this->attn->getComp(),
                            'EmpNo' => $e->EmpNo,
                            'Leave_Code' => $l->Leave_code,
                            'Days' => $l->Days,
                            'Year' => $year,
                            'Balance' => $l->Days,
                        );
                    }
                }
            }
            if($this->db->insert_ignore_batch('leave_year_applied',$leaves))
            {
                return true;
            }
            return false;
        }
        else
        {
            return false;
        }
    }

	/*
	Inserts or updates a page
	*/
	function save(&$leaveT_data,$leaveT_id=false)
	{
        $where = array(
            'EmpNo'=> $leaveT_data['EmpNo'],
            'Leave_Code'=>$leaveT_data['Leave_Code'],
            'Comp_Id'=>$leaveT_data['Comp_Id'],
            'Year'=>$leaveT_data['Year'],
            'LeaveFrom'=>$leaveT_data['LeaveFrom']
        );
        if(!$this->exist($where))
        {
            return $this->db->insert($this->tableName,$leaveT_data);
            // if($this->db->insert($this->tableName,$leaveT_data))
            // {
            //     $this->db->where('EmpNo', $leaveT_data['EmpNo'])
            //         ->where('Comp_Id', $leaveT_data['Comp_Id'])
            //         ->where('Leave_Code', $leaveT_data['Leave_Code'])
            //         ->where('Year', $leaveT_data['Year'])
            //         ->set('Balance', 'Balance-'.$leaveT_data['Days'], FALSE)
            //         ->update('leave_year_applied');
            //     return true;
            // }
        }
        return false;
	}
	
	function edit_year_leaves(&$data,$where){
		$update = $this->db->where($where)->update('leave_year_applied',$data);
		//echo $this->db->last_query(); die();
		return $update;
	}

    function add_nopay(&$data)
    {
        $where = array(
            'EmpNo'=> $data['EmpNo'],
            'Code'=>$data['Code'],
            'Comp_Id'=>$data['Comp_Id'],
            'Year'=>$data['Year'],
            'NopayFrom'=>$data['NopayFrom']
        );
        if(!$this->exist($where,'nopay_transaction'))
        {
            if($this->db->insert('nopay_transaction',$data))
            {
                return true;
            }
        }
        $this->messages->add('Nopay Transaction already exist', "error");
        return false;
    }

	function exist($where=array(),$table='leave_transaction')
	{
		$this->db->from($table);
		$this->db->where($where);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$this->messages->add($this->lang->line('error_leaveT_exist'), "error");
			return true;
		}
		else
		{
			return false;
		}
	}

	function delete($id)
	{
		if($this->delete_image($id))
		{
			$this->db->where('Code', $id);
			$this->db->where('Comp_Id', $this->_getComp());
			return $this->db->delete($this->tableName); 
		}
		return false;
		
	}
	
	public function change_status($leaveT_id,$status)
	{
		$this->db->where('Code', $leaveT_id);
		$this->db->where('Comp_Id', $this->_getComp());
		return $this->db->update($this->tableName,array( 'pStatus' => $status));	
	}

    function delete_leave($EmpNo,$Year,$Leave_Code,$LeaveFrom,$days)
    {
        $this->db->trans_start();
        //$this->db->where('Comp_Id', $comp_id);
        $this->db->where('EmpNo',$EmpNo);
        $this->db->where('Year',$Year);
        $this->db->where('Leave_Code',$Leave_Code);
        $this->db->where('LeaveFrom',$LeaveFrom);
        $this->db->delete($this->tableName);

        $this->db->where('EmpNo', $EmpNo)
            //->where('Comp_Id', $comp_id)
            ->where('Leave_Code', $Leave_Code)
            ->set('Balance', 'Balance+'.$days, FALSE)
            ->update('leave_year_applied');
        $this->db->trans_complete();
    }

    function delete_nopay($EmpNo,$Year,$Code,$NopayFrom)
    {
        //$this->db->where('Comp_Id', $comp_id);
        $this->db->where('EmpNo',$EmpNo);
        $this->db->where('Year',$Year);
        $this->db->where('Code',$Code);
        $this->db->where('NopayFrom',$NopayFrom);
        return $this->db->delete('nopay_transaction');
    }

    function get_month_leaves($month,$EmpNo)
    {
        $this->db->select('LeaveFrom, LeaveTo, LeaveType, Days');
        $this->db->from(' leave_transaction');
        //$this->db->where('Comp_Id', $comp);
        $this->db->where('EmpNo', $EmpNo);
        $this->db->where("DATE_FORMAT(LeaveFrom, '%Y-%m')='$month'");
        $query = $this->db->get();
        return $query->result();
    }
    

    function get_month_nopay($month,$EmpNo)
    {
        $this->db->select('NopayFrom, NopayTo, Days');
        $this->db->from(' nopay_transaction');
        //$this->db->where('Comp_Id', $comp);
        $this->db->where('EmpNo', $EmpNo);
        $this->db->where("DATE_FORMAT(NopayFrom, '%Y-%m')='$month'");
        $query = $this->db->get();
        return $query->result();
    }

    public function changes_status($where,$data)
    {
        $this->db->where($where);
        if ($this->db->update('leave_transaction', $data)) {
            return true;
        }
        return false;
    }
    
}
?>