<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Attendance extends MY_Controller
{
    private $allRecords;
    private $model;

    public function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('attendance_model');
        $this->model = $this->attendance_model;
        $this->load->library('form_validation');
    }

    // this function for index page (Home)
    public function index()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'all_record';
        $this->load->model('company_model', 'company');
        $data['companies'] = $this->company->get_all_company();
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $v = "";
        if ($data['Admin']) {
            $data['departments'] = $this->company->get_all_filter();
            $data['employees'] = $this->employee_model->get_all_filter();
        }
        if ($this->input->post('Comp')) {
            $v .= "&Comp=" . $this->input->post('Comp');
            $data['Comp'] = $this->input->post('Comp');
            $data['departments'] = $this->company->get_all_filter();
            $data['employees'] = $this->employee_model->get_all_filter();
        }
        if ($this->input->post('date')) {
            $v .= "&date=" . $this->input->post('date');
            $data['date'] = $this->input->post('date');
            //$data['items'] = $this->item->get_all_filter($data['branch'],$data['catcode']);
        }
        if ($this->input->post('department')) {
            $v .= "&department=" . $this->input->post('department');
            $data['department'] = $this->input->post('department');
            $data['employees'] = $this->employee_model->get_all_filter($this->input->post('department'));
        }
        if ($this->input->post('EmpNo')) {
            $v .= "&EmpNo=" . $this->input->post('EmpNo');
            $data['EmpNo'] = $this->input->post('EmpNo');
        }
        $data['v'] = $v;
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Attendance Entry';
        $data['heading'] = 'Transaction';
        $data['url'] = base_url('attendance');
        $this->load->view('templates/records/view_attendance', $data);
    }

    function user_attn()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
        $data['page_title'] = 'Attendance';
        $data['heading'] = 'Attendance';
        $data['page'] = 'user_attns';
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/attendance/user_attn',$data);
	}

    public function getUserAttns()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('attendance').".DATE,
			".$this->db->dbprefix('attendance').".INTIME,
			".$this->db->dbprefix('attendance').".OUTDATE,
			".$this->db->dbprefix('attendance').".OUTTIME")
            ->from("attendance")
            ->where($this->db->dbprefix('attendance') .'.USER', $this->session->userdata('EmpNo'));
            //->unset_column('comp,Year,EmpNo,date');
        
        echo $this->datatables->generate();
    }

    public function upload_attn()
    {
        //$this->tmw->checkPermissions();
        //echo $this->data['page'];
        //$data['page'] = 'employee';
        $data['page_title'] = 'Add Attendance';
        $data['heading'] = 'Timesheet';
        $this->data['message'] = view_error($this->messages->get());
        $bc = array(array('link' => base_url('admin'), 'page' => lang('home')), array('link' => '#', 'page' => lang('employees')));
        $meta = array('page_title' => lang('Companies'), 'bc' => $bc);
        $this->page_construct('attendance/upload', $meta, $this->data);
    }

    public function importFile()
    {
        $path = 'uploads/';
        //require_once APPPATH . "/third_party/PHPExcel.php";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'xlsx|xls|csv';
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('cvs_file')) {
            $error = array('error' => $this->upload->display_errors());
        } else {
            $data = array('upload_data' => $this->upload->data());
        }
        if (empty($error)) {
            if (!empty($data['cvs_file']['file_name'])) {
                $import_xls_file = $data['cvs_file']['file_name'];
            } else {
                $import_xls_file = 0;
            }
            echo '<pre>', print_r($import_xls_file);
            die();
            $inputFileName = $path . $import_xls_file;

            try {

                $extension = end($arr_file);
                if ('csv' == $extension) {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                } else {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                }
                $spreadsheet = $reader->load($_FILES['cvs_file']['tmp_name']);
                $sheetData = $spreadsheet->getActiveSheet()->toArray();
                echo "<pre>";
                print_r($sheetData);
                /*
            $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
            $objReader = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($inputFileName);
            $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            $flag = true;
            $i=0;
            foreach ($allDataInSheet as $value) {
            if($flag){
            $flag =false;
            continue;
            }
            $inserdata[$i]['first_name'] = $value['A'];
            $inserdata[$i]['last_name'] = $value['B'];
            $inserdata[$i]['email'] = $value['C'];
            $inserdata[$i]['contact_no'] = $value['D'];
            $i++;
            }
            $result = $this->import->insert($inserdata);
            if($result){
            echo "Imported successfully";
            }else{
            echo "ERROR !";
            }
             */

            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME)
                    . '": ' . $e->getMessage());
            }
        } else {
            echo $error['error'];
        }

    }

    public function import()
    {

        $file_mimes = array(
            'text/x-comma-separated-values',
            'text/comma-separated-values',
            'application/octet-stream',
            'application/vnd.ms-excel',
            'application/x-csv',
            'text/x-csv',
            'text/csv',
            'application/csv',
            'application/excel',
            'application/vnd.msexcel',
            'text/plain',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        );

        $fileMimes = array(
            'text/x-comma-separated-values',
            'text/comma-separated-values',
            'application/octet-stream',
            'application/vnd.ms-excel',
            'application/x-csv',
            'text/x-csv',
            'text/csv',
            'application/csv',
            'application/excel',
            'application/vnd.msexcel',
            'text/plain',
        );

        //if (isset($_FILES['cvs_file']['name']) && in_array($_FILES['cvs_file']['type'], $file_mimes)) {
        if (!empty($_FILES['cvs_file']['name']) && in_array($_FILES['cvs_file']['type'], $file_mimes)) {
            $arr_file = explode('.', $_FILES['cvs_file']['name']);

            // Open uploaded CSV file with read-only mode
            $csvFile = fopen($_FILES['cvs_file']['tmp_name'], 'r');

            // Skip the first line
            fgetcsv($csvFile);

            $csv_data = array();
            $type = $this->input->post('type');

            // Parse data from CSV file line by line
            // Parse data from CSV file line by line
            while (($getData = fgetcsv($csvFile, 10000, ",")) !== false) {

                //echo '<pre>',print_r($getData),'</pre>';  die();
                // Get row data
                if (!empty($getData[0])) {

                    if ($type == 1) {
                        $product_pack_size = $getData[6];
                        $product_code = $getData[0];
                        $row = array();
                        $row = array(
                            'DEVICE' => $getData[4],
                            'USER' => $getData[1],
                            'NAME' => $getData[2],
                            'USERKEY' => '',
                            'USERMODE' => '',
                            'USERACTION' => '',
                            'INOUTTIME' => $getData[6] . ' ' . $getData[7],
                            'DEPT' => $getData[0],

                        );
                        $csv_data[] = $row;
                        unset($row);
                    } else {
                        $row = array();
                        $fm = explode(" ", $getData[9]);
                        $fmn = explode("/", $fm[0]);
                        $new_date_format = $fmn[2] . '-' . $fmn[0] . '-' . $fmn[1] . ' ' . $fm[1];
                        $row = array(
                            'DEVICE' => $getData[4],
                            'USER' => $getData[2],
                            'NAME' => $getData[3],
                            'USERKEY' => '',
                            'USERMODE' => '',
                            'USERACTION' => '',
                            'INOUTTIME' => $new_date_format,
                            'DEPT' => $getData[6],
                        );
                        $csv_data[] = $row;
                        unset($row);
                    }
                }

            }
            //echo '<pre>',print_r($csv_data); die();

            $add = $this->model->save_batch_main($csv_data);
            if ($add) {
                $this->messages->add('Record Added', "success");
            }
            redirect('attendance/upload_attn');

            /*
        $extension = end($arr_file);
        if ('csv' == $extension) {
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
        } else if ('xls' == $extension) {
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        } else
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();

        $spreadsheet = $reader->load($_FILES['cvs_file']['tmp_name']);
        $sheetData = $spreadsheet->getActiveSheet()->toArray();
        echo "<pre>";
        print_r($sheetData);
         */
        } else {
            echo 'Import failed';
        }
    }

    //view attwndance month wise
    public function month()
    {
        $data = $this->data;
        $data['page'] = 'month_wise';
        $this->load->model('company_model', 'company');
        $data['companies'] = $this->company->get_all_company();
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $v = "";
        if ($this->input->post('Comp')) {
            $v .= "&Comp=" . $this->input->post('Comp');
            $data['Comp'] = $this->input->post('Comp');
            $data['departments'] = $this->company->get_all_filter();
            $data['employees'] = $this->employee_model->get_all_filter();
        }

        $data['departments'] = $this->company->get_all_filter();

        if ($this->input->post('month')) {
            $v .= "&month=" . $this->input->post('month');
            $data['month'] = $this->input->post('month');
        }
        if ($this->input->post('department')) {
            $v .= "&department=" . $this->input->post('department');
            $data['department'] = $this->input->post('department');
            $data['employees'] = $this->employee_model->get_all_filter($this->input->post('department'));
        }
        if ($this->input->post('EmpNo')) {
            $v .= "&EmpNo=" . $this->input->post('EmpNo');
            $data['EmpNo'] = $this->input->post('EmpNo');
        }
        //$this->attn->p($data['companies']); die();
        $data['v'] = $v;
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Month wise Attendance';
        $data['heading'] = 'Transaction';
        $data['url'] = base_url('attendance');
        $this->load->view('templates/records/month_wise', $data);
    }

    public function today()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'today';
        $data['page_title'] = 'Today Attendance';
        $data['heading'] = 'Attendance';
        $this->load->model('company_model');
        $data['companies'] = $this->company_model->get_all_company();
        //echo '<pre>',print_r($data['companies']); die();
        $data['admin'] = $this->Admin;
        $data['Edit'] = $this->Edit;
        $v = "";
        if ($this->input->post('Comp')) {
            $v .= "&Comp=" . $this->input->post('Comp');
            $data['Comp'] = $this->input->post('Comp');
        }

        if ($this->input->post('date')) {
            $v .= "&date=" . $this->input->post('date');
            $data['date'] = $this->input->post('date');
            //$data['items'] = $this->item->get_all_filter($data['branch'],$data['catcode']);
        }

        $data['v'] = $v;

        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/records/today_attendance', $data);
    }

    public function edit_records($empNo = null, $month = null)
    {
        $data = $this->data;
        $data['page'] = 'edit_records';
        $data['device'] = $this->attn->getDivice();
        $data['comp'] = $this->attn->getComp();
        if ($empNo and $month) {
            $data['empNo'] = $empNo;
            $data['month'] = $month;
            $records = $this->model->get_month_attn_records_by_user($empNo, $month);
            $new_rows = array();
            if (!empty($records)) {
                foreach ($records as $record) {
                    $new_rows[$record->DATE] = $record;
                }
            }
            $data['month_days'] = month_days($month);
            $modefy_rows = array();
            foreach ($data['month_days'] as $day) {
                if (!isset($new_rows[$day])) {
                    $modefy_rows[$day] = (object) array(
                        "ID" => 0,
                        "DEVICE" => 1,
                        "USER" => $empNo,
                        "NAME" => "",
                        "DATE" => "",
                        "Comp" => 'rta',
                        "INTIME" => "",
                        "OUTTIME" => "",
                        "OUTDATE" => "",
                        "EDIT" => 0,
                    );
                } else {
                    $modefy_rows[$day] = $new_rows[$day];
                }
            }
            $data['records'] = $modefy_rows;
            //$this->attn->p($modefy_rows); die();
            $data['month_records'] = $this->model->get_month_in_out_records_by_user($empNo, $month);
        }
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Month Attendances';
        $data['heading'] = 'Timesheet';
        $this->load->view('templates/records/edit_records', $data);
    }

    public function approval_records($empNo = null, $month = null)
    {
        /*
        if($this->Type!='SUPER ADMIN'){ 
            //redirect(base_url());
        }
        */
        $data = $this->data;
        $data['page'] = 'approval_records';
        $data['device'] = $this->attn->getDivice();
        $data['comp'] = $this->attn->getComp();
        if ($empNo and $month) {
            $data['empNo'] = $empNo;
            $data['month'] = $month;
            $records = $this->model->get_month_approval_attn_records_by_user($empNo, $month);
            $new_rows = array();
            if (!empty($records)) {
                foreach ($records as $record) {
                    $new_rows[$record->DATE] = $record;
                }
            }
            $data['month_days'] = month_days($month);
            $modefy_rows = array();
            foreach ($data['month_days'] as $day) {
                if (!isset($new_rows[$day])) {
                    $modefy_rows[$day] = (object) array(
                        "ID" => 0,
                        "DEVICE" => 1,
                        "USER" => $empNo,
                        "NAME" => "",
                        "DATE" => "",
                        "Comp" => 'rta',
                        "INTIME" => "",
                        "OUTTIME" => "",
                        "OUTDATE" => "",
                        "EDIT" => 0,
                    );
                } else {
                    $modefy_rows[$day] = $new_rows[$day];
                }
            }
            $data['records'] = $modefy_rows;
            //$this->attn->p($modefy_rows); die();
            $data['month_records'] = $this->model->get_month_in_out_records_by_user($empNo, $month);
        }
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Month Attendances';
        $data['heading'] = 'Timesheet';
        $this->load->view('templates/records/approval_records', $data);
    }

    public function approval_month_records()
    {
        $data = $this->data;
        $data['page'] = 'edit_records';
        $this->load->model('attendance_model');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('month', 'month', 'trim|required');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'trim|required');
        if ($this->form_validation->run() == false) {
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $data['page_title'] = 'Approval attenadance';
            $data['heading'] = 'Transaction';
            $this->load->view('templates/records/approval_records', $data);
        } else {
            $month = $this->input->post('month');
            $EmpNo = $this->input->post('EmpNo');
           

            $records = $this->attendance_model->approvalRecords($month, $EmpNo);
            if ($records) {
                $this->messages->add('Record Approved', "success");
            } else {
                if ($this->messages->count() == 0) {
                    $this->messages->add('Error', "error");
                }

            }
            redirect(base_url('attendance/approval_records/' . $EmpNo . '/' . $month));
        }
    }

    public function update_month_records()
    {
        $data = $this->data;
        $data['page'] = 'edit_records';
        $this->load->model('attendance_model');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('month', 'month', 'trim|required');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'trim|required');
        if ($this->form_validation->run() == false) {
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $data['page_title'] = 'Attendance Entry';
            $data['heading'] = 'Transaction';
            $this->load->view('templates/records/edit_records', $data);
        } else {
            $month = $this->input->post('month');
            $EmpNo = $this->input->post('EmpNo');
            $Comp = $this->attn->getComp();
            $rows = array();
            foreach ($_POST['records'] as $record) {
                if ($record[1] != '0000-00-00' or $record[1] != '') {
                    $rows[] = array(
                        'ID' => $record[5],
                        'DEVICE' => $record[6],
                        'USER' => $record[7],
                        'Comp' => $record[8],
                        'DATE' => $record[1],
                        'INTIME' => $record[2],
                        'OUTDATE' => $record[3],
                        'OUTTIME' => $record[4],
                        //'OLDDATE' => $record[9],
                        'EDIT' => 1,
                        'STATUS' => 0,
                    );
                }
            }

            //echo '<pre>',print_r($rows); die();

            $records = $this->attendance_model->updateRecords($rows, $month, $EmpNo, $Comp);
            if ($records) {
                $this->messages->add('Record Edit success', "success");
            } else {
                if ($this->messages->count() == 0) {
                    $this->messages->add('Error', "error");
                }

            }
            redirect(base_url('attendance/edit_records/' . $EmpNo . '/' . $month));
        }
    }

    public function add_ot($empNo = null, $month = null)
    {
        $data['page'] = 'add_ot';
        $this->form_validation->set_rules('EmpNo', 'Employee', 'required');
        if ($this->form_validation->run('attendance/add_ot') == true) {
            $month = $this->input->post('month');
            $EmpNo = $this->input->post('EmpNo');
            $rows = array();
            foreach ($_POST['records'] as $record) {

                if ($record[1] != '00-00-00' and $record[1] != '') {
                    $diff = $this->attn->DateIntervalToSec($record[1] . ' ' . $record[2], $record[3] . ' ' . $record[4]);
                    //echo $diff; die();
                    $rows[] = array(
                        'USER' => $record[7],
                        'Comp' => $this->attn->getComp(),
                        'DATE' => $record[1],
                        'INTIME' => $record[2],
                        'OUTDATE' => $record[3],
                        'OUTTIME' => $record[4],
                        'OT' => $diff,
                    );
                }
            }
            //$this->attn->p($rows); die();
        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('attendance/add_ot');
        }

        if ($this->form_validation->run() == true && $this->attendance_model->updateOTRecords($rows, $month, $EmpNo)) {
            $this->messages->add('Record Edit success', "success");
            redirect($_SERVER["HTTP_REFERER"]);
        } else {
            if ($empNo and $month) {
                $data['empNo'] = $empNo;
                $data['month'] = $month;
                $data['records'] = $this->model->get_month_attn_ot_records_by_user($empNo, $month);
                $this->attn->p($data['records']);
                die();
            }
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter();
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/records/add_ot', $data);
        }
    }

    public function change_date_wise($date = null, $dep = null)
    {
        $data = $this->data;
        $data['page'] = 'change_date_wise';
        if ($date and $dep) {
            $data['dep'] = $dep;
            $data['date'] = $date;
            $this->load->model('employee_model');
            $data['records'] = $this->employee_model->get_dep_wise_attn($dep, $date);
        }
        $this->load->model('company_model');
        $data['departments'] = $this->company_model->get_all();
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/records/change_date_wise', $data);
    }

    public function update_date_records()
    {
        $data = $this->data;
        $data['page'] = 'change_date_wise';
        $this->load->model('attendance_model');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Date', 'Date', 'trim|required');
        $this->form_validation->set_rules('Department', 'Department', 'trim|required');
        if ($this->form_validation->run() == false) {
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $data['page_title'] = 'Attendance Entry';
            $data['heading'] = 'Transaction';
            $this->load->view('templates/records/change_date_wise', $data);
        } else {
            $rows = array();
            $date = $this->input->post('Date');
            $dip = $this->input->post('Department');
            foreach ($_POST['records'] as $record) {
                $rows[] = array(
                    'ID' => $record[5],
                    'DEVICE' => $record[6],
                    'USER' => $record[7],
                    'Comp' => $record[8],
                    'DATE' => $record[1],
                    'INTIME' => (!empty($record[2])) ? $record[2] : '00:00:00',
                    'OUTDATE' => $record[3],
                    'OUTTIME' => (!empty($record[4])) ? $record[4] : '00:00:00',
                    'OLDDATE' => $record[9],
                    'EDIT' => 1,
                );
            }
            //$this->attn->p($rows); die();
            $records = $this->attendance_model->updateDateRecords($rows);
            if ($records) {
                $this->messages->add('Record Edit success', "success");
            } else {
                if ($this->messages->count() == 0) {
                    $this->messages->add('Error', "error");
                }

            }
            redirect(base_url('attendance/change_date_wise/' . $date . '/' . $dip));
        }
    }

    public function getRecods()
    {
        $Comp = (isset($_GET['Comp']) and !empty($_GET['Comp'])) ? $this->input->get('Comp') : null;
        $date = (isset($_GET['date']) and !empty($_GET['Comp'])) ? $this->input->get('date') : null;
        $month = (isset($_GET['month']) and !empty($_GET['month'])) ? $this->input->get('month') : null;
        $department = (isset($_GET['department']) and !empty($_GET['Comp'])) ? $this->input->get('department') : null;
        $EmpNo = (isset($_GET['EmpNo']) and !empty($_GET['Comp'])) ? $this->input->get('EmpNo') : null;
        $this->load->library('datatables');
        $this->datatables
            ->select(
                "IF(" . $this->db->dbprefix('employee') . ".EPFNo != ''," . $this->db->dbprefix('employee') . ".EPFNo," . $this->db->dbprefix('employee') . ".EmpNo) AS USER,
            " . $this->db->dbprefix('employee') . ".EmpName,
            " . $this->db->dbprefix('comp') . ".Name,
            " . $this->db->dbprefix('attendance') . ".DATE,
            " . $this->db->dbprefix('attendance') . ".INTIME,
            " . $this->db->dbprefix('attendance') . ".OUTDATE,
            " . $this->db->dbprefix('attendance') . ".OUTTIME,
            " . $this->db->dbprefix('attendance') . ".DATE AS date,
            " . $this->db->dbprefix('attendance') . ".USER AS user
            "
            )
            ->from("attendance")
            ->join('comp', $this->db->dbprefix('attendance') . '.Comp=' . $this->db->dbprefix('comp') . '.Code', 'left')
            ->join('employee', $this->db->dbprefix('attendance') . '.USER=' . $this->db->dbprefix('employee') . '.EmpNo  AND ' . $this->db->dbprefix('employee') . '.Comp=' . $this->db->dbprefix('attendance') . '.Comp', 'left')
            ->where($this->db->dbprefix('attendance') . '.DEVICE', $this->attn->get_unit_id())
            ->add_column("Actions", "<a class=\"green\" data-toggle='modal' data-target='#myModal' title='edit' href='" . site_url('attendance/add_attendance?v=1&USER=$1&DATE=$2') . "'><i class=\"fa fa-edit\"></i></a>
            <a href='#' class='tip po red' title='<b>Delete Item</b>' data-content=\"<p>Are u sure ?</p><a class='btn btn-danger po-delete' href='" . site_url('items/delete/$1') . "'>I am sure </a>
             <button class='btn po-close'>No</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a>", "user,date")
            ->unset_column('date,user');

        if ($Comp != null) {
            $this->datatables->where($this->db->dbprefix('attendance') . ".Comp", $Comp);
            $this->datatables->where($this->db->dbprefix('comp') . ".Code", $Comp);
        }

        if ($EmpNo != null) {
            $this->datatables->where($this->db->dbprefix('attendance') . ".USER", $EmpNo);
            $this->datatables->where($this->db->dbprefix('employee') . ".EmpNo", $EmpNo);
        }
        if ($date != null) {
            $this->datatables->where($this->db->dbprefix('attendance') . ".DATE", $date);
        }
        if ($department != null) {
            $this->datatables->where($this->db->dbprefix('employee') . ".Dep_code", $department);
            //$this->datatables->where("D.Dep_code", $department);
        }
        if ($month != null) {
            $this->datatables->where("DATE_FORMAT(attendance.DATE, '%Y-%m') = '" . $month . "'", null, false);
        }
        $this->db->order_by("attendance.DATE", "desc");
        $this->db->order_by("attendance.USER", "asc");
        $this->db->order_by("employee.EPFNo", "asc");
        echo $this->datatables->generate();
    }

    public function get_attn_filter()
    {
        $Date = isset($_POST['Date']) ? $_POST['Date'] : null;
        $Comp = isset($_POST['Comp']) ? $_POST['Comp'] : 'dp';
        $attn = $this->model->get_all_today($Comp, $Date);
        $count = count($attn);
        $return_data = array();
        $data = array();
        $return_data['recordsTotal'] = intval($count);
        $return_data['recordsFiltered'] = intval($count);
        foreach ($attn as $a):
            array_push(
                $data,
                array(
                    $a['USER'],
                    $a['EmpName'],
                    $a['Name'],
                    date('Y-m-d', strtotime($a['INOUTTIME'])),
                    date('H:i:s', strtotime($a['INOUTTIME'])),
                )
            );
        endforeach;
        $return_data['data'] = $data;
        echo json_encode($return_data);
    }

    public function get_absence_filter()
    {
        $Date = isset($_POST['Date']) ? $_POST['Date'] : date('Y-m-d');
        //$Comp = (isset($_POST['Comp']) and !empty($_POST['Comp'])) ? $_POST['Comp'] : $this->attn->getComp();
        $attn = $this->model->get_all_today_not($Date);
        //print_r($attn);
        $count = count($attn);
        $return_data = array();
        $data = array();
        $return_data['recordsTotal'] = intval($count);
        $return_data['recordsFiltered'] = intval($count);
        foreach ($attn as $a):
            array_push(
                $data,
                array(
                    $a['EmpNo'],
                    $a['EmpName'],
                )
            );
        endforeach;
        $return_data['data'] = $data;
        echo json_encode($return_data);
    }

    public function getAttendance()
    {
        $date = isset($_GET['Date']) ? $_GET['Date'] : date('Y-m-d');
        //$comp = isset($_GET['Comp']) ? (($_GET['Comp'] == '') ? $this->attn->getComp() : $_GET['Comp']) : $this->attn->getComp();
        $this->load->library('datatables');
        $this->datatables
            ->select(
                "IF(" . $this->db->dbprefix('employee') . ".EPFNo != ''," . $this->db->dbprefix('employee') . ".EPFNo," . $this->db->dbprefix('attendenceinfo') . ".USER) AS USER,
            " . $this->db->dbprefix('employee') . ".EmpName,
            DATE(" . $this->db->dbprefix('attendenceinfo') . ".INOUTTIME) DATE,
            TIME(" . $this->db->dbprefix('attendenceinfo') . ".INOUTTIME) TIME"
            )
            ->from("attendenceinfo")
        //->join('comp', $this->db->dbprefix('attendenceinfo') . '.DEVICE=' . $this->db->dbprefix('comp') . '.Unit_Id', 'left')
            ->join('employee', $this->db->dbprefix('attendenceinfo') . '.USER=' . $this->db->dbprefix('employee') . '.EmpNo', 'left')
            ->where($this->db->dbprefix('attendenceinfo') . '.USER !=', 0);

        if ($date != null) {
            $this->datatables->where("DATE(" . $this->db->dbprefix('attendenceinfo') . ".INOUTTIME)", $date);
        }
        $this->db->group_by(array($this->db->dbprefix('attendenceinfo') . ".INOUTTIME", $this->db->dbprefix('attendenceinfo') . ".USER", $this->db->dbprefix('attendenceinfo') . ".DEVICE"));
        $this->db->order_by($this->db->dbprefix('attendenceinfo') . ".INOUTTIME", "ASC");
        echo $this->datatables->generate();
    }

    public function getAbsence()
    {
        $device = (!$this->Admin) ? "`DEVICE`=" . $this->db->escape($this->attn->getDivice()) . " AND" : null;
        $date = isset($_GET['Date']) ? $_GET['Date'] : date('Y-m-d');
        $this->load->library('datatables');
        $this->datatables
            ->select(
                "IF(" . $this->db->dbprefix('employee') . ".EPFNo != ''," . $this->db->dbprefix('employee') . ".EPFNo," . $this->db->dbprefix('employee') . ".EmpNo) AS USER,
            " . $this->db->dbprefix('employee') . ".EmpName"
            )
            ->from("employee")
        //->join('comp', $this->db->dbprefix('employee') . '.Comp=' . $this->db->dbprefix('comp') . '.Code', 'left')
            ->where($this->db->dbprefix('employee') . '.Active', '1');
        $this->db->where_not_in("EmpNo", "SELECT `USER` FROM `attendenceinfo` WHERE " . $device . " DATE(INOUTTIME)='" . $date . "'", false);
        echo $this->datatables->generate();
    }

    public function add_attendance()
    {
        $data = $this->data;
        $data['page'] = 'all_record';
        if ($this->input->get('USER') and $this->input->get('DATE')) {
            $data['info'] = $this->model->get_info($this->input->get('USER'), $this->input->get('DATE'));
            //echo '<pre>',print_r($data['info']); die();
        }
        $this->load->view('templates/records/add', $data);
    }

    public function make_records()
    {
        $records = $this->model->get_all();
        $shifts = $this->model->get_user_shift();

        $this->load->model('reports/summary_attendance');
        $model = $this->summary_attendance;
        $data['employees'] = $model->get_all_employees();
        echo '<pre>', print_r($shifts);
        die();
    }

    public function newEntery()
    {
        $data = $this->data;
        $data['page'] = 'new';
        $this->load->model('company_model', 'company');
        $data['companies'] = $this->company->get_all_company();
        $data['admin'] = $this->Admin;
        $this->load->model('attendance_model');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Comp', 'Branch', 'trim|required');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'trim|required');
        $this->form_validation->set_rules('inDate', 'In date', 'trim|required');
        $this->form_validation->set_rules('inTime', 'In time', 'trim|required');
        if ($this->form_validation->run() == false) {
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $data['page_title'] = 'Attendance Entry';
            $data['heading'] = 'Transaction';
            $this->load->view('templates/records/new', $data);
        } else {
            $row = array(
                'Comp' => $this->input->post('Comp'),
                'DEVICE' => $this->input->post('DEVICE'),
                'USER' => $this->input->post('EmpNo'),
                'DATE' => $this->input->post('inDate'),
                'INTIME' => $this->input->post('inTime'),
                'OUTDATE' => $this->input->post('outDate'),
                'OUTTIME' => $this->input->post('outTime'),
                'EDIT' => 1,
            );
            $this->load->model('employee_model');
            //$info = $this->employee_model->addRecord($this->input->post('EmpNo'), $this->input->post('Comp'));
            $where = array(
                'Comp' => $this->input->post('Comp'),
                'USER' => $this->input->post('EmpNo'),
                'DATE' => $this->input->post('inDate'),
            );
            $records = $this->attendance_model->addRecord($row, $where);

            //$copy = $this->model->move_temp_attn($row['USER'], $row['DATE']);

            //$update_date = ($row['OUTDATE'] != '0000-00-00') ? $row['OUTDATE'] : $row['DATE'];

            //$update = $this->update($row['USER'], $update_date);

            //$edit_recovery = $this->model->edit_rows_recovery($row['USER'], $row['DATE']);

            if ($records) {
                $this->messages->add('Record add success', "success");
                redirect($_SERVER['HTTP_REFERER']);
            } else {
                if ($this->messages->count() == 0) {
                    $this->messages->add('Error', "error");
                }

                redirect('attendance/newEntery');
            }

        }
    }

    public function all($id = null)
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'all_record';
        $total_rows = $this->model->count_all();
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data['pagination'] = $this->pagin('attendance/all/', $total_rows, 50, 3);
        $data['records'] = $this->model->get_all_formated(50, $page);
        $this->load->model('reports/summary_attendance');
        $model = $this->summary_attendance;
        $data['employees'] = $model->get_all_employees();
        $data['Edit'] = $this->Edit;
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/records/view_attendance', $data);
    }

    public function search()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'all_record';
        $search = '';
        if (isset($_GET['d']) or isset($_GET['u'])) {
            $search = $_SERVER['QUERY_STRING'];
        }
        $total_rows = $this->model->get_all_search($search, 1);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        //echo $page;
        $data['pagination'] = $this->pagin('attendance/search/', $total_rows, 50, 3);
        $data['records'] = $this->model->get_all_search($search, 0, 50, $page);
        $this->load->model('reports/summary_attendance');
        $model = $this->summary_attendance;
        $data['employees'] = $model->get_all_employees();
        $data['Edit'] = $this->Edit;
        $this->load->model('company_model', 'company');
        $data['companies'] = $this->company->get_all_company();
        $data['admin'] = $this->attendance->check_permition();
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Attendance Entry Search';
        $data['heading'] = 'Transaction';
        $data['url'] = base_url('attendance/search');
        $this->load->view('templates/records/view_attendance', $data);
    }

    /* add records set for day*/
    public function add_records()
    {
        $this->load->model('attendance_model');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('date', 'Date', 'trim|required');
        $this->form_validation->set_rules('Shift_code', 'Shift Code', 'trim|required');
        if ($this->form_validation->run() == false) {
            $this->messages->add(validation_errors(), "error");
        } else {
            $records = $this->attendance_model->add_record_for_day($this->input->post('date'), $this->input->post('Shift_code'));
            if ($records) {
                $this->messages->add('Success', "success");
            } else {
                $this->messages->add('Error', "error");
            }
        }
        $this->index();
    }

    public function get_all_attentence()
    {
        $this->allRecords = $this->attendance_model->get_all();
        echo json_encode($this->allRecords);
    }

    public function view_rocords($date = null)
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'view_record';
        $data['records'] = $this->get_rocords();
        if ($date) {
            $data['date'] = $date;
            $this->session->set_userdata('complete_date');
        } else {
            $data['date'] = false;
        }
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/records/view_records', $data);
    }

    public function get_rocords()
    {
        $records = $this->attendance_model->get_today_records();
        $new_array = array();
        $i = 0;
        $u_id = 0;
        $c_date = '';
        foreach ($records as $tow) {

            $date = date_format(date_create($tow->Clock_Time), 'Y-m-d');
            if ($u_id == $tow->User_ID and ($c_date == $date)) {
                $tow->In = 'Out';
            } else {
                $tow->In = 'In';
                $u_id = $tow->User_ID;
                $c_date = $date;
            }

            if ($i == 0) {
                $u_id = $tow->User_ID;
                $c_date = $date;
            }
            $i++;
        }
        return ($records);
    }

    public function view_completed_rocords()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'complete_record';
        $data['records'] = $this->attendance_model->get_today_completes_records();
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/records/view_completed_records', $data);
    }

    private function file_upload($file = '')
    {
        $date = date('Y-m-d');
        $config['upload_path'] = './resources/upload/' . $date;
        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path'], 0777, true);
        }
        $config['allowed_types'] = 'txt|xls|xlsx|csv';
        $config['max_size'] = '1000KB';
        $config['max_width'] = '4000';
        $config['max_height'] = '4000';
        $this->load->library('upload', $config);
        if ($this->upload->do_upload($file)) {
            $path = $this->upload->data();
            return $path['full_path'];
        } else {
            $this->messages->add($this->upload->display_errors(), "error");
            return false;
        }
    }

    //to fill the From To date : Using jquery ajax
    public function change_in_out_date()
    {
        $data = $_POST;
        $where = array('ID' => $data['ID'], 'USER' => $data['USER'], 'DATE' => $data['OLDDATE']);
        $user = $data['USER'];
        $date = $data['OLDDATE'];
        unset($data['ID']);
        unset($data['USER']);
        unset($data['OLDDATE']);
        $dates = $this->model->change_in_out_date($data, $where);
        if ($dates) {
            $this->messages->add($this->lang->line('success_date_change'), "success");
        }
        $r = array();
        $r['type'] = 0;
        $r['msg'] = 'error';
        $r['value'] = 'error';
        if ($dates) {
            $r['type'] = 1;
            $r['msg'] = $where;
            $r['value'] = $data;
        }
        echo json_encode($r);
    }

    public function update($emp = null, $date = null)
    {
        $record_formatted = array();
        $this->load->model('cron_model');
        $shift_employees = $this->cron_model->get_all_user_shifts('dp', $emp);
        $records = $this->cron_model->get_emp_attn_rows(1, $emp, $date);
        //print_r($records);

        if (!empty($shift_employees)) {
            foreach ($shift_employees as $se) {
                $user_filtered = $this->attn->filter_by_value($records, 'USER', $se->EmpNo);
                $record_formatted[] = $this->attn->get_formatted_attendance($user_filtered, $se, 'dp');
            }
        }
        $data = array();
        foreach ($record_formatted as $rec) {
            foreach ($rec as $r) {
                $data[] = $r;
            }
        }
        /*print_r($data);
        die();*/

        //check whether new record has or not
        if (isset($data) and (count($data) > 0)) {
            $this->cron_model->save($data);
            return true;
        }
        return false;
    }

    //to fill the From To date : Using jquery ajax
    public function delete_record()
    {
        $where = $_POST;
        $delete = $this->attendance_model->delete_record($where);
        if ($delete) {
            $this->messages->add($this->lang->line('success_delete_record'), "success");
        }

        echo json_encode($delete);
    }

    public function _get_formated_attendance($records = array())
    {
        //echo '<pre>', print_r($records); die();
        //$output = $this->load->view("templates/reports/table",$data,true);
        $new_records_array = array();
        if (!empty($records) and is_array($records)) {
            $i = 0;
            $u_id = 0;
            $c_date = '';
            $s_date = '';
            $new_array = array();
            $new_row = array();
            $new_i = 0;
            $type = '';
            $TotalHours = '00:00:00';
            $array_cout = is_array($records) ? count($records) : 0;
            foreach ($records as $row) {
                $date = date_format(date_create($row['INOUTTIME']), 'Y-m-d');
                if ($i == 0) {
                    //$type = $row['In'];
                    $u_id = $row['USER'];
                    $new_row = $row;
                    $new_row['DATE'] = date_format(date_create($new_row['INOUTTIME']), 'Y-m-d');
                    $new_row['INTIME'] = date_format(date_create($new_row['INOUTTIME']), 'H:i:s');
                    unset($new_row['INOUTTIME']);
                    $s_date = $date;
                } else {
                    if ($u_id == $row['USER'] and ($s_date == $date)) {
                        $c_date = date_format(date_create($row['INOUTTIME']), 'H:i:s');
                        $new_row['OUTTIME'] = $c_date;
                        $new_row['OUTDATE'] = (isset($c_date)) ? date_format(date_create($row['INOUTTIME']), 'Y-m-d') : '0000-00-00';
                        //$new_row['OUTDATE'] = date_format(date_create($c_date), 'Y-m-d');
                        //echo '<pre>', print_r($new_row); die();
                    } else {
                        if (!empty($new_row)) {
                            if (!isset($new_row['OUTDATE'])) {
                                $new_row['OUTDATE'] = '0000-00-00';
                            }

                            if (!isset($new_row['OUTTIME'])) {
                                $new_row['OUTTIME'] = '00:00:00';
                            }

                            $new_row['Comp'] = $this->_getComp();
                            $new_array[$new_i] = $new_row;
                            $new_i++;
                            unset($new_row);
                        }
                        $u_id = $row['USER'];
                        $new_row = $row;
                        $new_row['DATE'] = date_format(date_create($new_row['INOUTTIME']), 'Y-m-d');
                        $new_row['INTIME'] = date_format(date_create($new_row['INOUTTIME']), 'H:i:s');
                        unset($new_row['INOUTTIME']);
                        $s_date = $date;
                    }
                }
                $i++;
            }
            if (!empty($new_row)) {
                if (!isset($new_row['OUTTIME'])) {
                    $new_row['OUTTIME'] = '00:00:00';
                }

                $new_row['Comp'] = $this->_getComp();
                $new_array[$new_i] = $new_row;
                unset($new_row);
            }
        }
        return $new_array;
    }

    public function pagin($url, $total_rows, $per_page, $uri_segment)
    {
        $this->load->library('pagination');
        $config['base_url'] = site_url($url);
        $config['total_rows'] = $total_rows;
        $config['per_page'] = $per_page;
        $config['uri_segment'] = $uri_segment;
        $config['full_tag_open'] = '<div class="pagination">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<span class="page active">';
        $config['cur_tag_close'] = '</span>';
        $config['prev_link'] = '&lt; Previous';
        $config['next_link'] = 'Next';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['num_links'] = 4;
        $config['use_page_numbers'] = true;
        $this->pagination->initialize($config);
        return $this->pagination->create_links();
    }

    public function getAbsencesByCompany()
    {
        $comp = $this->input->post('Comp');
        $absDate = $this->input->post('absdate');
        $today_not_attend = $this->model->get_all_today_not($comp, $absDate);
        $rtnn = '';
        foreach ($today_not_attend as $rs) {
            $rtnn .= "<tr>
                    <td>" . $rs['EmpNo'] . "</td>
                    <td>" . $rs['EmpName'] . "</td>
                  </tr>";
        }
        echo json_encode($rtnn);
    }

    public function attn_complete()
    {
        $data = $this->data;
        $data['page_title'] = 'Transfer Attendance to payroll';
        $data['heading'] = 'Ttimesheet';
        $this->load->library('form_validation');
        $new_rows = array();
        $month = '';
        $this->form_validation->set_rules('month', 'month', 'required');
        if ($this->form_validation->run() == true) {
            $month = $this->input->post('month');
            $this->load->model('monthitem_model');
            $holidays = $this->monthitem_model->get_holidays($month);
            $tot_days = $this->monthitem_model->get_tot($month);
            $not_days = $this->monthitem_model->get_not($month);
            $attns = $this->model->get_all_month_attns($month);
            $emp_half_days = $this->monthitem_model->get_month_half_days_employee_wise($month);
            $user = 0;
            $i = 0;
            $ot = 0;
            $dot = 0;
            $tot = 0;
            foreach ($attns as $row) {

                $half_in_day = 0;
                $half_out_day = 0;
                if (isset($emp_half_days[$row->USER])) {
                    $days = $emp_half_days[$row->USER];
                    if (in_array($row->DATE, $days)) {
                        $half_in_day = 1;
                    }
                    if (in_array($row->OUTDATE, $days)) {
                        $half_out_day = 1;
                    }
                }

                if ($i == 1) {

                    $user = $row->USER;
                    if ($row->SHIFT == 1) {

                        //$ot = $this->attn->convertSeconds(($row->InDay+1), '.');
                        if ($row->inmonth == $month) {
                            $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                            $new = array(
                                'Comp' => $row->Comp,
                                'USER' => $row->USER,
                                'DATE' => $row->DATE,
                                'INTIME' => $row->INTIME,
                                'OUTTIME' => $row->OUTTIME,
                                'OUTDATE' => $row->OUTDATE,
                                'WEEKDAY' => $row->weekday,
                                'DIFF' => $row->InDay,
                                'OT' => $ots[0],
                                'DOT' => $ots[1],
                                'TOT' => $ots[2],
                            );
                            unset($ots);
                            $new_rows[] = $new;
                        }
                    } else {
                        //$ot = $this->attn->convertSeconds($row->OutDay, '.');
                        if ($row->inmonth == $month) {
                            $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                            $new = array(
                                'Comp' => $row->Comp,
                                'USER' => $row->USER,
                                'DATE' => $row->DATE,
                                'INTIME' => $row->INTIME,
                                'OUTTIME' => '23:59:59',
                                'OUTDATE' => $row->DATE,
                                'WEEKDAY' => $row->weekday,
                                'DIFF' => $row->InDay,
                                'OT' => $ots[0],
                                'DOT' => $ots[1],
                                'TOT' => $ots[2],
                            );
                            unset($ots);
                            $new_rows[] = $new;
                        }
                        if ($row->outmonth == $month) {
                            $ots = $this->make_ots($holidays, $not_days, $tot_days, $row->OutDay, $row->outd, $row->outweekday, $half_out_day, $row->Shift_code);
                            $new1 = array(
                                'Comp' => $row->Comp,
                                'USER' => $row->USER,
                                'DATE' => $row->OUTDATE,
                                'INTIME' => '00:00:01',
                                'OUTTIME' => $row->OUTTIME,
                                'OUTDATE' => $row->OUTDATE,
                                'WEEKDAY' => $row->weekday,
                                'DIFF' => $row->OutDay,
                                'OT' => $ots[0],
                                'DOT' => $ots[1],
                                'TOT' => $ots[2],
                            );
                            unset($ots);
                            $new_rows[] = $new1;
                        }
                    }
                } else {

                    if ($user == $row->USER) {
                        if ($row->SHIFT == 1) {
                            //$ot = $this->attn->convertSeconds(($row->InDay+1), '.');
                            $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                            if ($row->inmonth == $month) {
                                $new = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->DATE,
                                    'INTIME' => $row->INTIME,
                                    'OUTTIME' => $row->OUTTIME,
                                    'OUTDATE' => $row->OUTDATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->InDay,
                                    'OT' => $ots[0],
                                    'DOT' => $ots[1],
                                    'TOT' => $ots[2],
                                );
                                unset($ots);
                                $new_rows[] = $new;
                            }
                        } else {

                            if ($row->inmonth == $month) {
                                $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                                //echo '<pre>',print_r($ots);
                                $new = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->DATE,
                                    'INTIME' => $row->INTIME,
                                    'OUTTIME' => '23:59:59',
                                    'OUTDATE' => $row->DATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->InDay,
                                    'OT' => $ots[0],
                                    'DOT' => $ots[1],
                                    'TOT' => $ots[2],
                                );
                                unset($ots);
                                $new_rows[] = $new;
                            }

                            if ($row->outmonth == $month) {
                                $ots2 = $this->make_ots($holidays, $not_days, $tot_days, $row->OutDay, $row->outd, $row->outweekday, $half_out_day, $row->Shift_code);
                                //echo 'dot';
                                //$ot2 = $this->attn->convertSeconds($row->OutDay, '.');
                                $new1 = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->OUTDATE,
                                    'INTIME' => '00:00:01',
                                    'OUTTIME' => $row->OUTTIME,
                                    'OUTDATE' => $row->OUTDATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->OutDay,
                                    'OT' => $ots2[0],
                                    'DOT' => $ots2[1],
                                    'TOT' => $ots2[2],
                                );
                                unset($ots2);
                                $new_rows[] = $new1;
                            }
                            //echo '<pre>',print_r($new_rows); //die();
                        }
                    } else {
                        $user = $row->USER;
                        if ($row->SHIFT == 1) {
                            //$ot = $this->attn->convertSeconds(($row->InDay+1), '.');
                            if ($row->inmonth == $month) {
                                $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                                $new = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->DATE,
                                    'INTIME' => $row->INTIME,
                                    'OUTTIME' => $row->OUTTIME,
                                    'OUTDATE' => $row->OUTDATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->InDay,
                                    'OT' => $ots[0],
                                    'DOT' => $ots[1],
                                    'TOT' => $ots[2],
                                );
                                unset($ots);
                                $new_rows[] = $new;
                            }

                        } else {
                            //$ot = $this->attn->convertSeconds($row->OutDay, '.');
                            //echo 'm <br/>';
                            if ($row->inmonth == $month) {
                                $ots = $this->make_ots($holidays, $not_days, $tot_days, ($row->InDay + 1), $row->ind, $row->weekday, $half_in_day, $row->Shift_code);
                                $new = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->DATE,
                                    'INTIME' => $row->INTIME,
                                    'OUTTIME' => '23:59:59',
                                    'OUTDATE' => $row->DATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->InDay,
                                    'OT' => $ots[0],
                                    'DOT' => $ots[1],
                                    'TOT' => $ots[2],
                                );
                                unset($ots);
                                $new_rows[] = $new;
                            }

                            if ($row->outmonth == $month) {
                                $ots = $this->make_ots($holidays, $not_days, $tot_days, $row->OutDay, $row->outd, $row->outweekday, $half_out_day, $row->Shift_code);
                                $new1 = array(
                                    'Comp' => $row->Comp,
                                    'USER' => $row->USER,
                                    'DATE' => $row->OUTDATE,
                                    'INTIME' => '00:00:01',
                                    'OUTTIME' => $row->OUTTIME,
                                    'OUTDATE' => $row->OUTDATE,
                                    'WEEKDAY' => $row->weekday,
                                    'DIFF' => $row->OutDay,
                                    'OT' => $ots[0],
                                    'DOT' => $ots[1],
                                    'TOT' => $ots[2],
                                );
                                unset($ots);
                                $new_rows[] = $new1;
                            }
                        }
                    }
                }
                $i++;
            }
            //echo '<pre>',print_r($new_rows);
            //echo '<pre>',print_r($attns);
            //die();
            //die();

        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('attendance/attn_complete');
        }

        if ($this->form_validation->run() == true && $this->model->add_month_completed_attn($new_rows, $month)) {
            $this->messages->add('Month TimeSheet successfully added', "success");
            redirect('attendance/attn_complete');
        } else {
            $this->load->model('items_model');
            $this->load->model('employee_model');
            $data['allowances'] = $this->items_model->get_all_by_type('A');
            $data['deductions'] = $this->items_model->get_all_by_type('D');
            $data['employees'] = $this->employee_model->get_all_filter();
            //echo '<pre>',print_r($data['allowances']); die();
            $data['page'] = 'attn_complete';
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            //echo '<pre>',print_r($data['message']),'</pre>';
            //die();
            $this->load->view('templates/records/attn_complete', $data);
        }
    }

    public function make_ots($holidays, $not_days, $tot_days, $normal_in_date_seconds = 0, $ind = 0, $weekday = 0, $hday = 0, $Shift_code = '')
    {
        $ot_hours = 0; //second
        $dot_hours = 0; //second
        $tot_hours = 0; //second
        $not = 0;
        $dot = 0;
        $tot = 0;
        $day_second = 9 * 60 * 60;
        $saturday_second = 5 * 60 * 60;
        $half_day = (4 * 60 * 60);
        $half_day_get_limit = (4 * 60 * 60) + (30 * 60);
        $half_day_limit = (7 * 60 * 60);
        $code = 'NOT';
        if ($code == 'NOT') {
            if ($Shift_code == '0023') {
                /* When IN day not holiday, IN day saturday */
                if ($weekday == 5) {
                    if ($normal_in_date_seconds > $saturday_second) {
                        $day_diff = ($normal_in_date_seconds - $saturday_second);
                        $ot_hours = $ot_hours + $day_diff;
                        //echo 'd';
                    }
                }

            } else {
                if (in_array($ind, $not_days)) {
                    $tot_hours = $ot_hours + $normal_in_date_seconds;
                }

                /* When IN day not holiday, IN day saturday */
                if (!in_array($ind, $holidays) and $weekday == 5) {
                    if ($normal_in_date_seconds > $saturday_second) {
                        $day_diff = ($normal_in_date_seconds - $saturday_second);
                        $ot_hours = $ot_hours + $day_diff;
                        //echo 'd';
                    }
                } else if (!in_array($ind, $holidays) and $weekday != 5) {

                    switch ($hday) {
                        case 0:
                            if ($normal_in_date_seconds > $day_second) {
                                $day_diff = ($normal_in_date_seconds - $day_second);
                                $ot_hours = $ot_hours + $day_diff;

                            }
                            break;
                        case 1:
                            if ($normal_in_date_seconds >= $half_day_get_limit and $normal_in_date_seconds < $half_day_limit) {
                                $day_diff = ($normal_in_date_seconds - $half_day);
                                $ot_hours = $ot_hours + $day_diff;

                            } else if ($normal_in_date_seconds < $half_day_get_limit) {
                                /*$day_diff = ($normal_in_date_seconds - $half_day);
                            $ot_hours = $ot_hours + $day_diff;*/
                            } else {
                                if ($normal_in_date_seconds > $day_second) {
                                    $day_diff = ($normal_in_date_seconds - $day_second);
                                    $ot_hours = $ot_hours + $day_diff;
                                }
                            }

                            break;

                    }

                    /*
                all calculation
                if ($normal_in_date_seconds > $day_second) {

                $day_diff = ($normal_in_date_seconds - $day_second);
                $ot_hours = $ot_hours + $day_diff;

                }*/
                }
            }

        }

        //$not = $this->attn->convertSeconds($ot_hours, '.');
        $not = $ot_hours;

        $code = 'DOT';

        if ($code == 'DOT') {
            //When IN day holiday
            if (in_array($ind, $holidays)) {
                /* if ($normal_in_date_seconds > $hours_second)
                {
                $dot_hours = $ot_hours + $normal_in_date_seconds;
                } */
                if (empty($tot_days) or !in_array($ind, $tot_days)) {
                    //echo 'dot';
                    $dot_hours = $dot_hours + $normal_in_date_seconds;
                }
                //echo 'x'.$ind;
            }
        }
        $dot = $dot_hours;

        $code = 'TOT';
        if ($code == 'TOT') {
            if (in_array($ind, $tot_days)) {
                $tot_hours = $tot_hours + $normal_in_date_seconds;
            }
        }
        $tot = $tot_hours;
        return array($not, $dot, $tot);
    }

    //view completed attendance month wise
    public function transferred_attendance()
    {
        $data = $this->data;
        $data['page'] = 'transferred_attendance';
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $v = "";
        if ($this->input->post('month') and $this->input->post('EmpNo')) {
            $v .= "&month=" . $this->input->post('month');
            $data['month'] = $this->input->post('month');
            $v .= "&EmpNo=" . $this->input->post('EmpNo');
            $data['EmpNo'] = $this->input->post('EmpNo');
            $completed_attendance = $this->model->get_completed_attendance($data['month'], $data['EmpNo']);
            $data['completed_attendance'] = $completed_attendance;
            //$this->attn->p($completed_attendance);die();
        }
        $data['v'] = $v;
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Transferred Attendance';
        $data['heading'] = 'Timesheet';
        $data['url'] = base_url('attendance');
        $this->load->view('templates/records/transferred_attendance', $data);
    }

    public function getCompletedRecords()
    {
        $month = (isset($_GET['month']) and !empty($_GET['month'])) ? $this->input->get('month') : null;
        $EmpNo = (isset($_GET['EmpNo']) and !empty($_GET['EmpNo'])) ? $this->input->get('EmpNo') : null;
        $this->load->library('datatables');
        $this->datatables
            ->select(
                $this->db->dbprefix('attn_completed') . ".DATE,
            " . $this->db->dbprefix('attn_completed') . ".INTIME,
            " . $this->db->dbprefix('attn_completed') . ".OUTDATE,
            " . $this->db->dbprefix('attn_completed') . ".OUTTIME,
            " . $this->db->dbprefix('attn_completed') . ".OT,
            " . $this->db->dbprefix('attn_completed') . ".DOT
            "
            )
            ->from("attn_completed")
            ->join('employee', $this->db->dbprefix('attn_completedf') . '.USER=' . $this->db->dbprefix('employee') . '.EmpNo', 'left');
        //->where($this->db->dbprefix('attn_completed') . '.Comp', $this->attn->getComp());
        //->unset_column('date,user');

        if ($EmpNo != null) {
            $this->datatables->where($this->db->dbprefix('attn_completed') . ".USER", $EmpNo);
            $this->datatables->where($this->db->dbprefix('employee') . ".EmpNo", $EmpNo);
        }
        if ($month != null) {
            $this->datatables->where("DATE_FORMAT(attn_completed.DATE, '%Y-%m') = '" . $month . "'", null, false);
        }
        $this->db->order_by("attn_completed.DATE", "desc");
        $this->db->order_by("attn_completed.USER", "asc");
        $this->db->order_by("employee.EPFNo", "asc");
        echo $this->datatables->generate();
    }

    public function summary_daily_attendance()
    {

        $Date = (isset($_GET['date'])) ? $_GET['date'] : null;
        $Comp = (isset($_GET['Comp']) and $_GET['Comp'] != '0') ? $_GET['Comp'] : null;
        $data['page'] = 'today';
        $xls = (isset($_GET['xls']) and !empty($_GET['xls'])) ? true : false;
        $pdf = (isset($_GET['pdf']) and !empty($_GET['pdf'])) ? true : false;
        $this->load->model('shift_model');
        $comtabel = 60;
        if ($pdf || $xls) {
            $attendances = $this->model->get_all_today($Comp, $Date);
            $prev_date = date('Y-m-d', strtotime($Date . ' -1 day'));
            $yesterday_attendances = $this->model->get_all_yesterday($Comp, $prev_date);
            //echo '<pre>',print_r($yesterday_attendances); die();
            $this->load->model('reports/summary_attendence');
            $model = $this->summary_attendence;
            if ($Comp) {
                $com = $model->getComp($Comp);
            } else {
            }

            if ($Comp != null) {
                $comp = $model->getComp($Comp);
            } else {
                $comp = array('Name' => $this->session->userdata('CompName'), 'Address' => $this->session->userdata('Address'));
            }
            if ($xls) {
                $this->load->library('excel');
                $this->excel->setActiveSheetIndex(0);
                $this->excel->getActiveSheet()->setTitle('Attendance Summary');
                $this->excel->getActiveSheet()->getStyle('B1:B4')->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getColumnDimension('B1')->setWidth(45);

                $this->excel->getActiveSheet()->SetCellValue('B1', 'Daily Attendance');
                $this->excel->getActiveSheet()->SetCellValue('C1', $comp['Name']);

                //$this->excel->getActiveSheet()->SetCellValue('B2',$compa);
                $this->excel->getActiveSheet()->SetCellValue('B3', 'Date : ' . date("d/m/Y", strtotime($Date)));
                $this->excel->getActiveSheet()->SetCellValue('C2', 'Attendance');
                $this->excel->getActiveSheet()->SetCellValue('B5', 'Id');
                $this->excel->getActiveSheet()->SetCellValue('C5', 'Emp Name');
                //$this->excel->getActiveSheet()->SetCellValue('D5', 'Company');
                $this->excel->getActiveSheet()->SetCellValue('D5', 'Department');
                $this->excel->getActiveSheet()->SetCellValue('E5', 'Attendance');
                $this->excel->getActiveSheet()->getColumnDimension('E5')->setWidth(40);
                $row = 6;
                $row_open = $row - 1;
                //View Attendance
                foreach ($attendances as $data_row) {
                    $this->excel->getActiveSheet()->SetCellValue('B' . $row, $data_row['USER']);
                    $this->excel->getActiveSheet()->SetCellValue('C' . $row, $data_row['EmpName']);
                    //$this->excel->getActiveSheet()->SetCellValue('D' . $row, $data_row['Name']);
                    $this->excel->getActiveSheet()->SetCellValue('D' . $row, $data_row['Department']);
                    $this->excel->getActiveSheet()->SetCellValue('E' . $row, date('H:i:s', strtotime($data_row['INOUTTIME'])));
                    $row++;
                    $add = $row;
                }

                $style = array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
                $style_left = array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT));
                $styleborder = array('borders' => array('allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN)));

                $this->excel->getActiveSheet()->getStyle('B' . $row_open . ':E' . $row)->applyFromArray($styleborder);

                $row2 = $add + 7;
                $row3 = $row2 + 2;
                $head = $row2 - 2;
                $headmerge = $head + 1;
                $head2 = $row3 - 1;

                $row = $row + 5;

                $this->excel->getActiveSheet()->getStyle('B1:B4')->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getColumnDimension('B1')->setWidth(45);
                //$this->excel->getActiveSheet()->SetCellValue('B2',$compa);
                $this->excel->getActiveSheet()->SetCellValue('B' . ($row + 1), 'Date : ' . date("d/m/Y", strtotime($prev_date)));
                $this->excel->getActiveSheet()->getStyle('B' . ($row + 1))->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getStyle('B' . ($row + 1))->getFont()->setSize(14);
                $this->excel->getActiveSheet()->SetCellValue('C' . $row, 'Attendance');
                $row++;
                $row++;
                $row++;
                $this->excel->getActiveSheet()->SetCellValue('B' . $row, 'Id');
                $this->excel->getActiveSheet()->SetCellValue('C' . $row, 'Emp Name');
                $this->excel->getActiveSheet()->SetCellValue('D' . $row, 'Department');
                $this->excel->getActiveSheet()->SetCellValue('E' . $row, 'Attendance');
                //$this->excel->getActiveSheet()->getColumnDimension('E'.$row)->setWidth(40);

                $row = $row + 1;
                //View Attendance
                foreach ($yesterday_attendances as $ya) {
                    $this->excel->getActiveSheet()->SetCellValue('B' . $row, $ya['USER']);
                    $this->excel->getActiveSheet()->SetCellValue('C' . $row, $ya['EmpName']);
                    //$this->excel->getActiveSheet()->SetCellValue('D' . $row, $ya['Name']);
                    $this->excel->getActiveSheet()->SetCellValue('D' . $row, $ya['Department']);
                    $this->excel->getActiveSheet()->SetCellValue('E' . $row, date('H:i:s', strtotime($ya['INOUTTIME'])));
                    $row++;
                    $add = $row;
                }

                $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
                $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
                $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
                $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
                //$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
                $this->excel->getActiveSheet()->mergeCells('C2:D3');
                $this->excel->getActiveSheet()->mergeCells('C' . $head . ':D' . $headmerge);
                $this->excel->getActiveSheet()->getStyle("C2:D3")->getFont()->setSize(16);
                $this->excel->getActiveSheet()->getStyle("B1:B3")->getFont()->setSize(13);
                $this->excel->getActiveSheet()->getStyle("A5:D5")->getFont()->setSize(12);

                $this->excel->getActiveSheet()->getStyle('A' . $head2 . ':' . 'C' . $head2)->getFont()->setSize(12);
                $this->excel->getActiveSheet()->getStyle('C' . $head . ':D' . $headmerge)->getFont()->setSize(16);
                $this->excel->getActiveSheet()->getStyle("C2:D3")->applyFromArray($style);
                $this->excel->getActiveSheet()->getStyle('C5:E' . $row3)->applyFromArray($style_left);
                $this->excel->getActiveSheet()->getStyle('C' . $head . ':D' . $headmerge)->applyFromArray($style);
                $this->excel->getActiveSheet()->getStyle('B' . $head2 . ':E' . $row)->applyFromArray($styleborder);

                $filename = 'attendence_summary_report';
                $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                $this->excel->getActiveSheet()->getStyle('A1:D5')->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getStyle('B' . $head2 . ':' . 'E' . $head2)->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getStyle('C' . $head . ':E' . $headmerge)->getFont()->setBold(true);

                if (ob_get_contents()) {
                    ob_end_clean();
                }

                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment;filename="' . $filename . '.xls"');
                header('Cache-Control: max-age=0');
                if (ob_get_contents()) {
                    ob_end_clean();
                }

                $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
                $objWriter->save('php://output');
                exit();
            }
        } else {
            $this->load->library('datatables');

            $this->datatables
                ->select("A.USER,E.EmpName AS NAME,A.DATE,A.INTIME,A.OUTTIME,
		IF( TIME( `A`.`OUTTIME`) = '00:00:00','00:00',TIME_FORMAT(TIMEDIFF(A.OUTTIME,A.INTIME),'%H:%i')) AS HOURS,
		IF(
			TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > TIME_TO_SEC(TIMEDIFF(S.Shift_To,S.Shift_From)),
			TIME_FORMAT( TIMEDIFF(A.OUTTIME,S.Shift_To) , '%H:%i' ),
			'00:00'
		) AS Extra,
		IF(
			TIME_TO_SEC(
				IF(
					TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > TIME_TO_SEC(TIMEDIFF(S.Shift_To,S.Shift_From)),
					TIME_FORMAT( TIMEDIFF(A.OUTTIME,S.Shift_To) , '%H:%i' )
					, '00:00'
				)
			) > (" . $comtabel . ")*60
			,
			IF(
				TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > TIME_TO_SEC(TIMEDIFF(S.Shift_To,S.Shift_From)),
				TIME_FORMAT( TIMEDIFF(A.OUTTIME,S.Shift_To) , '%H:%i' ),
				'00:00'
			)
			,
			'00:00'
		) AS OT", false)
                ->from('attendance1 A')
                ->join('employee AS E', "A.USER=E.EmpNo AND A.Comp=E.Comp", 'left')
                ->join('shift_transaction AS T', "T.EmpNo=E.EmpNo AND T.Comp_Id=A.Comp", 'left')
                ->join('shift AS S', "S.shift_code=T.Shift_code AND S.Comp_Id=A.Comp", 'left')
                ->where('E.Active', 1)
                ->where('A.Comp', $Comp);
            // ->group_by('products.id');
            if ($user_id) {
                $this->datatables->where("A.USER", $user_id);
            }
            if (!empty($start_date) and !empty($end_date)) {
                $this->datatables->where("A.DATE BETWEEN '" . $start_date . "' AND '" . $end_date . "'");
            } else if (!empty($start_date) and empty($end_date)) {
                $this->datatables->where("A.DATE", $start_date);
            }

        }
        if ($Comp != null) {
            $this->datatables->where("A.Comp", $Comp);
        }

        //$this->datatables->where("A.OUTTIME !=", '00:00:00');
        echo $this->datatables->generate();
    }

}
