<?php
ob_start();
require FCPATH . '/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Reports extends MY_Controller
{
    function __construct()
    {
        set_time_limit(1200);
        //ini_set('max_execution_time', '1200');
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->helper('report');
        $this->load->library('form_validation');
        $this->load->helper('download'); // Load download helper
    }
    function index()
    {
        parent::__construct();
        $this->date_input_pdf_export();
        $this->load->library('form_validation');
    }

    function _get_common_report_data()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data = array();
        $data['report_date_range_simple'] = get_simple_date_ranges();
        $data['months'] = get_months();
        $data['days'] = get_days();
        $data['years'] = get_years();
        $data['selected_month'] = date('n');
        $data['selected_day'] = date('d');
        $data['selected_year'] = date('Y');
        return $data;
    }

    public function _makeTable($pdf, $header, $data)
    {
        $pdf->Ln();
        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
        // Header
        $w = array(40, 80, 35, 25);
        $num_headers = count($header);
        for ($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln(); // Color and font restoration
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
        $fill = 0;
        foreach ($data as $rows) {
            $pdf->SetFontSize(10);
            $i = 0;
            foreach ($rows as $row) {
                $pdf->Cell($w[$i], 6, trim($row), 'LR', 0, 'L', $fill);
                $i++;
            }
            $pdf->SetFillColor(255, 255, 255);
            $pdf->Ln();
            $fill = !$fill;
        }
        $pdf->Cell(array_sum($w), 0, '', 'T');
        $pdf->Ln();
    }

    function payslips()
    {
        $this->form_validation->set_rules('month', 'Month', 'required');
        //$this->form_validation->set_rules('EmpNo[]', 'EmpNo', 'required');
        if ($this->form_validation->run('reports/payslips') == true) {
            ini_set('max_execution_time', 0);
            $data = $this->data;
            $emp = array();
            if ($this->input->post('month')) {
                $data['month'] = $this->input->post('month');
            }

            if ($this->input->post('EmpNo')) {
                $data['EmpNo'] = $this->input->post('EmpNo');
                $emp = $data['EmpNo'];
            }
            //echo '<pre>',print_r($data['EmpNo']); die();
            //$data['year']
            $month = $data['month'];
            $data['page'] = 'pay_slip';
            $this->load->model('reports/payslip_model');
            $model = $this->payslip_model;
            $employees = $model->getPayslipByemployees($this->attn->getComp(), $month, $emp);
            //$this->attn->p($employees);
            //echo count($employees);
            //die();
            $setting = $model->get_setting($this->attn->getComp());
            $margin_bottom = NULL;
            $header = NULL;
            $margin_top = NULL;
            ob_start();
            $this->load->library('pdf');
            $this->load->library('payslip');
            //set document information
            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'a4', true, 'utf-8', false);
            $pdf->setPrintHeader(false);
            $pdf->SetMargins(1, 2, 1, true);
            $i = 0;
            $pay_slip = '';
            $payslip_array = array();
            foreach ($employees as $empl) {
                if ($i % 2 == 0) { //$this->attn->p($options); die();
                    $pay_slip .= '<style>                                
                @page {                                  
                    size: landscape;
                }                                                            
                html,body{                                                                    
                height:841px;
                width:210mm;
                margin: 0;
                padding: 0;
                font-size:7px;
                font-family: "Times New Roman";
                }                                                            
                .table {   
                 max-width: 100%;
                 width: 100%;
                 }                                                            
                 table {                                                                    
                 border-collapse: collapse;
                 border-spacing: 0;
                 font-size: 8px;
                 }                                                            
                 table td{                                                                    
                    vertical-align:top;
                    margin: 0;
                 }                                                            
                 table tr, table td{                                    
                 line-height: 2px;
                    margin: 0px;
                    padding: 0;
                    height: 13px;
                }                                                            
                .table-bordered > tfoot > tr > td {                                                                    
                border: 1px solid #dddddd;
                }                                                            
                .table > tfoot > tr > td {                                                                    
                border-top: 1px solid #dddddd;
                 vertical-align: top;
                }                                                            
                .underlined {                                                                    
                border-bottom: 0.4em solid #000;
                 font-weight: bold;
                 width:100px !important;
                 }                                                            
                 div.row{width: 100%;}                                                            
                 div.col-sm-6{width: 50%; }                                                                    
                 /*table { border: 1px solid #dddddd;}*/                                                    
                 </style>';
                    $pay_slip .= '<div class="row">';
                    $pay_slip .= '<table border="0" style="height: 29.7cm;" width="100%"><tr>';
                }
                $pay_slip .= '<td width="24%">';
                $pay_slip .= '<table width="100%" style="height: 29.7cm;padding-top: 5px; padding-bottom: 5px; padding-left: 0px; padding-right: 2px;" class="table">';
                $pay_slip .= '<thead>';
                $pay_slip .= '<tr ><th colspan="2"><strong style="text-align: center">' . $this->session->userdata('CompName') . '</strong></th></tr>';
                $pay_slip .= '<tr ><th colspan="2" style="text-align: center"><p>' . $this->session->userdata('Address') . '</p></th></tr>';
                $pay_slip .= '<tr><th colspan="2" style="text-align: center"><u>Pay Slip for the month of ' . date('F-Y', strtotime($month)) . '</u></th></tr>';
                $pay_slip .= '</thead>';
                $pay_slip .= '<tbody>';
                $pay_slip .= '<tr ><td colspan="2">Emp.No &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->EmpNo . '</td></tr>';
                $pay_slip .= '<tr ><td colspan="2">Employee Name &nbsp;&nbsp;&nbsp;: ' . $empl->EmpName . '</td></tr>';
                $pay_slip .= '<tr ><td colspan="2">Department &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Department . '</td></tr>';
                $pay_slip .= '<tr ><td colspan="2">Designation &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Designation . '</td></tr>';
                $pay_slip .= '<tr ><td colspan="2">Grade &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . (isset($empl->Grade) ? $empl->Grade : '') . '</td></tr>';
                $pay_slip .= '<tr><td width="65%"  style="text-align:right"><u>Basic Salary for EPF</u></td><td width="35%" style="text-align: right;"><u>' . number_format($empl->BasicSalary, 2) . '</u></td></tr>';
                $pay_slip .= '<tr><td width="65%" style=""><b>Salary</b></td><td width="35%" style="text-align: right;"><b>' . number_format($empl->Salary, 2) . '</b></td></tr>';
                $allowances_for_basic = unserialize($empl->AllowancesForBasic);
                if (isset($allowances_for_basic) and !empty($allowances_for_basic)) {
                    foreach ($allowances_for_basic as $adb) {
                        $pay_slip .= '<tr ><td>' . $adb[0] . '</td><td style="text-align: right;">' . number_format($adb[1], 2) . '</td></tr>';
                    }
                }
                $deductions_for_basic = unserialize($empl->DeductionsForBasic);

                if (isset($deductions_for_basic) and !empty($deductions_for_basic)) {
                    foreach ($deductions_for_basic as $dfb) {
                        $pay_slip .= '<tr ><td>' . $dfb[0] . '</td><td style="text-align: right;">' . number_format($dfb[1], 2) . '</td></tr>';
                    }
                }
                $pay_slip .= '<tr ><td style="text-align: right; border-bottom: 0.5px solid #000;"><h4>Total Salary </h4></td><td style="text-align: right; border-top: 1px solid #000;border-bottom: 0.5px solid #000;"><h4>' . number_format($empl->TotalSalary, 2) . '</h4></td></tr>';


                $allowances = unserialize($empl->AllowanceString);

                if (isset($allowances) and !empty($allowances)) {
                    $pay_slip .= '<tr ><td colspan="2" style="text-align: center"><h4 style="margin: 0; padding: 0;">ADDITIONS</h4></td></tr>';

                    foreach ($allowances as $a) {
                        $pay_slip .= '<tr ><td>' . $a[0] . '</td><td style="text-align: right;">' . number_format($a[1], 2) . '</td></tr>';
                    }

                    $pay_slip .= '<tr><td style=" border-top:0.5px solid #000;"><strong>Total Allowances</strong></td><td style="text-align: right; border-top: 0.5px solid #000;"><h4>' . number_format($empl->Allowance, 2) . '</h4></td></tr>';
                }
                $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><h4>Gross Salary: </h4></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><h4>' . number_format($empl->GrossSalary, 2) . '</h4></td></tr>';
                $deductions = unserialize($empl->DeductionString);

                if (isset($deductions) and !empty($deductions)) {
                    $pay_slip .= '<tr ><td colspan="2"><h4 style="margin: 0; padding: 0; text-align: center">DEDUCTIONS</h4></td></tr>';

                    foreach ($deductions as $d) {
                        $pay_slip .= '<tr ><td>' . $d[0] . '</td><td style="text-align: right;">' . number_format($d[1], 2) . '</td></tr>';
                    }
                    $pay_slip .= '<tr><td style=" border-top:0.2px solid #000;">Total Deduction</td><td style="text-align: right; border-top:0.2px solid #000;"><h4>' . number_format($empl->Deduction, 2) . '</h4></td></tr>';
                }
                $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><b>Net Salary : </b></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><b>' . number_format($empl->salaryPayableRound, 2) . '</b></td></tr>';
                $pay_slip .= '<tr ><td>E.P.F ' . $empl->EPFepmString . '% </td><td style="text-align: right;">' . number_format($empl->EPFepm, 2) . '</td></tr>';
                $pay_slip .= '<tr ><td >ETF ' . $empl->ETFString . '% </td><td style="text-align: right; ">' . number_format($empl->ETF, 2) . '</td></tr>';
                //$pay_slip .= '<tr ><td style="border-bottom: 1px dashed #000;" colspan="2"><br/></td></tr>';

                if (isset($empl->Bank) and !empty($empl->Bank)) {
                    $pay_slip .= '<tr ><td colspan="2">Bank : ' . $empl->Bank . ' / A/C No : ' . $empl->AccountNo . '</td></tr>';
                    //$pay_slip .= '<tr style=" "><td style="border-bottom:1px solid black;">'.$empl->Bank.' '.$empl->Branch.'</td><td style="text-align: right;border-bottom:1px solid black;">'.number_format($empl->salaryPayableRound,2).'</td></tr>';

                }

                $pay_slip .= '<tr><td width="100%" colspan="2" style=" font-size:6px;text-align: center; border-top: 1px solid #000;">Software Developed by Sallelanka Solutions </td></tr>';

                $pay_slip .= '</tbody>';
                $pay_slip .= '</table>';
                $pay_slip .= '</td>';
                if ($i % 2 == 0 or $i % 2 == 1) {
                    $pay_slip .= '<td width="1%" style="border-left: 0.4px dotted #000000; height: 100%">&nbsp;</td>';
                }

                if ($i % 2 == 1) {
                    $pay_slip .= '</tr></table></div>';
                    //echo $pay_slip; die();
                    $pdf->AddPage('P', 'A4');
                    $pdf->writeHTML($pay_slip, true, false, true, false, '');
                    $pdf->lastPage();
                    //$pdf->setPage($pdf->getPage());
                    $pay_slip = '';
                }

                $i++;
            }
            //echo $i; die();
            if ($i % 4 == 1) {
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('L', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            if ($i % 4 == 3) {
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('L', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            if ($i % 4 == 2) { //echo 'yes'; die();
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('L', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            if ($i == 1) {
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('L', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            if (ob_get_contents())
                ob_end_clean();

            $this->load->helper('download');
            force_download($pdf->Output('payslip-' . $month . '.pdf', 'I'), 'Out put');
        }
        if ($this->form_validation->run() == true && $this->payroll_model->addPayroll($data)) {
            $this->messages->add('Template successfully added', "success");
            redirect('payroll/add_template');
        } else {
            $data = $this->data;
            $this->messages->add(validation_errors(), "error");
            //echo date('F-Y',strtotime('2017-10')); die();
            $data['page'] = 'pay_slip';
            $data['page_title'] = 'Pay Slip';
            $data['heading'] = 'Reports';
            $this->load->model('reports/summary_attendance');
            $model = $this->summary_attendance;
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter();
            $this->load->model('company_model');
            $data['companies'] = $this->company_model->getAll();
            $data['message'] = view_error($this->messages->get());
            $this->load->view("templates/reports/payslip", $data); 
        }
    }


    function pay_slips()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        $emp = 0;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
            $emp = $data['EmpNo'];
        }
        //$data['year']
        $month = $data['month'];
        $data['page'] = 'pay_slip';
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $employees = $model->getPayslip($this->attn->getComp(), $month, (($emp) ? $emp : 0));
        //$this->attn->p($employees);        //echo count($employees);        //die();
        $setting = $model->get_setting($this->attn->getComp());
        $margin_bottom = NULL;
        $header = NULL;
        $margin_top = NULL;
        ob_start();
        $this->load->library('pdf');
        $this->load->library('payslip');
        //set document information
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'a4', true, 'utf-8', false);
        $pdf->setPrintHeader(false);
        $pdf->SetMargins(1, 2, 2, true);
        $i = 0;
        $pay_slip = '';
        $payslip_array = array();
        foreach ($employees as $empl) {
            if ($i % 2 == 0) {
                //$this->attn->p($options); die();
                $pay_slip .= '<style>                            
                @page {  
                size: landscape;
                }                            
                html,body{                                
                    height:841px;
                    width:210mm;
                    margin: 0;
                    padding: 0;
                    font-size:8px;
                    font-family: "Times New Roman";
                }                            
                .table {                                
                    max-width: 100%;
                    width: 100%;
                }                            
                table {                                
                    border-collapse: collapse;
                    border-spacing: 0;
                    font-size: 8px;
                }                            
                table td{                                                  
                    vertical-align:top;
                    margin: 0;
                }                                                
                table tr, table td{                                
                    line-height: 2px;
                    margin: 0px;
                    padding: 0;
                    height: 13px;
                }                                                
                .table-bordered > tfoot > tr > td {                                
                    border: 1px solid #dddddd;
                }                            
                .table > tfoot > tr > td {                                
                    border-top: 1px solid #dddddd;
                    vertical-align: top;
                }                            
                .underlined {                                
                    border-bottom: 0.4em solid #000;
                    font-weight: bold;
                    width:100px !important;
                }                            
                div.row{width: 100%;}                            
                div.col-sm-6{width: 50%; }                                                    
                /*table { border: 1px solid #dddddd;}*/                        
                </style>';
                $pay_slip .= '<div class="row">';
                $pay_slip .= '<table border="0" style="height: 29.7cm;" width="100%"><tr>';
            }
            $pay_slip .= '<td width="24%">';
            $pay_slip .= '<table width="100%" style="height: 29.7cm;padding-top: 5px; padding-bottom: 5px; padding-left: 0px; padding-right: 2px;" class="table">';
            $pay_slip .= '<thead>';
            $pay_slip .= '<tr ><th colspan="2"><strong style="text-align: center">' . $this->session->userdata('CompName') . '</strong></th></tr>';
            $pay_slip .= '<tr ><th colspan="2" style="text-align: center"><p>' . $this->session->userdata('Address') . '</p></th></tr>';
            $pay_slip .= '<tr><th colspan="2" style="text-align: center"><u>Pay Slip for the month of ' . date('F-Y', strtotime($month)) . '</u></th></tr>';
            $pay_slip .= '</thead>';
            $pay_slip .= '<tbody>';
            $pay_slip .= '<tr ><td colspan="2">Emp.No &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->EmpNo . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Employee Name &nbsp;&nbsp;&nbsp;: ' . $empl->EmpName . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Department &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Department . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Designation &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Designation . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Grade &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . (isset($empl->Grade) ? $empl->Grade : '') . '</td></tr>';
            $pay_slip .= '<tr><td width="65%"  style="text-align:right"><u>Basic Salary for EPF</u></td><td width="35%" style="text-align: right;"><u>' . number_format($empl->BasicSalary, 2) . '</u></td></tr>';
            $pay_slip .= '<tr><td width="65%" style=""><b>Salary</b></td><td width="35%" style="text-align: right;"><b>' . number_format($empl->Salary, 2) . '</b></td></tr>';
            //Allowances for basic
            $allowances_for_basic = unserialize($empl->AllowancesForBasic);
            if (isset($allowances_for_basic) and !empty($allowances_for_basic)) {
                foreach ($allowances_for_basic as $adb) {
                    $pay_slip .= '<tr ><td>' . $adb[0] . '</td><td style="text-align: right;">' . number_format($adb[1], 2) . '</td></tr>';
                }
            }
            //Deductions for basic
            $deductions_for_basic = unserialize($empl->DeductionsForBasic);
            if (isset($deductions_for_basic) and !empty($deductions_for_basic)) {
                foreach ($deductions_for_basic as $dfb) {
                    $pay_slip .= '<tr ><td>' . $dfb[0] . '</td><td style="text-align: right;">' . number_format($dfb[1], 2) . '</td></tr>';
                }
            }
            $pay_slip .= '<tr ><td style="text-align: right; border-bottom: 0.5px solid #000;"><h4>Total Salary </h4></td><td style="text-align: right; border-top: 1px solid #000;border-bottom: 0.5px solid #000;"><h4>' . number_format($empl->TotalSalary, 2) . '</h4></td></tr>';
            //All allowances
            $allowances = unserialize($empl->AllowanceString);
            if (isset($allowances) and !empty($allowances)) {
                $pay_slip .= '<tr ><td colspan="2" style="text-align: center"><h4 style="margin: 0; padding: 0;">ADDITIONS</h4></td></tr>';
                foreach ($allowances as $a) {
                    $pay_slip .= '<tr ><td>' . $a[0] . '</td><td style="text-align: right;">' . number_format($a[1], 2) . '</td></tr>';
                }
                $pay_slip .= '<tr><td style=" border-top:0.5px solid #000;"><strong>Total Allowances</strong></td><td style="text-align: right; border-top: 0.5px solid #000;"><h4>' . number_format($empl->Allowance, 2) . '</h4></td></tr>';
            }
            $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><h4>Gross Salary: </h4></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><h4>' . number_format($empl->GrossSalary, 2) . '</h4></td></tr>';
            //All deductions
            $deductions = unserialize($empl->DeductionString);
            if (isset($deductions) and !empty($deductions)) {
                $pay_slip .= '<tr ><td colspan="2"><h4 style="margin: 0; padding: 0; text-align: center">DEDUCTIONS</h4></td></tr>';
                foreach ($deductions as $d) {
                    $pay_slip .= '<tr ><td>' . $d[0] . '</td><td style="text-align: right;">' . number_format($d[1], 2) . '</td></tr>';
                }
                $pay_slip .= '<tr><td style=" border-top:0.2px solid #000;">Total Deduction</td><td style="text-align: right; border-top:0.2px solid #000;"><h4>' . number_format($empl->Deduction, 2) . '</h4></td></tr>';
            }
            $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><b>Net Salary : </b></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><b>' . number_format($empl->salaryPayableRound, 2) . '</b></td></tr>';
            $pay_slip .= '<tr ><td>E.P.F ' . $empl->EPFepmString . '% </td><td style="text-align: right;">' . number_format($empl->EPFepm, 2) . '</td></tr>';
            $pay_slip .= '<tr ><td >ETF ' . $empl->ETFString . '% </td><td style="text-align: right; ">' . number_format($empl->ETF, 2) . '</td></tr>';
            $pay_slip .= '<tr ><td >Coins C/F </td><td style="text-align: right; ">' . number_format($empl->CCF, 2) . '</td></tr>';
            //footer
            //$pay_slip .= '<tr ><td style="border-bottom: 1px dashed #000;" colspan="2"><br/></td></tr>';
            //Bank details
            if (isset($empl->Bank) and !empty($empl->Bank)) {
                $pay_slip .= '<tr ><td colspan="2">Bank : ' . $empl->Bank . ' / A/C No : ' . $empl->AccountNo . '</td></tr>';
                //$pay_slip .= '<tr style=" "><td style="border-bottom:1px solid black;">'.$empl->Bank.' '.$empl->Branch.'</td><td style="text-align: right;border-bottom:1px solid black;">'.number_format($empl->salaryPayableRound,2).'</td></tr>';
            }

            $pay_slip .= '<tr><td width="100%" colspan="2" style=" font-size:6px;text-align: center; border-top: 1px solid #000;">Software Developed by Sallelanka Solutions </td></tr>';
            $pay_slip .= '</tbody>';
            $pay_slip .= '</table>';
            $pay_slip .= '</td>';
            if ($i % 2 == 0 or $i % 2 == 1) {
                $pay_slip .= '<td width="1%" style="border-left: 0.4px dotted #000000; height: 100%">&nbsp;</td>';
            }

            if ($i % 2 == 1) {
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('P', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            $i++;
        }
        //echo $i; die();
        if ($i % 2 == 1) {
            $pay_slip .= '</tr></table></div>';
            //echo $pay_slip; die();
            $pdf->AddPage('P', 'A4');
            $pdf->writeHTML($pay_slip, true, false, true, false, '');
            $pdf->lastPage();
            //$pdf->setPage($pdf->getPage());
            $pay_slip = '';
        } /* If only one employee          close the opened table         */
        if ($i == 1) {
            $pay_slip .= '</tr></table></div>';
            //echo $pay_slip; die();
            $pdf->AddPage('P', 'A4');
            $pdf->writeHTML($pay_slip, true, false, true, false, '');
            $pdf->lastPage();
            //$pdf->setPage($pdf->getPage());
            $pay_slip = '';
        }
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('payslip-' . $month . '.pdf', 'I'), 'Out put');
    }

    function pay_slips2()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        $emp = 0;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
            $emp = $data['EmpNo'];
        }
        //$data['year']
        $month = $data['month'];
        $data['page'] = 'pay_slip';
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $employees = $model->getPayslip($this->attn->getComp(), $month, (($emp) ? $emp : 0));
        //$this->attn->p($employees);        //echo count($employees);        //die();
        $setting = $model->get_setting($this->attn->getComp());
        $margin_bottom = NULL;
        $header = NULL;
        $margin_top = NULL;
        ob_start();
        $this->load->library('pdf');
        $this->load->library('payslip');
        //set document information
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'a4', true, 'utf-8', false);
        $pdf->setPrintHeader(false);
        $pdf->SetMargins(1, 2, 2, true);
        $i = 0;
        $pay_slip = '';
        $payslip_array = array();
        foreach ($employees as $empl) {
            if ($i % 4 == 0) {
                //$this->attn->p($options); die();
                $pay_slip .= '<style>                            
                    @page {                              
                        size: landscape;
                    }                            
                    html,body{                                
                        height:841px;
                        width:210mm;
                        margin: 0;
                        padding: 0;
                        font-size:8px;
                        font-family: "Times New Roman";
                    }                            
                    .table {                                
                        max-width: 100%;
                    width: 100%;
                    }                            
                    table {                                
                        border-collapse: collapse;
                        border-spacing: 0;
                        font-size: 8px;
                    }                            
                    table td{                                                    
                        vertical-align:top;
                        margin: 0;
                    }                                                
                    table tr, table td{                                
                        line-height: 2px;
                        margin: 0px;
                        padding: 0;
                        height: 13px;
                    }                                                
                    .table-bordered > tfoot > tr > td {                                
                        border: 1px solid #dddddd;
                    }                            
                    .table > tfoot > tr > td {                                
                        border-top: 1px solid #dddddd;
                        vertical-align: top;
                    }                            
                    .underlined {                                
                        border-bottom: 0.4em solid #000;
                        font-weight: bold;
                        width:100px !important;
                    }                            
                    div.row{width: 100%;}                           
                    div.col-sm-6{width: 50%; }                                                    
                                         /*table { border: 1px solid #dddddd;}*/    
                 </style>';
                $pay_slip .= '<div class="row">';
                $pay_slip .= '<table border="0" style="height: 29.7cm;" width="100%"><tr>';
            }
            $pay_slip .= '<td width="24%">';
            $pay_slip .= '<table width="100%" style="height: 29.7cm;padding-top: 5px; padding-bottom: 5px; padding-left: 0px; padding-right: 2px;" class="table">';
            $pay_slip .= '<thead>';
            $pay_slip .= '<tr ><th colspan="2"><strong style="text-align: center">' . $this->session->userdata('CompName') . '</strong></th></tr>';
            $pay_slip .= '<tr ><th colspan="2" style="text-align: center"><p>' . $this->session->userdata('Address') . '</p></th></tr>';
            $pay_slip .= '<tr><th colspan="2" style="text-align: center"><u>Pay Slip for the month of ' . date('F-Y', strtotime($month)) . '</u></th></tr>';
            $pay_slip .= '</thead>';
            $pay_slip .= '<tbody>';
            $pay_slip .= '<tr ><td colspan="2">Emp.No &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->EmpNo . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Employee Name &nbsp;&nbsp;&nbsp;: ' . $empl->EmpName . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Department &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Department . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Designation &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . $empl->Designation . '</td></tr>';
            $pay_slip .= '<tr ><td colspan="2">Grade &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp; ' . (isset($empl->Grade) ? $empl->Grade : '') . '</td></tr>';
            $pay_slip .= '<tr><td width="65%"  style="text-align:right"><u>Basic Salary for EPF</u></td><td width="35%" style="text-align: right;"><u>' . number_format($empl->BasicSalary, 2) . '</u></td></tr>';
            $pay_slip .= '<tr><td width="65%" style=""><b>Salary</b></td><td width="35%" style="text-align: right;"><b>' . number_format($empl->Salary, 2) . '</b></td></tr>';
            //Allowances for basic
            $allowances_for_basic = unserialize($empl->AllowancesForBasic);
            if (isset($allowances_for_basic) and !empty($allowances_for_basic)) {
                foreach ($allowances_for_basic as $adb) {
                    $pay_slip .= '<tr ><td>' . $adb[0] . '</td><td style="text-align: right;">' . number_format($adb[1], 2) . '</td></tr>';
                }
            }
            //Deductions for basic
            $deductions_for_basic = unserialize($empl->DeductionsForBasic);
            if (isset($deductions_for_basic) and !empty($deductions_for_basic)) {
                foreach ($deductions_for_basic as $dfb) {
                    $pay_slip .= '<tr ><td>' . $dfb[0] . '</td><td style="text-align: right;">' . number_format($dfb[1], 2) . '</td></tr>';
                }
            }
            $pay_slip .= '<tr ><td style="text-align: right; border-bottom: 0.5px solid #000;"><h4>Total Salary </h4></td><td style="text-align: right; border-top: 1px solid #000;border-bottom: 0.5px solid #000;"><h4>' . number_format($empl->TotalSalary, 2) . '</h4></td></tr>';
            //All allowances
            $allowances = unserialize($empl->AllowanceString);
            if (isset($allowances) and !empty($allowances)) {
                $pay_slip .= '<tr ><td colspan="2" style="text-align: center"><h4 style="margin: 0; padding: 0;">ADDITIONS</h4></td></tr>';

                foreach ($allowances as $a) {
                    $pay_slip .= '<tr ><td>' . $a[0] . '</td><td style="text-align: right;">' . number_format($a[1], 2) . '</td></tr>';
                }
                $pay_slip .= '<tr><td style=" border-top:0.5px solid #000;"><strong>Total Allowances</strong></td><td style="text-align: right; border-top: 0.5px solid #000;"><h4>' . number_format($empl->Allowance, 2) . '</h4></td></tr>';
            }
            $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><h4>Gross Salary: </h4></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><h4>' . number_format($empl->GrossSalary, 2) . '</h4></td></tr>';
            //All deductions
            $deductions = unserialize($empl->DeductionString);
            if (isset($deductions) and !empty($deductions)) {
                $pay_slip .= '<tr ><td colspan="2"><h4 style="margin: 0; padding: 0; text-align: center">DEDUCTIONS</h4></td></tr>';
                foreach ($deductions as $d) {
                    $pay_slip .= '<tr ><td>' . $d[0] . '</td><td style="text-align: right;">' . number_format($d[1], 2) . '</td></tr>';
                }
                $pay_slip .= '<tr><td style=" border-top:0.2px solid #000;">Total Deduction</td><td style="text-align: right; border-top:0.2px solid #000;"><h4>' . number_format($empl->Deduction, 2) . '</h4></td></tr>';
            }
            $pay_slip .= '<tr ><td style="border-bottom:1px solid #000;border-top:1px solid #000;"><b>Net Salary : </b></td><td style="text-align: right;border-bottom:1px solid #000;border-top:1px solid #000;"><b>' . number_format($empl->salaryPayableRound, 2) . '</b></td></tr>';
            $pay_slip .= '<tr ><td>E.P.F ' . $empl->EPFepmString . '% </td><td style="text-align: right;">' . number_format($empl->EPFepm, 2) . '</td></tr>';
            $pay_slip .= '<tr ><td >ETF ' . $empl->ETFString . '% </td><td style="text-align: right; ">' . number_format($empl->ETF, 2) . '</td></tr>';
            $pay_slip .= '<tr ><td >Coins C/F </td><td style="text-align: right; ">' . number_format($empl->CCF, 2) . '</td></tr>';

            //footer
            //$pay_slip .= '<tr ><td style="border-bottom: 1px dashed #000;" colspan="2"><br/></td></tr>';
            //Bank details
            if (isset($empl->Bank) and !empty($empl->Bank)) {
                $pay_slip .= '<tr ><td colspan="2">Bank : ' . $empl->Bank . ' / A/C No : ' . $empl->AccountNo . '</td></tr>';
                //$pay_slip .= '<tr style=" "><td style="border-bottom:1px solid black;">'.$empl->Bank.' '.$empl->Branch.'</td><td style="text-align: right;border-bottom:1px solid black;">'.number_format($empl->salaryPayableRound,2).'</td></tr>';
            }
            $pay_slip .= '<tr><td width="100%" colspan="2" style=" font-size:6px;text-align: center; border-top: 1px solid #000;">Software Developed by Sallelanka Solutions </td></tr>';
            $pay_slip .= '</tbody>';
            $pay_slip .= '</table>';
            $pay_slip .= '</td>';
            if ($i % 4 == 0 or $i % 4 == 1 or $i % 4 == 2) {
                $pay_slip .= '<td width="1%" style="border-left: 0.4px dotted #000000; height: 100%">&nbsp;</td>';
            }
            if ($i % 4 == 3) {
                $pay_slip .= '</tr></table></div>';
                //echo $pay_slip; die();
                $pdf->AddPage('L', 'A4');
                $pdf->writeHTML($pay_slip, true, false, true, false, '');
                $pdf->lastPage();
                //$pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            $i++;
        }

        //echo $i; die();
        if ($i % 4 == 3) {
            $pay_slip .= '</tr></table></div>';
            //echo $pay_slip; die();
            $pdf->AddPage('L', 'A4');
            $pdf->writeHTML($pay_slip, true, false, true, false, '');
            $pdf->lastPage();
            //$pdf->setPage($pdf->getPage());
            $pay_slip = '';
        }
        if ($i % 4 == 2) { //echo 'yes'; die();
            $pay_slip .= '</tr></table></div>';
            //echo $pay_slip; die();
            $pdf->AddPage('L', 'A4');
            $pdf->writeHTML($pay_slip, true, false, true, false, '');
            $pdf->lastPage();
            //$pdf->setPage($pdf->getPage());
            $pay_slip = '';
        } /* If only one employee          close the opened table         */
        if ($i == 1) {
            $pay_slip .= '</tr></table></div>';
            //echo $pay_slip; die();
            $pdf->AddPage('L', 'A4');
            $pdf->writeHTML($pay_slip, true, false, true, false, '');
            $pdf->lastPage();
            //$pdf->setPage($pdf->getPage());
            $pay_slip = '';
        }
        if (ob_get_contents())
            ob_end_clean();

        $this->load->helper('download');
        force_download($pdf->Output('payslip-' . $month . '.pdf', 'I'), 'Out put');
    }


    function pay_slips3()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        $emp = 0;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
            $emp = $data['EmpNo'];
        }
        $company =''; 
        if ($this->input->get('company')) {
            $data['company'] = $this->input->get('company');
            $company = $data['company'];
        }
        //$data['year']
        $month = $data['month'];
        $f_month = date_create($month . '-01');
        $data['page'] = 'pay_slip';
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $month_year_explode = explode('-', $month);
        $month_year = (int) $month_year_explode[0];
        $emp_year_leaves = $model->get_leave_days($month_year);
        //echo '<pre>',print_r($emp_year_leaves);die();
        //echo '<pre>',print_r($emp_year_leaves);die();
        $employees = $model->getPayslip($month, (($emp) ? $emp : 0),$company);
        //echo '<pre>', print_r($employees);
        //die();
        $setting = $model->get_setting($this->attn->getComp());
        $margin_bottom = NULL;
        $header = NULL;
        $margin_top = NULL;
        ob_start();
        $this->load->library('pdf');
        $this->load->library('payslip');
        //set document information
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'A4', true, 'utf-8', false);
        $pdf->setPrintHeader(false);
        $pdf->SetMargins(5, 5, 5, true);
        $i = 0;
        $pay_slip = '';
        foreach ($employees as $empl) {
            if ($i % 2 == 0) {
                $pay_slip .= '<style>                           
                        html,body{                                
                            height:841px;
                            width:210mm;
                            margin: 0;
                            padding: 0;
                            font-size: 9px;
                        }                            
                        .table {                                
                            max-width: 100%;
                            width: 100%;
                        }                            
                        table {                                
                            border-collapse: collapse;
                            border-spacing: 0;
                        }                            
                        table td{                                
                        font-size:9px;
                            vertical-align:top;
                            margin: 0;
                        }                                                        
                        .table-bordered > tfoot > tr > td {                                
                        border: 1px solid #dddddd;
                        }                            
                        .table > tfoot > tr > td {                                
                        border-top: 1px solid #dddddd;
                            vertical-align: top;
                        }                            
                        .underlined {                                 
                        border-bottom: 0.4em solid #000;
                            font-weight: bold;
                            width:100px !important;
                        }                            
                        div.row{width: 100%;}                            
                        div.col-sm-6{width: 50%; }                                /*table { border: 1px solid #dddddd;}*/                        
                        </style>';
                $pay_slip .= '<div class="row">';
                $pay_slip .= '<table border="0" style="height: 29.7cm;" width="100%"><tr>';
            }
            $pay_slip .= '<td width="48%">';
            $pay_slip .= '<table width="100%" style="height: 29.7cm; border: 2px solid #000; padding: 5px;" class="table">';
            $pay_slip .= '<thead>';
            $pay_slip .= '<tr><th colspan="2"><strong style="text-align: center">Rathna Traders<br/>No. 108/1 A, Makola South,<br/>Makola.</strong></th></tr>';
            $pay_slip .= '<tr><th colspan="2"><strong style="text-align: center"><u>PaySlip</u></strong></th></tr>';
            $pay_slip .= '</thead>';
            $pay_slip .= '<tbody>';
            $pay_slip .= '<tr style="line-height: 38%;"><td colspan="2">Emp.No: ' . $empl->EmpNo . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td colspan="2">Emp.Name: ' . (($empl->Title) ? $empl->Title . ' ' : '') . $empl->EmpName . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td colspan="2">Designation: ' . $empl->Designation . '</td></tr>';
            //$pay_slip .= '<tr style="line-height: 38%;"><td colspan="2">E.P.F.No: ' . $empl->EPFNo . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td colspan="2">Month Of Pay : ' . date_format($f_month, "F Y") . '</td></tr>';

            /*if(isset($empl->Bank) and !empty($empl->Bank)){
                            $pay_slip .= '<tr style="line-height: 40%;"><td colspan="2">Bank: '.$empl->Bank.' - '.$empl->Branch.'</td></tr>';
            }*/
            //All allowances
            $AllowancesForBasic = unserialize($empl->AllowancesForBasic);
            $pay_slip .= '<tr style="line-height: 38%; "><td width="65%" style="height:10px;border-top: 1px solid #000;"><b>Basic Salary </b></td><td width="35%" style="text-align: right;border-top: 1px solid #000;"><b>' . number_format($empl->Salary, 2) . '</b></td></tr>';
            //All allowances
            if (isset($AllowancesForBasic) and !empty($AllowancesForBasic)) {
                foreach ($AllowancesForBasic as $ab) {
                    if ($ab[1] != 0.00)
                        $pay_slip .= '<tr style="line-height: 38%;"><td>' . $ab[0] . '</td><td style="text-align: right;">' . number_format($ab[1], 2) . '</td></tr>';
                }
            }

            $pay_slip .= '<tr style="line-height: 38%;"><td> (-) Nopay </td><td style="text-align: right;">' . number_format($empl->Nopay, 2) . '</td></tr>';
            //border-top: 1px solid #000;
            $pay_slip .= '<tr style="line-height: 38%; "><td width="78%" style="height:10px;"><b>Salary for EPF </b></td><td width="22%" style="text-align: right;"><p style="text-align: right;border-top: 1px solid #000;border-bottom: 1px double #000; padding-bottom:2px; width:50%"><strong style="line-height: 1.6;">' . number_format($empl->TotalForEpf, 2) . '</strong></p></td></tr>';
            //All allowances
            $allowances = unserialize($empl->AllowanceString);
            //All allowances
            if (isset($allowances) and !empty($allowances)) {
                $pay_slip .= '<tr style="line-height: 20%;"><td colspan="2"><b><u>Allowance/Incomes</u></b></td></tr>';
                foreach ($allowances as $a) {
                    if ($a[1] != 0.00)
                        $pay_slip .= '<tr style="line-height: 38%;"><td>' . $a[0] . '</td><td style="text-align: right;">' . number_format($a[1], 2) . '</td></tr>';
                }
                //border-top:1px solid #000;
                $pay_slip .= '<tr><td style="line-height: 40%; ">Total Allowances</td><td style="text-align: right;"><b><u>' . number_format($empl->NotBasicAllowance, 2) . '</u></b></td></tr>';
            }
            $pay_slip .= '<tr style="line-height: 38%;"><td><b>Gross Salary: </b></td><td style="text-align: right;"><b>' . number_format($empl->GrossSalary, 2) . '</b></td></tr>';
            //All deductions
            $deductions = unserialize($empl->DeductionString);
            //All dedutions
            if (isset($deductions) and !empty($deductions)) {
                $pay_slip .= '<tr style="line-height: 50%;"><td colspan="2"><h4><u style="border-bottom: 10px solid black;">Other Deduction</u></h4></td></tr>';
                foreach ($deductions as $d) {
                    if ($d[1] != 0.00)
                        $pay_slip .= '<tr style="line-height: 38%;"><td>' . $d[0] . '</td><td style="text-align: right;">' . number_format($d[1], 2) . '</td></tr>';
                }
                //border-top:1px solid #000;
                $pay_slip .= '<tr><td style="line-height: 38%; ">Total Deduction</td><td style="text-align: right;"><h4><u>' . number_format($empl->Deduction, 2) . '</u></h4></td></tr>';
            }
            //Bank details
            /* if(isset($empl->Bank) and !empty($empl->Bank)){
            $pay_slip .= '<tr style="line-height: 80%;"><td colspan="2"><b><u>Transaction (Bank)</u></b></td></tr>';
            $pay_slip .= '<tr style="line-height: 40%; "><td style="border-bottom:1px solid black;">'.$empl->Bank.' - '.$empl->Branch.'</td><td style="text-align: right;border-bottom:1px solid black;">'.number_format($empl->salaryPayable, 2).'</td></tr>';
            }*/
            $pay_slip .= '<tr style="line-height: 60%;"><td style="">Net Salary : </td><td style="text-align: right;"><p style="text-align: right;border-top: 1px solid #000;border-bottom: 1px double #000; padding-bottom:2px; width:50%"><strong style="line-height: 1.6;">' . number_format($empl->salaryPayable, 2) . '</strong></p></td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td>No Pay Days </td><td style="text-align: right;">' . number_format($empl->NopayDays, 2) . '</td></tr>';


            $pay_slip .= '<tr style="line-height: 38%;"><td>Normal OT Hours </td><td style="text-align: right;">' . str_replace('.', ':', number_format($empl->NotValue, 2)) . '</td></tr>';
            //$pay_slip .= '<tr style="line-height: 38%;"><td>Double OT Hours </td><td style="text-align: right;">' . str_replace('.', ':', number_format($empl->DotValue, 2)) . '</td></tr>';
            if ($empl->TotValue != '0.00')
                $pay_slip .= '<tr style="line-height: 38%;"><td>Triple OT Hours </td><td style="text-align: right;">' . str_replace('.', ':', number_format($empl->TotValue, 2)) . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td>EPF ' . $empl->EPFepmString . ' </td><td style="text-align: right;">' . number_format($empl->EPFepm, 2) . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 38%;"><td style="border-bottom: 1px solid #000;">EPF ' . $empl->ETFString . ' </td><td style="text-align: right; border-bottom: 1px solid #000;">' . number_format($empl->ETF, 2) . '</td></tr>';
            //Loan details            //if(isset($empl->Loan) and !empty($empl->Loan)){                $pay_slip .= '<tr style="line-height: 60%;"><td colspan="2"><h4><u>Balance Loan Details </u></h4></td></tr>';
            $pay_slip .= '<tr style="line-height: 60%;"><td colspan="2">';
            $pay_slip .= '<table><tr><th width="50%">Loan Type</th><th width="25%">Loan Period</th><th width="25%">Loan Amt</th></tr></table>';
            $pay_slip .= '</td></tr>';
            $pay_slip .= '<tr style="line-height: 80%; "><td colspan="2" style="border-bottom:1px solid black;"></td></tr>';


            //}
            //footer
            if (isset($emp_year_leaves[$empl->EmpNo])) {
                $emp_lv = $emp_year_leaves[$empl->EmpNo];
                $leave_blnc = 0;
                if (isset($emp_lv['0002'])) {
                    $leave_blnc = $leave_blnc + $emp_lv['0002']->Balance;
                }
                if (isset($emp_lv['0003'])) {
                    $leave_blnc = $leave_blnc + $emp_lv['0003']->Balance;
                }
                $pay_slip .= '<tr style="line-height: 40%;"><td style="border-bottom: 1px dashed #000;" colspan="2">Leave Balance : ' . $leave_blnc . '<br/><br/></td></tr>';
            } else {
                $pay_slip .= '<tr style="line-height: 40%;"><td style="border-bottom: 1px dashed #000;" colspan="2"><br/><br/></td></tr>';
            }
            //$pay_slip .= '<tr style="line-height: 40%;"><td style="border-bottom: 1px dashed #000;" colspan="2"><br/><br/></td></tr>';
            $pay_slip .= '<tr style="line-height: 40%;"><td colspan="2"><strong style="font-size: 10px">Rathna Traders</strong></td></tr>';
            $pay_slip .= '<tr style="line-height: 40%;"><td width="30%"><strong>EMP.NO</strong></td><td width="50%">:' . $empl->EmpNo . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 80%;"><td><strong>EMP.NAME</strong></td><td>:' . (($empl->Title) ? $empl->Title . ' ' : '') . $empl->EmpName . '</td></tr>';
            //$pay_slip .= '<tr style="line-height: 40%;"><td><strong>NIC NO</strong></td><td>:'.$empl->IDNo.'</td></tr>';
            $pay_slip .= '<tr style="line-height: 40%;"><td><strong>BANK</strong></td><td>:' . $empl->Bank . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 40%;"><td><strong>BRANCH</strong></td><td>:' . $empl->Branch . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 40%;"><td><strong>A/C NO</strong></td><td>:' . $empl->AccountNo . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 100%;"><td width="100%" colspan="2">Received the sum of Rs.' . number_format($empl->salaryPayable, 2) . ' being the net salary <br/>for the Month of <b>' . date_format($f_month, "F Y") . '</b></td></tr>';
            $pay_slip .= '<tr style="line-height: 60%;"><td width="30%"><div style="border-top:1px dashed #000; text-align: center;">Signature</div></td><td style="text-align: center" width="30%">' . ($i + 1) . '</td><td width="40%" style="text-align: right">' . date('d/m/Y') . '</td></tr>';
            $pay_slip .= '<tr style="line-height: 60%;"><td width="100%" colspan="2" style=" font-size:6px;text-align: center; border-top: 1px solid #000;">Software Developed by Sallelanka Solutions </td></tr>';
            $pay_slip .= '</tbody>';
            $pay_slip .= '</table>';
            $pay_slip .= '</td>';

            if ($i % 2 == 0) {
                $pay_slip .= '<td width="4%">&nbsp;</td>';
            }
            if ($i % 2 == 1) {
                $pay_slip .= '</tr></table></div>';
                $pdf->AddPage();
                $pdf->writeHTML($pay_slip, true, false, true, false);
                $pdf->setPage($pdf->getPage());
                $pay_slip = '';
            }
            $i++;
        }
        if ($i % 2 == 1) {
            $pay_slip .= '</tr></table></div>';
            $pdf->AddPage();
            $pdf->writeHTML($pay_slip, true, false, true, false);
            $pdf->setPage($pdf->getPage());
            $pay_slip = '';
        }
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('payslip-' . $month . '.pdf', 'I'), 'Out put');
    }



    function month_full_report()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'full_report';
        $data['page_title'] = 'Full Report';
        $data['heading'] = 'Reports';
        $this->load->model('company_model');
        $data['companies'] = $this->company_model->getAll();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/full_report", $data);
    }

    function month_full()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $records = $model->getPayslip($month,0,$company);
        //echo '<pre>',print_r($records); die();
        $this->load->model('company_model');
        $company_details = $this->company_model->getCompanyByCode($company);
        $this->load->model('items_model');
        $headings = $this->items_model->get_all('');
        
        $allowance_headings = $this->attn->object_filter($headings, 'Id', 'A');
        //echo '<pre>',print_r($allowance_headings); die();
        $basic_allowance_headings = $this->attn->object_filter($allowance_headings, 'Basic', 'yes');
        //echo '<pre>',print_r($basic_allowance_headings); die();
        $other_allowance_headings = $this->attn->object_filter($allowance_headings, 'Basic', 'no');
        $deduction_headings = $this->attn->object_filter($headings, 'Id', 'D');
        $basic_deduction_headings = $this->attn->object_filter($deduction_headings, 'Basic', 'yes');
        $other_deduction_headings = $this->attn->object_filter($deduction_headings, 'Basic', 'no');
        $np_heading = $this->attn->object_filter($headings, 'Id', 'N');
        $ot_heading = $this->attn->object_filter($headings, 'Code', 'NOT');
        $dot_heading = $this->attn->object_filter($headings, 'Code', 'DOT');
        $tot_heading = $this->attn->object_filter($headings, 'Code', 'TOT');
        // For store headers
        $excel_headers = array();
        $excel_headers[] = array('', '# ');
        $excel_headers[] = array('', 'Emp Name');
        $excel_headers[] = array('', 'Emp No');
        $excel_headers[] = array('', 'Basic');
        foreach ($basic_allowance_headings as $bah)
            $excel_headers[] = array($bah->Code, $bah->ItemName);

        foreach ($basic_deduction_headings as $bdh)
            $excel_headers[] = array($bdh->Code, $bdh->ItemName);


        $excel_headers[] = array($np_heading[0]->Code, $np_heading[0]->ItemName);
        $excel_headers[] = array('', 'Total for P.F');
        foreach ($other_allowance_headings as $oah)
            $excel_headers[] = array($oah->Code, $oah->ItemName);

        echo '<pre>',print_r($other_allowance_headings); //die();
        
        $excel_headers[] = array('NOT', $ot_heading[0]->ItemName);
        $excel_headers[] = array('DOT', $dot_heading[0]->ItemName);
        $excel_headers[] = array('TOT', '');
        $excel_headers[] = array('', "GROSS");
        $excel_headers[] = array('', "GROSS SALARY");
        $excel_headers[] = array('', "DIFF");
        $excel_headers[] = array('EPF', "EPF (8%)");
        foreach ($other_deduction_headings as $odh)
            $excel_headers[] = array($odh->Code, $odh->ItemName);
        $excel_headers[] = array('', "TOTAL DED");
        $excel_headers[] = array('', "Net Salary");
        $excel_headers[] = array('', "EPF 12%");
        $excel_headers[] = array('', "ETF 3%");

        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('PayRoll Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        //$sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', $company_details->Name);
        $sheet->SetCellValue('B2', 'Month of - ' . $month);
        $sheet->SetCellValue('B3', 'PAYROLL SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
        $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth(20);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }

        $r++;
        $TotalHours = '00:00:00';
        $TotalOT = '00:00:00';
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 12);
            $excel_values[] = $d->EmpName;
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $this->attn->formatMoney($d->Salary);
            $basic_allowances = unserialize($d->AllowancesForBasic);
            $new_basic_allowances = array();
            foreach ($basic_allowances as $ba)
                $new_basic_allowances[$ba[4]] = $ba[1];

            
            $excel_values[] = $this->attn->formatMoney($new_basic_allowances[$header_index_codes[4]]);
            $excel_values[] = $this->attn->formatMoney($new_basic_allowances[$header_index_codes[5]]);
            $excel_values[] = $this->attn->formatMoney(0);
            $excel_values[] = $this->attn->formatMoney($d->Nopay);
            $excel_values[] = $this->attn->formatMoney($d->TotalForEpf);
            //All allowances
            $allowances = unserialize($d->AllowanceString);
            
            $new_allowances = array();
            foreach ($allowances as $r_a)
                $new_allowances[$r_a[4]] = $r_a[1];

            
                foreach($other_allowance_headings as $oah){
                    if(isset($new_allowances[$oah->Code])){
                        $excel_values[] = $this->attn->formatMoney($new_allowances[$oah->Code]);
                    }else{
                        $excel_values[] = '0.00';
                    }
                }

            for ($x = 8; $x < (count($other_allowance_headings) + 8); $x++) {
           
                //echo  $header_index_codes[$x],'<br/>';
                //if(isset($new_allowances[$header_index_codes[$x]]))
                    //$excel_values[] = (isset($new_allowances[$header_index_codes[$x]])) ? $this->attn->formatMoney($new_allowances[$header_index_codes[$x]]) : '0.00';
            }

            //echo '<pre>',print_r($other_allowance_headings); die();  
            //$this->attn->p($new_allowances); //die();
            $excel_values[] = $this->attn->formatMoney($new_allowances[$header_index_codes[$x]]);
            $x++;
            $excel_values[] = $this->attn->formatMoney($new_allowances[$header_index_codes[$x]]);
            $x++;
            $excel_values[] = $this->attn->formatMoney($new_allowances[$header_index_codes[$x]]);
            $x++;
            $excel_values[] = $this->attn->formatMoney($d->GrossSalary);
            $x++;
            $excel_values[] = $this->attn->formatMoney($d->GrossSalary);
            $x++;
            $excel_values[] = $this->attn->formatMoney(0.00);
            $x++;
            //All deductions
            $deductions = unserialize($d->DeductionString);
            $new_deductions = array();
            foreach ($deductions as $r_d)
                $new_deductions[$r_d[4]] = $r_d[1];
            //echo $x;
            //$this->attn->p($new_deductions);
            //$this->attn->p($header_index_codes); die();
            for ($n = $x; $n <= (count($other_deduction_headings) + $x); $n++) {
                $excel_values[] = (isset($new_deductions[$header_index_codes[$n]])) ? $this->attn->formatMoney($new_deductions[$header_index_codes[$n]]) : '0.00';
            }
            $excel_values[] = $this->attn->formatMoney($d->Deduction);
            $excel_values[] = $this->attn->formatMoney($d->salaryPayable);
            $excel_values[] = $this->attn->formatMoney($d->EPFepm);
            $excel_values[] = $this->attn->formatMoney($d->ETF);
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );

        $sheet->getStyle('A11:AS' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D12:AS' . $r)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
        //$sheet->getStyle('D12:AS'.$r)->getNumberFormat()->setFormatCode('###0.00');
        //$sheet->getStyle('F'.$row.':'.'H'.$row)->applyFromArray($BStyle);
        //$sheet->SetCellValue('F' . $row, $TotalHours);
        //$sheet->SetCellValue('H' . $row, $TotalOT);
        $filename = 'PayRoll_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:AS11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_bank_report()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        //echo date('F-Y',strtotime('2017-10')); die();
        $data['page'] = 'bank';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/bank", $data);
    }

    function month_bank()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_month_salary_by_employees($this->attn->getComp(), $month);
        //echo $this->attn->p($records); die();
        // For store headers
        $excel_headers = array();

        $excel_headers[] = array(10, "#");
        $excel_headers[] = array(10, "EPF NO");
        $excel_headers[] = array(30, 'NAME');
        $excel_headers[] = array(17, 'ACCOUNT NO');
        $excel_headers[] = array(15, 'BANK CODE');
        $excel_headers[] = array(15, 'BRANCH CODE');
        $excel_headers[] = array(30, 'BRANCH');
        $excel_headers[] = array(20, 'AMOUNT');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Bank Sheet - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(60);
        $i = 0;
        $r = 1;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(20);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $n = 1;
        foreach ($records as $d) {
            if (is_numeric($d->EPFNo)) {
                $sheet->getRowDimension($r)->setRowHeight(20);
                $excel_values = array();
                $excel_values[] = $n;
                $excel_values[] = $d->EPFNo;
                $excel_values[] = $d->AccountName;
                $excel_values[] = $d->AccountNo;
                $excel_values[] = $d->BankCode;
                $excel_values[] = $d->BranchCode;
                $excel_values[] = $d->Bank . '-' . $d->Branch;
                $excel_values[] = $d->salaryPayable;

                //$this->attn->p($excel_values); die();
                $s = 0;
                foreach ($excel_values as $ev) {
                    $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                    $s++;
                }
                $r++;
                $n++;
            }
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),

            'font' => array(
                'size' => 10,
                'name' => 'Times New Roman',
            )
        );
        /*'alignment' => array(
                'horizontal' =>\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                'vertical' =>\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ), */
        $sheet->getStyle('A1:H' . ($r - 1))->applyFromArray($BStyle);

        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );

        $sheet->getStyle("A2:A" . $r)->applyFromArray($style);
        $sheet->getStyle('H2:H' . $r)->getNumberFormat()->setFormatCode('#,##0.00');


        //$sheet->getStyle('D12:AS'.$r)->getNumberFormat()->setFormatCode('###0.00');

        //$sheet->getStyle('F'.$row.':'.'H'.$row)->applyFromArray($BStyle);
        //$sheet->SetCellValue('F' . $row, $TotalHours);
        //$sheet->SetCellValue('H' . $row, $TotalOT);

        $filename = 'Bank Sheet -' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A1:H1')->getFont()->setBold(true);
        $sheet->getStyle('D2:F' . $r)->getFont()->setBold(true);
        //$sheet->getStyle('C2:G' . $row)->getAlignment()->setWrapText(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_leave_report()
    {
        $data = $this->data;
        $this->data['page_title'] = 'Month Leave report';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'month_leave_report';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/leave_report", $this->data);
    }


    function month_leaves()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $this->load->model('company_model');
        $company_details = $this->company_model->getCompanyByCode($company);
        $month = $data['month'];
        $this->load->model('transaction/leave_transaction_model');
        $this->load->model('employee_model');
        $records = $this->employee_model->getAll($company);
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name ');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(20, 'Leaves');
        $excel_headers[] = array(20, 'Nopays');
        $excel_headers[] = array(20, "Counts");
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Leave Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        //$sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', $company_details->Name);
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'LEAVE SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);        $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);

            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);

            $sheet->getRowDimension($r)->setRowHeight(35);

            $header_index_codes[$i] = $eh[0];

            $i++;
        }

        $r++;

        foreach ($records as $d) {
            $leaves = $this->leave_transaction_model->get_employee_month_leaves($d->EmpNo, $month);
            //echo '<pre>',print_r($leaves); die();
            $app_nopay = $this->leave_transaction_model->get_employee_month_nopays($d->EmpNo, $month);
            $this->load->model('monthitem_model');
            $trns_nopay = $this->monthitem_model->get_employee_month_nopay($month, $d->EmpNo);
            $nopays = 0;
            if ($trns_nopay) {
                $nopays = $app_nopay;
            } else if ($app_nopay and $app_nopay = !0) {
                $nopays = $trns_nopay;
            }
            $nopays = $trns_nopay;
            $leaves = ($leaves) ? $leaves : 0;
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 11);
            $excel_values[] = $d->FullName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $leaves;
            $excel_values[] = $nopays;
            $excel_values[] = $nopays + $leaves;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }



        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:F' . $r)->applyFromArray($BStyle);
        //$sheet->getStyle('D12:AS'.$r)->getNumberFormat()->setFormatCode('###0.00');
        //$sheet->getStyle('F'.$row.':'.'H'.$row)->applyFromArray($BStyle);
        //$sheet->SetCellValue('F' . $row, $TotalHours);
        //$sheet->SetCellValue('H' . $row, $TotalOT);
        $filename = 'Leave_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:F11')->getFont()->setBold(true);
        //$sheet->getStyle('C2:G' . $row)->getAlignment()->setWrapText(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function month_leave_employee_wise_report()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        //echo date('F-Y',strtotime('2017-10')); die();
        $this->data['page'] = 'leave_employee_report';
        $this->load->model('employee_model');
        $this->data['page_title'] = 'Leave report';
        $this->data['heading'] = 'Reports';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->data['employees'] = $this->employee_model->get_all_filter();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/leave_employee_wise_report", $this->data);
    }

    function month_leave_employee_wise()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $data['EmpNo'] = '';
        $data['Year']  = date('Y');
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
        }
        if ($this->input->get('Year')) {
            $data['Year'] = $this->input->get('Year');
        }
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $EmpNo = $data['EmpNo'];
        $this->load->model('transaction/leave_transaction_model');
        $this->load->model('employee_model');

        $employees = $this->employee_model->getEmpNameIdByEmpNo($EmpNo,$company);

        $year = $data['Year'];
        $leaves = $this->leave_transaction_model->get_all_year_leaves($year);
        //echo '<pre>',print_r($leaves); die();
        //$leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $EmpNo);
        //$nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $EmpNo);
        $excel_headers = array();
        $excel_headers[] = array(20, 'Employee No');
        $excel_headers[] = array(20, 'Employee Name');
        $excel_headers[] = array(20, 'CASUAL');
        $excel_headers[] = array(20, 'CASUAL BALANCE');
        $excel_headers[] = array(20, 'ANNUAL');
        $excel_headers[] = array(20, 'ANNUAL BALANCE');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Leave Summary - ' . $year);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B2', 'YEAR -  ' . $year);
        $sheet->SetCellValue('B3', 'LEAVE SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
               $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $casual = 0;
        $annual = 0;

        foreach ($employees as $emp) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $emp->EmpNo;
            $excel_values[] = $emp->FullName;
            if (isset($leaves[$emp->EmpNo])) {
                $leave = $leaves[$emp->EmpNo];
                if (isset($leave['0019'])) {
                    $excel_values[] = $leave['0019']->Days;
                    $excel_values[] = $leave['0019']->Days;
                }
                if (isset($leave['0020'])) {
                    $excel_values[] = $leave['0020']->Days;
                    $excel_values[] = $leave['0020']->Balance;
                }
            } else {
            }


            $excel_values[] = '';
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:F' . $r)->applyFromArray($BStyle);
        $filename = 'Leave_Summary-' . $year . ((!empty($EmpNo)) ? ' - ' . $EmpNo : '');
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:F11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function year_leave()
    {
        //echo '<pre>',print_r($data['EmpNo']); die();
        $this->form_validation->set_rules('year', 'Year', 'required');
        $year = isset($_GET['year']) ? $_GET['year'] : null;
        $EmpNo = isset($_GET['EmpNo']) ? $_GET['EmpNo'] : null;
        //echo '<pre>',print_r($EmpNo); die();
        if ($year and $EmpNo) {
            ini_set('max_execution_time', 0);
            $data = $this->data;
            $emp = array();
            //echo '<pre>',print_r($data['EmpNo']); die();
            //$data['year']            $data['page'] = 'year_leave';
            $this->load->model('transaction/leave_transaction_model');
            $model = $this->leave_transaction_model;
            $records = $model->get_employee_year_leaves($this->attn->getComp(), $year, $EmpNo);
            //$this->attn->p($employees);
            //echo count($employees);
            $excel_headers = array();
            $excel_headers[] = array(20, 'Leave Name');
            $excel_headers[] = array(20, 'Type');
            $excel_headers[] = array(20, 'From');
            $excel_headers[] = array(20, 'To');
            $excel_headers[] = array(20, 'Days');
            $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            $sheet->setTitle('Leave Summary - ' . $EmpNo);
            $sheet->getStyle('B1')->getFont()->setBold(true);
            $sheet->getColumnDimension('B1')->setWidth(45);
            $sheet->SetCellValue('B1', 'Rathna Hardware');
            $sheet->SetCellValue('B2', 'YEAR LEAVE SUMMARY');
            $sheet->SetCellValue('B3', 'YEAR : ' . $year);
            $sheet->SetCellValue('B4', 'Employee Name : ' . $records[0]->EmpName);
            $i = 0;
            $r = 6;
            $header_index_codes = array();
            foreach ($excel_headers as $eh) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
                $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
                $sheet->getRowDimension($r)->setRowHeight(35);
                $header_index_codes[$i] = $eh[0];
                $i++;
            }
            $r++;
            $total = 0;
            foreach ($records as $d) {
                //$sheet->getRowDimension($r)->setRowHeight(35);
                $excel_values = array();
                $excel_values[] = $d->Description;
                $excel_values[] = $d->LeaveType;
                $excel_values[] = $d->LeaveFrom;
                $excel_values[] = $d->LeaveTo;
                $excel_values[] = $d->Days;
                $total = (float) $total + $d->Days;
                $s = 0;
                foreach ($excel_values as $ev) {
                    $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                    $s++;
                }
                $r++;
            }
            $sheet->SetCellValue('E' . $r, $total);
            $sheet->getStyle('E' . $r)->getFont()->setBold(true);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $BStyle = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                    )
                ),
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                ),
                'font' => array(
                    'size' => 12,
                    'name' => 'Times New Roman',
                )
            );
            $sheet->getStyle('A6:E' . $r)->applyFromArray($BStyle);
            //$sheet->getStyle('D6:D'.$r)->getNumberFormat()->setFormatCode('#,##0.00');
            $style = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,));
            $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
            $filename = 'year_leave_Summary-' . $year . '-' . $EmpNo;
            //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
            $sheet->getStyle('A6:E6')->getFont()->setBold(true);
            //$sheet->getStyle('C2:G' . $row)->getAlignment()->setWrapText(true);
            if (ob_get_contents())
                ob_end_clean();
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
            header('Cache-Control: max-age=0');
            if (ob_get_contents())
                ob_end_clean();
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            $writer->save('php://output');
            exit();
        } else {
            $data = $this->data;
            $this->messages->add(validation_errors(), "error");
            //echo date('F-Y',strtotime('2017-10')); die();
            $data['page'] = 'year_leave';
            $this->load->model('reports/summary_attendance');
            $model = $this->summary_attendance;
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter($this->attn->getComp());
            $data['message'] = view_error($this->messages->get());
            $this->load->view("templates/reports/year_leave", $data);
        }
    }

    function year_full_leave()
    {
        $this->load->model('employee_model');
        $employees = $this->employee_model->get_all_filter($this->attn->getComp());
        //echo '<pre>',print_r($data['employees']); die();
        $this->form_validation->set_rules('year', 'Year', 'required');
        $year = isset($_GET['year']) ? $_GET['year'] : null;

        if ($year) {
            ini_set('max_execution_time', 0);
            $data = $this->data;
            $emp = array();
            //echo '<pre>',print_r($data['EmpNo']); die();
            //$data['year']            $data['page'] = 'year_leave';
            $this->load->model('transaction/leave_transaction_model');
            $model = $this->leave_transaction_model;
            $records = $model->get_year_applied_leaves($this->attn->getComp(), $year);
            //echo '<pre>',print_r($records); die();
            $emp_lvs = array();
            if (!empty($records)) {
                $i = 0;
                $emp_id = 0;
                $emp_name = '';
                $leave_id = 0;
                $leave_name = '';
                $leave_count = 0;
                $lvs = array();
                $ll = '';
                foreach ($records as $row) {

                    if ($i == 0) {
                        $emp_id = $row->EmpNo;
                        $emp_name = $row->EmpName;
                        $leave_id = $row->Leave_Code;
                        $leave_name = $row->Description;
                        $leave_count = floatval($leave_count) + floatval($row->Days);
                        $ll = $ll . $row->Days . ',';
                    } else {
                        if ($emp_id == $row->EmpNo) {
                            if ($leave_id == $row->Leave_Code) {
                                $leave_count = floatval($leave_count) + floatval($row->Days);
                                $ll = $ll . $row->Days . ',';
                            } else {
                                //$leave_id = $row->Leave_Code;
                                $lvs[$leave_id]['count'] = $leave_count;
                                $lvs[$leave_id]['lname'] = $leave_name;

                                $leave_id = $row->Leave_Code;
                                $leave_name = $row->Description;
                                $leave_count = floatval($row->Days);
                                $ll = $row->Days . ',';
                            }
                        } else {
                            $lvs[$leave_id]['count'] = $leave_count;
                            $lvs[$leave_id]['lname'] = $leave_name;
                            $emp_lvs[$emp_id]['leaves'] = $lvs;
                            $emp_lvs[$emp_id]['name'] = $emp_name;
                            $emp_id = $row->EmpNo;
                            $emp_name = $row->EmpName;
                            $leave_id = $row->Leave_Code;
                            $leave_name = $row->Description;
                            $leave_count = floatval($row->Days);
                            $ll = $row->Days . ',';
                            unset($lvs);
                        }
                    }
                    $i++;
                }

                $lvs[$leave_id]['count'] = $leave_count;
                $lvs[$leave_id]['lname'] = $leave_name;
                $emp_lvs[$emp_id]['leaves'] = $lvs;
                $emp_lvs[$emp_id]['name'] = $emp_name;
            }
            //echo '<pre>',print_r($records);
            //echo '<pre>',print_r($emp_lvs); die();
            //echo count($employees);
            $excel_headers = array();
            $excel_headers[] = array(70, 'Employee Name');
            $excel_headers[] = array(30, 'Leave Counts');
            $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            $sheet->setTitle('Leave Summary');
            $sheet->getStyle('A1')->getFont()->setBold(true);
            //$sheet->getColumnDimension('A1')->setWidth(45);
            $sheet->SetCellValue('A1', 'Rathna Hardware');
            $sheet->SetCellValue('A2', 'EMPLOYEES YEAR LEAVE SUMMARY');
            $sheet->SetCellValue('A3', 'YEAR : ' . $year);
            $i = 0;
            $r = 6;
            $header_index_codes = array();
            foreach ($excel_headers as $eh) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
                $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
                $sheet->getRowDimension($r)->setRowHeight(35);
                $header_index_codes[$i] = $eh[0];
                $i++;
            }
            $r++;
            $total = 0;
            foreach ($employees as $employee) {
                if (isset($emp_lvs[$employee->EId])) {
                    $d = $emp_lvs[$employee->EId];
                } else {
                    $d = array('leaves' => array(), 'name' => $employee->EmpName);
                }
                //echo '<pre>',print_r($records),'</pre>';
                //$sheet->getRowDimension($r)->setRowHeight(35);
                $excel_values = array();
                $excel_values[] = $d['name'];
                $lve_data = '';
                if (!empty($d['leaves'])) {

                    foreach ($d['leaves'] as $lc) {
                        $lve_data .= $lc['lname'] . " - " . $lc['count'] . PHP_EOL;
                    }
                } else {
                    $lve_data .= ' 0 ' . PHP_EOL;
                }

                $excel_values[] = $lve_data;
                //$total = (float)$total + $d->Days;
                $s = 0;
                foreach ($excel_values as $ev) {
                    $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                    $sheet->getStyle($this->attn->getNameFromNumber($s) . $r)->getAlignment()->setWrapText(true);
                    $s++;
                }

                $r++;
            }
            //$sheet->SetCellValue('B'.$r, $total);
            //$sheet->getStyle('B'.$r)->getFont()->setBold(true);
            //$sheet->getRowDimension($r)->setRowHeight(35);
            $BStyle = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                    )
                ),
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                ),
                'font' => array(
                    'size' => 12,
                    'name' => 'Times New Roman',
                )
            );
            $sheet->getStyle('A6:B' . $r)->applyFromArray($BStyle);
            $style = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,));
            $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
            $filename = 'employees_year_leave_Summary-' . $year;
            //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
            $sheet->getStyle('A6:B6')->getFont()->setBold(true);
            //$sheet->getStyle('C2:G' . $row)->getAlignment()->setWrapText(true);
            if (ob_get_contents())
                ob_end_clean();
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
            header('Cache-Control: max-age=0');
            if (ob_get_contents())
                ob_end_clean();
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            $writer->save('php://output');
            exit();
        } else {
            $data = $this->data;
            $this->messages->add(validation_errors(), "error");
            //echo date('F-Y',strtotime('2017-10')); die();
            $data['page'] = 'year_leave_full';
            $this->load->model('reports/summary_attendance');
            $model = $this->summary_attendance;
            $data['employees'] = $employees;
            $data['message'] = view_error($this->messages->get());
            $this->load->view("templates/reports/year_leave_full", $data);
        }
    }




    function month_night_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_custom_transaction_by_employees($this->attn->getComp(), $month, 'NightAllo');
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name ');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(20, 'Rate');
        $excel_headers[] = array(20, 'Quantity');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Night Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'NIGHT ALLOWANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Rate;
            $excel_values[] = $d->Quantity;
            $excel_values[] = $d->Amount;
            $total = (float) $total + $d->Amount;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('F' . $r, $total);
        $sheet->getStyle('F' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:F' . $r)->applyFromArray($BStyle);
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
        $sheet->getStyle('D6:F' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $filename = 'Night_Allowance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:F6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }



    function month_packing()
    {
        $data = $this->data;
        $data['page'] = 'month_packing_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/packing_report", $data);
    }

    function month_packing_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_custom_transaction_by_employees($this->attn->getComp(), $month, 'Pack');
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Packing Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'PACKING ALLOWANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + $d->Amount;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }

        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
        $filename = 'Packing_Allowance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_breakfast()
    {
        $data = $this->data;
        $data['page'] = 'month_breakfast_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/breakfast_report", $data);
    }

    function month_breakfast_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_custom_transaction_by_employees($this->attn->getComp(), $month, 'BF');
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Packing Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'BREAKFAST ALLOWANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + ($d->Amount);
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
        $filename = 'Breakfast_Allowance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_lunch()
    {
        $data = $this->data;
        $data['page'] = 'month_lunch_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/lunch_report", $data);
    }

    function month_lunch_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_custom_transaction_by_employees($this->attn->getComp(), $month, 'LA');
        $excel_headers = array();
        $excel_headers[] = array('', 'No');
        $excel_headers[] = array('', 'Emp Name');
        $excel_headers[] = array('', 'Emp No');
        $excel_headers[] = array('', 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Lunch Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->getStyle("B1")->getFont()->setSize(14);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'LUNCH ALLOWANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth(20);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + ($d->Amount);
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A6:B" . $r)->applyFromArray($style);
        $filename = 'Lunch_Allowance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);

        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_salary_advance()
    {
        $data = $this->data;
        $data['page'] = 'month_salary_advance_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/salary_advance_report", $data);
    }

    function month_salary_advance_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_trns_by_employees($this->attn->getComp(), $month, 'SA');
        $excel_headers = array();
        $excel_headers[] = array(10, '# ');
        $excel_headers[] = array(50, 'Emp Name');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Salary Advance - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->getStyle("B1")->getFont()->setSize(14);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'SALARY ADVANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + $d->Amount;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A6:B" . $r)->applyFromArray($style);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $filename = 'Salary_Advance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function month_special_advance()
    {
        $data = $this->data;
        $data['page'] = 'month_special_advance_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/special_advance_report", $data);
    }

    function month_special_advance_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_trns_by_employees($this->attn->getComp(), $month, 'SPA');
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Special Advance - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->getStyle("B1")->getFont()->setSize(14);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'SPECIAL ADVANCE SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + $d->Amount;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A6:B" . $r)->applyFromArray($style);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $filename = 'Special_Advance_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function month_hostel()
    {
        $data = $this->data;
        $data['page'] = 'month_hostel_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/hostel_report", $data);
    }


    function month_hostel_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_custom_transaction_by_employees($this->attn->getComp(), $month, 'Hos');
        $excel_headers = array();
        $excel_headers[] = array(10, 'No');
        $excel_headers[] = array(50, 'Emp Name');
        $excel_headers[] = array(20, 'Emp No');
        $excel_headers[] = array(25, 'Amount');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Hostel Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B2', 'MONTH OF ' . date('F-Y', strtotime($month)));
        $sheet->SetCellValue('B3', 'HOSTEL DEDUCTION SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $total = 0;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = ($r - 6);
            $excel_values[] = $d->EmpName;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            $excel_values[] = $d->Amount;
            $total = (float) $total + $d->Amount;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $sheet->SetCellValue('D' . $r, $total);
        $sheet->getStyle('D' . $r)->getFont()->setBold(true);
        $sheet->getRowDimension($r)->setRowHeight(35);
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:D' . $r)->applyFromArray($BStyle);
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A5:B" . $r)->applyFromArray($style);
        $sheet->getStyle('D6:D' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $filename = 'Hostel_Deduction_Summary-' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:D6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function month_bank_sheet()
    {
        $data = $this->data;
        $data['page'] = 'month_bank_sheet';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/bank_sheet_report", $data);
    }

    function month_bank_sheet_report()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_month_salary_by_employees($this->attn->getComp(), $month);
        $excel_headers = array();
        $excel_headers[] = array(50, 'NAME');
        $excel_headers[] = array(20, 'BANK CODE');
        $excel_headers[] = array(20, 'BRANCH CODE');
        $excel_headers[] = array(20, 'ACCOUNT NO');
        $excel_headers[] = array(20, 'AMOUNT');
        $excel_headers[] = array(10, "EPF NO");
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Bank Sheet - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(60);
        $i = 0;
        $r = 1;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->AccountName;
            $excel_values[] = $d->Bank;
            $excel_values[] = $d->Branch;
            $excel_values[] = $d->AccountNo;
            $excel_values[] = $d->salaryPayable;
            $excel_values[] = (!empty($d->EPFNo)) ? $d->EPFNo : $d->EmpNo;
            //$this->attn->p($excel_values); die();
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A1:F' . $r)->applyFromArray($BStyle);
        $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $sheet->getStyle("A2:A" . $r)->applyFromArray($style);
        $sheet->getStyle('D3:F' . $r)->getNumberFormat()->setFormatCode('#,##0.00');
        $filename = 'Bank Sheet -' . $month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A1:F1')->getFont()->setBold(true);

        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function month_salary_report()
    {
        $data = $this->data;
        $data['page_title'] = 'Month Salary Details ';
        $data['heading'] = 'Reports';
        $data['page'] = 'month_salary_report';
        $this->load->model('company_model');
        $data['departments'] = $this->company_model->get_all($this->attn->getComp());
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/salary_report", $data);
    }


    function salary_report()
    {
        $data = $this->data;
        $data['page_title'] = 'Basic salary report';
        $data['heading'] = 'Reports';
        $data['page'] = 'month_salary_report';
        $this->load->model('company_model');
        $data['companies'] = $this->company_model->getAll();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/salary_report", $data);
    }

    function basic_salary_excel()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $this->load->model('payroll_model');

        $this->load->model('employee_model');
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $employees = $this->employee_model->getEmpBasicSalary($company);
        //echo '<pre>',print_r($employees); die();
        $excel_headers = array();
        $excel_headers[] = array('', 'No', 8);
        $excel_headers[] = array('', 'Name', 40);
        $excel_headers[] = array('', 'Emp No', 10);
        $excel_headers[] = array('', 'Basic Salary', 20);
        $excel_headers[] = array('', 'BR 1', 20);
        $excel_headers[] = array('', 'BR 2', 20);
        $excel_headers[] = array('', 'Total Basic Salary', 25);
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Basic Salary Summary');
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B3', 'BASIC SALARY SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[2]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        foreach ($employees as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $d->FullName;
            $excel_values[] = $this->attn->formatMoney($d->Basic_Salary);
            $bar1 = $d->br12['0001'];
            $bar2 = $d->br12['0002'];
            $excel_values[] = $this->attn->formatMoney($bar1);
            $excel_values[] = $this->attn->formatMoney($bar2);
            $total = (float)$d->Basic_Salary + (float)$bar1 + (float)$bar2 + (float)$d->Amount;
            $excel_values[] = $this->attn->formatMoney($total);
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }

        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:G' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D7:G' . $r)->getNumberFormat()->setFormatCode('###0.00');
        $name_style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            )
        );
        $sheet->getStyle('B6:B' . $r)->applyFromArray($name_style);
        $filename = 'Basic_salary_Summary-';
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:G6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }
    function gross_salary_report()
    {
        $data = $this->data;
        $data['page_title'] = 'Gross salary report';
        $data['heading'] = 'Reports';
        $data['page'] = 'gross_salary_report';
        $this->load->model('company_model');
        $data['companies'] = $this->company_model->getAll();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/gross_salary_report", $data);
    }

    function gross_salary_excel()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $this->load->model('payroll_model');
        $from_month = $this->input->get('from_month');
        $to_month = $this->input->get('to_month');
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $this->load->model('company_model');
        $company_details = $this->company_model->getCompanyByCode($company);
        $records = $this->payroll_model->getGrossSaleryMonths($from_month, $to_month,0,$company);
        //echo '<pre>',print_r($records); die();
        $excel_headers = array();
        $excel_headers[] = array('', 'Emp No', 10);
        $excel_headers[] = array('', 'Name', 40);
        $excel_headers[] = array('', 'Gross Salary', 20);
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Basic Salary Summary');
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', $company_details->Name);
        $sheet->SetCellValue('B3', 'GROSS SALARY SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[2]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $d->EmpName;
            $excel_values[] = $this->attn->formatMoney($d->GrossSalary);
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }

        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:G' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D7:G' . $r)->getNumberFormat()->setFormatCode('###0.00');
        $name_style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            )
        );
        $sheet->getStyle('B6:B' . $r)->applyFromArray($name_style);
        $filename = 'Gross_salary_Summary-' . $from_month . '-' . $to_month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:G6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function net_salary_report()
    {
        $data = $this->data;
        $data['page_title'] = 'Net salary report';
        $data['heading'] = 'Reports';
        $data['page'] = 'gross_salary_report';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/net_salary_report", $data);
    }

    function net_salary_excel()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $this->load->model('payroll_model');
        $from_month = $this->input->get('from_month');
        $to_month = $this->input->get('to_month');
        $records = $this->payroll_model->getNetSaleryMonths($from_month, $to_month);
        //echo '<pre>',print_r($records); die();
        $excel_headers = array();
        $excel_headers[] = array('', 'Emp No', 10);
        $excel_headers[] = array('', 'Name', 40);
        $excel_headers[] = array('', 'NET Salary', 20);
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Basic Salary Summary');
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B3', 'NET SALARY SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[2]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $d->EmpName;
            $excel_values[] = $this->attn->formatMoney($d->NetSalary);
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }

        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:G' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D7:G' . $r)->getNumberFormat()->setFormatCode('###0.00');
        $name_style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            )
        );
        $sheet->getStyle('B6:B' . $r)->applyFromArray($name_style);
        $filename = 'Net_salary_Summary-' . $from_month . '-' . $to_month;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:G6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function all_dec_report()
    {
        $data = $this->data;
        $data['page_title'] = 'Total deduction & allowance report';
        $data['heading'] = 'Reports';
        $data['page'] = 'gross_salary_report';
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/all_dec_report", $data);
    }

    function all_dec_excel()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $this->load->model('payroll_model');
        $month = $this->input->get('month');
        $EmpNo = $this->input->get('EmpNo');
        $records = $this->payroll_model->getAllDecMonths($month, $EmpNo);
        //echo '<pre>',print_r($records); die();
        $excel_headers = array();
        $excel_headers[] = array('', 'Emp No', 10);
        $excel_headers[] = array('', 'Name', 40);
        $excel_headers[] = array('', 'Total allowance', 20);
        $excel_headers[] = array('', 'Total deduction', 20);
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Deduction & allowance Summary');
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Rathna Hardware');
        $sheet->SetCellValue('B3', 'Total deduction & Total allowance SUMMARY');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[2]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $d->EmpName;
            $excel_values[] = $this->attn->formatMoney($d->NotBasicAllowance);
            $excel_values[] = $this->attn->formatMoney($d->Deduction);
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }

        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:G' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D7:G' . $r)->getNumberFormat()->setFormatCode('###0.00');
        $name_style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            )
        );
        $sheet->getStyle('B6:B' . $r)->applyFromArray($name_style);
        $filename = 'All_dec_Summary-' . $month . '-' . $EmpNo;
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:G6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function employee_information()
    {
        $data = $this->data;
        $this->data['page_title'] = 'Employee Information';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'month_salary_report';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->load->model('department_model');
        $this->data['departments'] = $this->department_model->getAll();
        //echo '<pre>',print_r($this->data['companies'] ); die();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/employee_information", $this->data);
    }


    public function exportToExcel()
    {

        $this->load->model('employee_model');
        // Fetch data from the employee table
        $data['employee_data'] = $this->employee_model->getEmployeeData();

        // Create a new PhpSpreadsheet object
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Add custom headers to the Excel sheet
        $headers = ['Employee Number', 'Employee Type', 'Full Name', 'Calling Name', 'Sure Name', 'Initials Name', 'Start Date', 'Basic Salary'];
        $column = 'A';
        foreach ($headers as $header) {
            $sheet->setCellValue($column . '1', $header);
            $column++;
        }
        echo '<pre>', print_r($data['employee_data']);
        die();
        // Add custom data to the Excel sheet
        $row = 2;
        foreach ($data['employee_data'] as $row_data) {
            $column = 'A';
            foreach ($headers as $header) {
                $columnKey = array_search($header, $headers);
                $sheet->setCellValue($column . $row, $row_data[array_keys($row_data)[$columnKey]]);
                $column++;
            }
            $row++;
        }
        // Save Excel file
        $filename = 'employee_data.xlsx';
        $writer = new Xlsx($spreadsheet);
        $writer->save($filename);

        // Set the headers for download
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Send the file to the browser
        readfile($filename);

        // Delete the file after sending
        unlink($filename);
    }


    function employee_information_excel()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', 0);
        set_time_limit(0);
        $data = $this->data;
        $where = array();
        if ($this->input->get('company')) {
            $data['E.company'] = $this->input->get('company');
            $where['E.Comp'] = $this->input->get('company');
        }
        if ($this->input->get('department')) {
            $data['E.department'] = $this->input->get('department');
            $where['E.Dep_code'] = $this->input->get('Dep_code');
        }
        $this->load->model('employee_model');
        $model = $this->employee_model;
        $records = $model->getEmployeeFilter($where);
        //echo '<pre>',print_r($records); die();

        $excel_headers = array();
        $excel_headers[] = array('', 'Code', 8);
        $excel_headers[] = array('', 'ID No', 15);
        $excel_headers[] = array('', 'Employee Type', 15);
        $excel_headers[] = array('', 'Full Name', 30);
        $excel_headers[] = array('', 'Calling Name', 30);
        $excel_headers[] = array('', 'Sure Name', 20);
        $excel_headers[] = array('', 'Initials Name', 25);
        $excel_headers[] = array('', 'EPF No', 15);
        $excel_headers[] = array('', 'Company', 25);
        $excel_headers[] = array('', 'Gender', 15);
        $excel_headers[] = array('', 'Title', 15);
        $excel_headers[] = array('', 'Date Of Birth', 25);
        $excel_headers[] = array('', 'Status', 25);
        $excel_headers[] = array('', 'Current Address', 30);
        $excel_headers[] = array('', 'Permanent Address', 30);
        $excel_headers[] = array('', 'Department', 25);
        $excel_headers[] = array('', 'Designation', 25);
        $excel_headers[] = array('', 'Mobile', 25);
        $excel_headers[] = array('', 'Start Date', 25);
        $excel_headers[] = array('', 'Active', 15);
        $excel_headers[] = array('', 'Month Working days', 25);
        $excel_headers[] = array('', 'Emergency', 25);
        $excel_headers[] = array('', 'Egy Relationship', 25);
        $excel_headers[] = array('', 'Egy Email Address', 25);
        $excel_headers[] = array('', 'Egy Telephone', 25);
        $excel_headers[] = array('', 'Account Number', 25);
        $excel_headers[] = array('', 'Bank Name', 25);
        $excel_headers[] = array('', 'Branch', 25);
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Employee Information');
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Employee Information');
        $i = 0;
        $r = 6;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[2]);
            $sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;


        foreach ($records as $d) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $d->EmpNo;
            $excel_values[] = $d->IDNo;
            $excel_values[] = $d->work_type;
            $excel_values[] = $d->FullName;
            $excel_values[] = $d->EmpName;
            $excel_values[] = $d->SureName;
            $excel_values[] = $d->InitialsName;
            $excel_values[] = $d->EPFNo;
            $excel_values[] = $d->CompanyName;
            $excel_values[] = $d->Gender;
            $excel_values[] = $d->Title;
            $excel_values[] = $d->Birth;
            $excel_values[] = $d->Empstatus;
            $excel_values[] = $d->Address;
            $excel_values[] = $d->PermanentAddress;
            $excel_values[] = $d->Department;
            $excel_values[] = $d->DesignationName;
            $excel_values[] = $d->MobileNo;
            $excel_values[] = $d->StartDate;
            $excel_values[] = ($d->Active == 1) ? 'Active' : 'Inactive';
            $excel_values[] = $d->Month_working_days;
            $excel_values[] = $d->Emergency;
            $excel_values[] = $d->Relationship;
            $excel_values[] = $d->EmerAddress;
            $excel_values[] = $d->HomeNo;
            $excel_values[] = $d->AccountNo;
            $excel_values[] = $d->Bank;
            $excel_values[] = $d->Branch;
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }
        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A6:AB' . $r)->applyFromArray($BStyle);
        $sheet->getStyle('D7:AB' . $r)->getNumberFormat()->setFormatCode('###0.00');
        $name_style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            )
        );
        $sheet->getStyle('B6:B' . $r)->applyFromArray($name_style);
        $filename = 'Employee Information';
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A6:AB6')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function nopay()
    {
        $this->data['page_title'] = 'No Pay report';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'month_salary_report';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->load->model('department_model');
        $this->data['departments'] = $this->department_model->getAll();
        $this->load->model('employee_model');
        $this->data['employees'] = $this->employee_model->get_all_filter();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/no_pay", $this->data);
    }

    function nopay_report()
    {
        $data = $this->data;
        $data['EmpNo'] = '';
        $data['Year']  = date('Y');
        $month  = date('m');
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
        }
        if ($this->input->get('Year')) {
            $data['Year'] = $this->input->get('Year');
        }
        if ($this->input->get('month')) {
            $month = $this->input->get('month');
        }
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        
        $EmpNo = $data['EmpNo'];
        $this->load->model('transaction/leave_transaction_model');
        $this->load->model('employee_model');

        $employees = $this->employee_model->getEmpNameIdByEmpNo($EmpNo,$company);

        $year = $data['Year'];
        $nopays = $this->leave_transaction_model->get_year_month_employee_nopay_details($year);

        //$leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $EmpNo);
        //$nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $EmpNo);
        $excel_headers = array();
        $excel_headers[] = array(20, 'Employee No');
        $excel_headers[] = array(45, 'Employee Name');
        $excel_headers[] = array(25, 'Date');
        $excel_headers[] = array(20, 'Reason');
        $excel_headers[] = array(20, 'Days');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('NOPAY Summary - ' . $year);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B2', 'YEAR -  ' . $year);
        $sheet->SetCellValue('B3', 'NOPAY SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
               $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            //$sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $casual = 0;
        $annual = 0;

        foreach ($employees as $emp) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $emp->EmpNo;
            $excel_values[] = $emp->FullName;
            if (isset($nopays[$emp->EmpNo])) {
                $np = $nopays[$emp->EmpNo];
                foreach ($np as $n) {
                    $excel_values[] =  $n->NopayFrom . ' / ' . $n->NopayTo;
                    $excel_values[] =  $n->Reason;
                    $excel_values[] =  $n->Days;
                    $s = 0;
                    foreach ($excel_values as $ev) {
                        $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                        $s++;
                    }
                    $excel_values = array();
                    $excel_values[] =  '';
                    $excel_values[] =  '';
                    $r++;
                }
            }
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:E' . $r)->applyFromArray($BStyle);
        $filename = 'Nopay_Summary-' . $year . ((!empty($month)) ? ' - month ' . $month : '') . ((!empty($EmpNo)) ? ' - Emp ' . $EmpNo : '');
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:E11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function ot()
    {
        $this->data['page_title'] = 'OT report';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'month_salary_report';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->load->model('employee_model');
        $this->data['employees'] = $this->employee_model->get_all_filter();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/overtime", $this->data);
    }

    function ot_report()
    {
        $data = $this->data;
        $data['EmpNo'] = '';
        $month  = date('Y-m');
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
        }

        if ($this->input->get('month')) {
            $month = $this->input->get('month');
        }

        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }

        $EmpNo = $data['EmpNo'];
        $this->load->model('transaction/leave_transaction_model');
        $this->load->model('employee_model');

        $employees = $this->employee_model->getEmpNameIdByEmpNo($EmpNo,$company);
        $this->load->model('reports/payslip_model');
        $orvertimes = $this->payslip_model->get_payroll_month_emp($month);
        //echo '<pre>', print_r($employees);
        //die();
        //$leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $EmpNo);
        //$nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $EmpNo);
        $excel_headers = array();
        $excel_headers[] = array(20, 'Employee No');
        $excel_headers[] = array(45, 'Employee Name');
        $excel_headers[] = array(25, 'Aomunt');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('OT Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B2', 'Month -  ' . $month);
        $sheet->SetCellValue('B3', 'OT SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
               $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            //$sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $casual = 0;
        $annual = 0;

        foreach ($employees as $emp) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $emp->EmpNo;
            $excel_values[] = $emp->FullName;

            if (isset($orvertimes[$emp->EmpNo])) {

                $ot = $orvertimes[$emp->EmpNo];
                $excel_values[] = $ot['NotValue'];
            }else{
                $excel_values[] = 0;
            }
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:C' . $r)->applyFromArray($BStyle);
        $filename = 'OT_Summary-'.((!empty($month)) ? ' - month ' . $month : '') . ((!empty($EmpNo)) ? ' - Emp ' . $EmpNo : '');
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:C11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    
    function late()
    {
        $this->data['page_title'] = 'Late report';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'daily_attendance';
        $this->load->model('company_model');
        $this->data['companies'] = $this->company_model->getAll();
        $this->load->model('employee_model');
        $this->data['employees'] = $this->employee_model->get_all_filter();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/late", $this->data);
    }

    function late_report()
    {
        $data = $this->data;
        $date = date('Y-m-d');
        if($this->input->get('indate')) {
            $date = $this->input->get('indate');
        }
        $company ='';
        if ($this->input->get('company')) {
            $company = $this->input->get('company');
        }
        $this->load->model('attendance_model');
        $lates = $this->attendance_model->getLeaveData($date,$date,'',$company);
        //echo '<pre>',print_r($lates); die();
        //$leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $EmpNo);
        //$nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $EmpNo);
        $excel_headers = array();
        $excel_headers[] = array(20, 'Employee No');
        $excel_headers[] = array(45, 'Employee Name');
        $excel_headers[] = array(25, 'Date');
        $excel_headers[] = array(25, 'Intime');
        $excel_headers[] = array(25, 'Out date');
        $excel_headers[] = array(25, 'Out time');
        $excel_headers[] = array(25, 'Hours');
        $excel_headers[] = array(25, 'Late');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Late Summary - ' . $date);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B2', 'Date -  ' . $date);
        $sheet->SetCellValue('B3', 'LATE SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
               $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            //$sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $casual = 0;
        $annual = 0;

        foreach ($lates as $late) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $late->USER;
            $excel_values[] = $late->NAME;
            $excel_values[] = $late->DATE;
            $excel_values[] = $late->INTIME;
            $excel_values[] = $late->OUTDATE;
            $excel_values[] = $late->OUTTIME;
            $excel_values[] = $late->HOURS;
            $excel_values[] = $late->late;
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:H' . $r)->applyFromArray($BStyle);
        $filename = 'Late_Summary-'.((!empty($date)) ? ' - date ' . $date : '');
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:H11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }

    function join()
    {
        $this->data['page_title'] = 'Date of join & year of service report';
        $this->data['heading'] = 'Reports';
        $this->data['page'] = 'daily_attendance';
        $this->load->model('employee_model');
        $this->data['employees'] = $this->employee_model->get_all_filter();
        $this->data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/join", $this->data);
    }

    function join_report()
    {
        $data = $this->data;
        $data['EmpNo'] = '';
        if ($this->input->get('EmpNo')) {
            $data['EmpNo'] = $this->input->get('EmpNo');
        }
        $EmpNo = $data['EmpNo'];
        $this->load->model('employee_model');
        $employees = $this->employee_model->getEmpJoin($EmpNo);
        //echo '<pre>', print_r($employees);die();
        //$leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $EmpNo);
        //$nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $EmpNo);
        $excel_headers = array();
        $excel_headers[] = array(20, 'Employee No');
        $excel_headers[] = array(45, 'Employee Name');
        $excel_headers[] = array(25, 'Join date');
        $excel_headers[] = array(25, 'Year of service');
        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('SERVICE Summary - ' . $month);
        $sheet->getStyle('B1')->getFont()->setBold(true);
        $sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B2', 'Month -  ' . $month);
        $sheet->SetCellValue('B3', 'SERVICE SUMMARY');
        /*$sheet->SetCellValue('B2', $comp['Name'].' - '.$comp['Address']);
               $sheet->SetCellValue('B3', 'Date : '.$date);*/
        $i = 0;
        $r = 11;
        $header_index_codes = array();
        foreach ($excel_headers as $eh) {
            $sheet->SetCellValue($this->attn->getNameFromNumber($i) . $r, $eh[1]);
            $sheet->getColumnDimension($this->attn->getNameFromNumber($i))->setWidth($eh[0]);
            //$sheet->getRowDimension($r)->setRowHeight(35);
            $header_index_codes[$i] = $eh[0];
            $i++;
        }
        $r++;
        $casual = 0;
        $annual = 0;

        foreach ($employees as $emp) {
            $sheet->getRowDimension($r)->setRowHeight(35);
            $excel_values = array();
            $excel_values[] = $emp->EmpNo;
            $excel_values[] = $emp->FullName;
            $excel_values[] = $emp->StartDate;
            $excel_values[] = $emp->time_difference;
            $s = 0;
            foreach ($excel_values as $ev) {
                $sheet->SetCellValue($this->attn->getNameFromNumber($s) . $r, $ev);
                $s++;
            }
            $r++;
        }


        $BStyle = array(
            'borders' => array(
                'allborders' => array(
                    'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_GENERAL,
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                )
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ),
            'font' => array(
                'size' => 12,
                'name' => 'Times New Roman',
            )
        );
        $sheet->getStyle('A11:F' . $r)->applyFromArray($BStyle);
        $filename = 'Service summary';
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A11:F11')->getFont()->setBold(true);
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }


    function epf()
    {
        $data = $this->data;
        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/epf", $data);
    }

    function etf()
    {
        $data = $this->data;

        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/etf", $data);
    }

    function epf_jan_june()
    {
        $data = $this->data;
        $year = date('Y', strtotime('2018'));
        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/epf_jan_june", $data);
    }

    function epf_july_december()
    {
        $data = $this->data;
        $year = date('Y', strtotime('2018'));
        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/epf_july_december", $data);
    }
    function etf_jan_june()
    {

        $data = $this->data;
        $year = date('Y', strtotime('2018'));
        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/etf_jan_june", $data);
    }

    function etf_july_december()
    {

        $data = $this->data;
        $year = date('Y', strtotime('2018'));

        $data['page'] = 'epf_etf';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/etf_july_december", $data);
    }


    function report_epf()
    {

        ini_set('max_execution_time', 0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $epf = $model->get_month_epf_by_employees($month, $this->attn->getComp());
        $tr = '';
        $total = 0;
        if ($epf) {
            foreach ($epf as $s) {
                $tr .= '<tr nobr="true">';
                $tr .= '<td width="15%">' . $s->EPFNo . '</td>';
                $tr .= '<td width="15%">' . $s->EmpNo . '</td>';
                $tr .= '<td width="45%">' . $s->EmpName . '</td>';
                $tr .= '<td width="25%" style="text-align: right">' . number_format($s->EPFepm, 2) . '</td>';
                $tr .= '</tr>';
                $total = floatval($total) + floatval($s->EPFepm);
            }
        }
        $tr .= '<tr nobr="true">';
        $tr .= '<td colspan="3" width="75%" style="text-align: right"><strong>Total</strong></td>';
        $tr .= '<td width="25%" style="text-align: right">' . number_format($total, 2) . '</td>';
        $tr .= '</tr>';
        $title = 'E.P.F Employer of ' . date('F-Y', strtotime($month));
        $pdf = $this->_getHeader($title, '');
        $pdf->AddPage();

        $tbl = '';
        $tbl .= "<style>
        thead { display: table-header-group }
        tfoot { display: table-row-group }
        tr { page-break-inside: avoid }
        </style>    
        <table width=\"95%\" cellpadding=\"5\" border=\"1\">    
        <tr nobr=\"true\">        
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">E.P.F #</strong></th>        
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">Employee No</strong></th>        
        <th scope=\"col\" width=\"45%\"><strong style=\"text-align: center\">Name</strong></th>        
        <th scope=\"col\" width=\"25%\"><strong style=\"text-align: center\">E.P.F</strong></th>    
        </tr>   <tbody> " . $tr . "</tbody></table>";

        $pdf->writeHTML($tbl, true, false, false, false, '');
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('epf-' . $month . '.pdf', 'I'), 'Out put');
    }

    function report_etf()
    {

        ini_set('max_execution_time', 0);
        $data = $this->data;

        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }


        $month = $data['month'];
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $epf = $model->get_month_etf_by_employees($month, $this->attn->getComp());
        //echo '<pre>',print_r($epf); die();
        $tr = '';
        $total = 0;
        if ($epf) {
            foreach ($epf as $s) {
                $tr .= '<tr nobr="true">';
                $tr .= '<td width="15%">' . $s->EPFNo . '</td>';
                $tr .= '<td width="15%">' . $s->EmpNo . '</td>';
                $tr .= '<td width="45%">' . $s->EmpName . '</td>';
                $tr .= '<td width="25%" style="text-align: right">' . number_format($s->ETF, 2) . '</td>';
                $tr .= '</tr>';
                $total = floatval($total) + floatval($s->ETF);
            }
        }
        $tr .= '<tr nobr="true">';
        $tr .= '<td colspan="3" width="75%" style="text-align: right"><strong>Total</strong></td>';
        $tr .= '<td width="25%" style="text-align: right">' . number_format($total, 2) . '</td>';
        $tr .= '</tr>';
        $title = 'E.P.F Employer of ' . date('F-Y', strtotime($month));
        $pdf = $this->_getHeader($title, '');
        $pdf->AddPage();
        $tbl = "<style>thead { display: table-header-group }tfoot { display: table-row-group }tr { page-break-inside: avoid }</style>    
        <table cellpadding=\"5\" width=\"95%\" border=\"1\">    <tr nobr=\"true\">        
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">EPF No</strong></th>
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">Employer No</strong></th>
        <th scope=\"col\" width=\"45%\"><strong style=\"text-align: center\">Employer Name</strong></th>       
        <th scope=\"col\" width=\"25%\"><strong style=\"text-align: center\">ETF Contribution</strong></th>   
        </tr>   <tbody>" . $tr . "</tbody></table>";
        $pdf->writeHTML($tbl, true, false, false, false, '');
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('etf-' . $month . '.pdf', 'I'), 'Out put');
    }

    function report_epf_year()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        if ($this->input->get('year')) {
            $data['year'] = $this->input->get('year');
        }
        $v = 0;
        if ($this->input->get('v')) {
            $v = $this->input->get('v');
        }
        $year = $data['year'];
        $month1 = $year . '-01';
        $month2 = $year . '-06';
        $title = 'E.P.F Employer of ' . date('Y', strtotime($year)) . " January to June";
        if ($v == 1) {
            $month1 = $year . '-07';
            $month2 = $year . '-12';
            $title = 'E.P.F Employer of ' . date('Y', strtotime($year)) . " July to December";
        }
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $epf = $model->get_all_between_months_epf($this->attn->getComp(), $month1, $month2);
        $tr = '';
        $total_1 = $total_2 = $total_3 = $total_4 = $total_5 = $total_6 = 0;
        if ($epf) {
            foreach ($epf as $s) {
                $tr .= '<tr nobr="true">';
                $tr .= '<td width="12%">' . $s[0]->EPFNo . '</td>';
                $tr .= '<td width="12%">' . $s[0]->EmpNo . '</td>';
                $tr .= '<td width="16%">' . $s[0]->EmpName . '</td>';
                for ($i = 0; $i < 6; $i++) {
                    if (isset($s[$i])) {
                        $tr .= '<td style="text-align: right" width="10%">' . $s[$i]->EPFEM . '</td>';
                        $n = $i + 1;
                        ${"total_{$n}"} = floatval(${"total_{$n}"}) + floatval($s[$i]->EPFEM);
                    } else {
                        $tr .= '<td style="text-align: right" width="10%">' . ' ' . '</td>';
                    }
                }
                $tr .= '</tr>';
            }
        }
        $tr .= '<tr nobr="true">';
        $tr .= '<td colspan="3" width="40%" style="text-align: right"><strong>Total</strong></td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_1, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_2, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_3, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_4, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_5, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_6, 2) . '</td>';
        $tr .= '</tr>';
        $pdf = $this->_getHeader($title, '');
        $pdf->AddPage();
        $tbl = "<style>
        thead { display: table-header-group }
        tfoot { display: table-row-group }
        tr { page-break-inside: avoid }</style>  
          <table cellpadding=\"5\" border=\"1\">   
           <tr nobr=\"true\">        
           <th scope=\"col\" width=\"12%\" ><strong style=\"text-align: center\">E.P.F #</strong></th>        
           <th scope=\"col\" width=\"12%\" ><strong style=\"text-align: center\">Employee No</strong></th>        
           <th scope=\"col\" width=\"16%\" ><strong style=\"text-align: center\">Name</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">January</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">February</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">March</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">April</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">May</strong></th>        
           <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">June</strong></th>    
           </tr>   <tbody>" . $tr . "</tbody></table>";


        $pdf->writeHTML($tbl, true, false, false, false, '');
        //Close and output PDF document
        if (ob_get_contents())
            ob_end_clean();

        $this->load->helper('download');
        force_download($pdf->Output('etf-' . $year . '.pdf', 'I'), 'Out put');
    }


    function report_etf_year()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        if ($this->input->get('year')) {
            $data['year'] = $this->input->get('year');
        }
        $v = 0;
        if ($this->input->get('v')) {
            $v = $this->input->get('v');
        }
        $year = $data['year'];
        $month1 = $year . '-01';
        $month2 = $year . '-06';
        $title = 'E.T.F Employee of ' . date('Y', strtotime($year)) . " January to June";
        if ($v == 1) {
            $month1 = $year . '-07';

            $month2 = $year . '-12';

            $title = 'E.T.F Employee of ' . date('Y', strtotime($year)) . " July to December";
        }
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $epf = $model->get_all_between_months_etf($this->attn->getComp(), $month1, $month2);

        $tr = '';
        $total_1 = $total_2 = $total_3 = $total_4 = $total_5 = $total_6 = 0;
        if ($epf) {
            foreach ($epf as $s) {
                $tr .= '<tr nobr="true">';
                $tr .= '<td width="12%">' . $s[0]->EPFNo . '</td>';
                $tr .= '<td width="12%">' . $s[0]->EmpNo . '</td>';
                $tr .= '<td width="16%">' . $s[0]->EmpName . '</td>';

                for ($i = 0; $i < 6; $i++) {

                    if (isset($s[$i])) {

                        $tr .= '<td style="text-align: right" width="10%">' . $s[$i]->ETF . '</td>';

                        $n = $i + 1;

                        ${"total_{$n}"} = floatval(${"total_{$n}"}) + floatval($s[$i]->ETF);
                    } else {
                        $tr .= '<td style="text-align: right" width="10%">' . ' ' . '</td>';
                    }
                }
                $tr .= '</tr>';
            }
        }
        $tr .= '<tr nobr="true">';
        $tr .= '<td colspan="3" width="40%" style="text-align: right"><strong>Total</strong></td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_1, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_2, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_3, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_4, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_5, 2) . '</td>';
        $tr .= '<td width="10%" style="text-align: right">' . number_format($total_6, 2) . '</td>';
        $tr .= '</tr>';
        $pdf = $this->_getHeader($title, '');
        $pdf->AddPage();
        $tbl = "<style>thead { display: table-header-group }
tfoot { display: table-row-group }tr { page-break-inside: avoid }</style> 
   <table cellpadding=\"5\" border=\"1\">    <tr nobr=\"true\">        
   <th scope=\"col\" width=\"12%\" ><strong style=\"text-align: center\">E.P.F #</strong></th>        
   <th scope=\"col\" width=\"12%\" ><strong style=\"text-align: center\">Employee No</strong></th>        
   <th scope=\"col\" width=\"16%\" ><strong style=\"text-align: center\">Name</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">January</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">February</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">March</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">April</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">May</strong></th>        
   <th scope=\"col\" width=\"10%\" ><strong style=\"text-align: center\">June</strong></th>    
   </tr>   <tbody>" . $tr . " </tbody></table>";

        $pdf->writeHTML($tbl, true, false, false, false, '');


        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('etf-' . $year . '.pdf', 'I'), 'Out put');
    }


    function allowance_deduction()
    {
        $data = $this->data;
        $data['page'] = 'allowance_deduction';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/allowance_deduction", $data);
    }

    function report_allowance_deduction()
    {

        ini_set('max_execution_time', 0);
        $data = $this->data;
        $month = date('Y-m');
        $item = $Item_Code = $Item_Name = '';
        if ($this->input->get('month')) {
            $month = $this->input->get('month');
        }

        if ($this->input->get('item')) {
            $item = $this->input->get('item');
        }
        if ($this->input->get('Item_Code')) {
            $Item_Code = $this->input->get('Item_Code');
        }
        if ($this->input->get('Item_Name')) {
            $Item_Name = $this->input->get('Item_Name');
        }

        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $month_allowance_deduction = $model->get_month_allowance_deduction($this->attn->getComp(), $month, $item, $Item_Code);
        //echo '<pre>',print_r($month_allowance_deduction); die();
        $tr = '';
        $total = 0;
        if ($month_allowance_deduction) {
            foreach ($month_allowance_deduction as $s) {
                $tr .= '<tr nobr="true">';
                $tr .= '<td width="15%">' . $s[6] . '</td>';
                $tr .= '<td width="15%">' . $s[7] . '</td>';
                if ($item == 'O' or $item == 'N') {

                    $tr .= '<td width="40%">' . $s[5] . '</td>';
                    $tr .= '<td width="10%">' . $s[3] . '</td>';
                } else {
                    $tr .= '<td width="50%">' . $s[5] . '</td>';
                }


                $tr .= '<td width="20%" style="text-align: right">' . number_format($s[1], 2) . '</td>';
                $tr .= '</tr>';
                $total = floatval($total) + floatval($s[1]);
            }
        }
        $tr .= '<tr nobr="true">';
        $tr .= '<td colspan="3" width="80%" style="text-align: right"><strong>Total</strong></td>';
        $tr .= '<td width="20%" style="text-align: right">' . number_format($total, 2) . '</td>';
        $tr .= '</tr>';
        $title = $Item_Name . '-' . date('F-Y', strtotime($month));
        $pdf = $this->_getHeader($title, '');
        $pdf->AddPage();
        $tbl = "<style>thead { display: table-header-group }tfoot { display: table-row-group }tr { page-break-inside: avoid }</style>    
        <table cellpadding=\"5\" width=\"95%\" border=\"1\">    <tr nobr=\"true\">        
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">EPF No</strong></th>
        <th scope=\"col\" width=\"15%\"><strong style=\"text-align: center\">Employer No</strong></th>";
        if ($item == 'O' or $item == 'N') {
            $h_d = ($item == 'N') ? 'Days' : 'Hours';
            $tbl .= "<th scope=\"col\" width=\"40%\"><strong style=\"text-align: center\">Employer Name</strong></th>";
            $tbl .= "<th scope=\"col\" width=\"10%\"><strong style=\"text-align: center\">" . $h_d . "</strong></th>";
        } else {
            $tbl .= "<th scope=\"col\" width=\"50%\"><strong style=\"text-align: center\">Employer Name</strong></th>";
        }

        $tbl .= "<th scope=\"col\" width=\"20%\"><strong style=\"text-align: center\">Amount</strong></th>   
        </tr>   <tbody>" . $tr . "</tbody></table>";
        $pdf->writeHTML($tbl, true, false, false, false, '');
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output($title . '.pdf', 'I'), 'Out put');
    }


    function salary_summary()
    {

        $data = $this->data;
        $data['page'] = 'summary';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/salary_summary", $data);
    }

    function report_salary_summary()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $d = new DateTime($month);
        $d->modify('last month');
        $pm = $d->format('Y-m');
        $m = array($pm, $month);
        $this->load->model('reports/payslip_model');
        $model = $this->payslip_model;
        $p = $model->get_month_salary_summary($this->attn->getComp(), $m);
        $tr = '';
        if (!empty($p)) {

            $tr .= '<tr nobr="true">';
            $tr .= '<td style="border-top: 2px solid #000000;" width="40%"><b>Basic Salary</b></td>';
            $tr .= '<td style="text-align: right; border-top: 2px solid #000000;"  width="20%"><b>' . number_format((float) $p['BasicSalary'][0], 2) . '</b></td>';
            $tr .= '<td style="text-align: right; border-top: 2px solid #000000;"  width="20%"><b>' . number_format((float) $p['BasicSalary'][1], 2) . '</b></td>';
            $tr .= '<td style="text-align: right; border-top: 2px solid #000000;"  width="20%"><b>' . number_format((float) ($p['BasicSalary'][1] - $p['BasicSalary'][0]), 2) . '</b></td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Nopay Amount</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Nopay'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Nopay'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Nopay'][1] - $p['Nopay'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Budgetary relief allowance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['BR'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['BR'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['BR'][1] - $p['BR'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Gross Pay for funds</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['TotalSalary'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['TotalSalary'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['TotalSalary'][1] - $p['TotalSalary'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr style="line-height: 10%;" nobr="true">';
            $tr .= '<td style="border: 1px dashed #000000;" width="40%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">OT Normal 1.5 Amount</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Nothr'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Nothr'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Nothr'][1] - $p['Nothr'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Extra OT 2.0 Amount</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Dothr'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Dothr'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Dothr'][1] - $p['Dothr'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Extra OT 3.0 Amount</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) 0, 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) 0, 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) 0, 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Attendance Allowance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['AttnAllowance'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['AttnAllowance'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['AttnAllowance'][1] - $p['AttnAllowance'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Special Allowance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['SpecialAllowance'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['SpecialAllowance'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['SpecialAllowance'][1] - $p['SpecialAllowance'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Telephone</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Telephone'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Telephone'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Telephone'][1] - $p['Telephone'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Fuel</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Fuel'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Fuel'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Fuel'][1] - $p['Fuel'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Star Allowance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['StarAllowance'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['StarAllowance'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['StarAllowance'][1] - $p['StarAllowance'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Coins B/F</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['CBF'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['CBF'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['CBF'][1] - $p['CBF'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Total Allowances</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Allowances'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Allowances'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Allowances'][1] - $p['Allowances'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Total Income</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['GrossSalary'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['GrossSalary'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['GrossSalary'][1] - $p['GrossSalary'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr style="line-height: 10%;" nobr="true">';
            $tr .= '<td style="border: 1px dashed #000000;" width="40%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">EPF Employee</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['EPF'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['EPF'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['EPF'][1] - $p['EPF'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Salary Advance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['SalaryAdvance'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['SalaryAdvance'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['SalaryAdvance'][1] - $p['SalaryAdvance'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Other Deduction</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['OtherDeduction'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['OtherDeduction'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['OtherDeduction'][1] - $p['OtherDeduction'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Meal Deduction</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['MealDeduction'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['MealDeduction'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['MealDeduction'][1] - $p['MealDeduction'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Insurance</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Insurance'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Insurance'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['Insurance'][1] - $p['Insurance'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Death Deduction</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['DeathDeducton'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['DeathDeducton'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['DeathDeducton'][1] - $p['DeathDeducton'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%">Welfare</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['DeathDeducton'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['DeathDeducton'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['DeathDeducton'][1] - $p['DeathDeducton'][0], 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Total Deduction</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Deductions'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Deductions'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['Deductions'][1] - $p['Deductions'][0], 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr style="line-height: 10%;" nobr="true">';
            $tr .= '<td style="border: 1px dashed #000000;" width="40%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Net Payable</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['salaryPayable'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['salaryPayable'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['salaryPayable'][1] - $p['salaryPayable'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Coins C/F</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['CCF'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['CCF'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['CCF'][1] - $p['CCF'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>Net Salary Paid</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['salaryPayableRound'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['salaryPayableRound'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['salaryPayableRound'][1] - $p['salaryPayableRound'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr style="line-height: 10%;" nobr="true">';
            $tr .= '<td style="border: 1px dashed #000000;" width="40%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '<td width="20%"></td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td width="40%"><b>EPF 12%</b></td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['EPFEM'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) $p['EPFEM'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right" width="20%">' . number_format((float) ($p['EPFEM'][1] - $p['EPFEM'][0]), 2) . '</td>';
            $tr .= '</tr>';
            $tr .= '<tr nobr="true">';
            $tr .= '<td style="border-bottom: 2px solid #000000;" width="40%"><b>ETF 3%</b></td>';
            $tr .= '<td style="text-align: right;border-bottom: 2px solid #000000;" width="20%">' . number_format((float) $p['ETF'][0], 2) . '</td>';
            $tr .= '<td style="text-align: right;border-bottom: 2px solid #000000;" width="20%">' . number_format((float) $p['ETF'][1], 2) . '</td>';
            $tr .= '<td style="text-align: right;border-bottom: 2px solid #000000;" width="20%">' . number_format((float) ($p['ETF'][1] - $p['ETF'][0]), 2) . '</td>';
            $tr .= '</tr>';


            ob_start();
            $this->load->library('pdf');
            $this->load->library('payslip');
            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'a4', true, 'utf-8', false);
            $pdf->SetMargins(5, 5, 10, true);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Namal Kumarasinghe');
            $pdf->SetTitle('Salary & Wages Summary for the month of ' . date('F-Y', strtotime($month)));
            $pdf->SetSubject('TCPDF Tutorial');
            $pdf->SetHeaderData('', '', 'Salary & Wages for the month of ' . date('F-Y', strtotime($month)), '');
            $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA)); // set default monospaced font        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);        // set margins        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);        // set auto page breaks        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);        // set image scale factor        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);        // set some language-dependent strings (optional)        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        $pdf->SetFont('helvetica', '', 8);
        $pdf->AddPage();
        $mf = date('F-Y', strtotime($month));
        $mfp = date('F-Y', strtotime($pm));
        $tbl = "<style>table {border-collapse: collapse;}td{border: 1px dashed #000000; border-left: 2px solid #000000;border-right: 2px solid #000000;}</style>
    <table cellspacing=\"0\" cellpadding=\"7\" border=\"0\">       <tr nobr=\"true\">          
    <th  width=\"40%\"><strong style=\"text-align: center\"></strong></th>          
    <th style=\"border: 2px solid #000000;\" scope=\"col\" width=\"20%\"><strong style=\"text-align: center; font-size: 15px;\">Month of $mfp</strong></th>          
    <th style=\"border: 2px solid #000000;\" scope=\"col\" width=\"20%\"><strong style=\"text-align: center; font-size: 15px;\">Month of $mf</strong></th>          
    <th style=\"border: 2px solid #000000;\" scope=\"col\" width=\"20%\"><strong style=\"text-align: center; font-size: 15px;\">Varience <br />Prev - Curr</strong></th> 
    </tr>    <tbody>" . $tr . " </tbody></table>";
        $tbl = utf8_encode($tbl);
        $pdf->writeHTML($tbl, true, false, false, false, '');
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('Salary Summary-' . $month . '.pdf', 'I'), 'Out put');
    }


    function Payroll()
    {
        $data = $this->data;
        $data['page'] = 'signature';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/signature", $data);
    }

    function view()
    {
        $data = $this->data;
        $data['page'] = 'pay_slip';
        $this->load->model('reports/summary_attendance');
        $model = $this->summary_attendance;
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter($this->attn->getComp());
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/view", $data);
    }

    function daily_attendance()
    {
        $data = $this->data;
        $data['page'] = 'daily_attendance';
        $data['admin'] = $this->Admin;
        $data['page_title'] = 'Day Attendance Report';
        $data['heading'] = 'Reports';
        $this->load->model('department_model');
        $data['departments'] = $this->department_model->getAll();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/daily_attendance", $data);
    }


    function report_daily_attendance()
    {
        $indate = (isset($_GET['indate'])) ? $_GET['indate'] : null;
        $department = (isset($_GET['department'])) ? $_GET['department'] : null;
        $data['page'] = 'today';
        $xls = true;
        $this->load->model('shift_model');
        $this->load->model('attendance_model');
        $attendances = $this->attendance_model->get_all_today($indate, $department);
        //echo '<pre>',print_r($attendances); die();
        $yesterday_attendances = $this->attendance_model->get_all_yesterday($prev_date);
        $this->load->model('reports/summary_attendence');
        $model = $this->summary_attendence;
        $comp = array('Name' => $this->session->userdata('CompName'), 'Address' => $this->session->userdata('Address'));

        $spreadsheet = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Attendance Summary');
        $sheet->getStyle('B1:B4')->getFont()->setBold(true);
        //$sheet->getColumnDimension('B1')->setWidth(45);
        $sheet->SetCellValue('B1', 'Daily Attendance');
        $sheet->SetCellValue('B3', 'Date : ' . date("d/m/Y", strtotime($indate)));
        $sheet->SetCellValue('C2', 'Attendance In');
        $sheet->SetCellValue('B5', 'EmpNo');
        $sheet->SetCellValue('C5', 'Emp Name');
        $sheet->SetCellValue('D5', 'Department');
        $sheet->SetCellValue('E5', 'Attendance');
        //$sheet->getColumnDimension('E5')->setWidth(40);
        $row = 6;
        $row_open = $row - 1;
        foreach ($attendances as $data_row) {
            $sheet->SetCellValue('B' . $row, $data_row['USER']);
            $sheet->SetCellValue('C' . $row, $data_row['EmpName']);
            //$sheet->SetCellValue('D' . $row, $data_row['Name']);
            $sheet->SetCellValue('D' . $row, $data_row['Department']);
            $sheet->SetCellValue('E' . $row, date('H:i:s', strtotime($data_row['INOUTTIME'])));
            $row++;
            $add = $row;
        }
        $style = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
        $style_left = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT));
        $styleborder = array('borders' => array('allborders' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)));
        $sheet->getStyle('B' . $row_open . ':E' . $row)->applyFromArray($styleborder);
        $row2 = $add + 7;
        $row3 = $row2 + 2;
        $head = $row2 - 2;
        $headmerge = $head + 1;
        $head2 = $row3 - 1;
        $row = $row + 5;
        $sheet->getColumnDimension('A')->setWidth(12);
        $sheet->getColumnDimension('B')->setWidth(25);
        $sheet->getColumnDimension('C')->setWidth(25);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->mergeCells('C2:D3');
        $sheet->mergeCells('C' . $head . ':D' . $headmerge);
        $sheet->getStyle("C2:D3")->getFont()->setSize(16);
        $sheet->getStyle("B1:B3")->getFont()->setSize(13);
        $sheet->getStyle("A5:D5")->getFont()->setSize(12);
        $sheet->getStyle('A' . $head2 . ':' . 'C' . $head2)->getFont()->setSize(12);
        $sheet->getStyle('C' . $head . ':D' . $headmerge)->getFont()->setSize(16);
        $sheet->getStyle("C2:D3")->applyFromArray($style);
        $sheet->getStyle('C5:E' . $row3)->applyFromArray($style_left);
        $sheet->getStyle('C' . $head . ':D' . $headmerge)->applyFromArray($style);
        $sheet->getStyle('B' . $head2 . ':E' . $row)->applyFromArray($styleborder);
        $filename = 'attendence_summary_report';
        //$this->excel->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        $sheet->getStyle('A1:D5')->getFont()->setBold(true);
        $sheet->getStyle('B' . $head2 . ':' . 'E' . $head2)->getFont()->setBold(true);
        $sheet->getStyle('C' . $head . ':E' . $headmerge)->getFont()->setBold(true);
        //echo '<pre>',print_r($yesterday_attendances); die();
        if (ob_get_contents())
            ob_end_clean();
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '.xls"');
        header('Cache-Control: max-age=0');
        if (ob_get_contents())
            ob_end_clean();
        //$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer = new Xlsx($spreadsheet);
        //$path='temp/helloworld.xls';
        //$writer->save($path);
        //echo '<pre>',print_r($yesterday_attendances); die();
        $writer->save('php://output');
        //exit();
    }


    function month_attendance()
    {
        $data = $this->data;
        $data['page'] = 'month_attendance_report';
        $data['page_title'] = 'Month Attendance Report';
        $data['heading'] = 'Reports';
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter();
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/month_attendance", $data);
    }

    function report_month_attendance()
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        $emp = '';
        if ($this->input->post('month')) {
            $data['month'] = $this->input->post('month');
        }
        if ($this->input->post('EmpNo')) {
            $emp = $this->input->post('EmpNo');
        }
        $month = $data['month'];
        $f_month = date_create($month . '-01');
        $data['page'] = 'pay_slip';
        $margin_bottom = NULL;
        $header = NULL;
        $margin_top = NULL;
        ob_start();
        $this->load->library('pdf');
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'A4', true, 'utf-8', false);
        $i = 0;
        $this->load->model('employee_model');
        $employees = $this->employee_model->get_all_emp_name($emp);
        $this->load->model('attendance_model');
        $month_days = $this->attn->getDaysInYearMonth($data['month'], 'Y-m-d');
        $completed_attendance = $this->attendance_model->get_completed_attendance_date_wise($month);
        $this->load->model('monthitem_model');
        $holidays = $this->monthitem_model->get_holiday_details($month);
        //echo '<pre>',print_r($holidays); die();
        $this->load->model('transaction/leave_transaction_model');
        foreach ($employees as $empl) {
            $pdf->SetMargins(10, 0, 10, false);
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $data['EmpName'] = $empl->EmpNo . ' - ' . $empl->EmpName;
            $data['month_days'] = $month_days;
            $data['holidays'] = $holidays;
            $data['month'] = $month;
            $data['completed_attendance'] = (isset($completed_attendance[$empl->EId])) ? $completed_attendance[$empl->EId] : array();
            $leaves = $this->leave_transaction_model->get_employee_month_leaves_details($month, $empl->EId);
            $leave_days = array();
            if ($leaves) {
                foreach ($leaves as $lv) {
                    $leave_days[] = $lv->LeaveFrom;
                }
            }
            $nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($month, $empl->EId);

            $nopay_days = array();
            if ($nopays) {
                foreach ($nopays as $npd) {
                    $nopay_days[] = $npd->NopayFrom;
                }
            }
            $data['nopay_days'] = $nopay_days;
            $data['leave_days'] = $leave_days;
            $html = $this->load->view("templates/reports/attendance_list", $data, TRUE);

            $pdf->AddPage();

            $pdf->writeHTML($html, true, false, true, false);
            $pdf->setPage($pdf->getPage());
        }
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('Attendance-' . $month . '.pdf', 'I'), 'Out put');
    }


    function report_month_attendance_excel($month = '')
    {
        ini_set('max_execution_time', 0);
        $data = $this->data;
        $emp = 0;
        if ($this->input->get('month')) {
            $data['month'] = $this->input->get('month');
        }
        $month = $data['month'];
        $f_month = date_create($month . '-01');
        $data['page'] = 'pay_slip';
        $margin_bottom = NULL;
        $header = NULL;
        $margin_top = NULL;
        ob_start();

        $inputFileName = "monthattn.xlsx";

        /**  Identify the type of $inputFileName  **/
        $inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($inputFileName);

        /**  Create a new Reader of the type that has been identified  **/
        $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        /**  Load $inputFileName to a Spreadsheet Object  **/
        $spreadsheet = $reader->load($inputFileName);

        /**  Convert Spreadsheet Object to an Array for ease of use  **/
        $schdeules = $spreadsheet->getActiveSheet()->toArray();

        echo '<pre>', print_r($schdeules);
        die();

        $this->load->library('pdf');
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'A4', true, 'utf-8', false);
        $i = 0;
        $this->load->model('employee_model');
        $employees = $this->employee_model->get_all_emp_name($this->attn->getComp());
        $this->load->model('attendance_model');
        $month_days = $this->attn->getDaysInYearMonth($data['month'], 'Y-m-d');
        $completed_attendance = $this->attendance_model->get_completed_attendance_date_wise($this->attn->getComp(), $month);
        $this->load->model('monthitem_model');
        $holidays = $this->monthitem_model->get_holiday_details($this->attn->getComp(), $month);
        //echo '<pre>',print_r($holidays); die();
        $this->load->model('transaction/leave_transaction_model');
        foreach ($employees as $empl) {
            $pdf->SetMargins(10, 0, 10, false);
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $data['EmpName'] = $empl->EmpNo . ' - ' . $empl->EmpName;
            $data['month_days'] = $month_days;
            $data['holidays'] = $holidays;
            $data['month'] = $month;
            $data['completed_attendance'] = (isset($completed_attendance[$empl->EId])) ? $completed_attendance[$empl->EId] : array();
            $leaves = $this->leave_transaction_model->get_employee_month_leaves_details($this->attn->getComp(), $month, $empl->EId);
            $leave_days = array();
            if ($leaves) {
                foreach ($leaves as $lv) {
                    $leave_days[] = $lv->LeaveFrom;
                }
            }
            $nopays = $this->leave_transaction_model->get_month_employee_leave_nopay_details($this->attn->getComp(), $month, $empl->EId);

            $nopay_days = array();
            if ($nopays) {
                foreach ($nopays as $npd) {
                    $nopay_days[] = $npd->NopayFrom;
                }
            }
            $data['nopay_days'] = $nopay_days;
            $data['leave_days'] = $leave_days;
            $html = $this->load->view("templates/reports/attendance_list", $data, TRUE);

            $pdf->AddPage();

            $pdf->writeHTML($html, true, false, true, false);
            $pdf->setPage($pdf->getPage());
        }
        if (ob_get_contents())
            ob_end_clean();
        $this->load->helper('download');
        force_download($pdf->Output('Attendance-' . $month . '.pdf', 'I'), 'Out put');
    }


    function is_date($str)
    {
        $stamp = strtotime($str);
        if (!is_numeric($stamp))
            return FALSE;
        $month = date('m', $stamp);
        $day = date('d', $stamp);
        $year = date('Y', $stamp);
        if (checkdate($month, $day, $year))
            return TRUE;
        return FALSE;
    }

    function _getHeader($title, $margin)
    {
        ob_start();
        $this->load->library('pdf');
        $this->load->library('payslip');

        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, 'a4', true, 'utf-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Namal Kumarasinghe');
        $pdf->SetTitle($title);
        $pdf->SetSubject('TCPDF Tutorial');
        $pdf->SetHeaderData('', '', $title, '');
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        $pdf->SetMargins(5, 27, 5, true);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        $pdf->SetFont('helvetica', '', 8);
        return $pdf;
    }

    function _getTimeDiff($dtime, $atime)
    {
        if ($dtime == '')
            return '00:00:00';
        if ($atime == '')
            return '00:00:00';
        $nextDay = $dtime > $atime ? 1 : 0;
        $dep = explode(':', $dtime);
        $arr = explode(':', $atime);
        $diff = abs(mktime($dep[0], $dep[1], 0, date('n'), date('j'), date('y')) - mktime($arr[0], $arr[1], 0, date('n'), date('j') + $nextDay, date('y')));
        $hours = floor($diff / (60 * 60));
        $mins = floor(($diff - ($hours * 60 * 60)) / (60));
        $secs = floor(($diff - (($hours * 60 * 60) + ($mins * 60))));
        if (strlen($hours) < 2) {
            $hours = "0" . $hours;
        }
        if (strlen($mins) < 2) {
            $mins = "0" . $mins;
        }
        if (strlen($secs) < 2) {
            $secs = "0" . $secs;
        }
        return $hours . ':' . $mins;
    }


    function _addtime($time1, $time2)
    {
        $times = array($time1, $time2);
        $seconds = 0;
        foreach ($times as $time) {
            $tt = explode(':', $time);

            if (count($tt) < 3) {
                array_push($tt, "01");
            }
            list($hour, $minute, $second) = $tt;
            $seconds += $hour * 3600;
            $seconds += $minute * 60;
            $seconds += $second;
        }
        $hours = floor($seconds / 3600);
        $seconds -= $hours * 3600;
        $minutes = floor($seconds / 60);
        $seconds -= $minutes * 60;
        if ($seconds < 9) {
            $seconds = "0" . $seconds;
        }
        if ($minutes < 9) {
            $minutes = "0" . $minutes;
        }
        if ($hours < 9) {
            $hours = "0" . $hours;
        }
        return "{$hours}:{$minutes}";
    }

    function _makeDate($time, $days)
    {
        return "Days - $days  Hours - $time";
    }

    function _makeDate2($time)
    {
        $seconds = 0;
        $tt = explode(':', $time);
        list($hour, $minute) = $tt;

        $seconds += $hour * 3600;
        $seconds += $minute * 60;
        $days = floor($seconds / (24 * 3600));
        $seconds -= $days * 24 * 3600;
        $hours = floor($seconds / 3600);
        $seconds -= $hours * 3600;
        $minutes = floor($seconds / 60);
        $seconds -= $minutes * 60;
        if ($seconds < 9) {
            $seconds = "0" . $seconds;
        }
        if ($minutes < 9) {
            $minutes = "0" . $minutes;
        }
        if ($hours < 9) {
            $hours = "0" . $hours;
        }
        return "{$days} Days, {$hours} Hours, {$minutes} Minutes";
    }
}
