<?php
require_once("Main_model.php");
class Shift_transaction_model extends Main_model
{
	private $tableName = 'shift_transaction';
	private $join = 'employee';
	private $join2 = 'shift';
	
	public function _construct()
	{
		//$this->load->database();
	}

	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the shifts
	*/
	function get_all($id=0,$limit=0,$offset=0)
	{

		$this->db->select('t.EmpNo, t.Shift_code, t.Hours,t.Comp_Id, t.StartDate, t.EndDate, jt.EmpName, jt2.Name');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
		$this->db->join($this->join2.' AS jt2', 't.Shift_code = jt2.shift_code','left');
		$this->db->where('jt.Active',1);
  		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}


	function get_all_user_shifts($user='')
	{
		$this->db->select('t.EmpNo, jt2.Shift_From, jt2.Shift_To, t.StartDate, t.EndDate,t.Hours, jt.EmpName,t.Comp_Id');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
		$this->db->join($this->join2.' AS jt2', 't.Shift_code = jt2.shift_code','left');
		if($user!='')$this->db->where('t.EmpNo', $user);
		$this->db->where('jt.Active',1);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}

	function get_user_shift($user='')
	{
		$this->db->select('t.EmpNo, jt2.Shift_From, jt2.Shift_To, t.StartDate, t.EndDate,t.Hours, jt.EmpName,t.Comp_Id');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.EmpNo = jt.EmpNo','left');
		$this->db->join($this->join2.' AS jt2', 't.Shift_code = jt2.shift_code','left');
		if($user!='')$this->db->where('t.EmpNo', $user);
		$this->db->where('jt.Active',1);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	function get_info($shift_code='',$EmpNo=0)
	{
		$this->db->select('t.*, jt2.Shift_From, jt2.Shift_To');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join2.' AS jt2', 't.Shift_code = jt2.shift_code','left');
		$this->db->where('t.shift_code',$shift_code);
		$this->db->where('t.EmpNo', $EmpNo);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	/*
	Inserts or updates a page
	*/
	function save(&$shiftT_data,$where=array())
	{
		if (empty($where))
		{
			if(!$this->exist($shiftT_data['EmpNo'], $shiftT_data['Shift_code']))
			{
				if($this->db->insert($this->tableName,$shiftT_data))
				{
					$shiftT_data['shift_code']=$this->db->insert_id();
					return true;
				}
			}else{
				$this->messages->add($this->lang->line('error_shiftT_exist'), "error");
				return false;
			}


		}
		$this->db->where($where);
		return $this->db->update($this->tableName,$shiftT_data);
	}

	function exist($EmpNo, $Shift_code)
	{
		$this->db->from($this->tableName);
		$this->db->where('EmpNo',$EmpNo);
		$this->db->where('Shift_code',$Shift_code);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$this->messages->add($this->lang->line('error_shiftT_exist'), "error");
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/*
	Deletes one shift
	*/
	public function deleteShift($EmpNo,$ShiftCode)
	{
		/*if ($this->getSupplierPurchases($id)) {
			return false;
		}*/
		if ($this->db->delete($this->tableName, array('EmpNo' => $EmpNo, 'Shift_code' => $ShiftCode))) {
			return true;
		}
		return FALSE;
	}
	
	public function change_status($shiftT_id,$status)
	{
		$this->db->where('Code', $shiftT_id);
		$this->db->where('Comp_Id', $this->attn->getComp());
		return $this->db->update($this->tableName,array( 'pStatus' => $status));	
	}

}
?>
