<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script type="text/javascript">

$(document).on('click', 'a.approval-record', function() {
        if(confirm('Are you really sure?')){
          return true;
        }
        return false;
      });

    // Example starter JavaScript for disabling form submissions if there are invalid fields
    (function () {
        'use strict'

        // Fetch all the forms we want to apply custom Bootstrap validation styles to
        var forms = document.querySelectorAll('.needs-validation')

        // Loop over them and prevent submission
        Array.prototype.slice.call(forms)
            .forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }

                    form.classList.add('was-validated')
                }, false)
            })
    })()
  

    $(function () {

        loadRecords();
    });
</script>

<script type="text/javascript">
    function loadRecords() {
       

        var oTable2 = $('#applied-leave').dataTable({
            "aaSorting": [[2, "desc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "iDisplayLength": 50,
            "bDestroy": true,
            'bProcessing': true,
            'bServerSide': true,
            'sAjaxSource': '<?= site_url('leave_transaction/getPendingLeaves?v=1') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "",
                    "value": ""
                });
                $.ajax({ 'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback });
            },
            "aoColumns": [{ "bSortable": false }, null, null, null, null, {"mRender": pending_status}, null, { "bSortable": false }]
        });

    }


    function pending_status(x) {
    if(x == null) {
        return '';
    } else if(x == 'Pending') {
        return '<span class="badge bg-label-warning me-1">Pending</span>';
    } else {
        return '<span class="badge bg-label-success me-1">Approved</span>';
    }
}
</script>