<?php $this->load->view("templates/common/top_section"); ?>
<!-- Icons. Uncomment required icon fonts -->
<link rel="stylesheet" href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet"
	href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<!-- /section:basics/content.breadcrumbs -->
<!-- Basic Layout & Basic with Icons -->
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex justify-content-between align-items-center">
				<h5 class="mb-0">Apply Shift</h5>
			</div>
			<div class="card-body">


				<form class="form-horizontal needs-validation" novalidate
					action="<?php echo base_url('shift_transaction/post'); ?>" method="post" role="form">

					<input type="hidden" <?php echo ($edit and isset($shiftT->Shift_code)) ? 'value="' . $shiftT->Shift_code . '"' : null; ?> class="span6" name="shift_t_id" />
					<input type="hidden" <?php echo ($edit and isset($shiftT->EmpNo)) ? 'value="' . $shiftT->EmpNo . '"' : null; ?> class="span6" name="emp_no" />
					<input type="hidden" <?php echo ($edit and isset($shiftT->Comp_Id)) ? 'value="' . $shiftT->Comp_Id . '"' : null; ?> class="span6" name="Comp" />

					<div class="mb-3">
						<label class="form-label" for="EmpNo">Employee</label>
						<select id="EmpNo" class="select2 form-select form-control" required name="EmpNo">
							<option value="">--Select Employee --</option>
							<?php
							if (is_array($employees)) {
								foreach ($employees as $ename) {
									$select = (isset($shiftT->EmpNo) and $ename->EmpNo == $shiftT->EmpNo) ? 'selected="selected"' : null;
									echo '<option ' . $select . ' value="' . $ename->EId . '">' . trim($ename->EmpName) . ' - ' . $ename->EmpNo . '</option>';
								}
							}
							?>
						</select>
						<div class="invalid-feedback">
							Employee is required.
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label" for="name">Shift Code</label>
						<select required class="select2 form-select form-control" name="Shift_code" id="Shift_code">
							<option value="">Shift Code</option>
							<?php
							if (is_array($shtCodes)) {
								foreach ($shtCodes as $code) {
									$select = (isset($shiftT->Shift_code) and $code->shift_code == $shiftT->Shift_code) ? 'selected="selected"' : null;
									echo '<option ' . $select . ' value="' . $code->shift_code . '">' . trim($code->Name) . '</option>';
								}
							}
							?>
						</select>
						<div class="invalid-feedback">
							Shift is required.
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label" for="From">From</label>
						<input type="date" <?php echo (isset($shiftT->Shift_From)) ? 'value="' . $shiftT->Shift_From . '"' : null; ?> class="form-control"
							onChange="return makeBalance();" name="From" id="Shift_From" placeholder="0" required />
						<div class="invalid-feedback">
							From is required.
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label" for="Shift_To">To</label>
						<input type="date" <?php echo (isset($shiftT->Shift_To)) ? 'value="' . $shiftT->Shift_To . '"' : null; ?> class="form-control" onChange="return makeBalance();" name="To" id="Shift_To"
							placeholder="0" required />
						<div class="invalid-feedback">
							To is required.
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label" for="Hours">Hours</label>
						<input type="text" <?php echo (isset($shiftT->Hours)) ? 'value="' . $shiftT->Hours . '"' : null; ?>
							class="form-control" name="Hours" id="Hours" placeholder="0" required />
						<div class="invalid-feedback">
							To is required.
						</div>
					</div>



					<div class="mb-3">
						<label class="form-label" for="StartDate">Start Date</label>
						<input type="date" <?php echo (isset($shiftT->StartDate)) ? 'value="' . $shiftT->StartDate . '"' : null; ?> class="form-control" name="StartDate"
							id="StartDate" placeholder="" />

					</div>

					<div class="mb-3">
						<label class="form-label" for="StartDate">End Date</label>
						<input type="date" <?php echo (isset($shiftT->EndDate)) ? 'value="' . $shiftT->EndDate . '"' : null; ?> class="form-control" name="EndDate" id="EndDate" placeholder="" />

					</div>



					<button type="submit" class="btn btn-primary">Add</button>
				</form>
			</div>
		</div>


	</div>



	<div class="col-md-12">
		<div class="row">
			<div class="col-md-12 mb-4">
				<!-- Basic Bootstrap Table -->
				<div class="card">
					<h5 class="card-header">Applied Shifts</h5>
					<div class="card-datatable text-nowrap">
						<table class="table" id="table">
							<thead>
							<tr>
								<th>Emp No</th>
								<th>Emp Name</th>
								<th>Shift Code</th>
								<th>Hours</th>
								<th>Start Date</th>
								<th>End Date</th>
								<th>Options</th>
							</tr>
							</thead>
							<tbody class="table-border-bottom-0">

							</tbody>
						</table>
					</div>
				</div>
			</div>
			<!--/ Basic Bootstrap Table -->

		</div>
	</div>



</div>

<?php $this->load->view("templates/common/footer"); ?>