<?php $this->load->view("templates/common/top_section"); ?>
<!-- Icons. Uncomment required icon fonts -->
<link rel="stylesheet" href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet"
    href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<!-- /section:basics/content.breadcrumbs -->
<!-- Basic Layout & Basic with Icons -->
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Apply Nopay </h5>
            </div>
            <div class="card-body">


                <form class="form-horizontal needs-validation" novalidate
                    action="<?php echo base_url('leave_transaction/add_nopay'); ?>" method="post" role="form">
                    <input type="hidden" value="NP" name="Code">
                    <div class="mb-3">
                        <label class="form-label" for="EmpNo">Employee</label>
                        <select id="EmpNo" class="select2  form-select form-control" required name="EmpNo">
                            <option value="">--Select Employee --</option>
                            <?php
                            foreach ($employees as $emp) {
                                $select = (isset($e) and $e == $emp->EId) ? 'selected="selected"' : null;
                                echo '<option ' . $select . ' value="' . $emp->EId . '">' . trim($emp->EmpName) . ' -- ' . $emp->EmpNo . '</option>';
                            }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Employee is required.
                        </div>
                    </div>
                 
        

                    <div class="mb-3">
                        <label for="NopayFrom" class="form-label">Leave (Form - To)</label>
                        <div class="input-group input-daterange" id="bs-datepicker-daterange">
                            <input type="text" id="NopayFrom" name="NopayFrom" placeholder="Leave From"
                                class="form-control">
                            <span class="input-group-text">to</span>
                            <input type="text" placeholder="NopayTo" id="NopayTo" name="NopayTo" class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="Installment">Num of Days</label>
                        <input type="text" min="1" value="1" class="form-control" onChange="return makeBalance();"
                            name="Days" id="Days" placeholder="0" required />
                        <div class="invalid-feedback">
                            Days is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="Term">Reason</label>
                        <input type="text" class="form-control" name="Reason" id="Reason" placeholder="" />

                    </div>

                    
                    <button type="submit" class="btn btn-primary">Add</button>
                </form>
            </div>
        </div>


    </div>

  

    <div class="col-md-6">
        <div class="row">
            <div class="col-md-12 mb-4">
                <!-- Basic Bootstrap Table -->
                <div class="card">
                    <h5 class="card-header">Nopay  Balance </h5>
                    <div class="card-datatable text-nowrap">
                        <table class="table" id="applied-nopay">
                            <thead>
                                <tr>
                                    <th>From</th>
                                        <th>To</th>
                                        <th>Days</th>
                                        <th>Reason</th>
                                        <th>Options</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
        </div>
    </div>



</div>

<?php $this->load->view("templates/common/footer"); ?>