<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Products extends CI_Controller {

  var $main_menu_name = "products";
  var $sub_menu_name = "products";

  //Edit By Gihan Dias 2023/06/22
  public function __construct()
  {
    parent::__construct();
    $this->load->model('category_models');
    $this->load->model('product_models');
    $this->load->model('common_model');
    $this->load->model('weight_model');
    $this->load->model('Shipping_Category_Models');
  }

//Edit By Gihan Dias 2023/06/22
  public function add_product()
  {
    $data['main_menu_name'] = $this->main_menu_name;
    $data['sub_menu_name'] 	= 'add_products';
    $data['main_category'] 	= $this->category_models->getCategory();
    $data['capacity'] 	= $this->category_models->getCapacity();
    $data['weight'] 	= $this->weight_model->get_all_weight();
    $this->load->view('product/add_product',$data);
  }

  //product save function start
  //Edit By Gihan Dias 2023/06/22
  public function save_product()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_name', 'Product Name', 'trim|required|xss_clean');
    $this->form_validation->set_rules('product_code', 'Product Code', 'trim|required|xss_clean|is_unique[product.product_code]');
    $this->form_validation->set_rules('product_cost', 'product cost', 'trim|required|xss_clean');
    $this->form_validation->set_rules('product_price', 'product_price', 'trim|required|xss_clean');
    $this->form_validation->set_rules('capacity_id', 'Size/Capacity', 'trim|xss_clean');
    $this->form_validation->set_rules('category', 'Category', 'trim|required|xss_clean');
    $this->form_validation->set_rules('subcategory', 'Sub category', 'trim|required|xss_clean');
    $this->form_validation->set_rules('product_details', 'product details', 'trim|xss_clean');
    $this->form_validation->set_rules('preparation_time', 'preparation_time', 'required|trim|xss_clean');
    $this->form_validation->set_rules('product_weight', 'product_weight', 'required|trim|xss_clean');
    //$this->form_validation->set_rules('youtube_link', 'Video', '');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);

    }else{

      $product_name 			= $this->input->post('product_name');
      $product_code 			= $this->input->post('product_code');
      $category 	  			= $this->input->post('category');
      $subcategory  			= $this->input->post('subcategory');
     // $individualWeight	    	= $this->input->post('individual_weight');
      $capacity_id		    	= $this->input->post('capacity_id');
      $product_cost 			= $this->price_filter($this->input->post('product_cost'));
      $product_price 			= $this->price_filter($this->input->post('product_price'));
      $product_details 	    	= $this->input->post('product_details');
      $product_id           =$this->input->post('product_id');
      $preparation_time=      $this->input->post('preparation_time');
      $product_weight=      $this->input->post('product_weight');


      //print_r($individualWeight);


      //------------------------------------------------------------
      if (!empty($_FILES["userfile"]['name'])) {

        $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
        $this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));

        if ( ! $this->upload->do_upload()){
          $st = array('status' =>0,'validation' => $this->upload->display_errors());
          echo json_encode($st);
        }
        else{

          $this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
          if ( ! $this->image_lib->resize())
          {
            echo $this->image_lib->display_errors();
          }
          else
          {
            $imgName    = $this->upload->data();
            $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
            //data array_start
            $data1 = array(
              'cat_id'  				=> $category,
              'sub_cat_id'  	  => $subcategory,
              'product_name'    => $product_name,
              'product_code'		=> $product_code,
              'product_image'   => $imgName['file_name'],
              'product_thumb' 	=> $imageThumb,
              'product_cost'  	=> $product_cost,
              'product_price'		=> $product_price,
              'product_details'	=> $product_details,
              'capacity_id'     => $capacity_id,
              'preparation_time' =>$preparation_time,
              'product_weight' =>$product_weight,
            );
            //data array_start
            $last_id = $this->product_models->save_product($data1);
            if ($last_id) {

              $weightData = array(
                'weight_id' =>$product_weight,
                'product_id' =>$last_id,
                'price' =>$product_price,
                'cost' =>$product_cost,
            );
            $this->weight_model->save_product_weight_with_price($weightData);
              $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
              echo json_encode($st);

            } else {
              $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
              echo json_encode($st);
            }
            $this->image_lib->clear();
          }
        }
      } else {
        //----------------------------------------------
        $data2 = array(
          'cat_id'  				=> $category,
          'sub_cat_id'  			=> $subcategory,
          'product_name'        	=> $product_name,
          'product_code'			=> $product_code,
          'product_cost'  	    	=> $product_cost,
          'product_price'			=> $product_price,
          'product_details' 		=> $product_details,
          'capacity_id'=>$capacity_id,
          'preparation_time' => $preparation_time,
          'product_weight'=>$product_weight,
        );

        //----------------------------------------------
        $last_id = $this->product_models->save_product($data2);
        if ($last_id) {
          $weightData = array(
            'weight_id' =>$product_weight,
            'product_id' =>$last_id,
            'price' =>$product_price,
          );
          $this->weight_model->save_product_weight_with_price($weightData);
          $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
          echo json_encode($st);

        } else {

          $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
          echo json_encode($st);
        }
      }
    }
  }

  //Product save function end


  //Edit By Gihan Dias 2023/06/22
  public function save_img($image_name_enc)
  {
      $this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
      $this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));

      if (  $this->upload->do_upload()){

        }else{

            $st = array('status' =>0,'validation' => $this->upload->display_errors());
            echo json_encode($st);
        }
  }











  //Old functions
  //---------------------------------------------------------------------------
  public function index()
  {
    $data['main_menu_name'] = $this->main_menu_name;
    $data['sub_menu_name'] = $this->sub_menu_name;
    $this->load->view('product/products',$data);
  }
  //---------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  public function get_sub_category_by_id()
  {
    $parent_category =  $this->input->get('category_id');

    if ( $parent_category ) {
      $val = $this->category_models->get_sub_category( $this->input->get('category_id') );
      if (!empty($val)) {
        echo '<select name="subcategory" id="subcategory" class="form-control search-select">';
        echo "<option value=''></option>";
        foreach ($val as $key => $lst) {
          echo "<option value='$lst->sub_cat_id'>$lst->sub_cat_name</option>";
        }
        echo '</select>';
      }
    } else {
      echo NULL;
    }
  }


  //----------------------------------------------------------------------------------------------------
  function price_filter($amount='')
  {
    $s = explode("Rs.",$amount);
    return str_replace(',', '', $s[1]);
  }
  //---------------------------------------------------------------------------
  public function get_list_product($value='')
  {
    $search_key=$this->input->get('search');
    $search_key_val=$search_key['value'];
    $start=$this->input->get('start');
    $length=$this->input->get('length');
    $totalData = 0;
    $values = $this->product_models->getProducts($start,$length,$search_key_val);
    $value_count = $this->product_models->getProducts('','','');
    if($search_key_val){
      //	$values_c = $this->product_models->getProducts('','',$search_key_val);
      //	$totalData = count($values_c);
    }
    $totalData = $value_count;
    $totalFiltered = $totalData;
    $data = array();
    if (!empty($values)) {
      foreach ($values as $products) {
        $k ='';
        if ($products->product_status == 0) {$k = "btn-danger";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
        $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

        $row = array();
        $qty = 0;
        $row[] = '<div style="margin-bottom: 0px; width: 50px; height: 50px;" class="fileupload-new thumbnail"><img alt="" src="'.base_url()."uploads/product/image/thumbs/".$products->product_thumb.'"></div>';
        $row[] =$products->product_code;
        $row[] = $products->product_name;
        $row[] = $products->cat_name;
        $row[] = $retVal;
        if ($this->session->userdata('ss_group_id')==1 || $this->session->userdata('ss_group_id')==2 ){
          $row[] = $products->product_cost;
        }
        $row[] = $products->wholesale_price;
        $row[] = $products->credit_salling_price;
        $row[] = $products->product_price;
        $row[] = $qty;
        $actdes='';
        $actdes =$actdes. '<div class="btn-group text-left">
        <button data-toggle="dropdown" class="btn btn-default btn-xs '.$k.' dropdown-toggle" type="button">Actions <span class="caret"></span></button>
        <ul role="menu" class="dropdown-menu pull-right">
        <li><a href="'.base_url('products/view').'/'.$products->product_id.'"><i class="fa fa-file-text-o"></i> Product Details</a></li>
        ';
        if ($this->session->userdata('ss_group_id')==1 ||$this->session->userdata('ss_group_id')==10){
          $actdes =$actdes. '    <li><a href="'.base_url('products/edit').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Edit Product</a></li>
          <li class="divider"></li><li><a onclick="product_delete('.$products->product_id.'); return false;" href="#"><i class="fa fa-trash-o"></i> Delete Product</a></li>
          ';
        }
        $actdes = $actdes.'
        <li><a onclick=" print_barcode('.$products->product_id.'); return false;" href="#"><i class="fa fa-print"></i> Print Barcode</a></li>
        <li><a href="'.base_url('products/upload_images').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Upload Images</a></li>
        <li><a href="'.base_url('products/update_specification').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Update Specification</a></li>



        </ul></div>';
        $row[] =$actdes;
        $data[] = $row;
      }

      $output = array('data' =>$data,"recordsTotal"    => intval( $totalData ),
      "recordsFiltered" => intval( $totalFiltered ));
      echo json_encode($output);
    }else{
      $output = array('data' =>'');
      echo json_encode($output);
    }
  }
  //---------------------------------------------------------------------------
  public function view($product_id = "")
  {
    $sd = $this->product_models->get_product_by_id($product_id);
    if(!empty($sd)){

      $data['product_details'] = $this->product_models->get_product_by_id($product_id);
      $data['warehouses'] = $this->product_models->get_warehouse_product($product_id);
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = $this->sub_menu_name;
      $this->load->view('product/view_product',$data);
    }else{
      show_404();
    }
  }
  //---------------------------------------------------------------------------
  public function edit($product_id='')
  {
    $data['main_menu_name'] = $this->main_menu_name;
    $data['sub_menu_name']  = $this->sub_menu_name;
    $data['main_category']  = $this->category_models->getCategory();
    $data['unit_type']      = $this->product_models->getUnit();
    $data['tax']            = $this->product_models->getTax();
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $data['sub_category']   = $this->category_models->getSubCategory($data['product_details']->cat_id);
    $data['sub_category2']   = $this->category_models->get_sub_category2($data['product_details']->sub_cat_id);
    $data['brand_type'] 	= $this->product_models->getBrand();
    $data['color_type'] 	= $this->product_models->getColor();
    $data['capacity'] 	= $this->category_models->getCapacity();
    $data['storage'] 	= $this->category_models->getStorage();
    $data['warranty'] 	= $this->category_models->getWarrnty();
    $data['shipping_cat']	= $this->Shipping_Category_Models->getCategory();
    //$data['product_weight'] 	= $this->weight_model->get_all_weight();
    $data['weight'] 	= $this->weight_model->get_all_weight();
    

    
    $this->load->view('product/edit_product',$data);
  }
  //---------------------------------------------------------------------------
  public function single_barcode($product_id='')
  {
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $this->load->view('barcode/product_barcode',$data);
  }
  //---------------------------------------------------------------------------
  function gen_barcode($product_code = NULL, $height = 80)
  {
    if($this->input->get('code')){ $product_code = $this->input->get('code'); }
    if($this->input->get('height')){ $height = $this->input->get('height'); }
    //load library
    $this->load->library('zend');
    //load in folder Zend
    $this->zend->load('Zend/Barcode');
    //'drawText' => FALSE
    $barcodeOptions = array('text' => $product_code, 'barHeight' => $height, 'stretchText' => TRUE );
    $rendererOptions = array('imageType'=>'png', 'horizontalPosition' => 'center', 'verticalPosition' => 'middle');
    $imageResource = Zend_Barcode::render('code128', 'image', $barcodeOptions, $rendererOptions);
    return $imageResource;
  }
  //---------------------------------------------------------------------------
  function delete_product($product_id='')
  {
    $d = $this->product_models->delete_product($this->input->post('product_id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //---------------------------------------------------------------------------
  public function update_product()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_name', 'Product Name', 'trim|required|xss_clean');
    $this->form_validation->set_rules('subcategory_2', 'Sub Category 2', 'trim|xss_clean');
    $this->form_validation->set_rules('product_cost', 'product cost', 'trim|xss_clean');
    $this->form_validation->set_rules('product_price', 'product_price', 'trim|xss_clean');
   // $this->form_validation->set_rules('wholesale_price', 'wholesale price', 'trim|xss_clean');
    $this->form_validation->set_rules('credit_salling_price', 'credit salling price', 'trim|xss_clean');
    $this->form_validation->set_rules('brand', 'Brand', 'trim|xss_clean');
    $this->form_validation->set_rules('warranty_id', 'Warranty', 'trim|xss_clean');
    $this->form_validation->set_rules('storage_id', 'RAM/Storage Size', 'trim|xss_clean');
    $this->form_validation->set_rules('capacity_id', 'Size/Capacity', 'trim|xss_clean');
    $this->form_validation->set_rules('color', 'Color', 'trim|xss_clean');
    $this->form_validation->set_rules('category', 'Category', 'trim|xss_clean');
    $this->form_validation->set_rules('subcategory', 'Sub category', 'trim|xss_clean');
    $this->form_validation->set_rules('unit', 'unit', 'trim|xss_clean');
    $this->form_validation->set_rules('store_position', 'store position', 'trim|xss_clean');
    $this->form_validation->set_rules('product_details', 'product details', 'trim|xss_clean');
    $this->form_validation->set_rules('product_id', 'product details', 'trim|xss_clean');
    $this->form_validation->set_rules('shipping_cat', 'Shipping Category', 'trim|xss_clean');
    $this->form_validation->set_rules('delivery_estimate', 'Entimated Time', ' trim|xss_clean');
    $this->form_validation->set_rules('waranty_conditions', 'Warrany Condition', 'trim|xss_clean');
    $this->form_validation->set_rules('stock_availability', 'Available Qty', 'trim|xss_clean');
    $this->form_validation->set_rules('sold_qty', 'Sold Qty', 'trim|xss_clean');
    $this->form_validation->set_rules('return_policy', 'Return Policy', 'trim|xss_clean');
    $this->form_validation->set_rules('preparation_time', 'preparation_time', 'required|trim|xss_clean');
    $this->form_validation->set_rules('product_weight', 'product_weight', 'required|trim|xss_clean');
    
    $this->form_validation->set_rules('show_website', 'Show Web', 'trim|xss_clean');
    

    //show_website

    //$this->form_validation->set_rules('youtube_link', 'Video', 'xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 			= $this->input->post('product_id');
      $product_name 			= $this->input->post('product_name');
      //$product_code 			= $this->input->post('product_code');
      $category 	  			= $this->input->post('category');
      $subcategory  			= $this->input->post('subcategory');
      $subcategory_2  		= $this->input->post('subcategory_2');
      $brand		  			= $this->input->post('brand');
      $warranty_id		  	= $this->input->post('warranty_id');
      $storage_id		  		= $this->input->post('storage_id');
      $capacity_id		  	= $this->input->post('capacity_id');
      $color		  			= $this->input->post('color');
      $unit 		  			= $this->input->post('unit');
      $shipping_cat 		  	= $this->input->post('shipping_cat');
      $product_cost 			= $this->price_filter($this->input->post('product_cost'));
      $product_price 			= $this->price_filter($this->input->post('product_price'));
      $wholesale_price 		= $this->price_filter($this->input->post('wholesale_price'));
      $credit_salling_price 	= $this->price_filter($this->input->post('credit_salling_price'));
      $tax 					= $this->input->post('tax');
      $alert_quty 			= $this->input->post('alert_quty');
      $product_details 		= $this->input->post('product_details');
      $product_part_no 		= $this->input->post('product_part_no');
      $product_oem_part_number=$this->input->post('product_oem_part_number');
      $product_id=$this->input->post('product_id');
      $store_position=$this->input->post('store_position');
      $product_max_qty=$this->input->post('product_max_qty');
      $product_sn_exissts=$this->input->post('product_sn_exissts');
      $youtube_link=$this->input->post('youtube_link');
      $delivery_estimate=$this->input->post('delivery_estimate');
      $waranty_conditions=$this->input->post('waranty_conditions');
      $stock_availability=$this->input->post('stock_availability');
      $sold_qty=$this->input->post('sold_qty');
      $return_policy=$this->input->post('return_policy');
      $show_website=$this->input->post('show_website');
      $preparation_time=      $this->input->post('preparation_time');
     $product_weight=   $this->input->post('product_weight');
    //-----------------------------------------------------------

    // print_r($product_price);
    // die();
      if (!empty($_FILES["userfile"]['name'])) {
        $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
        $this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
        if ( ! $this->upload->do_upload()){
          $st = array('status' =>0,'validation' => $this->upload->display_errors());
          echo json_encode($st);
        }
        else{

          $this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
          if ( ! $this->image_lib->resize())
          {
            echo $this->image_lib->display_errors();
          }
          else
          {
            $imgName    = $this->upload->data();
            $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
            //data array_start
            $data1 = array(
              'cat_id'  				=> $category,
              'sub_cat_id'  			=> $subcategory,
              'sub_cat_2_id'			=> $subcategory_2,
              'product_name'        	=> $product_name,
              //'product_code'			=> $product_code,
              'product_image'        	=> $imgName['file_name'],
              'product_thumb' 		=> $imageThumb,
              'product_alert_qty'  	=> $alert_quty,
              'product_unit'  		=> $unit,
              'product_cost'  		=> $product_cost,
              'product_price'			=> $product_price,
              'wholesale_price'  		=> $wholesale_price,
              'credit_salling_price'  => $credit_salling_price,
              'tax'  					=> $tax,
              'product_details' 		=> $product_details,
              'product_part_no' 		=> $product_part_no,
              'product_oem_part_number' => $product_oem_part_number,
              'store_position'=>$store_position,
              'product_max_qty'=>$product_max_qty,
              'brand_id'=>$brand,
              'warranty_id'=>$warranty_id,
              'storage_id'=>$storage_id,
              'capacity_id'=>$capacity_id,
              'color_id'=>$color,
              'shipping_cost_category'=>$shipping_cat,
              'product_sn_exissts'=>$product_sn_exissts,
              'youtube_link'=>$youtube_link,
              'delivery_estimate'=>$delivery_estimate,
              'waranty_conditions'=>$waranty_conditions,
              'stock_availability'=>$stock_availability,
              'sold_qty'=>$sold_qty,
              'return_policy'=>$return_policy,
              'preparation_time' =>$preparation_time,
             'product_weight'  =>$product_weight,
              'show_website'=>$show_website

            );
            //data array_start
            $last_id = $this->product_models->update_product($data1,$product_id);
            if ($last_id) {
              $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
              echo json_encode($st);

            } else {
              $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
              echo json_encode($st);
            }
            $this->image_lib->clear();
          }
        }
      } else {
        //----------------------------------------------
        $data2 = array(
          'cat_id'  				=> $category,
          'sub_cat_id'  			=> $subcategory,
          'sub_cat_2_id'			=> $subcategory_2,
          'product_name'        	=> $product_name,
          //'product_code'			=> $product_code,
          'product_alert_qty'  	=> $alert_quty,
          'product_unit'  		=> $unit,
          'product_cost'  		=> $product_cost,
          'product_price'			=> $product_price,
          'wholesale_price'  		=> $wholesale_price,
          'credit_salling_price'  => $credit_salling_price,
          'tax'  					=> $tax,
          'product_details' 		=> $product_details,
          'product_part_no' 		=> $product_part_no,
          'product_oem_part_number' => $product_oem_part_number,
          'store_position'=>$store_position,
          'product_max_qty'=>$product_max_qty,
          'brand_id'=>$brand,
          'warranty_id'=>$warranty_id,
          'storage_id'=>$storage_id,
          'capacity_id'=>$capacity_id,
          'color_id'=>$color,
          'shipping_cost_category'=>$shipping_cat,
          'product_sn_exissts'=>$product_sn_exissts,
          'youtube_link'=>$youtube_link,
          'delivery_estimate'=>$delivery_estimate,
          'waranty_conditions'=>$waranty_conditions,
          'stock_availability'=>$stock_availability,
          'sold_qty'=>$sold_qty,
          'return_policy'=>$return_policy,
          'preparation_time' =>$preparation_time,
           'product_weight' =>$product_weight,
          'show_website'=>$show_website
        );

        //----------------------------------------------
        $last_id = $this->product_models->update_product($data2,$product_id);
        if ($last_id) {

          $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
          echo json_encode($st);

        } else {

          $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
          echo json_encode($st);
        }
      }
    }
  }

  //---------------------------------------------------------------------------
  public function upload_images($product_id='')
  {
    $data['main_menu_name'] = $this->main_menu_name;
    $data['sub_menu_name']  = $this->sub_menu_name;
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $data['images'] = $this->product_models->list_product_image($product_id);
    $this->load->view('product/upload_images',$data);
  }
  //----------------------------------------------------------------------------

  public function save_images()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
    $this->form_validation->set_rules('des_header', 'product details', 'trim|xss_clean');
    $this->form_validation->set_rules('des_body', 'product details', 'trim|xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 			= $this->input->post('product_id');
      $des_header 			= $this->input->post('des_header');
      $des_body 			= $this->input->post('des_body');
      //------------------------------------------------------------
      if (!empty($_FILES["userfile"]['name'])) {
        $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
        $this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
        if ( ! $this->upload->do_upload()){
          $st = array('status' =>0,'validation' => $this->upload->display_errors());
          echo json_encode($st);
        }
        else{

          $this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
          if ( ! $this->image_lib->resize())
          {
            echo $this->image_lib->display_errors();
          }
          else
          {
            $imgName    = $this->upload->data();
            $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
            //data array_start
            $data1 = array(
              'product_id'			=>$product_id,
              'product_image'        	=> $imgName['file_name'],
              'product_thumb' 		=> $imageThumb,
              'des_header' 		=> $des_header,
              'des_body' 		=> $des_body,
            );
            //data array_start
            $last_id = $this->product_models->save_images($data1);
            if ($last_id) {
              $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
              echo json_encode($st);

            } else {
              $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
              echo json_encode($st);
            }
            $this->image_lib->clear();
          }
        }
      } else {
        //----------------------------------------------
        $data2 = array(
        );

        //----------------------------------------------
        $last_id = $this->product_models->save_images($data2);
        if ($last_id) {

          $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
          echo json_encode($st);

        } else {

          $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
          echo json_encode($st);
        }
      }
    }
  }
  //---------------------------------------------------------------------------
  function delete_image($product_id='')
  {
    $d = $this->product_models->delete_image($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //-----------------------------------------------------------------------------
  //---------------------------------------------------------------------------
  public function update_specification($product_id='')
  {
    $data['main_menu_name'] = $this->main_menu_name;
    $data['sub_menu_name']  = $this->sub_menu_name;
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $data['specification'] = $this->product_models->list_product_specification($product_id);
    $data['accessories'] = $this->product_models->list_product_accessories($product_id);
    $data['connectivity'] = $this->product_models->list_product_connectivity($product_id);
    $data['product_list'] = $this->product_models->get_product_for_relevant_product($product_id);
    $data['relavent_product_list'] = $this->product_models->get_relevant_product($product_id);
    $this->load->view('product/product_specification',$data);
  }
  //----------------------------------------------------------------------------

  public function save_specification()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
    $this->form_validation->set_rules('specification_name', 'Specification category', 'required|trim|xss_clean');
    $this->form_validation->set_rules('specification_value', 'Specification value', 'required|trim|xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 		= $this->input->post('product_id');
      $specification_name 		= $this->input->post('specification_name');
      $specification_value 		= $this->input->post('specification_value');
      $data1 = array(
        'product_id'			=>$product_id,
        'specification_name'    => $specification_name,
        'specification_value' 	=> $specification_value,
      );
      //data array_start
      $last_id = $this->product_models->save_specification($data1);
      if ($last_id) {
        $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
        echo json_encode($st);

      } else {
        $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
        echo json_encode($st);
      }

    }

  }
  //---------------------------------------------------------------------------

  function delete_specification($product_id='')
  {
    $d = $this->product_models->delete_specification($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //-----------------------------------------------------
  // new implimentation on 2020-08-14 for suba category 2
  public function get_sub_category2_by_id()
  {
    $parent_category =  $this->input->get('category_id');

    if ( $parent_category ) {
      $val = $this->category_models->get_sub_category2( $this->input->get('category_id') );
      if (!empty($val)) {
        echo '<select name="subcategory_2" id="subcategory_2" class="form-control">';
        echo "<option value=''></option>";
        foreach ($val as $key => $lst) {
          echo "<option value='$lst->sub_cat_2_id'>$lst->sub_cat_2_name</option>";
        }
        echo '</select>';
      }
    } else {
      echo NULL;
    }
  }


  //----------------------------------------------------------------------------

  public function add_product_connectivity()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
    $this->form_validation->set_rules('conectivity_header', 'Connectivity category', 'required|trim|xss_clean');
    $this->form_validation->set_rules('conectivity_body', 'Connectivity value', 'required|trim|xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 		= $this->input->post('product_id');
      $conectivity_header 		= $this->input->post('conectivity_header');
      $conectivity_body 		= $this->input->post('conectivity_body');
      $data1 = array(
        'product_id'			=>$product_id,
        'conectivity_header'  => $conectivity_header,
        'conectivity_body' 	=> $conectivity_body,
      );
      //data array_start
      $last_id = $this->product_models->save_connectivity($data1);
      if ($last_id) {
        $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
        echo json_encode($st);

      } else {
        $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
        echo json_encode($st);
      }

    }

  }

  function delete_connectivity($product_id='')
  {
    $d = $this->product_models->delete_connectivity($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //---------------------------------------------------------------------------
  //----------------------------------------------------------------------------

  public function add_product_accesssries()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
    $this->form_validation->set_rules('accessories_header', 'Accessories category', 'required|trim|xss_clean');
    $this->form_validation->set_rules('accessories_body', 'Connectivity value', 'required|trim|xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 		= $this->input->post('product_id');
      $accessories_header 		= $this->input->post('accessories_header');
      $accessories_body 		= $this->input->post('accessories_body');
      $data1 = array(
        'product_id'		=>$product_id,
        'accessories_header'  => $accessories_header,
        'accessories_body' 	=> $accessories_body,
      );
      //data array_start
      $last_id = $this->product_models->save_accessories($data1);
      if ($last_id) {
        $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
        echo json_encode($st);

      } else {
        $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
        echo json_encode($st);
      }

    }

  }
  function delete_accessories($product_id='')
  {
    $d = $this->product_models->delete_accessories($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //---------------------------------------------------------------------------

  public function add_product_relevent_items()
  {
    $this->load->library('form_validation'); //form validation lib
    $this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
    $this->form_validation->set_rules('product_list', 'Relevant items', 'required|trim|xss_clean');
    if ($this->form_validation->run() == FALSE)
    {
      $st = array('status' =>0,'validation' => validation_errors());
      echo json_encode($st);
    }
    else
    {
      $product_id 		= $this->input->post('product_id');
      $relevent_product_id 		= $this->input->post('product_list');
      $data1 = array(
        'product_id'		=>$product_id,
        'relevant_product_id'  => $relevent_product_id,
      );
      //data array_start
      $last_id = $this->product_models->save_relevant_items($data1);
      if ($last_id) {
        $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
        echo json_encode($st);

      } else {
        $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
        echo json_encode($st);
      }

    }

  }
  function delete_relevent_items($product_id='')
  {
    $d = $this->product_models->delete_relevent_items($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }
  }
  //---------------------------------------------------------------------------



}
