<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Orders_model extends CI_Model {
  
  private $tableName = 'orders';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  //Sales payment get 
	function get_sale_payments_by_sale_id($sale_id) {
		$this->db->select('ocp.*,user.user_first_name,user_group.user_group_name,mpt.pay_type_name');
		$this->db->from('order_customer_payment ocp');
		$this->db->join('user', 'ocp.user_id = user.user_id', 'left');
		$this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
		$this->db->join('mstr_payment_type mpt', 'ocp.payment_type = mpt.pay_type_id', 'left');
		$this->db->order_by("ocp.payment_id", "desc");
		$this->db->where("ocp.ref_payment_id",$sale_id);//("id !=",$id);
		//$this->db->where("sale_payments.sale_payment_type",'sale');
		$query = $this->db->get();
		return $query->result();
	}
	
		//Sales payment save
	function save_sale_payments(&$data,$sale_pymnt_id=false)
	{
		if (!$sale_pymnt_id)
		{
			return $this->db->insert('order_customer_payment',$data);
		}else {
			//$this->db->where('supp_id', $sale_pymnt_id);
			//return $this->db->update('order_customer_payment',$data);
		}
	}	
  
    public function get_all_orders_del(){
        $this->db->select('o.*,oc.*,os.*,pt.pay_type_name,');
		$this->db->from('orders o');
		$this->db->join('orders_customer oc', 'oc.order_reference_id = o.order_reference_id', 'left');
        $this->db->join('order_status os', 'os.status_id = o.order_status', 'left');
        $this->db->join('mstr_payment_type pt', 'os.pay_type_id =pt.pay_type_id', 'left');
		$this->db->order_by("o.order_id", "asc");
		$query = $this->db->get();
	//	echo $this->db->last_query();
		return $query->result_array();
    }
  
  public function get_all_mstr_order_status(){
      $this->db->select('mos.*');
		$this->db->from('mstr_order_status mos');
		$this->db->order_by("mos.status_id", "asc");
//		$this->db->where("o.exp_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
  }
  
   public function get_all_orders(){
      $this->db->select('oc.*,c.*,mos.*,pt.pay_type_name,dt.delivery_type');
		$this->db->from('order_customer oc');
		$this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
		$this->db->join('master_delivery_type dt','oc.delivery_type = dt.delivery_type_id' ,'left');
         $this->db->join('mstr_order_status mos', 'oc.order_status = mos.status_id', 'left');
         
           $this->db->join('mstr_payment_type pt', 'oc.payment_type =pt.pay_type_id', 'left');
		
		$this->db->order_by("oc.ord_cus_id", "desc");
//		$this->db->where("o.exp_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
  }
  
  public function get_order_by_id($ord_cus_id = ""){
	
    $this->db->select('oc.*,c.*,mc.cname,r.route_name,oca.*,ma.area_name,w.name,w.address,w.phone,pt.pay_type_name,dt.delivery_type,oci.product_price');
    $this->db->from('order_customer oc');
    $this->db->join('master_delivery_type dt','oc.delivery_type = dt.delivery_type_id' ,'left');
	$this->db->join('order_customer_item oci','oc.ord_cus_id = oci.order_cus_id' ,'left');
	
	
	$this->db->join('mstr_order_status mos', 'oc.order_approval_status = mos.status_id', 'left');
    $this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
    $this->db->join('order_customer_address oca', 'oc.ord_cus_id = oca.order_id', 'left');
    $this->db->join('mstr_payment_type pt', 'oc.payment_type =pt.pay_type_id', 'left');
	//$this->db->join('mstr_city mc', 'oc.delivery_place_id = mc.cid', 'left');
    $this->db->join('mstr_city mc', 'c.city_id = mc.cid', 'left');
    $this->db->join('route r', 'mc.route_id = r.route_id', 'left');
    $this->db->join('master_area ma', 'r.area_id = ma.area_id', 'left');
    $this->db->join('warehouses w', 'oc.warehouse_id = w.id', 'left');
    $this->db->where('oc.ord_cus_id',$ord_cus_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row();
     }
     else
     {
       return false;
     }
  }
  
  public function get_order_by_order_id($order_id = ""){
      $this->db->select('o.*, oc.*');
     $this->db->from('orders o');
     $this->db->join('orders_customer oc','oc.order_reference_id = o.order_reference_id','left');
     $this->db->where('o.order_id',$order_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row();
     }
     else
     {
       return false;
     }
  }
  
//   public function get_order_items($order_cus_id = ""){
//       $this->db->select("oci.*,p.*,");
//      $this->db->from("order_customer_item oci");
// 	 $this->db->join('product p','oci.product_id = p.product_id','left');
	 
//      $this->db->where("oci.order_cus_id",$order_cus_id);
	 
//      $query = $this->db->get();  
//      if($query->num_rows() >0)
//      {
//        return $query->result();
//      }
//      else
//      {
//        return false;
//      }
//   }
//start dakshina 11/21/2023
  public function get_order_items($order_cus_id = ""){
	$this->db->select("oci.*,p.*,pv.product_weight");
   $this->db->from("order_customer_item oci");
   $this->db->join('product p','oci.product_id = p.product_id','inner');
   $this->db->join('product_variation pv','oci.product_w_id = pv.product_w_id','inner');
   $this->db->where("oci.order_cus_id",$order_cus_id);
   
   $query = $this->db->get();  
   if($query->num_rows() >0)
   {
	 return $query->result();
   }
   else
   {
	 return false;
   }
}
  
//end dakshina
  function save_orders(&$supplier_data,$ord_cus_id=false)
	{
		if (!$ord_cus_id)
		{
			$this->db->insert('order_customer',$supplier_data);
		}else {
			$this->db->where('ord_cus_id', $ord_cus_id);
			return $this->db->update('order_customer',$supplier_data);
		}
	}
  
  public function get_order_items_by_order_id($order_id = ""){
      $this->db->select("oci.*,p.product_name,p.product_id,,p.product_code,oc.*");
     $this->db->from("order_customer_item oci");
	  $this->db->join('order_customer oc','oci.order_cus_id = oc.ord_cus_id','left');
	  $this->db->join('product p','oci.product_id = p.product_id','left');
     $this->db->where("oci.order_cus_id",$order_id);
     $query = $this->db->get();  
	// echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result_array();
     }
     else
     {
       return false;
     }
  }
  
  public function change_status($status){
      $this->db->set('order_status', $status);
      $flag = $this->db->update('orders');
      return $flag;
  }
  
  
  function get_order_avalable_product_qty_for_pack($product_id,$ord_cus_id){
		$this->db->select_sum('oci.product_qty');
		//$this->db->where("fi.fi_type_id", 'sale');
		$this->db->from('order_customer_item oci');
		$this->db->join('order_customer oc', "oci.order_cus_id = oc.ord_cus_id", 'left');
		$this->db->where("oci.product_id", $product_id);
		$this->db->where("oci.order_cus_id", $ord_cus_id);
		$this->db->where("oc.order_status", 2);
		
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row()->product_qty;
	}
	
	//added by namal 
	function get_order_packed_product_qty_new(){
	    
		$this->db->select_sum('si.quantity');
		$this->db->select("s.ord_cus_id");
		$this->db->from('sale_items si');
		$this->db->join('sales s', "si.sale_id = s.sale_id", 'left');
		$this->db->where('s.ord_cus_id is NOT NULL', NULL, FALSE);
		$this->db->group_by('s.ord_cus_id');
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		$res_data = array();
		if($query->num_rows() > 0){
		    foreach($query->result() as $row){
		        $res_data[$row->ord_cus_id] = $row->quantity;
		    }
		}
		return $res_data;
	}
	
	//Sales return get get product qty
	function get_order_packed_product_qty($product_id,$ord_cus_id){
		$this->db->select_sum('si.quantity');
		$this->db->from('sale_items si');
		$this->db->join('sales s', "si.sale_id = s.sale_id", 'left');
		//$this->db->where("r.warehouse_id", $warehouse_id);
		$this->db->where("s.ord_cus_id", $ord_cus_id);
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		return $query->row()->quantity;
	}
	
	function get_order_product_qty($product_id,$ord_cus_id){
		$this->db->select_sum('oci.product_qty');
		$this->db->from('order_customer_item oci');
		//$this->db->join('sales s', "si.sale_id = s.sale_id", 'left');
		//$this->db->where("r.warehouse_id", $warehouse_id);
		$this->db->where("oci.order_cus_id", $ord_cus_id);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row()->product_qty;
	}
	

	
	//added by namal
	// function get_order_product_qty_new(){
	// 	$this->db->select_sum('oci.product_qty');
	// 	$this->db->select("oci.order_cus_id");
	// 	$this->db->from('order_customer_item oci');
	// 	$this->db->group_by('oci.order_cus_id');
	// 	$query = $this->db->get();
	// 	$res_data = array();
	// 	if($query->num_rows() > 0){
	// 	    foreach($query->result() as $row){
	// 	        $res_data[$row->order_cus_id] = $row->product_qty;
	// 	    }
	// 	}
	// 	return $res_data;
	// }



	function get_order_product_qty_new(){
		$this->db->select_sum('oci.product_qty');
		$this->db->select("oci.order_cus_id");
		$this->db->select("oci.product_price"); // Add this line to select the product_price column
		$this->db->from('order_customer_item oci');
		
		$this->db->group_by('oci.order_cus_id');
		$query = $this->db->get();
		$res_data = array();
		if($query->num_rows() > 0){
			
			foreach($query->result() as $row){
				$res_data[$row->order_cus_id] = array(
					'product_qty' => $row->product_qty,
					'product_price' => $row->product_price
				);
			}
		}
		return $res_data;
	}

}
// $subtotal=0;
// foreach($cart as $cartProduct){
//  $subtotal+=$cartProduct['price'] * $cartProduct['qty'];
//  $product_id=$cartProduct['id'];
//  $product_details = $this->product_model->get_single_product($product_id);                    
//  $qty_total+= $cartProduct['qty'];                    
//  $nested_data=array(
// 	 'product_id'=>$cartProduct['id'],                    
// 	 'product_price'=>$cartProduct['price'],                        
// 	 'product_qty'=>$cartProduct['qty'],                       
// 	  );
// 	  $order_item_array[]=$nested_data;
//  }
