<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');//version 1.4
class Stock_Counter_Model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
     //sachith 2022-02-07 system update (centralize the stock count)
    function get_stock_balance($warehouse_id='',$product_id){
        return $this->calculate_stock_balance($warehouse_id,$product_id);
    }
    function get_freeze_quntity($warehouse_id='',$product_id){
         return $this->delivery_to_be_load_qty($warehouse_id,$product_id);
    }
    private function  calculate_stock_balance($warehouse_id='',$product_id){
        $grn_total= $this->get_grn_qty($warehouse_id,$product_id);
        $sale_total= $this->get_sale_qty($warehouse_id,$product_id);
        $sale_return_total= $this->get_sale_return_qty($warehouse_id,$product_id);
        $damage_total= $this->get_damage_qty($warehouse_id,$product_id);
        $grn_return_total= $this->get_grn_return_qty($warehouse_id,$product_id);
        $loaded_qty= $this->delivery_loaded_qty($warehouse_id,$product_id);
        $to_be_load_qty= $this->delivery_to_be_load_qty($warehouse_id,$product_id);
        $unloaded_qty= $this->delivery_unloaded_qty($warehouse_id,$product_id);
        $product_balance=(($grn_total+$sale_return_total+$unloaded_qty)-($grn_return_total+$damage_total+$sale_total+$loaded_qty+$to_be_load_qty));
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    private function get_grn_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('pi.quantity');
        $this->db->from('purchase_items pi');
        if($warehouse_id){
            $this->db->join('purchases p','p.id=pi.purchase_id','inner');
            $this->db->where('p.warehouse_id', $warehouse_id);
        }
        $this->db->where('pi.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    private function get_sale_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('si.quantity');
        $this->db->from('sale_items si');
        if($warehouse_id){
            $this->db->join('sales s','s.sale_id=si.sale_id','inner');
            $this->db->where('s.warehouse_id', $warehouse_id);
        }
        $this->db->where('si.product_id', $product_id);
        $this->db->where('si.direct_sale', 1);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    private function get_sale_return_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('si.quantity');
        $this->db->from('sales_return_items si');
         if($warehouse_id){
            $this->db->join('sales_return a','s.sl_rtn_id=si.sl_rtn_id','inner');
            $this->db->where('s.warehouse_id', $warehouse_id);
        }
        $this->db->where('si.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
            
        }
    }
    private function get_damage_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('di.pdmgitm_quantity');
        $this->db->from('product_damage_item di');
         if($warehouse_id){
            $this->db->join('product_damage d','d.pdmg_id=di.pdmg_id','inner');
            $this->db->where('d.warehouse_id', $warehouse_id);
        }
        $this->db->where('di.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['pdmgitm_quantity']))
        {
            return $result['pdmgitm_quantity'];
        }else{
       return 0;
        }
    }
     private function get_grn_return_qty($warehouse_id='',$product_id)
    {
       return 0;
    }
    private function delivery_loaded_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('ci.issue_qty');
        $this->db->from('customer_order_items ci');
         if($warehouse_id){
            $this->db->join('customer_order_master c','c.cus_order_master_id=ci.cus_order_master_id','inner');
            $this->db->where('c.warehouse_id', $warehouse_id);
        }
        $this->db->where('ci.delivery_status', 1);
        $this->db->where('ci.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['issue_qty']))
        {
            return $result['issue_qty'];
        }else{
       return 0;
        }
    }
    private function delivery_to_be_load_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('ci.issue_qty');
        $this->db->from('customer_order_items ci');
         if($warehouse_id){
            $this->db->join('customer_order_master c','c.cus_order_master_id=ci.cus_order_master_id','inner');
            $this->db->where('c.warehouse_id', $warehouse_id);
        }
        $this->db->where('ci.delivery_status', 0);
        $this->db->where('ci.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['issue_qty']))
        {
            return $result['issue_qty'];
        }else{
       return 0;
        }
    }
    private function delivery_unloaded_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('ci.return_qty');
        $this->db->from('customer_order_return_items ci');
         if($warehouse_id){
        $this->db->where('ci.warehouse_id', $warehouse_id);
         }
        $this->db->where('ci.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['return_qty']))
        {
            return $result['return_qty'];
        }else{
       return 0;
        }
    }
    //batch_stock balance start------------------------------------------------------------------------------------------------------
      function get_stock_balance_batch($warehouse_id='',$product_id,$batch_id){
        $grn_total= $this->get_batch_grn_qty_test($warehouse_id,$product_id,$batch_id);
        $sale_total= $this->get_batch_sale_qty($warehouse_id,$product_id,$batch_id);
        $hwsale_total= $this->get_batch_hw_sale_qty($warehouse_id,$product_id,$batch_id);
        $sale_return_total= $this->get_batch_sale_return_qty($warehouse_id,$product_id,$batch_id);
        $adjesment_total= $this->get_batch_adjesment_qty($warehouse_id,$product_id,$batch_id);
        $grn_return_total= $this->get_batch_grn_return_qty($warehouse_id,$product_id,$batch_id);
        $product_balance=($grn_total-$grn_return_total)-($sale_total-$sale_return_total)+$adjesment_total-$this->get_batch_sub_sale_qty($warehouse_id,$product_id,$batch_id) - $hwsale_total;
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    function get_batch_grn_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        //$this->db->from('btatch_prroduct_grn bg');
        $this->db->from('batch_product bg');
        $this->db->join('purchase_items p','p.id=grn_item_id','inner');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('bg.batch_id', $batch_id);
        $this->db->group_by('p.product_id');
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_grn_qty_test($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('btatch_prroduct_grn bg');
        //$this->db->from('batch_product bg');
        $this->db->join('purchase_items p','p.id=grn_item_id','inner');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('bg.batch_id', $batch_id);
        $this->db->group_by('p.product_id');
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_sale_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('sale_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_hw_sale_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_sub_sale_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('hw.quantity');
        $this->db->select('pr.pr_quantity');
        $this->db->from('hw_sale_items hw');
        $this->db->join('product pr','pr.product_id = hw.product_id','left');
        $this->db->where('pr.sub_product_of', $product_id);
        $this->db->where('hw.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            //return (1/12)*3;//$result['quantity'];
            if($result['quantity']){
                $little_product_size = $result['pr_quantity'];
                $big_product_size = $this->get_pr_qty($product_id);
                $qty = $result['quantity'];
                return ($little_product_size/$big_product_size)*$qty;
            }
        }else{
            return 0;
        }
    }
     function get_batch_sale_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sales_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     function get_batch_adjesment_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.batch_qty');
        $this->db->from('batch_stock_adjesment p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['batch_qty']))
        {
            return $result['batch_qty'];
        }else{
       return 0;
        }
    }
     function get_batch_grn_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     //product batch_stock balance end-------------------------------------------------------------------------------
     
     //product batch purcheses balance stsrt ------------------------------------------------------------------------
     
     function get_purchased_stock_balance($product_id,$grn_id){
        $grn_total= $this->get_purchased_grn_qty($product_id,$grn_id);
        $grn_return_total= $this->get_purchased_return_grn_qty_total($product_id,$grn_id);
        $product_balance=$grn_total-$grn_return_total;
        return $product_balance;
    }
     function get_purchased_grn_qty($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_purchased_return_grn_qty_total($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.grn_item_id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_bid($batch_ref_number){
        $this->db->select('batch_id,batch_product.product_id,product.ao,product.warehouse_id,product_name,product_code,batch_product.product_cost,batch_product.retail_cash,batch_product.retail_wholesale,batch_product.retail_credit,unit_code as unit_name,pr_quantity,sub_product_of');
        $this->db->from('batch_product');
        $this->db->join('product','product.product_id = batch_product.product_id','left');
        $this->db->join('mstr_unit','product.product_unit = mstr_unit.unit_id','left');
        $this->db->where('batch_ref_number', $batch_ref_number);
        $query = $this->db->get();
        $result=$query->row();
        return $result;
    }
    function get_pr_qty($product_id){
        $this->db->select('pr_quantity');
        $this->db->from('product');
        $this->db->where('product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row()->pr_quantity;
        return $result;
    }
     //product batch purcheses balance end ------------------------------------------------------------------------
   
}