<?php $this->load->view("templates/common/top_section"); ?>
    <!-- /section:basics/content.breadcrumbs -->
    <div class="page-content">
        <!-- /section:settings.box -->
        <div class="page-header">
            <h1><?= (isset($page_title) ? $page_title : null) ?></h1>
        </div><!-- /.page-header -->

        <div class="row">
            <div class="col-xs-12">
                <!-- PAGE CONTENT BEGINS -->
                <div class="col-xs-12 col-sm-6 widget-container-col ui-sortable">
                    <div class="widget-box  ui-sortable-handle">
                        <div class="widget-header widget-header-flat">
                            <h5 class="widget-title">Apply Leave</h5>
                        </div>
                        <div class="widget-body">
                            <div class="widget-main no-padding">
                                <!-- /section:elements.form -->
                                <form class="form-horizontal" action="<?php echo base_url('leave_transaction/post'); ?>"
                                      method="post" role="form">
                                    <fieldset>

                                        <input type="hidden" <?php echo ($edit and isset($leaveT->Leave_Code)) ? 'value="' . $leaveT->Leave_Code . '"' : null; ?>
                                               class="span6" name="leave_code"/>
                                        <input type="hidden" <?php echo ($edit and isset($leaveT->EmpNo)) ? 'value="' . $leaveT->EmpNo . '"' : null; ?>
                                               name="emp_no"/>
                                        <input type="hidden" <?php echo ($edit and isset($leaveT->EmpNo)) ? 'name="EmpNo"' : null; ?> />
                                        <input type="hidden" <?php echo ($edit and isset($leaveT->EmpNo)) ? 'value="' . $leaveT->Comp_Id . '"' : null; ?>
                                               name="Comp"/>
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Emp No:</label>
                                            <div class="col-sm-9">
                                                <select required class="chosen-select col-xs-10 col-sm-8 input"
                                                        required <?php echo ($edit and isset($leaveT->EmpNo)) ? 'disabled' : null; ?>
                                                        name="EmpNo" id="EmpNo">
                                                    <option value="">Employee Name</option>
                                                    <?php
                                                    if (is_array($employees)) {
                                                        foreach ($employees as $ename) {
                                                            $select = (isset($emp) and $ename->EId == $emp) ? 'selected="selected"' : null;
                                                            echo '<option ' . $select . ' value="' . $ename->EId . '">' . trim($ename->EmpName) . ' -- ' . $ename->EmpNo . '</option>';
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Leave Code:</label>
                                            <div class="col-sm-9">
                                                <select required class="chosen-select col-xs-10 col-sm-8 input"
                                                        name="Leave_Code" id="Leave_Code">
                                                    <option value="">Leave Code</option>
                                                    <?php
                                                    if (is_array($LeaveCodes)) {
                                                        foreach ($LeaveCodes as $code) {
                                                            $select = (isset($leaveT->EmpNo) and $code->Leave_code == $leaveT->Leave_Code) ? 'selected="selected"' : null;
                                                            echo '<option ' . $select . ' value="' . $code->Leave_code . '">' . trim($code->Description) . '</option>';
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Leave Date : </label>
                                            <div class="col-sm-9">
                                                <input required
                                                       type="text" <?php echo ($edit and isset($leaveT->LeaveDate)) ? 'value="' . $leaveT->LeaveDate . '"' : 'value="' . date('Y-m-d') . '"'; ?>
                                                       name="LeaveDate" id="LeaveDate" placeholder="Leave Date"
                                                       data-date-format="yyyy-mm-dd" class="col-xs-10 col-sm-8 years">
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Reason :</label>
                                            <div class="col-sm-9">
                                                <input type="text" name="Reason" id="Reason" <?php echo ($edit and isset($leaveT->Reason)) ? 'value="' . $leaveT->Reason . '"' : null; ?>
                                                       class="col-xs-10 col-sm-8 input">
                                            </div>
                                        </div>

                                        <div class="control-group">
                                            <label class="col-sm-3 control-label no-padding-right"></label>
                                            <div class="col-sm-9">
                                                <div class="radio">
                                                    <label>
                                                        <input name="LeaveType" checked type="radio" value="full" <?php echo ($edit and $leaveT->LeaveType=='full') ? 'checked' : null; ?>
                                                               class="ace"/>
                                                        <span class="lbl"> Full Day</span>
                                                    </label>
                                                    <label>
                                                        <input name="LeaveType" type="radio" value="half" <?php echo ($edit and $leaveT->LeaveType=='half') ? 'checked' : null; ?>
                                                               class="ace"/>
                                                        <span class="lbl"> Half Day</span>
                                                    </label>
                                                </div>

                                                <div class="radio">

                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Leave (Form - To)</label>
                                            <div class="col-sm-9">
                                                <div class="row">
                                                    <div class="col-xs-8 col-sm-11">
                                                        <div class="input-daterange input-group">
                                                            <input type="text" class="input-sm form-control"
                                                                   placeholder="Leave From" <?php echo ($edit and isset($leaveT->LeaveFrom)) ? 'value="' . $leaveT->LeaveFrom . '"' : date('Y-m-d'); ?> name="LeaveFrom"/>
                                                            <span class="input-group-addon">
																		<i class="fa fa-exchange"></i>
																	</span>

                                                            <input type="text" class="input-sm form-control" <?php echo ($edit and isset($leaveT->LeaveTo)) ? 'value="' . $leaveT->LeaveTo . '"' : date('Y-m-d'); ?>
                                                                   placeholder="Leave To" name="LeaveTo"/>
                                                        </div>

                                                        <!-- /section:plugins/date-time.datepicker -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Num of Days:</label>
                                            <div class="col-sm-9">
                                                <input required onKeyUp="return makeBalance();"
                                                       onChange="return makeBalance();" min="1"
                                                       type="number" <?php echo ($edit and isset($leaveT->Days)) ? 'value="' . $leaveT->Days . '"' : null; ?>
                                                       name="Days" id="Days" class="col-xs-10 col-sm-8 input">
                                            </div>
                                        </div>

                                        <!-- form-group -->
                                        <input type="hidden" name="day" id="day" class="span2 Balance">

                                        <!-- form-group -->
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label no-padding-right">Balance:</label>
                                            <div class="col-sm-9">
                                                <input type="text" <?php echo ($edit and isset($leaveT->Balance)) ? 'value="' . $leaveT->Balance . '"readonly' : null; ?>
                                                       name="Balance" readonly id="Balance"
                                                       class="col-xs-10 col-sm-8 disable input">
                                            </div>
                                        </div>


                                    </fieldset>

                                    <div class="clearfix form-actions">
                                        <div class="col-md-offset-3 col-md-9">
                                            <button class="btn btn-info" type="submit">
                                                <i class="ace-icon fa fa-check bigger-110"></i>
                                                <?php echo (isset($edit) and $edit) ? 'Update' : 'Apply'; ?>
                                            </button>
                                            <button class="btn" type="reset">
                                                <i class="ace-icon fa fa-undo bigger-110"></i>
                                                Reset
                                            </button>
                                        </div>
                                    </div>
                                </form>
                                <!-- /section:plugins/date-time.datetimepicker -->
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-6 widget-container-col ui-sortable">
                    <div class="widget-box widget-color-blue ui-sortable-handle">
                        <!-- #section:custom/widget-box.options -->
                        <div class="widget-header">
                            <h5 class="widget-title bigger lighter">
                                <i class="ace-icon fa fa-table"></i>
                                Year Leave Balance
                            </h5>
                        </div>
                        <!-- /section:custom/widget-box.options -->
                        <div class="widget-body">
                            <div class="widget-main no-padding">
                                <table id="leave-balance" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>Leave Code</th>
                                        <th>Description</th>
                                        <th>Days</th>
                                        <th>Balance</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-6 widget-container-col ui-sortable">
                    <div class="widget-box widget-color-blue ui-sortable-handle">
                        <!-- #section:custom/widget-box.options -->
                        <div class="widget-header">
                            <h5 class="widget-title bigger lighter">
                                <i class="ace-icon fa fa-table"></i>
                                Year Applied Leaves
                            </h5>
                        </div>
                        <!-- /section:custom/widget-box.options -->
                        <div class="widget-body">
                            <div class="widget-main no-padding">
                                <table id="applied-leave" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>Leave Code</th>
                                        <th>Description</th>
                                        <th>Date</th>
                                        <th>Leave From</th>
                                        <th>Leave To</th>
                                        <th>Days</th>
                                        <th>Balance</th>
                                        <th>Reason</th>
                                        <th>Options</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.page-content -->
    </div>
    </div><!-- /.main-content -->
<?php $this->load->view("templates/common/footer"); ?>