<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Leave extends MY_Controller {
	
	private $model;
	
	 public function __construct()
	{
		parent::__construct();
		if (!$this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('login');
		}
		$this->load->model('leave_model');
		$this->model=$this->leave_model;
		$this->data['page'] = 'leave';
	} 
	// this function for index page (Home)
	function index()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['message'] = view_error($this->messages->get());
		$data['leaves'] = $this->model->get_all($this->attn->getComp());
		$this->load->view('templates/leave/index',$data);
	}
	
	public function add($id=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['edit'] = false;
		$data['page'] = 'leave';
		if($id and $data['Edit'])
		{
			$data['edit'] = true;
			$data['leave'] = $this->leave_model->get_info($id,$this->attn->getComp());
		}
		$data['leaves'] = $this->model->get_all($this->attn->getComp());
		//echo '<pre>',print_r($data['leaves']);die();
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Leave Register';
		$data['heading'] = 'Master Files';
		$data['url'] = base_url('add-leave');
		$this->load->view('templates/leave/add',$data);
	}

	public function post()
	{
		$post_id=$this->input->post('leave_id')=='' ? false:$this->input->post('leave_id');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('Leave_code', 'Leave Code', 'trim|required');
		$this->form_validation->set_rules('Name', 'Name', 'trim|required');
		$this->form_validation->set_rules('Days', 'Days', 'trim|required|numeric');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			redirect('leave/add');
		}
		else
		{
			$leave_data = array(
			'Comp_Id' => ($this->input->post('Comp')!='') ? $this->input->post('Comp'):$this->session->userdata('Comp'),
			'Leave_code' => ($this->input->post('Leave_code')!='') ? $this->input->post('Leave_code'):null,
			'Description' => $this->input->post('Name'),
			'Days' => $this->input->post('Days')
			);
			//get save id
			$returnId = $this->model->save($leave_data,$post_id);
			$postType =($post_id) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($this->lang->line('success_leave_'.$postType), "success");
				redirect('leave/add');
			}
			else
			{
				if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_leave_'.$postType), "error");
				redirect('leave/add');
			}
		}	
	}

	public function get_details_filter()
	{
		$this->load->library('datatables');
		$action = '<div class="d-flex align-items-sm justify-content-sm">
        <a href="'.site_url('leave/add/$1').'" class="btn btn-sm btn-icon"><i class="bx bx-edit"></i></a>
        </div>';
		$this->datatables
			->select($this->db->dbprefix('leave') . ".Leave_code as code,
			" . $this->db->dbprefix('leave') . ".Description,
			" . $this->db->dbprefix('leave') . ".Days")
			->from("leave")
			->join('comp', $this->db->dbprefix('leave') . '.Comp_Id=' . $this->db->dbprefix('comp') . '.Code', 'left')
			->where($this->db->dbprefix('leave') . '.Comp_Id', $this->attn->getComp())
			->add_column("Actions", $action, "code");
		//->unset_column('id');
		echo $this->datatables->generate();

	}
	
}
?>