<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Person extends MY_Controller {
	
	private $model;
	 public function __construct()
	{
		parent::__construct();
		$this->load->model('user_model');
		$this->model = $this->user_model;
	} 
	
	function index()
	{
		//echo hash('sha512', '123456');die();
		if ($this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('today-attendance');
		}
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/login',$data);
	}
	
	function getUsers()    {
        //$this->tmw->checkPermissions('index');
        $action = "
        <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  <a class=\"dropdown-item\" href='" . base_url('person/edit_user/$1') ."'
					><i class=\"bx bx-edit-alt me-1\"></i> Edit</a>
                    <a class=\"dropdown-item\" href='" . base_url('person/view/$1') ."'
					><i class=\"bx bx-edit-alt me-1\"></i> View</a>
				  <a class=\"dropdown-item\" href='". base_url('person/delete/$1') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>";
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('user') .".Id AS Id,
                CONCAT(".$this->db->dbprefix('user') .".FirstName,'',".$this->db->dbprefix('user') .".FirstName) AS Name,
				".$this->db->dbprefix('user') .".Username,
				".$this->db->dbprefix('user') .".Email,
				".$this->db->dbprefix('user') .".EmpNo,
				".$this->db->dbprefix('user') .".Type")
            ->from("user")
            //->edit_column('status', '$1__$2', 'status,Id')
            //->unset_column('Id')
            ->add_column("Actions", $action, "Id");
            //->unset_column('Id');
        echo $this->datatables->generate();
    }
	public function login()
	{
		//echo hash('sha512', 'demorathna1234**');die();
		if ($this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('welcome');
		}
		$return =array();
			if($this->model->login($this->input->post('User_ID'), $this->input->post('Password')))
			{
				//$this->messages->add($this->lang->line('success_login'), "success");
				redirect('welcome/');
			}
			else
			{
				$this->messages->add($this->lang->line('error_login'), "error");
				$this->index();
			}
	}
	
	public function login_old()
	{
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_rules('Company_code', 'Company Code', 'required');
		$this->form_validation->set_rules('User_ID', 'Username', 'required');
		$this->form_validation->set_rules('Password', 'Password', 'required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			$this->index();
		}
		else
		{
			if($this->model->login($this->input->post('Company_code'), $this->input->post('User_ID'), $this->input->post('Password')))
			{
				$this->messages->add($this->lang->line('success_login'), "success");
				redirect('upload-attendance/');
			}
			else
			{
				$this->messages->add($this->lang->line('error_login'), "error");
				$this->index();
			}
		}
	}

	function add_user()
    {
        $data = $this->data;

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('FirstName', 'First Name', 'trim|required');
        $this->form_validation->set_rules('LastName', 'Last Name', 'trim|required');
        $this->form_validation->set_rules('Type', 'Type', 'trim|required');
        $this->form_validation->set_rules('Username', 'Username', 'trim|required|is_unique[user.Username]');
		$this->form_validation->set_rules('Password', 'Password', 'trim|required|min_length[6]');
        $this->form_validation->set_rules('RePassword', 'Re-enter Password', 'trim|required|matches[Password]');
        if ($this->form_validation->run('person/add_user') == true) {
			if(isset($_FILES['Avatar']['name']) && !empty($_FILES['Avatar']['name'])) 
			{
				$image_upload = $this->model->upload_file('Avatar');
				if($image_upload)
				{
					$upImageName = $image_upload['file_name'];
				}
				else
				{
					$upImageName = '';
				}
			}
			else
			{
				$upImageName = isset($_POST['Avatar']) ? $_POST['Avatar'] : '';
			}
            $user_data = array(
                'FirstName' => $this->input->post('FirstName'),
                'EmpNo' => $this->input->post('EmpNo'),
                'LastName' => $this->input->post('LastName'),
                'Email' => $this->input->post('Email'),
                'Type' => $this->input->post('Type'),
                'Username' => $this->input->post('Username'),
                'Password' => hash('sha512', $this->input->post('Password')),
				'Avatar' => $upImageName,
            );
        }elseif ($this->input->post('edit_user')) {
            $this->messages->add(validation_errors(), "error");
            redirect('person/users/');
        }

        if ($this->form_validation->run() == true && $this->model->addUser($user_data)) {
            $this->messages->add('User successfully added', "success");
            redirect('person/users/');
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['edit'] = false;
            $data['page_title'] = 'Add User'; 
            $data['heading'] = 'Users';
            $data['url'] = base_url('leave-transaction');
			$this->load->model('employee_model');
			$data['employees'] = $this->employee_model->getEmpNameId();
			//echo '<pre>',print_r($data['users']); die();
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/users/add_user',$data);
        }
    }

	function edit_user($id=null)
    {
        $data = $this->data;

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Username', 'Username', 'trim|required');
        if ($this->form_validation->run('person/edit_user') == true) {
            $user_data = array(
                'FirstName' => $this->input->post('FirstName'),
                'LastName' => $this->input->post('LastName'),
                'Email' => $this->input->post('Email'),
				'Type' => $this->input->post('Type'),
            );
			if($this->session->userdata('Type')=='ADMIN'){
				$user_data['Type'] = $this->input->post('Type');
			}
        }elseif ($this->input->post('edit_user')) {
            $this->messages->add(validation_errors(), "error");
            redirect('person/edit_user/'.$id);
        }

        if ($this->form_validation->run() == true && $this->model->updateUser($this->input->post('Id'),$user_data)) {
            $this->messages->add('User successfully updated', "success");
            redirect('person/users');
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'user_leave';
            $data['edit'] = false;
            $data['user'] = $this->model->get_user_details_by_emp_id($id);
            $data['page_title'] = 'Edit User'; 
            $data['heading'] = 'Users';
            $data['url'] = base_url('leave-transaction');
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/users/edit_user',$data);
        }
    }

	function change_password()
    {
        $data = $this->data;

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('password', 'Password', 'required');
		$this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'required|matches[password]');
        if ($this->form_validation->run('person/change_password') == true) {
          
        }elseif ($this->input->post('edit_user')) {
            $this->messages->add(validation_errors(), "error");
            redirect('person/change_password/');
        }

        if ($this->form_validation->run() == true && $this->model->changeUserPassword($this->session->userdata('Id'),$this->input->post('password'))) {
            $this->messages->add('User password successfully changed', "success");
            redirect('person/change_password/');
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'change_password';
            $data['edit'] = false;
            $data['page_title'] = 'Change Password';
            $data['heading'] = 'Users';
            $data['url'] = base_url('leave-transaction');
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/users/change_password',$data);
        }
    }
	
	public function users()
	{
		/*
		if($this->Type!='SUPER ADMIN'){ 
			//$this->messages->add($this->lang->line('error_permisiion'), "error");
            //redirect(base_url());
        }
		*/
            $this->data['message'] = view_error($this->messages->get());
            $this->data['page_title'] = 'User List';
		    $this->data['heading'] = 'Users';
            $this->load->view('templates/users/user_list', $this->data);
	}
	
	public function post()
	{
		if($this->input->get('user_id'))
		{
			$data['edit'] = true;
			$data['udetails'] = $this->model->get_info($this->input->get('user_id'));
		}
		else
		{
			$data['edit'] = false;
		}
		$data['message'] = view_error($this->messages->get());
		$this->load->view('admin/users/add_user',$data);
	}
		
	public function save()
	{
		$post_id=$this->input->post('user_id')=='' ? null:$this->input->post('user_id');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('user_type', 'Select User type', 'trim|required');
		$this->form_validation->set_rules('fname', 'First Name', 'trim|required');
		$this->form_validation->set_rules('lname', 'Last Name', 'trim|required');
		if($post_id) $this->form_validation->set_rules('user_email', 'Email', 'trim|required|valid_email');
		else $this->form_validation->set_rules('user_email', 'Email', 'trim|required|valid_email|is_unique[user.user_email]');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[repassword]');
		$this->form_validation->set_rules('repassword', 'Password Confirmation', 'trim|required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			$url = ($post_id) ? '?user_id='.$post_id : null;
			redirect('/admin/user/post/'.$url);
		}
		else
		{
			//hash('sha512', $password);
			$page_data = array(
			'id' => $post_id ,
			'fname' => $this->input->post('fname') ,
			'lname' => $this->input->post('lname') ,
			'user_email' => $this->input->post('user_email') ,
			'password' =>  hash('sha512', $this->input->post('password'))
			);
			//get save id
			$returnId = $this->model->save($page_data,$post_id,$this->input->post('user_type'));
			$posttest = isset($post_id) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($posttest.' user succefuly', "success");
				redirect('/admin/user/users');
			}
			else
			{
				$redirect_url = ($posttest=='edit') ? '?user_id='.$post_id : '';
				$this->messages->add('not '.$posttest.' user', "error");
				redirect('admin/user/post/'.$redirect_url);
			}
		}	
	}
	
	function check_edit()
	{
		if($this->session->userdata('Comp'))
		{
			return true; 
		}
		else
		{
			$this->messages->add('You have no permission to access', "error");
			return false;
		}
	}
	/*
	Logs out a user by destorying all session data and redirect to login
	*/
	
	function logout()
	{
		$this->session->sess_destroy();
		redirect('');
	}
	
}
?>