<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Public_Controller extends MY_Controller {

    function __construct()
    {
        parent::__construct();
       
        $this->assets = base_url() . 'themes/default/assets/frontend/';
        $this->data['assets'] = base_url() . 'themes/default/assets/frontend/';
        $this->path = './assets/uploads/';
        $this->data['path'] = $this->path;
        $this->data['Path'] = './assets/uploads/';
        $this->loggedIn = $this->tmw->logged_in();
        if($this->loggedIn) {
            $this->User = $this->tmw->in_group('user') ? TRUE : NULL;
            $this->data['User'] = $this->User;
            //echo $this->tmw->print_arrays($this->Settings); die();
        }
     

        if ($this->session->userdata('site_lang')) {
            $this->config->set_item('language', $this->session->userdata('site_lang'));
            $this->lang->load('site', $this->session->userdata('site_lang'));
        }else{
            $this->config->set_item('language', $this->Settings->Language);
            $this->lang->load('site', $this->Settings->Language);
        }
        
        if ($this->session->userdata('site_lang')) 
        {
            $this->data['Language'] = $this->session->userdata('site_lang');
            $this->Language = $this->data['Language'];
        }
        else
        {
            $this->data['Language'] = 'english';
        }

        $this->m = strtolower($this->router->fetch_class());
        $this->v = strtolower($this->router->fetch_method());
        $this->data['m']= $this->m;
        $this->data['v'] = $this->v;
        //page variable for load custom javascript files of header file
        $this->data['page'] = $this->m;

    }

    function page_construct($page, $meta = array(), $data = array()) {
        $meta['message'] = isset($data['message']) ? $data['message'] : '';
        $meta['msg'] = isset($data['msg']) ? $data['msg'] : $this->session->flashdata('message');
        $meta['error'] = isset($data['error']) ? $data['error'] : $this->session->flashdata('error');
        $meta['warning'] = isset($data['warning']) ? $data['warning'] : $this->session->flashdata('warning');
        $meta['assets'] = $data['assets'];
        $meta['Settings'] = $data['Settings'];
        $meta['User'] = isset($data['User']) ? $data['User'] :NULL;
        $meta['page'] = $data['page'];
        $meta['m'] = $data['m'];
        $meta['v'] = $data['v'];
  
        $this->load->view('frontend/header', $meta);
        $this->load->view('frontend/'.$page, $data);
        $this->load->view('frontend/footer');
    }

    
    function user_construct($page, $meta = array(), $data = array()) {
        $meta['message'] = isset($data['message']) ? $data['message'] :NULL;
        $meta['assets'] = $data['assets'];
        $meta['Settings'] = $data['Settings'];
        $meta['User'] = isset($data['User']) ? $data['User'] :NULL;
        $meta['page'] = $data['page'];
        $this->load->view('frontend/header', $meta);
        $this->load->view('frontend/users/'.$page, $data);
        $this->load->view('frontend/footer');
    }

}
