<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Tmw
{

    public function __construct()
    {

    }


    public function __get($var)
    {
        return get_instance()->$var;
    }

    public function rows_filter_assoc($array = array(), $key, $value)
    {
        $return = array();
        if (!empty($array)):
            foreach ($array as $a):
                if ($a->{$key} == $value):
                    $return[] = $a;
                endif;
            endforeach;
        endif;
        return $return;
    }

    public function URLIsValid($url)
    {
        if (!filter_var($url, FILTER_VALIDATE_URL) === false) {
            return true;
        } else {
            return false;
        }
    }


    private function _rglobRead($source, &$array = array())
    {
        if (!$source || trim($source) == "") {
            $source = ".";
        }
        foreach ((array)glob($source . "/*/") as $key => $value) {
            $this->_rglobRead(str_replace("//", "/", $value), $array);
        }
        $hidden_files = glob($source . ".*") AND $htaccess = preg_grep('/\.htaccess$/', $hidden_files);
        $files = array_merge(glob($source . "*.*"), $htaccess);
        foreach ($files as $key => $value) {
            $array[] = str_replace("//", "/", $value);
        }
    }

    private function _zip($array, $part, $destination, $output_name = 'sma')
    {
        $zip = new ZipArchive;
        @mkdir($destination, 0777, true);

        if ($zip->open(str_replace("//", "/", "{$destination}/{$output_name}" . ($part ? '_p' . $part : '') . ".zip"), ZipArchive::CREATE)) {
            foreach ((array)$array as $key => $value) {
                $zip->addFile($value, str_replace(array("../", "./"), NULL, $value));
            }
            $zip->close();
        }
    }

    public function array_push_assoc($array, $key, $value)
    {
        $array[$key] = $value;
        return $array;
    }

    public function formatMoney($number, $currency = '',$decimals=2)
    {
        $ts =  ',';
        $ds = '.';
        return $currency . number_format($number, $decimals, $ds, $ts);
    }

    public function formatQuantity($number, $decimals = NULL)
    {
        $ts =  ',';
        $ds = '.';
        return number_format($number, $decimals, $ds, $ts);
    }

    public function formatNumber($number, $decimals = NULL)
    {
        $ts =  ',';
        $ds = '.';
        return number_format($number, $decimals, $ds, $ts);
    }

    public function formatDecimal($number, $decimals = NULL)
    {
        if (!is_numeric($number)) {
            return NULL;
        }
        if (!$decimals) {
            $decimals = $this->Settings->decimals;
        }
        return number_format($number, $decimals, '.', ',');
    }

    public function clear_tags($str)
    {
        return htmlentities(
            strip_tags($str,
                '<span><div><a><br><p><b><i><u><img><blockquote><small><ul><ol><li><hr><big><pre><code><strong><em><table><tr><td><th><tbody><thead><tfoot><h3><h4><h5><h6>'
            ),
            ENT_QUOTES | ENT_XHTML | ENT_HTML5,
            'UTF-8'
        );
    }

    public function decode_html($str)
    {
        return html_entity_decode($str, ENT_QUOTES | ENT_XHTML | ENT_HTML5, 'UTF-8');
    }

    public function roundMoney($num, $nearest = 0.05)
    {
        return round($num * (1 / $nearest)) * $nearest;
    }

    public function roundNumber($number, $toref = NULL)
    {
        switch ($toref) {
            case 1:
                $rn = round($number * 20) / 20;
                break;
            case 2:
                $rn = round($number * 2) / 2;
                break;
            case 3:
                $rn = round($number);
                break;
            case 4:
                $rn = ceil($number);
                break;
            default:
                $rn = $number;
        }
        return $rn;
    }

    public function unset_data($ud)
    {
        if ($this->session->userdata($ud)) {
            $this->session->unset_userdata($ud);
            return true;
        }
        return FALSE;
    }

    public function hrsd($sdate)
    {
        if ($sdate) {
            return date($this->dateFormats['php_sdate'], strtotime($sdate));
        } else {
            return '0000-00-00';
        }
    }

    public function hrld($ldate)
    {
        if ($ldate) {
            return date($this->dateFormats['php_ldate'], strtotime($ldate));
        } else {
            return '0000-00-00 00:00:00';
        }
    }

    public function fsd($inv_date)
    {
        if ($inv_date) {
            $jsd = $this->dateFormats['js_sdate'];
            if ($jsd == 'dd-mm-yyyy' || $jsd == 'dd/mm/yyyy' || $jsd == 'dd.mm.yyyy') {
                $date = substr($inv_date, -4) . "-" . substr($inv_date, 3, 2) . "-" . substr($inv_date, 0, 2);
            } elseif ($jsd == 'mm-dd-yyyy' || $jsd == 'mm/dd/yyyy' || $jsd == 'mm.dd.yyyy') {
                $date = substr($inv_date, -4) . "-" . substr($inv_date, 0, 2) . "-" . substr($inv_date, 3, 2);
            } else {
                $date = $inv_date;
            }
            return $date;
        } else {
            return '0000-00-00';
        }
    }

    public function fld($ldate)
    {
        if ($ldate) {
            $date = explode(' ', $ldate);
            $jsd = $this->dateFormats['js_sdate'];
            $inv_date = $date[0];
            $time = $date[1];
            if ($jsd == 'dd-mm-yyyy' || $jsd == 'dd/mm/yyyy' || $jsd == 'dd.mm.yyyy') {
                $date = substr($inv_date, -4) . "-" . substr($inv_date, 3, 2) . "-" . substr($inv_date, 0, 2) . " " . $time;
            } elseif ($jsd == 'mm-dd-yyyy' || $jsd == 'mm/dd/yyyy' || $jsd == 'mm.dd.yyyy') {
                $date = substr($inv_date, -4) . "-" . substr($inv_date, 0, 2) . "-" . substr($inv_date, 3, 2) . " " . $time;
            } else {
                $date = $inv_date;
            }
            return $date;
        } else {
            return '0000-00-00 00:00:00';
        }
    }

    public function send_email($to, $subject, $message, $from = NULL, $from_name = NULL, $attachment = NULL, $cc = NULL, $bcc = NULL)
    {
        //echo $to; die();
        $this->load->library('email');
        //$config['useragent'] = "EduNext";
        $config['mailtype'] = "html";
        $config['protocol'] = 'mail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['crlf'] = "\r\n";
        $config['newline'] = "\r\n";
       /* if ($this->Settings->protocol == 'sendmail') {
            $config['mailpath'] = $this->Settings->mailpath;
        } elseif ($this->Settings->protocol == 'smtp') {
            $this->load->library('encrypt');
            $config['smtp_host'] = $this->Settings->smtp_host;
            $config['smtp_user'] = $this->Settings->smtp_user;
            $config['smtp_pass'] = $this->encrypt->decode($this->Settings->smtp_pass);
            $config['smtp_port'] = $this->Settings->smtp_port;
            if (!empty($this->Settings->smtp_crypto)) {
                $config['smtp_crypto'] = $this->Settings->smtp_crypto;
            }
        }*/

        $this->email->initialize($config);

        if ($from && $from_name) {
            $this->email->from($from, $from_name);
        } elseif ($from) {
            $this->email->from($from, $this->Settings->SiteName);
        } else {
            $this->email->from($this->Settings->DefaultEmail, $this->Settings->SiteName);
        }

        $this->email->to($to);
        if ($cc) {
            $this->email->cc($cc);
        }
        if ($bcc) {
            $this->email->bcc($bcc);
        }
        $this->email->subject($subject);
        $this->email->message($message);
        if ($attachment) {
            if (is_array($attachment)) {
                foreach ($attachment as $file) {
                    $this->email->attach($file);
                }
            } else {
                $this->email->attach($attachment);
            }
        }

        if ($this->email->send()) {
            //echo $this->email->print_debugger(); die();
            return TRUE;
        } else {
            echo $this->email->print_debugger(); die();
            return FALSE;
        }
    }

    public function checkPermissions($action = NULL, $js = NULL, $module = NULL)
    {
        //echo 'dt',lang("access_denied"), die();
        if (!$this->actionPermissions($action, $module)) {

            $this->session->set_flashdata('error', lang("access_denied"));
            if ($js) {
                die("<script type='text/javascript'>setTimeout(function(){ window.top.location.href = '" . (isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : site_url('welcome')) . "'; }, 10);</script>");
            } else {
                redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
            }
        }
    }

    public function actionPermissions($action = NULL, $module = NULL)
    {
        if ($this->Owner || $this->Admin) {

            //echo $action, die();
            if ($this->Admin && stripos($action, 'delete') !== false) {

                return FALSE;
            }
            return TRUE;
        } elseif ($this->Customer || $this->Supplier) {
            return false;
        } else {
            if (!$module) {
                $module = $this->m;
            }
            if (!$action) {
                $action = $this->v;
            }
            //$gp = $this->site->checkPermissions();
            if ($this->GP[$module . '-' . $action] == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function save_barcode($text = NULL, $bcs = 'code39', $height = 56, $stext = 1, $width = 256)
    {
        $drawText = ($stext != 1) ? FALSE : TRUE;
        $this->load->library('zend');
        $this->zend->load('Zend/Barcode');
        $barcodeOptions = array('text' => $text, 'barHeight' => $height, 'drawText' => $drawText);
        $rendererOptions = array('imageType' => 'png', 'horizontalPosition' => 'center', 'verticalPosition' => 'middle'); //'width' => $width
        $image = Zend_Barcode::draw($bcs, 'image', $barcodeOptions, $rendererOptions);
        if (imagepng($image, 'assets/uploads/barcode' . $this->session->userdata('user_id') . '.png')) {
            imagedestroy($image);
            $bc = file_get_contents('assets/uploads/barcode' . $this->session->userdata('user_id') . '.png');
            $bcimage = base64_encode($bc);
            return $bcimage;
        }
        return FALSE;
    }

    public function qrcode($type = 'text', $text = 'PHP QR Code', $size = 2, $level = 'H', $file_name = NULL)
    {
        $file_name = 'assets/uploads/qrcode' . $this->session->userdata('user_id') . '.png';
        if ($type == 'link') {
            $text = urldecode($text);
        }
        $this->load->library('phpqrcode');
        $config = array('data' => $text, 'size' => $size, 'level' => $level, 'savename' => $file_name);
        $this->phpqrcode->generate($config);
        $qr = file_get_contents('assets/uploads/qrcode' . $this->session->userdata('user_id') . '.png');
        $qrimage = base64_encode($qr);
        return $qrimage;
    }

    public function generate_pdf($content, $name = 'download.pdf', $output_type = NULL, $footer = NULL, $margin_bottom = NULL, $header = NULL, $margin_top = NULL, $orientation = 'P')
    {
        if (!$output_type) {
            $output_type = 'D';
        }
        if (!$margin_bottom) {
            $margin_bottom = 10;
        }
        if (!$margin_top) {
            $margin_top = 10;
        }
        $this->load->library('pdf');
        $pdf = new mPDF('utf-8', 'A4-' . $orientation, '13', '', 10, 10, $margin_top, $margin_bottom, 9, 9);
        $pdf->debug = false;
        $pdf->autoScriptToLang = true;
        $pdf->autoLangToFont = true;
        $pdf->SetProtection(array('print')); // You pass 2nd arg for user password (open) and 3rd for owner password (edit)
        //$pdf->SetProtection(array('print', 'copy')); // Comment above line and uncomment this to allow copying of content
        $pdf->SetTitle($this->Settings->site_name);
        $pdf->SetAuthor($this->Settings->site_name);
        $pdf->SetCreator($this->Settings->site_name);
        $pdf->SetDisplayMode('fullpage');
        $stylesheet = file_get_contents('assets/bs/bootstrap.min.css');
        $pdf->WriteHTML($stylesheet, 1);
        $pdf->WriteHTML($content);
        if ($header != '') {
            $pdf->SetHTMLHeader('<p class="text-center">' . $header . '</p>', '', TRUE);
        }
        if ($footer != '') {
            $pdf->SetHTMLFooter('<p class="text-center">' . $footer . '</p>', '', TRUE);
        }
        //$pdf->SetHeader($this->Settings->site_name.'||{PAGENO}', '', TRUE); // For simple text header
        //$pdf->SetFooter($this->Settings->site_name.'||{PAGENO}', '', TRUE); // For simple text footer
        if ($output_type == 'S') {
            $file_content = $pdf->Output('', 'S');
            write_file('assets/uploads/' . $name, $file_content);
            return 'assets/uploads/' . $name;
        } else {
            $pdf->Output($name, $output_type);
        }
    }

    public function print_arrays()
    {
        $args = func_get_args();
        echo "<pre>";
        foreach ($args as $arg) {
            print_r($arg);
        }
        echo "</pre>";
        die();
    }

    public function logged_in()
    {
        return (bool)$this->session->userdata('identity');
    }

    public function in_group($check_group, $id = false)
    {
        $id || $id = $this->session->userdata('user_id');
        $group = $this->site->getUserGroup($id);
        if ($group->name === $check_group) {
            return TRUE;
        }
        return FALSE;
    }

    public function log_payment($msg, $val = NULL)
    {
        $this->load->library('logs');
        return (bool)$this->logs->write('payments', $msg, $val);
    }

    public function zip($source = NULL, $destination = "./", $output_name = 'sma', $limit = 5000)
    {
        if (!$destination || trim($destination) == "") {
            $destination = "./";
        }

        $this->_rglobRead($source, $input);
        $maxinput = count($input);
        $splitinto = (($maxinput / $limit) > round($maxinput / $limit, 0)) ? round($maxinput / $limit, 0) + 1 : round($maxinput / $limit, 0);

        for ($i = 0; $i < $splitinto; $i++) {
            $this->_zip(array_slice($input, ($i * $limit), $limit, true), $i, $destination, $output_name);
        }

        unset($input);
        return;
    }

    public function unzip($source, $destination = './')
    {
        // @chmod($destination, 0777);
        $zip = new ZipArchive;
        if ($zip->open(str_replace("//", "/", $source)) === true) {
            $zip->extractTo($destination);
            $zip->close();
        }
        // @chmod($destination,0755);
        return TRUE;
    }

    public function view_rights($check_id, $js = NULL)
    {
        if (!$this->Owner && !$this->Admin) {
            if ($check_id != $this->session->userdata('user_id')) {
                $this->session->set_flashdata('warning', $this->data['access_denied']);
                if ($js) {
                    die("<script type='text/javascript'>setTimeout(function(){ window.top.location.href = '" . (isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : site_url('welcome')) . "'; }, 10);</script>");
                } else {
                    redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
                }
            }
        }
        return TRUE;
    }

    function makecomma($input)
    {
        if (strlen($input) <= 2) {
            return $input;
        }
        $length = substr($input, 0, strlen($input) - 2);
        $formatted_input = $this->makecomma($length) . "," . substr($input, -2);
        return $formatted_input;
    }

    public function formatSAC($num)
    {
        $pos = strpos((string)$num, ".");
        if ($pos === false) {
            $decimalpart = "00";
        } else {
            $decimalpart = substr($num, $pos + 1, 2);
            $num = substr($num, 0, $pos);
        }

        if (strlen($num) > 3 & strlen($num) <= 12) {
            $last3digits = substr($num, -3);
            $numexceptlastdigits = substr($num, 0, -3);
            $formatted = $this->makecomma($numexceptlastdigits);
            $stringtoreturn = $formatted . "," . $last3digits . "." . $decimalpart;
        } elseif (strlen($num) <= 3) {
            $stringtoreturn = $num . "." . $decimalpart;
        } elseif (strlen($num) > 12) {
            $stringtoreturn = number_format($num, 2);
        }

        if (substr($stringtoreturn, 0, 2) == "-,") {
            $stringtoreturn = "-" . substr($stringtoreturn, 2);
        }

        return $stringtoreturn;
    }

    public function md()
    {
        die("<script type='text/javascript'>setTimeout(function(){ window.top.location.href = '" . (isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : site_url('welcome')) . "'; }, 10);</script>");
    }

    public function upload_file($image, $path = 'upload', $width = 0, $height = 0, $wm = false)
    {
        //$this->load->library('email');
        $uploadedFiles = array();
        $config['upload_path'] = './themes/default/assets/frontend/images/' . $path;
        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path'], 0777);
        }
        $config['allowed_types'] = 'gif|jpg|png|bmp|jpeg|JPG|JPEG|pdf|doc|docx';
        $config['max_size'] = '3000';
        $config['max_width'] = '4000';
        $config['max_height'] = '4000';
        $this->load->library('upload', $config);
        $upload = $this->upload->do_upload($image);
        if (!$upload) {
            $this->messages->add($this->upload->display_errors(), "error");
            return false;
        } else {
            $path = $this->upload->data();
        }
        $this->load->library('image_lib');
        $configThumb = array();
        $configThumb['image_library'] = 'gd2';
        $configThumb['source_image'] = $path['full_path'];
        $configThumb['maintain_ratio'] = FALSE;
        $configThumb['overwrite'] = FALSE;
        if (($width != 0 and $height != 0)) {
            $configThumb['create_thumb'] = TRUE;
            $configThumb['width'] = $width;
            $configThumb['height'] = $height;
            //$configThumb['maintain_ratio'] = FALSE;
            //$config['overwrite'] = TRUE;
        }

        $this->load->library('image_lib');
        $this->image_lib->initialize($configThumb);
        if (!$this->image_lib->resize()) {
            $this->messages->add($this->image_lib->display_errors(), "error");
            return false;
        } else {
            $this->image_lib->clear();
            if ($wm) $this->overlay($path['full_path']);
            return $path;
        }
    }

    public function image_file($dir = './assets/uploads/', $name, $image, $dm = array(), $wm = false, $overwrite = FALSE)
    {
        $config['upload_path'] = $dir;
        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path'], 0777);
        }
        $config['file_name'] = $name;
        $config['overwrite'] = $overwrite;
        $config['allowed_types'] = 'gif|jpg|png|bmp|jpeg|JPG|JPEG';
        $config['max_size'] = '2048000';
        $config['max_width'] = '2000';
        $config['max_height'] = '2000';
        $this->load->library('upload');
        $this->upload->initialize($config);
        $upload = $this->upload->do_upload($image);
        if (!$upload) {
            $this->messages->add($this->upload->display_errors(), "error");
            return false;
        }
        $path = $this->upload->data();
        //echo '<pre>',print_r($path);
        $this->load->library('image_lib');
        //$this->overlay($path['full_path']);
        $this->image_lib->clear();
        if (!empty($dm)) {
            foreach ($dm as $img)
                $this->resize_image($dir, $path['file_name'], $img['w'], $img['h']);
        }
        return $path;
    }

    public function resize_image($dir, $fullname, $width = '500', $height = '500',$thumb=FALSE)
    {
        // get src file's extension and file name
        $extension = pathinfo($fullname, PATHINFO_EXTENSION);
        $filename = pathinfo($fullname, PATHINFO_FILENAME);
        $image_org = $dir . $filename . "." . $extension;
        $image_thumb = $dir . $width . 'X' . $height . "-" . $filename . "." . $extension;
        $this->image_lib->clear();
        // CONFIGURE IMAGE LIBRARY
        $config['image_library'] = 'gd2';
        $config['source_image'] = $image_org;
        $config['new_image'] = $image_thumb;
        $config['quality'] = '100%';
        $config['create_thumb'] = $thumb;
        $config['maintain_ratio'] = true;
        $config['thumb_marker'] = '';
        $config['width'] = $width;
        $config['height'] = $height;
        $this->image_lib->initialize($config);
        if ($this->image_lib->resize()) {
            $this->image_lib->clear();
            return true;
        } else {
            $this->messages->add($this->image_lib->display_errors(), "error");
        }
        $this->image_lib->clear();
        return false;
        //}
    }

    public function overlay($path)
    {
        $config['image_library'] = 'gd2';
        $config['source_image'] = $path;
        $config['wm_type'] = 'overlay';
        //$config['wm_text'] = 'Copyright by - cityhits';
        $config['wm_overlay_path']  = './assets/watermark.png'; //the overlay image
        $config['wm_opacity'] = 100;
        $config['wm_vrt_alignment'] = 'middle';
        $config['wm_hor_alignment'] = 'center';
        $config['width'] = '220';
        $config['height'] = '54';
        $config['wm_padding'] = '20';
        //$config['wm_font_size'] = '50';
        $this->load->library('image_lib');
        $this->image_lib->initialize($config);
        if (!$this->image_lib->watermark()) {
            $this->messages->add($this->image_lib->display_errors(), "error");
            return false;
        }
        return true;
    }

    function remoteFileExists($url)
    {
        $curl = curl_init($url);

        //don't fetch the actual page, you only want to check the connection is ok
        curl_setopt($curl, CURLOPT_NOBODY, true);

        //do request
        $result = curl_exec($curl);

        $ret = false;

        //if request did not fail
        if ($result !== false) {
            //if request was ok, check response code
            $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            if ($statusCode == 200) {
                $ret = true;
            }
        }

        curl_close($curl);

        return $ret;
    }

    function check_file_exists($path)
    {
        if (file_exists($path)) {
            return true;
        } else {
            return false;
        }
    }

    function split_words($string, $nb_caracs)
    {
        $string = strip_tags(html_entity_decode($string));
        if (strlen($string) <= $nb_caracs) {
            $final_string = $string;
        } else {
            $final_string = "";
            $words = explode(" ", $string);
            foreach ($words as $value) {
                if (strlen($final_string . " " . $value) < $nb_caracs) {
                    if (!empty($final_string)) $final_string .= " ";
                    $final_string .= $value;
                } else {
                    break;
                }
            }
            //$final_string .= $separator;
        }
        return $final_string;
    }

    public function file_delete($path)
    {
        if (is_file($path)) {
            chmod($path, 0777);

            if (unlink($path)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function get_pagin($url, $total_rows, $per_page, $uri_segment=0,$page_query_string=FALSE)
    {
        $this->load->library('pagination');
        $config['base_url'] = site_url($url);
        $config['total_rows'] = $total_rows;
        $config['per_page'] = $per_page;
        if($page_query_string) {
            $config['enable_query_string'] = TRUE;
            $config['page_query_string'] = TRUE;
            $config['query_string_segment'] = 'page';
            $config['use_page_numbers'] = TRUE;
        }
        if($uri_segment!=0) $config['uri_segment'] = $uri_segment;
        $config['attributes'] = array('class' => 'page-link');
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['cur_tag_open'] = '<li class="page-item active"><a class="page-link">';
        $config['cur_tag_close'] = '</a></li>';
        $config['prev_tag_open'] = '<li class="page-item">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = '<span aria-hidden="true"><span class="lnr lnr-chevron-left"></span></span>';
        $config['next_link'] = '<span aria-hidden="true"><span class="lnr lnr-chevron-right"></span></span>';
        $config['next_tag_open'] = '<li class="page-item">';
        $config['next_tag_close'] = '</li>';
        $config['first_tag_open'] = '<li class="page-item">';
        $config['first_tag_close'] = '</li>';
        $config['first_link'] = 'First';
        $config['last_tag_open'] = '<li class="page-item">';
        $config['last_tag_close'] = '</li>';
        $config['last_link'] = 'Last';
        $config['num_tag_open'] = '<li class="page-item">';
        $config['num_tag_close'] = '</li>';
        $config['num_links'] = 6;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        return $this->pagination->create_links();
    }
	
	function date_diffent($d1,$d2){
		$date1=date_create($d1);
		$date2=date_create($d2);
		$diff=date_diff($date1,$date2);
		$dff_days = (int)$diff->format("%R%a");
		return ($dff_days<0)?0:$dff_days;
	}

}