<?php $this->load->view("templates/common/top_section"); ?>

<form class="form-horizontal needs-validation" novalidate action="<?php echo base_url('monthItem/add_monthpay'); ?>"
    method="post" role="form">
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Monthly Pay Apply</h5>
                </div>
                <div class="card-body">

                    <div class="">

                        <input type="hidden" <?php echo (isset($item->Comp)) ? 'value="' . $item->Comp . '"' : null; ?>
                            name="Comp" />
                        <div class="row mb-3 g-3">

                            <div class="col-12 col-sm-3">
                                <label class="form-label" for="Month">Month</label>
                                <input type="text" placeholder="Month" name="month" id="month" <?= (isset($month)) ? 'value="' . $month . '"' : date('Y-m'); ?> data-date-format="yyyy-mm" readonly
                                    class="form-control datfe-picker">
                            </div>

                            <div class="col-12 col-sm-3">
                                <label class="form-label" for="Month">Employee</label>
                                <?php $title = array('A' => 'Allowance', 'D' => 'Deduction', 'N' => 'No pay', 'L' => 'Late', 'O' => 'Over Time'); ?>
                                <select id="EmpNo" class="select2 form-select form-control col-sm-4" name="EmpNo">
                                    <option value="">--Select Employee --</option>
                                    <?php
                                    foreach ($employees as $emp) {
                                        $select = (isset($empNo) and $empNo == $emp->EId) ? 'selected="selected"' : null;
                                        echo '<option ' . $select . ' value="' . $emp->EId . '">' . trim($emp->EmpName) . ' - ' . $emp->EmpNo . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-12 col-sm-3">

                            </div>
                            <div class="col-12 col-sm-3">

                                <button class="btn btn-info  mt-4"><i class="bx bx-update me-2"></i>Update</button>
                            </div>
                        </div>




                    </div>
                </div>


            </div>

        </div>
    </div>

        <div class="row">

            <!-- First column-->
            <div class="col-12 col-lg-6">
                <!-- Product Information -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-tile mb-0">Allowances</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $i = 0;
                        if (isset($allowances) and !empty($allowances)) {
                            foreach ($allowances as $alw) {
                                $alw_value = (isset($alw->Amount)) ? $alw->Amount : 0;
                                $saved_alw_valued = 0;
                                if (isset($apply_allowances)) {
                                    $filtered = $this->attn->filter_by_key($apply_allowances, 'Item_Code', $alw->Code);
                                    if (isset($filtered[0])) {
                                        $saved_alw_valued = $filtered[0]->Amount;
                                    }
                                }

                                ?>
                                <div class="row mb-3">
                                    <label class="col-sm-4 col-form-label" for="basic-default-name">
                                        <?= $alw->ItemName; ?>
                                    </label>
                                    <div class="col-sm-8">
                                        <input type="hidden" value="<?= $alw->Code; ?>" name="records[<?= $i; ?>][1]" />
                                        <input type="hidden" value="<?= isset($month) ? $month : ''; ?>"
                                            name="records[<?= $i; ?>][2]" />
                                        <input type="hidden" value="<?= $alw->Id; ?>" name="records[<?= $i; ?>][3]" />

                                        <?php if ($saved_alw_valued) { ?>
                                            <div class="row">
                                                <div class="col-12 col-sm-8">
                                                    <input type="text" class="form-control" value="<?= $saved_alw_valued; ?>"
                                                        name="records[<?= $i; ?>][4]" />
                                                </div>
                                                <div class="col-12 col-sm-4">
                                                    <span class="badge bg-success">
                                                        (<?= $alw_value; ?>)
                                                    </span>
                                                </div>
                                            </div>
                                        <?php } else { ?>
                                            <input type="text" class="form-control" value="<?= $alw_value; ?>"
                                                name="records[<?= $i; ?>][4]" />

                                        <?php } ?>

                                    </div>

                                </div>

                                <?php
                                $i++;
                            }
                        } ?>


                    </div>
                </div>
                <!-- /Product Information -->
                <!-- Media -->
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 card-title">Over Time</h5>

                    </div>
                    <div class="card-body">
                        <?php
                        //$o=0;
                        if (isset($overtimes) and !empty($overtimes)) {
                            foreach ($overtimes as $ovt) {
                                $hours = (isset($ovt->Hours)) ? $ovt->Hours : 0;
                                $savehours = 0;
                                if (isset($apply_overtimes)) {
                                    $filtered = $this->attn->filter_by_key($apply_overtimes, 'Item_Code', $ovt->Code);
                                    if (!empty($filtered[0])) {
                                        $savehours = $filtered[0]->Rate;
                                    }
                                }
                                ?>
                                <div class="row mb-3">
                                    <label class="col-sm-4 col-form-label" for="basic-default-name">
                                        <?= $ovt->ItemName; ?>
                                    </label>
                                    <div class="col-sm-8">
                                        <input type="hidden" value="<?= $ovt->Code; ?>" name="records[<?= $i; ?>][1]" />
                                        <input type="hidden" value="<?= isset($month) ? $month : ''; ?>"
                                            name="records[<?= $i; ?>][2]" />
                                        <input type="hidden" value="<?= $ovt->Id; ?>" name="records[<?= $i; ?>][3]" />
                                        <?php if ($savehours) { ?>
                                            <div class="row">
                                                <div class="col-12 col-sm-8">
                                                    <input type="text" class="form-control" value="<?= $savehours; ?>"
                                                    name="records[<?= $i; ?>][5]" />
                                                </div>
                                                <div class="col-12 col-sm-4">
                                                    <span class="badge bg-success">
                                                        (<?= $hours; ?>)
                                                    </span>
                                                </div>
                                            </div>   
                                        <?php } else { ?>
                                            <input type="text" class="form-control" value="<?= $hours; ?>"
                                                name="records[<?= $i; ?>][5]" />
                                        <?php } ?>
                                    </div>
                                </div>
                                <?php $i++;
                            }
                        } ?>
                    </div>
                </div>
                <!-- /Media -->


            </div>
            <!-- /Second column -->

            <!-- Second column -->
            <div class="col-12 col-lg-6">
                <!-- Pricing Card -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Deduction</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        //$d=0;
                        if (isset($deductions) and !empty($deductions)) {
                            foreach ($deductions as $dt) {
                                $ddv_value = (isset($dt->Amount)) ? $dt->Amount : 0;
                                if ($dt->Code == 'Wel') {
                                    if (isset($Welfare)) {
                                        $ddv_value = $Welfare;
                                    }
                                }
                                $saved_ddv_valued = 0;
                                if (isset($apply_deductions)) {
                                    $filtered_dt = $this->attn->filter_by_key($apply_deductions, 'Item_Code', $dt->Code);
                                    if (!empty($filtered_dt[0])) {
                                        $saved_ddv_valued = $filtered_dt[0]->Amount;
                                    }
                                }
                                ?>
                                <div class="row mb-3">
                                    <label class="col-sm-4 col-form-label" for="basic-default-name">
                                        <?= $dt->ItemName; ?>
                                    </label>

                                    <div class="col-sm-8">
                                        <input type="hidden" value="<?= $dt->Code; ?>" name="records[<?= $i; ?>][1]" />
                                        <input type="hidden" value="<?= isset($month) ? $month : ''; ?>"
                                            name="records[<?= $i; ?>][2]" />
                                        <input type="hidden" class="form-control" value="<?= $dt->Id; ?>"
                                            name="records[<?= $i; ?>][3]" />

                                        <?php if ($saved_ddv_valued) { ?>
                                            <div class="row">
                                                <div class="col-12 col-sm-8">
                                                    <input type="text" class="form-control" value="<?= $saved_ddv_valued; ?>"
                                                        name="records[<?= $i; ?>][4]" />
                                                </div>
                                                <div class="col-12 col-sm-4">
                                                    <span class="badge bg-success">
                                                        (<?= $ddv_value; ?>)
                                                    </span>
                                                    </div>
                                            </div>
                                        <?php } else { ?>
                                            <input type="text" class="form-control" value="<?= $ddv_value; ?>"
                                                name="records[<?= $i; ?>][4]" />

                                        <?php } ?>
                                    </div>
                                </div>
                                <?php
                                $i++;
                            }
                        } ?>
                    </div>
                </div>
                <!-- /Pricing Card -->
                <!-- Organize Card -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">No Pay / Late</h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($nopays) and !empty($nopays)) {

                            foreach ($nopays as $np) {
                                $days = (isset($np->Days)) ? $np->Days : 0;
                                $saved_days = 0;
                                if (isset($apply_nopays)) {
                                    $filtered_np = $this->attn->filter_by_key($apply_nopays, 'Item_Code', $np->Code);
                                    if (!empty($filtered_np[0])) {
                                        $saved_days = $filtered_np[0]->Rate;
                                    }
                                }
                                ?>
                                <div class="row mb-3">
                                    <label class="col-sm-4 col-form-label" for="basic-default-name">
                                        <?= $np->ItemName; ?>
                                    </label>
                                    <div class="col-sm-8">
                                        <input type="hidden" value="<?= $np->Code; ?>" name="records[<?= $i; ?>][1]" />
                                        <input type="hidden" value="<?= isset($month) ? $month : ''; ?>"
                                            name="records[<?= $i; ?>][2]" />
                                        <input type="hidden" value="<?= $np->Id; ?>" name="records[<?= $i; ?>][3]" />

                                        <?php if ($saved_days) { ?>
                                            <div class="row">
                                                <div class="col-12 col-sm-8">
                                                    <input type="text" class="form-control" value="<?= $saved_days; ?>"
                                                        name="records[<?= $i; ?>][5]" />
                                                </div>
                                                <div class="col-12 col-sm-4">
                                                    <span class="badge bg-success">
                                                        (<?= $days; ?>)
                                                </span>
                                                </div>
                                            </div>
                                        <?php } else { ?>
                                            <input type="text" class="form-control" value="<?= $days; ?>"
                                                name="records[<?= $i; ?>][5]" />
                                        <?php } ?>

                                    </div>
                                </div>
                                <?php $i++;
                            }
                        } ?>

                        <?php if (isset($lates) and !empty($lates)) {
                            foreach ($lates as $l) {
                                ?>
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label" for="basic-default-name">
                                        <?= $l->ItemName; ?>
                                    </label>
                                    <input type="text" class="form-control" name="">

                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
                <!-- /Organize Card -->
            </div>
            <!-- /Second column -->
        </div>


</form>

<?php $this->load->view("templates/common/footer"); ?>