<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<!-- inline scripts related to this page -->
<script type="text/javascript">

// Example starter JavaScript for disabling form submissions if there are invalid fields
(function () {
  'use strict'

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }

        form.classList.add('was-validated')
      }, false)
    })
})()
	jQuery(function($) {


		var oTable = $('#emplyee-table').dataTable({
			/*"aaSorting": [[4, "desc"], [2, "desc"]],*/
			"aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
			"iDisplayLength": 10,
			"bDestroy": true,
			'bProcessing': true,
			'bServerSide': true,
			'sAjaxSource': '<?= site_url('person/getUsers/?v=1') ?>',
			'fnServerData': function (sSource, aoData, fnCallback) {
				aoData.push({
					"name": "",
					"value": ""
				});
				$.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
			},
			"aoColumns": [{ "bSortable":false }, null,null,null,null,null, { "bSortable":false }]
		});

		//initiate dataTables plugin
		var oTable1 =
			$('#dynamic-table')
				//.wrap("<div class='dataTables_borderWrap' />")   //if you are applying horizontal scrolling (sScrollX)
				.dataTable( {
					bAutoWidth: false,
					"aoColumns": [
						{ "bSortable": false },
						null, null,null, null, null,null,null,
						{ "bSortable": false }
					],
					"aaSorting": [],

					//,
					//"sScrollY": "200px",
					//"bPaginate": false,

					//"sScrollX": "100%",
					//"sScrollXInner": "120%",
					//"bScrollCollapse": true,
					//Note: if you are applying horizontal scrolling (sScrollX) on a ".table-bordered"
					//you may want to wrap the table inside a "div.dataTables_borderWrap" element

					"iDisplayLength": 50
				} );
		//oTable1.fnAdjustColumnSizing();




		//initiate TableTools extension


		//also add tooltips to table tools buttons
		//addding tooltips directly to "A" buttons results in buttons disappearing (weired! don't know why!)
		//so we add tooltips to the "DIV" child after it becomes inserted






		/////////////////////////////////
		//table checkboxes
		$('th input[type=checkbox], td input[type=checkbox]').prop('checked', false);

		//select/deselect all rows according to table header checkbox
		$('#dynamic-table > thead > tr > th input[type=checkbox]').eq(0).on('click', function(){
			var th_checked = this.checked;//checkbox inside "TH" table header

			$(this).closest('table').find('tbody > tr').each(function(){
				var row = this;
				if(th_checked) tableTools_obj.fnSelect(row);
				else tableTools_obj.fnDeselect(row);
			});
		});

		//select/deselect a row when the checkbox is checked/unchecked
		$('#dynamic-table').on('click', 'td input[type=checkbox]' , function(){
			var row = $(this).closest('tr').get(0);
			if(!this.checked) tableTools_obj.fnSelect(row);
			else tableTools_obj.fnDeselect($(this).closest('tr').get(0));
		});




		$(document).on('click', '#dynamic-table .dropdown-toggle', function(e) {
			e.stopImmediatePropagation();
			e.stopPropagation();
			e.preventDefault();
		});


		//And for the first simple table, which doesn't have TableTools or dataTables
		//select/deselect all rows according to table header checkbox
		var active_class = 'active';
		$('#simple-table > thead > tr > th input[type=checkbox]').eq(0).on('click', function(){
			var th_checked = this.checked;//checkbox inside "TH" table header

			$(this).closest('table').find('tbody > tr').each(function(){
				var row = this;
				if(th_checked) $(row).addClass(active_class).find('input[type=checkbox]').eq(0).prop('checked', true);
				else $(row).removeClass(active_class).find('input[type=checkbox]').eq(0).prop('checked', false);
			});
		});

		//select/deselect a row when the checkbox is checked/unchecked
		$('#simple-table').on('click', 'td input[type=checkbox]' , function(){
			var $row = $(this).closest('tr');
			if(this.checked) $row.addClass(active_class);
			else $row.removeClass(active_class);
		});



		/********************************/
		//add tooltip for small view action buttons in dropdown menu
		$('[data-rel="tooltip"]').tooltip({placement: tooltip_placement});

		//tooltip placement on right or left
		function tooltip_placement(context, source) {
			var $source = $(source);
			var $parent = $source.closest('table');
			var off1 = $parent.offset();
			var w1 = $parent.width();

			var off2 = $source.offset();
			//var w2 = $source.width();

			if( parseInt(off2.left) < parseInt(off1.left) + parseInt(w1 / 2) ) return 'right';
			return 'left';
		}

	})
</script>

<script type="text/javascript">
	function format(date) {
		date = new Date(date);

		var day = ('0' + date.getDate()).slice(-2);
		var month = ('0' + (date.getMonth() + 1)).slice(-2);
		var year = date.getFullYear();

		return year + '-' + month + '-' + day;
	}


	$(function() {
		var curntDate = format(new Date());
		var Comp = $('#Comp').val();
		loadData(curntDate,Comp);

		$( document ).ajaxComplete(function() {
			$('#myPleaseWait').modal('hide');
		});
		$( document ).ajaxStart(function() {
			$('#myPleaseWait').modal('show');
		});
	});

	function loadData(){
		var nowdate = $('#absDate').val();
		var Comp = $('#Comp').val();
		getAttendance(nowdate,Comp);
		getAbsence(nowdate, Comp);
	}



	function getAttendance(date,comp)
	{
		$('#attendance').dataTable( {
			"processing": true,
			"destroy": true,
			"ajax": {
				url :"<?php echo base_url('attendance/get_attn_filter'); ?>",
				type: "post",  // method  , by default get
				"data":{Date:date,Comp:comp},
				error: function(){  // error handling
					$(".employee-grid-error").html("");
					$("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
					$("#employee-grid_processing").css("display","none");
				}
			},

			"bStateSave": true,
			"iDisplayLength": 50
		} );
	}

	function getAbsence(date,comp)
	{
		$('#absence').dataTable( {
			"processing": true,
			"destroy": true,
			"ajax": {
				url :"<?php echo base_url('attendance/get_absence_filter'); ?>",
				type: "post",  // method  , by default get
				"data":{Date:date,Comp:comp},
				error: function(){  // error handling
					$(".employee-grid-error").html("");
					$("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
					$("#employee-grid_processing").css("display","none");
				}
			},

			"bStateSave": true,
			"lengthMenu": [50, 60, 80, 100, 120],
			"pageLength": 50
		} );
	}
</script>

<!--
<script type="text/javascript">
$(function() {
	$('.date-picker').datepicker().next().on(ace.click_event, function(){
		$(this).prev().focus();
	});
});
</script>

<script type="text/javascript">

	$(document).ready(function(e) {
		$('.delete').click(function(s) {
			var r = confirm("Are you sure?");
			//var dpCode = $(this).data("id");
			//alert(dpCode);
			if (r == true) {
				return true;
			}
			return false;
		});

	});

</script>

-->
